/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import shetiphian.core.SideExecutor;
import shetiphian.core.client.ColorHandler;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ITabFiller;
import shetiphian.core.platform.Services;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.client.misc.TextureInfoHelper;
import shetiphian.multibeds.common.component.Bedding;
import shetiphian.multibeds.common.component.Texture;
import shetiphian.multibeds.common.item.ItemBedCustomization;
import shetiphian.multibeds.common.item.ItemPillowSheet;
import shetiphian.multibeds.common.item.StackMigrationHelper;
import shetiphian.multibeds.common.item.TagData;

public class ItemBlockMultiBed
extends BlockItem
implements ITabFiller,
IColored,
TagData {
    public ItemBlockMultiBed(Block block, Item.Properties properties) {
        super(block, properties);
        SideExecutor.runOnClient(() -> () -> ColorHandler.colorize((IColored)this));
    }

    public void fillCreativeTab(CreativeModeTab.Output entries, CreativeModeTab.ItemDisplayParameters context) {
        if (Services.PLATFORM.isDevelopmentEnvironment()) {
            entries.accept(ItemBlockMultiBed.createStack(new ItemStack((ItemLike)this), Texture.DEV_TEST_1));
            entries.accept(ItemBlockMultiBed.createStack(new ItemStack((ItemLike)this), Texture.DEV_TEST_2));
        } else {
            entries.accept(ItemBlockMultiBed.createStack(new ItemStack((ItemLike)this), Texture.DEFAULT));
        }
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        super.verifyComponentsAfterLoad(stack);
        if (SideExecutor.isLogicalServer()) {
            StackMigrationHelper.migrateTextures(stack);
            StackMigrationHelper.migrateBedding(stack);
        }
    }

    public InteractionResult place(BlockPlaceContext context) {
        Direction face = context.getClickedFace();
        if (face.getAxis() == context.getHorizontalDirection().getAxis()) {
            final BlockPos pos = context.getClickedPos().relative(face);
            context = new BlockPlaceContext(this, (UseOnContext)context){

                public BlockPos getClickedPos() {
                    return this.replaceClicked ? super.getClickedPos() : pos;
                }
            };
        }
        return super.place(context);
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        return context.getLevel().setBlock(context.getClickedPos(), state, 18);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (!stack.isEmpty()) {
            TextureInfoHelper.addTextureInfo(tooltip, ((Texture)stack.getOrDefault((DataComponentType)Roster.Components.TEXTURE_DATA.get(), (Object)Texture.EMPTY)).stack());
            this.addInformation(stack, tooltip);
        }
    }

    public static ItemStack createStack(Block block, ItemStack textureStack) {
        if (block != null) {
            ItemStack bedStack = new ItemStack((ItemLike)block);
            if (!textureStack.isEmpty()) {
                bedStack.set((DataComponentType)Roster.Components.TEXTURE_DATA.get(), (Object)new Texture(textureStack.copyWithCount(1)));
            }
            return bedStack;
        }
        return ItemStack.EMPTY;
    }

    private static ItemStack createStack(ItemStack stack, Texture texture) {
        if (!stack.isEmpty() && !texture.stack().isEmpty()) {
            stack.set((DataComponentType)Roster.Components.TEXTURE_DATA.get(), (Object)texture);
        }
        return stack;
    }

    public boolean hasBedding(ItemStack bedStack) {
        if (!bedStack.isEmpty()) {
            return bedStack.has((DataComponentType)Roster.Components.BEDDING_DATA.get()) && bedStack.get((DataComponentType)Roster.Components.BEDDING_DATA.get()) != Bedding.EMPTY;
        }
        return false;
    }

    public static ItemStack getTextureStack(ItemStack bedStack) {
        if (!bedStack.isEmpty()) {
            return ((Texture)bedStack.getOrDefault((DataComponentType)Roster.Components.TEXTURE_DATA.get(), (Object)Texture.DEFAULT)).stack();
        }
        return Texture.DEFAULT_STACK;
    }

    public int getColorFor(IColored.Data data, int index) {
        if (index == 0) {
            return Services.CLIENT.getItemColors().getColor(ItemBlockMultiBed.getTextureStack(data.stack), 0);
        }
        if ((index == 1 || index == 3) && !data.stack.isEmpty() && data.stack.getItem() instanceof TagData) {
            ItemStack colorStack = index == 1 ? this.getSheet(data.stack) : this.getPillow(data.stack);
            Item item = colorStack.getItem();
            if (item instanceof ItemPillowSheet) {
                return ((ItemPillowSheet)item).getRenderColor(colorStack);
            }
            if (item instanceof ItemBedCustomization) {
                return ((ItemBedCustomization)item).getColor(colorStack).getTextureDiffuseColor();
            }
        }
        return -1;
    }
}

