/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.item;

import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import shetiphian.core.SideExecutor;
import shetiphian.core.client.ColorHandler;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ITabFiller;
import shetiphian.core.platform.Services;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.client.misc.TextureInfoHelper;
import shetiphian.multibeds.common.component.Texture;
import shetiphian.multibeds.common.item.StackMigrationHelper;

public class ItemBlockLadder
extends BlockItem
implements ITabFiller,
IColored {
    public ItemBlockLadder(Block block, Item.Properties properties) {
        super(block, properties);
        SideExecutor.runOnClient(() -> () -> ColorHandler.colorize((IColored)this));
    }

    public void fillCreativeTab(CreativeModeTab.Output entries, CreativeModeTab.ItemDisplayParameters context) {
        entries.accept(ItemBlockLadder.createStack(this.getBlock(), Texture.DEFAULT_STACK));
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        super.verifyComponentsAfterLoad(stack);
        if (SideExecutor.isLogicalServer()) {
            StackMigrationHelper.migrateTextures(stack);
        }
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        return context.getLevel().setBlock(context.getClickedPos(), state, 18);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        if (!stack.isEmpty()) {
            TextureInfoHelper.addTextureInfo(tooltip, ((Texture)stack.getOrDefault((DataComponentType)Roster.Components.TEXTURE_DATA.get(), (Object)Texture.EMPTY)).stack());
        }
    }

    public static ItemStack createStack(Block block, ItemStack textureStack) {
        if (block != null) {
            ItemStack ladderStack = new ItemStack((ItemLike)block);
            if (!textureStack.isEmpty()) {
                ladderStack.set((DataComponentType)Roster.Components.TEXTURE_DATA.get(), (Object)new Texture(textureStack.copyWithCount(1)));
            }
            return ladderStack;
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getTextureStack(ItemStack ladderStack) {
        if (!ladderStack.isEmpty()) {
            return ((Texture)ladderStack.getOrDefault((DataComponentType)Roster.Components.TEXTURE_DATA.get(), (Object)Texture.DEFAULT)).stack();
        }
        return Texture.DEFAULT_STACK;
    }

    public int getColorFor(IColored.Data data, int index) {
        if (index == 0) {
            return Services.CLIENT.getItemColors().getColor(ItemBlockLadder.getTextureStack(data.stack), 0);
        }
        return -1;
    }
}

