/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.item;

import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.Pair;
import shetiphian.core.SideExecutor;
import shetiphian.core.client.ClientHelpers;
import shetiphian.core.client.ColorHandler;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ITabFiller;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.common.item.ItemBedCustomization;
import shetiphian.multibeds.common.item.ItemEmbroideryThread;
import shetiphian.multibeds.common.item.StackMigrationHelper;
import shetiphian.multibeds.common.misc.EnumBlanket;
import shetiphian.multibeds.common.misc.EnumSpreadArt;

public class ItemBlanket
extends ItemBedCustomization
implements ITabFiller {
    public static final Pair<EnumBlanket, EnumSpreadArt> NO_DATA = Pair.of((Object)((Object)EnumBlanket.NONE), (Object)((Object)EnumSpreadArt.NONE));

    public ItemBlanket(Item.Properties properties, DyeColor color) {
        super(properties, color, ItemBedCustomization.EnumType.BLANKET);
        SideExecutor.runOnClient(() -> () -> {
            ColorHandler.colorize((IColored)this);
            ClientHelpers.addProperty((Item)this, (String)"pattern", (stack, world, entity, number) -> ItemBlanket.getBlanket(stack).getPattern().ordinal());
        });
    }

    public void fillCreativeTab(CreativeModeTab.Output entries, CreativeModeTab.ItemDisplayParameters context) {
        for (EnumBlanket.Pattern pattern : EnumBlanket.Pattern.values()) {
            ItemStack stack = new ItemStack((ItemLike)this);
            stack.set((DataComponentType)Roster.Components.PATTERN_DATA.get(), (Object)pattern);
            entries.accept(stack);
        }
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        super.verifyComponentsAfterLoad(stack);
        if (SideExecutor.isLogicalServer()) {
            StackMigrationHelper.migrateBlanket(stack);
        }
    }

    public static String getPatternName(ItemStack stack) {
        if (!stack.isEmpty()) {
            return ((EnumBlanket.Pattern)((Object)stack.getOrDefault((DataComponentType)Roster.Components.PATTERN_DATA.get(), (Object)EnumBlanket.Pattern.PLAIN))).getSerializedName();
        }
        return "plain";
    }

    public static void setPatternName(ItemStack stack, EnumBlanket.Pattern pattern) {
        if (!stack.isEmpty()) {
            stack.set((DataComponentType)Roster.Components.PATTERN_DATA.get(), (Object)pattern);
        }
    }

    private static String getBlanketName(ItemStack stack) {
        return ItemBlanket.getPatternName(stack) + "_" + (stack.getItem() instanceof ItemBlanket ? ((ItemBlanket)stack.getItem()).getColor(stack).getName() : "red");
    }

    public static EnumBlanket getBlanket(ItemStack stack) {
        EnumBlanket blanket = EnumBlanket.byName(ItemBlanket.getBlanketName(stack));
        return blanket != EnumBlanket.NONE ? blanket : EnumBlanket.PLAIN_RED;
    }

    public static Pair<EnumBlanket, EnumSpreadArt> getBlanketData(ItemStack stack) {
        if (stack.isEmpty()) {
            return NO_DATA;
        }
        if (stack.getItem() instanceof BannerItem) {
            return Pair.of((Object)((Object)EnumBlanket.BANNER), (Object)((Object)ItemEmbroideryThread.getArtwork(stack)));
        }
        return Pair.of((Object)((Object)EnumBlanket.byName(ItemBlanket.getBlanketName(stack))), (Object)((Object)ItemEmbroideryThread.getArtwork(stack)));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        EnumSpreadArt art;
        super.appendHoverText(stack, context, tooltip, flag);
        if (!ItemBlanket.getPatternName(stack).equalsIgnoreCase("plain")) {
            tooltip.add((Component)Component.translatable((String)"misc.multibeds.pattern").append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)("misc.multibeds.pattern." + ItemBlanket.getPatternName(stack)))));
        }
        if ((art = ItemEmbroideryThread.getArtwork(stack)) != EnumSpreadArt.NONE) {
            tooltip.add((Component)Component.literal((String)"\u00a77\u00a7o * ").append((Component)Component.translatable((String)"misc.multibeds.art")).append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)("misc.multibeds.art." + art.toString()))));
        }
    }
}

