/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import shetiphian.core.SideExecutor;
import shetiphian.core.client.ClientHelpers;
import shetiphian.core.client.ColorHandler;
import shetiphian.core.common.Helpers;
import shetiphian.core.common.IColored;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.common.block.BlockMultiBed;
import shetiphian.multibeds.common.component.Bedding;
import shetiphian.multibeds.common.item.ItemBedCustomization;
import shetiphian.multibeds.common.item.ItemEmbroideryThread;
import shetiphian.multibeds.common.item.ItemPillowSheet;
import shetiphian.multibeds.common.item.StackMigrationHelper;
import shetiphian.multibeds.common.item.TagData;
import shetiphian.multibeds.common.tileentity.TileEntityMultiBed;

public class ItemBeddingPackage
extends Item
implements IColored,
TagData {
    public ItemBeddingPackage(Item.Properties properties) {
        super(properties);
        SideExecutor.runOnClient(() -> () -> {
            ColorHandler.colorize((IColored)this);
            ClientHelpers.addProperty((Item)this, (String)"fill", (stack, world, entity, number) -> (this.hasArt(stack) ? 1 : 0) + (this.getBlanket(stack).isEmpty() ? 0 : 2) + (this.getPillow(stack).isEmpty() ? 0 : 4) + (this.getSheet(stack).isEmpty() ? 0 : 8));
        });
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (!other.isEmpty()) {
            ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)other);
        }
        return super.overrideOtherStackedOnMe(stack, other, slot, action, player, access);
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        super.verifyComponentsAfterLoad(stack);
        if (SideExecutor.isLogicalServer()) {
            StackMigrationHelper.migrateBedding(stack);
        }
    }

    public InteractionResult useOn(UseOnContext data) {
        Level world = data.getLevel();
        BlockPos pos = data.getClickedPos();
        ItemStack dataItem = data.getItemInHand();
        if (world.getBlockState(pos).getBlock() instanceof BlockMultiBed && dataItem.getItem() instanceof ItemBeddingPackage) {
            TileEntityMultiBed[] bedTiles;
            Player player = data.getPlayer();
            Direction face = data.getClickedFace();
            BlockPos[] bedBlocks = BlockMultiBed.getBlocks((BlockGetter)world, pos);
            if ((player == null || player.mayUseItemAt(bedBlocks[0], face, dataItem) && player.mayUseItemAt(bedBlocks[1], face, dataItem)) && (bedTiles = BlockMultiBed.getTiles((BlockGetter)world, pos)) != null) {
                ItemStack bedding = dataItem.split(1);
                if (!world.isClientSide()) {
                    this.setTagFrom(bedding, bedTiles, true);
                    if (player != null) {
                        if (!player.getAbilities().instabuild) {
                            Helpers.giveItem((Player)player, (ItemStack)bedding, (SoundEvent)(dataItem.getCount() > 0 ? SoundEvents.ITEM_PICKUP : null));
                        } else {
                            if (dataItem.getCount() < 1) {
                                dataItem.setCount(1);
                            }
                            boolean give = true;
                            NonNullList inventory = player.getInventory().items;
                            for (ItemStack invStack : inventory) {
                                if (!Helpers.areItemStacksEqual((ItemStack)invStack, (ItemStack)bedding)) continue;
                                give = false;
                                break;
                            }
                            if (give) {
                                Helpers.giveItem((Player)player, (ItemStack)bedding);
                            }
                        }
                    }
                }
                SoundType soundtype = SoundType.WOOL;
                world.playSound(player, pos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void setTagFrom(ItemStack bedding, TileEntityMultiBed[] bedTiles, boolean alterBed) {
        if (bedTiles != null) {
            boolean mirror = false;
            ItemStack blanket = ItemStack.EMPTY;
            ItemStack pillow = ItemStack.EMPTY;
            ItemStack sheet = ItemStack.EMPTY;
            for (int half = 0; half < 2; ++half) {
                if (blanket.isEmpty() && bedTiles[half].hasBlanket()) {
                    blanket = bedTiles[half].getBlanketItem();
                    mirror = bedTiles[half].isMirrored();
                }
                if (pillow.isEmpty() && bedTiles[half].hasPillow()) {
                    pillow = bedTiles[half].getPillowItem();
                }
                if (!sheet.isEmpty() || !bedTiles[half].hasSheet()) continue;
                sheet = bedTiles[half].getSheetItem();
            }
            if (alterBed) {
                if (bedTiles[0].setBlanketItem(this.getBlanket(bedding), this.getMirrored(bedding))) {
                    bedTiles[1].setBlanketItem(bedTiles[0].getBlanketItem(), bedTiles[0].isMirrored());
                } else {
                    bedTiles[0].removeBlanket();
                    bedTiles[1].removeBlanket();
                }
                if (bedTiles[0].setPillowItem(this.getPillow(bedding))) {
                    bedTiles[1].setPillowItem(bedTiles[0].getPillowItem());
                } else {
                    bedTiles[0].removePillow();
                    bedTiles[1].removePillow();
                }
                if (bedTiles[0].setSheetItem(this.getSheet(bedding))) {
                    bedTiles[1].setSheetItem(bedTiles[0].getSheetItem());
                } else {
                    bedTiles[0].removeSheet();
                    bedTiles[1].removeSheet();
                }
                Helpers.syncTile((BlockEntity)bedTiles[0]);
                Helpers.syncTile((BlockEntity)bedTiles[1]);
            }
            bedding.set((DataComponentType)Roster.Components.BEDDING_DATA.get(), (Object)new Bedding(blanket, pillow, sheet, mirror));
        }
    }

    public static ItemStack createFor(TileEntityMultiBed[] bedTiles) {
        ItemStack bedding;
        if (bedTiles != null && !(bedding = new ItemStack((ItemLike)Roster.Items.BEDDING_PACKAGE.get())).isEmpty() && bedding.getItem() instanceof ItemBeddingPackage) {
            ((ItemBeddingPackage)bedding.getItem()).setTagFrom(bedding, bedTiles, false);
            return bedding;
        }
        return ItemStack.EMPTY;
    }

    public int getColorFor(IColored.Data data, int index) {
        ItemStack stack;
        if (index > 0 && index < 5 && !(stack = this.getColorStack(data.stack, index)).isEmpty()) {
            if (index == 4) {
                return ItemEmbroideryThread.getArtwork(stack).getColor();
            }
            Item item = stack.getItem();
            if (item instanceof BannerItem) {
                return ((BannerItem)item).getColor().getTextureDiffuseColor();
            }
            if (item instanceof ItemPillowSheet) {
                return ((ItemPillowSheet)item).getRenderColor(stack);
            }
            if (item instanceof ItemBedCustomization) {
                return ((ItemBedCustomization)item).getColor(stack).getTextureDiffuseColor();
            }
        }
        return -1;
    }

    private ItemStack getColorStack(ItemStack bedding, int index) {
        if (!bedding.isEmpty() && bedding.getItem() instanceof ItemBeddingPackage) {
            switch (index) {
                case 1: {
                    return this.getSheet(bedding);
                }
                case 2: {
                    return this.getBlanket(bedding);
                }
                case 3: {
                    return this.getPillow(bedding);
                }
                case 4: {
                    return this.getArt(bedding);
                }
            }
        }
        return ItemStack.EMPTY;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        this.addInformation(stack, tooltip);
    }
}

