/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import shetiphian.core.SideExecutor;
import shetiphian.core.client.ColorHandler;
import shetiphian.core.common.Helpers;
import shetiphian.core.common.IColored;
import shetiphian.multibeds.common.block.BlockMultiBed;
import shetiphian.multibeds.common.tileentity.TileEntityMultiBed;

public class ItemBedCustomization
extends Item
implements IColored {
    private final DyeColor color;
    private final EnumType type;

    ItemBedCustomization(Item.Properties properties, DyeColor color, EnumType type) {
        super(properties);
        this.color = color;
        this.type = type;
        SideExecutor.runOnClient(() -> () -> ColorHandler.colorize((IColored)this));
    }

    public InteractionResult useOn(UseOnContext data) {
        return ItemBedCustomization.putOnBed(data.getItemInHand(), data.getPlayer(), data.getLevel(), data.getClickedPos(), data.getClickedFace(), false) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public static boolean putOnBed(ItemStack stack, Player player, Level world, BlockPos pos, Direction face, boolean mirror) {
        TileEntityMultiBed[] bedTiles;
        BlockPos[] bedBlocks;
        EnumType type;
        if (stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        EnumType enumType = item instanceof ItemBedCustomization ? ((ItemBedCustomization)item).getType() : (type = item instanceof BannerItem ? EnumType.BLANKET : null);
        if (type == null) {
            return false;
        }
        if (world.getBlockState(pos).getBlock() instanceof BlockMultiBed && player.mayUseItemAt((bedBlocks = BlockMultiBed.getBlocks((BlockGetter)world, pos))[0], face, stack) && player.mayUseItemAt(bedBlocks[1], face, stack) && (bedTiles = BlockMultiBed.getTiles((BlockGetter)world, pos)) != null) {
            if (!world.isClientSide()) {
                if (!player.getAbilities().instabuild) {
                    ItemStack drop = ItemStack.EMPTY;
                    for (int index = 0; index < 2; ++index) {
                        switch (type.ordinal()) {
                            case 0: {
                                if (!bedTiles[index].hasSheet()) break;
                                drop = bedTiles[index].getSheetItem();
                                break;
                            }
                            case 1: {
                                if (!bedTiles[index].hasPillow()) break;
                                drop = bedTiles[index].getPillowItem();
                                break;
                            }
                            case 2: {
                                if (!bedTiles[index].hasBlanket()) break;
                                drop = bedTiles[index].getBlanketItem();
                            }
                        }
                        if (drop.isEmpty()) continue;
                        Helpers.dropItem((Level)world, (BlockPos)bedBlocks[index], (ItemStack)drop);
                        break;
                    }
                }
                switch (type.ordinal()) {
                    case 0: {
                        bedTiles[0].setSheetItem(stack);
                        bedTiles[1].setSheetItem(stack);
                        break;
                    }
                    case 1: {
                        bedTiles[0].setPillowItem(stack);
                        bedTiles[1].setPillowItem(stack);
                        break;
                    }
                    case 2: {
                        bedTiles[0].setBlanketItem(stack, mirror);
                        bedTiles[1].setBlanketItem(stack, mirror);
                    }
                }
                Helpers.syncTile((BlockEntity)bedTiles[0]);
                Helpers.syncTile((BlockEntity)bedTiles[1]);
            }
            SoundType soundtype = SoundType.WOOL;
            world.playSound(player, pos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
            stack.shrink(1);
            return true;
        }
        return false;
    }

    public EnumType getType() {
        return this.type;
    }

    public DyeColor getColor(ItemStack stack) {
        return this.color;
    }

    public int getColorFor(IColored.Data data, int index) {
        return this.color.getTextureDiffuseColor();
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)("item.multibeds." + this.getType().getName()));
    }

    public static enum EnumType {
        SHEET,
        PILLOW,
        BLANKET;


        private String getName() {
            return this.toString().toLowerCase();
        }
    }
}

