/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.inventory;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import shetiphian.core.common.inventory.MenuProviderWithData;
import shetiphian.multibeds.common.inventory.ContainerBlanketLoom;
import shetiphian.multibeds.common.inventory.ContainerBuilder;

public class ContainerProviders {

    public static class LadderKit
    implements MenuProviderWithData {
        private static final Component displayName = Component.translatable((String)"inv.ladder_kit");

        public Component getDisplayName() {
            return displayName;
        }

        public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
            return ContainerBuilder.Ladder(id, inventory);
        }

        public static ContainerBuilder createMenu(int id, Inventory inventory, FriendlyByteBuf data) {
            return ContainerBuilder.Ladder(id, inventory);
        }

        public void write(FriendlyByteBuf data) {
        }
    }

    public record BlanketLoom(BlockPos pos) implements MenuProviderWithData
    {
        private static final Component displayName = Component.translatable((String)"inv.blanket_loom");

        public Component getDisplayName() {
            return displayName;
        }

        public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
            return new ContainerBlanketLoom(id, inventory, ContainerLevelAccess.create((Level)player.level(), (BlockPos)this.pos));
        }

        public static ContainerBlanketLoom createMenu(int id, Inventory inventory, FriendlyByteBuf data) {
            BlockPos pos = data.readBlockPos();
            return new ContainerBlanketLoom(id, inventory, ContainerLevelAccess.create((Level)inventory.player.level(), (BlockPos)pos));
        }

        public void write(FriendlyByteBuf data) {
            data.writeBlockPos(this.pos);
        }
    }

    public static class BedKit
    implements MenuProviderWithData {
        private static final Component displayName = Component.translatable((String)"inv.bed_kit");

        public Component getDisplayName() {
            return displayName;
        }

        public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
            return ContainerBuilder.Bed(id, inventory);
        }

        public static ContainerBuilder createMenu(int id, Inventory inventory, FriendlyByteBuf data) {
            return ContainerBuilder.Bed(id, inventory);
        }

        public void write(FriendlyByteBuf data) {
        }
    }
}

