/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.inventory;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.common.item.ItemBlockLadder;
import shetiphian.multibeds.common.item.ItemBlockMultiBed;
import shetiphian.multibeds.common.item.ItemBuilderKit;
import shetiphian.multibeds.common.misc.EnumBedStyle;

public class ContainerBuilder
extends AbstractContainerMenu {
    private final BuilderMode builderMode;
    private final DataSlot indexBedStyle = DataSlot.standalone();
    private final Slot slotBaseItem;
    private final Slot slotMaterial;
    private final Slot slotOutput;
    private Runnable callbackInventoryChange = () -> {};
    private final Container invOutput = new SimpleContainer(1){

        public void setChanged() {
            super.setChanged();
            ContainerBuilder.this.callbackInventoryChange.run();
        }
    };
    private boolean canUse;
    private ItemStack stackOutput = ItemStack.EMPTY;
    private final Container invInput = new SimpleContainer(2){

        public void setChanged() {
            super.setChanged();
            ContainerBuilder.this.slotsChanged((Container)this);
            ContainerBuilder.this.callbackInventoryChange.run();
        }
    };

    public static ContainerBuilder Bed(int id, Inventory playerInv) {
        return new ContainerBuilder(id, playerInv, BuilderMode.BED);
    }

    public static ContainerBuilder Ladder(int id, Inventory playerInv) {
        return new ContainerBuilder(id, playerInv, BuilderMode.LADDER);
    }

    private ContainerBuilder(int id, final Inventory playerInv, BuilderMode mode) {
        super(mode.getType(), id);
        this.builderMode = mode;
        this.canUse = true;
        this.slotBaseItem = this.addSlot(new Slot(this.invInput, 0, 53, 102){

            public boolean mayPlace(ItemStack stack) {
                return ContainerBuilder.this.builderMode.getItemClass().isInstance(stack.getItem());
            }
        });
        this.slotMaterial = this.addSlot(new Slot(this, this.invInput, 1, 71, 102){

            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() instanceof BlockItem && !(((BlockItem)stack.getItem()).getBlock() instanceof EntityBlock);
            }
        });
        this.slotOutput = this.addSlot(new Slot(this.invOutput, 0, 113, 102){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public void onTake(Player player, ItemStack stack) {
                if (player.getAbilities().instabuild) {
                    super.onTake(player, stack);
                    return;
                }
                if (ContainerBuilder.this.slotBaseItem.getItem().isDamageableItem()) {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        Level level = player.level();
                        if (level instanceof ServerLevel) {
                            ServerLevel serverWorld = (ServerLevel)level;
                            ContainerBuilder.this.slotBaseItem.getItem().hurtAndBreak(1, serverWorld, serverPlayer, entity -> {});
                        }
                    }
                } else {
                    ContainerBuilder.this.slotBaseItem.remove(1);
                }
                ContainerBuilder.this.slotMaterial.remove(1);
                if (ContainerBuilder.this.builderMode == BuilderMode.BED && !ContainerBuilder.this.slotBaseItem.hasItem()) {
                    for (ItemStack itemStack : playerInv.items) {
                        if (itemStack.isEmpty() || !(itemStack.getItem() instanceof ItemBuilderKit)) continue;
                        super.onTake(player, stack);
                        return;
                    }
                    ContainerBuilder.this.canUse = false;
                }
                super.onTake(player, stack);
            }
        });
        int pX = 11;
        int pY = 148;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; col = (int)((byte)(col + 1))) {
                this.addSlot(new Slot((Container)playerInv, col + row * 9 + 9, pX + col * 18, pY));
            }
            pY += 18;
        }
        pY += 4;
        for (int col = 0; col < 9; col = (int)((byte)(col + 1))) {
            this.addSlot(new Slot((Container)playerInv, col, pX + col * 18, pY));
        }
        this.indexBedStyle.set(EnumBedStyle.COT.ordinal());
        this.addDataSlot(this.indexBedStyle);
        this.slotBaseItem.set(playerInv.getSelected().split(1));
        this.updateOutputStack();
    }

    public int getBedStyleIndex() {
        return this.indexBedStyle.get();
    }

    public boolean stillValid(Player player) {
        return this.canUse || !player.containerMenu.getCarried().isEmpty();
    }

    public boolean clickMenuButton(Player player, int id) {
        this.indexBedStyle.set(Mth.clamp((int)id, (int)0, (int)EnumBedStyle.values().length));
        this.updateOutputStack();
        return true;
    }

    private void updateOutputStack() {
        ItemStack stack = this.getUpdatedStack();
        if (!stack.isEmpty()) {
            this.stackOutput = stack;
            this.slotsChanged(null);
        }
    }

    private ItemStack getUpdatedStack() {
        switch (this.builderMode.ordinal()) {
            case 0: {
                EnumBedStyle style = EnumBedStyle.byIndex(this.indexBedStyle.get());
                return ItemBlockMultiBed.createStack((Block)Roster.Blocks.getBed(style), this.slotMaterial.getItem());
            }
            case 1: {
                ItemStack stack = ItemBlockLadder.createStack((Block)Roster.Blocks.LADDER.get(), this.slotMaterial.getItem());
                stack.setCount(4);
                return stack;
            }
        }
        return ItemStack.EMPTY;
    }

    public void slotsChanged(Container inventory) {
        ItemStack stackBedKit = this.slotBaseItem.getItem();
        ItemStack stackMaterial = this.slotMaterial.getItem();
        if (stackBedKit.isEmpty() || stackMaterial.isEmpty()) {
            this.slotOutput.set(ItemStack.EMPTY);
        } else {
            if (inventory != null) {
                this.updateOutputStack();
            }
            this.slotOutput.set(this.stackOutput);
        }
        this.broadcastChanges();
    }

    public void setInventoryChangeCallback(Runnable runnable) {
        this.callbackInventoryChange = runnable;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot clickedSlot = (Slot)this.slots.get(index);
        if (clickedSlot != null && clickedSlot.hasItem()) {
            ItemStack itemInSlot = clickedSlot.getItem();
            itemstack = itemInSlot.copy();
            if (index == this.slotOutput.index) {
                if (!this.moveItemStackTo(itemInSlot, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                clickedSlot.onQuickCraft(itemInSlot, itemstack);
            } else if (index != this.slotBaseItem.index && index != this.slotMaterial.index ? (this.slotBaseItem.mayPlace(itemInSlot) ? !this.moveItemStackTo(itemInSlot, this.slotBaseItem.index, this.slotBaseItem.index + 1, false) : (this.slotMaterial.mayPlace(itemInSlot) ? !this.moveItemStackTo(itemInSlot, this.slotMaterial.index, this.slotMaterial.index + 1, false) : (index >= 3 && index < 30 ? !this.moveItemStackTo(itemInSlot, 30, 39, false) : index >= 30 && index < 39 && !this.moveItemStackTo(itemInSlot, 3, 30, false)))) : !this.moveItemStackTo(itemInSlot, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (itemInSlot.isEmpty()) {
                clickedSlot.set(ItemStack.EMPTY);
            } else {
                clickedSlot.setChanged();
            }
            if (itemInSlot.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            clickedSlot.onTake(player, itemInSlot);
        }
        return itemstack;
    }

    public void removed(Player player) {
        super.removed(player);
        this.clearContainer(player, this.invInput);
    }

    public void setItem(int slotID, int stateID, ItemStack stack) {
        super.setItem(slotID, stateID, stack);
        this.updateRenderedStack();
    }

    public void setData(int id, int data) {
        super.setData(id, data);
        this.updateRenderedStack();
    }

    private void updateRenderedStack() {
        this.stackOutput = this.getUpdatedStack();
        this.callbackInventoryChange.run();
    }

    public Slot getSlotBaseItem() {
        return this.slotBaseItem;
    }

    public Slot getSlotMaterial() {
        return this.slotMaterial;
    }

    public ItemStack getPreviewItem() {
        return this.slotOutput.hasItem() ? this.slotOutput.getItem() : this.stackOutput;
    }

    public BuilderMode getBuilderMode() {
        return this.builderMode;
    }

    public static enum BuilderMode {
        BED((MenuType)Roster.Containers.BED_KIT.get(), ItemBuilderKit.Bed.class),
        LADDER((MenuType)Roster.Containers.LADDER_KIT.get(), ItemBuilderKit.Ladder.class);

        private final MenuType<?> type;
        private final Class<?> itemClass;

        private BuilderMode(MenuType<?> type, Class<?> itemClass) {
            this.type = type;
            this.itemClass = itemClass;
        }

        private MenuType<?> getType() {
            return this.type;
        }

        Class<?> getItemClass() {
            return this.itemClass;
        }
    }
}

