/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.inventory;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.TagHelper;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.common.component.Artwork;
import shetiphian.multibeds.common.item.ItemBedCustomization;
import shetiphian.multibeds.common.item.ItemBlanket;
import shetiphian.multibeds.common.misc.EnumBlanket;

public class ContainerBlanketLoom
extends AbstractContainerMenu {
    private final ContainerLevelAccess worldPos;
    private final DataSlot indexSelectedPattern = DataSlot.standalone();
    private EnumBlanket enumBlanket = EnumBlanket.NONE;
    private final Slot slotBlanket;
    private final Slot slotDye;
    private final Slot slotString;
    private final Slot slotOutput;
    private final Container invInputs = new SimpleContainer(3){

        public void setChanged() {
            super.setChanged();
            ContainerBlanketLoom.this.slotsChanged((Container)this);
            if (ContainerBlanketLoom.this.slotOutput.getItem().isEmpty()) {
                ItemStack stack = this.getItem(0);
                if (stack.isEmpty()) {
                    ContainerBlanketLoom.this.enumBlanket = EnumBlanket.NONE;
                } else if (stack.getItem() instanceof ItemBlanket) {
                    DyeColor color = ((ItemBlanket)stack.getItem()).getColor(stack);
                    String pattern = ItemBlanket.getPatternName(stack);
                    ContainerBlanketLoom.this.enumBlanket = EnumBlanket.byName(pattern + "_" + color.getName());
                }
            }
        }
    };
    private final Container invOutput = new SimpleContainer(1){

        public void setChanged() {
            super.setChanged();
            ItemStack stack = this.getItem(0);
            if (stack.isEmpty() && ContainerBlanketLoom.this.slotBlanket.getItem().isEmpty()) {
                ContainerBlanketLoom.this.enumBlanket = EnumBlanket.NONE;
            } else if (stack.getItem() instanceof ItemBlanket) {
                DyeColor color = ((ItemBlanket)stack.getItem()).getColor(stack);
                String pattern = ItemBlanket.getPatternName(stack);
                ContainerBlanketLoom.this.enumBlanket = EnumBlanket.byName(pattern + "_" + color.getName());
            }
        }
    };

    public ContainerBlanketLoom(int id, Inventory playerInv) {
        this(id, playerInv, ContainerLevelAccess.NULL);
    }

    public ContainerBlanketLoom(int id, Inventory playerInv, final ContainerLevelAccess callable) {
        super((MenuType)Roster.Containers.BLANKET_LOOM.get(), id);
        this.worldPos = callable;
        this.slotBlanket = this.addSlot(new Slot(this.invInputs, 0, 16, 88){

            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() instanceof ItemBlanket;
            }

            public void set(ItemStack stack) {
                ContainerBlanketLoom.this.indexSelectedPattern.set(ItemBlanket.getBlanket(stack).getPattern().ordinal());
                super.set(stack);
            }
        });
        this.slotDye = this.addSlot(new Slot(this, this.invInputs, 1, 40, 88){

            public boolean mayPlace(ItemStack stack) {
                return DyeHelper.isDye((ItemStack)stack);
            }
        });
        this.slotString = this.addSlot(new Slot(this, this.invInputs, 2, 64, 88){

            public boolean mayPlace(ItemStack stack) {
                return TagHelper.isInTag((ItemStack)stack, (String)"c:strings");
            }
        });
        this.slotOutput = this.addSlot(new Slot(this.invOutput, 0, 40, 120){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public void onTake(Player thePlayer, ItemStack stack) {
                ItemStack stackBlanket = ContainerBlanketLoom.this.slotBlanket.getItem();
                if (!ItemBlanket.getPatternName(stack).equals(ItemBlanket.getPatternName(stackBlanket))) {
                    ContainerBlanketLoom.this.slotString.remove(1);
                }
                if (stack.getItem() != stackBlanket.getItem()) {
                    ContainerBlanketLoom.this.slotDye.remove(1);
                }
                ContainerBlanketLoom.this.slotBlanket.remove(1);
                callable.execute((world, pos) -> world.playSound(null, pos, SoundEvents.UI_LOOM_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f));
                super.onTake(thePlayer, stack);
            }
        });
        int pX = 27;
        int pY = 171;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; col = (int)((byte)(col + 1))) {
                this.addSlot(new Slot((Container)playerInv, col + row * 9 + 9, pX + col * 18, pY));
            }
            pY += 18;
        }
        pY += 4;
        for (int col = 0; col < 9; col = (int)((byte)(col + 1))) {
            this.addSlot(new Slot((Container)playerInv, col, pX + col * 18, pY));
        }
        this.addDataSlot(this.indexSelectedPattern);
        this.slotBlanket.set(playerInv.getSelected().split(1));
    }

    public void clicked(int slotId, int dragType, ClickType clickType, Player player) {
        if (player.getAbilities().instabuild && player.containerMenu.getCarried().isEmpty()) {
            ItemStack blanket;
            if (slotId == this.slotString.index) {
                if (!this.slotString.hasItem()) {
                    this.slotString.set(new ItemStack((ItemLike)Items.STRING));
                    this.updateOutputStack();
                    this.broadcastChanges();
                    return;
                }
            } else if (slotId == this.slotDye.index && !this.slotDye.hasItem() && (blanket = this.slotBlanket.getItem()).getItem() instanceof ItemBedCustomization) {
                DyeColor color = DyeColor.byId((int)(((ItemBedCustomization)blanket.getItem()).getColor(blanket).getId() + 1));
                this.slotDye.set(new ItemStack((ItemLike)DyeItem.byColor((DyeColor)color)));
                this.updateOutputStack();
                this.broadcastChanges();
                return;
            }
        }
        super.clicked(slotId, dragType, clickType, player);
    }

    public boolean stillValid(Player playerIn) {
        return ContainerBlanketLoom.stillValid((ContainerLevelAccess)this.worldPos, (Player)playerIn, (Block)Blocks.LOOM);
    }

    public boolean clickMenuButton(Player player, int id) {
        if (id >= 0 && id < EnumBlanket.Pattern.values().length) {
            this.indexSelectedPattern.set(id);
            this.updateOutputStack();
            return true;
        }
        return false;
    }

    public void slotsChanged(Container inventory) {
        this.updateOutputStack();
        this.broadcastChanges();
    }

    private void updateOutputStack() {
        ItemStack stackBlanket = this.slotBlanket.getItem();
        ItemStack stackDye = this.slotDye.getItem();
        ItemStack stackString = this.slotString.getItem();
        ItemStack stackOutput = ItemStack.EMPTY;
        if (!stackBlanket.isEmpty()) {
            if (!stackDye.isEmpty() || !stackString.isEmpty()) {
                DyeColor dyeColor = DyeHelper.getDyeColor((ItemStack)stackDye);
                if (!stackDye.isEmpty() && dyeColor != null) {
                    stackOutput = new ItemStack((ItemLike)Roster.Items.getBlanket(dyeColor));
                } else {
                    stackOutput = stackBlanket.copy();
                    stackOutput.setCount(1);
                }
                Artwork artwork = (Artwork)stackBlanket.get((DataComponentType)Roster.Components.ARTWORK_DATA.get());
                if (artwork != null) {
                    stackOutput.set((DataComponentType)Roster.Components.ARTWORK_DATA.get(), (Object)artwork);
                }
                if (!stackString.isEmpty()) {
                    ItemBlanket.setPatternName(stackOutput, EnumBlanket.Pattern.byIndex(this.indexSelectedPattern.get()));
                }
            }
        } else {
            this.indexSelectedPattern.set(0);
        }
        if (!ItemStack.matches((ItemStack)stackOutput, (ItemStack)this.slotOutput.getItem())) {
            this.slotOutput.set(stackOutput);
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == this.slotOutput.index) {
                if (!this.moveItemStackTo(itemstack1, 4, 40, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index != this.slotDye.index && index != this.slotBlanket.index && index != this.slotString.index ? (itemstack1.getItem() instanceof ItemBlanket ? !this.moveItemStackTo(itemstack1, this.slotBlanket.index, this.slotBlanket.index + 1, false) : (DyeHelper.isDye((ItemStack)itemstack1) ? !this.moveItemStackTo(itemstack1, this.slotDye.index, this.slotDye.index + 1, false) : (TagHelper.isInTag((ItemStack)itemstack1, (String)"c:strings") ? !this.moveItemStackTo(itemstack1, this.slotString.index, this.slotString.index + 1, false) : (index >= 4 && index < 31 ? !this.moveItemStackTo(itemstack1, 31, 40, false) : index >= 31 && index < 40 && !this.moveItemStackTo(itemstack1, 4, 31, false))))) : !this.moveItemStackTo(itemstack1, 4, 40, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    public void removed(Player player) {
        super.removed(player);
        this.worldPos.execute((p_217028_2_, p_217028_3_) -> this.clearContainer(player, this.invInputs));
    }

    public Slot getSlotBlanket() {
        return this.slotBlanket;
    }

    public Slot getSlotDye() {
        return this.slotDye;
    }

    public Slot getSlotString() {
        return this.slotString;
    }

    public EnumBlanket getEnumBlanket() {
        return this.enumBlanket;
    }
}

