/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.crafting;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.common.item.ItemBlockLadder;
import shetiphian.multibeds.common.item.ItemBlockMultiBed;

public class RecipeUncraft
extends CustomRecipe {
    public static final byte LADDER_COUNT = 4;

    public RecipeUncraft(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput inventory, Level world) {
        for (int index = 0; index < inventory.size(); ++index) {
            ItemStack stack = inventory.getItem(index);
            if (stack.isEmpty()) continue;
            Item item = stack.getItem();
            if (item instanceof ItemBlockMultiBed) {
                return this.handleBeds(inventory, index) > 0;
            }
            if (item instanceof ItemBlockLadder) {
                return !this.handleLadders(inventory, index).isEmpty();
            }
            return false;
        }
        return false;
    }

    private int handleBeds(CraftingInput inventory, int start) {
        int counter = 0;
        for (int index = start; index < inventory.size(); ++index) {
            ItemBlockMultiBed bed;
            ItemStack stack = inventory.getItem(index);
            if (stack.isEmpty()) continue;
            Item item = stack.getItem();
            if (item instanceof ItemBlockMultiBed && !(bed = (ItemBlockMultiBed)item).hasBedding(stack)) {
                counter += stack.getCount();
                continue;
            }
            return 0;
        }
        return counter > 0 && counter <= ((Item)Roster.Items.BED_KIT.get()).getDefaultMaxStackSize() ? counter : 0;
    }

    private ItemStack handleLadders(CraftingInput inventory, int start) {
        ItemStack material = ItemStack.EMPTY;
        int counter = 0;
        for (int index = start; index < inventory.size(); ++index) {
            ItemStack stack = inventory.getItem(index);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof ItemBlockLadder) {
                ItemStack texture = ItemBlockLadder.getTextureStack(stack);
                if (material.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)material, (ItemStack)texture)) {
                    material = texture;
                    counter += stack.getCount();
                    continue;
                }
            }
            return ItemStack.EMPTY;
        }
        return (counter /= 4) > 0 ? material.copyWithCount(Math.min(counter, material.getMaxStackSize())) : ItemStack.EMPTY;
    }

    public ItemStack assemble(CraftingInput inventory, HolderLookup.Provider provider) {
        for (int index = 0; index < inventory.size(); ++index) {
            ItemStack stack = inventory.getItem(index);
            if (stack.isEmpty()) continue;
            Item item = stack.getItem();
            if (item instanceof ItemBlockMultiBed) {
                int count = this.handleBeds(inventory, index);
                if (count <= 0) continue;
                return new ItemStack((ItemLike)Roster.Items.BED_KIT.get(), count);
            }
            if (!(item instanceof ItemBlockLadder)) continue;
            return this.handleLadders(inventory, index);
        }
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inventory) {
        ItemStack material = this.handleLadders(inventory, 0);
        int used = material != null ? material.getCount() * 4 : 0;
        NonNullList list = NonNullList.withSize((int)inventory.size(), (Object)ItemStack.EMPTY);
        for (int index = 0; index < list.size(); ++index) {
            ItemStack stack = inventory.getItem(index);
            if (stack.isEmpty()) continue;
            Item item = stack.getItem();
            if (item instanceof ItemBlockMultiBed) {
                list.set(index, (Object)ItemBlockMultiBed.getTextureStack(stack).copyWithCount(stack.getCount()));
                continue;
            }
            if (!(item instanceof ItemBlockLadder) || (used -= stack.getCount()) >= 0) continue;
            list.set(index, (Object)stack.copyWithCount(-used));
            used = 0;
        }
        return list;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height > 0;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)Roster.RecipeSerializers.UNCRAFT.get();
    }
}

