/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.crafting;

import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import shetiphian.core.common.TagHelper;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.common.item.ItemEmbroideryThread;

public class RecipeSpool
extends CustomRecipe {
    public RecipeSpool(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput inv, Level world) {
        int string_count = 0;
        ItemStack spool = ItemStack.EMPTY;
        for (int index = 0; index < inv.size(); ++index) {
            ItemStack invStack = inv.getItem(index);
            if (this.isValid(invStack)) {
                if (invStack.getItem() instanceof ItemEmbroideryThread) {
                    if (spool.isEmpty()) {
                        spool = invStack.copy();
                        continue;
                    }
                    return false;
                }
                ++string_count;
                continue;
            }
            if (invStack.isEmpty()) continue;
            return false;
        }
        return !spool.isEmpty() && spool.getDamageValue() - 3 * string_count >= 0;
    }

    private boolean isValid(ItemStack stack) {
        return !stack.isEmpty() && (stack.getItem() instanceof ItemEmbroideryThread || TagHelper.isInTag((ItemStack)stack, (String)"c:strings"));
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        int string_count = 0;
        ItemStack spool = ItemStack.EMPTY;
        for (int index = 0; index < inv.size(); ++index) {
            ItemStack invStack = inv.getItem(index);
            if (!this.isValid(invStack)) continue;
            if (invStack.getItem() instanceof ItemEmbroideryThread) {
                spool = invStack.copy();
                spool.setCount(1);
                continue;
            }
            if (invStack.isEmpty()) continue;
            ++string_count;
        }
        if (!spool.isEmpty()) {
            int damage = spool.getDamageValue() - 3 * string_count;
            spool.setDamageValue(Math.max(0, damage));
        }
        return spool;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)Roster.RecipeSerializers.SPOOLING.get();
    }
}

