/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public record Texture(ItemStack stack) {
    public static final ItemStack DEFAULT_STACK = new ItemStack((ItemLike)Blocks.OAK_PLANKS);
    public static final String DEFAULT_TEXTURE = "minecraft:block/oak_planks";
    private static final Codec<ItemStack> OPTIONAL_SINGLE_ITEM_CODEC = ExtraCodecs.optionalEmptyMap((Codec)ItemStack.SINGLE_ITEM_CODEC).xmap(optional -> optional.orElse(ItemStack.EMPTY), stack -> stack.isEmpty() ? Optional.empty() : Optional.of(stack));
    public static final Codec<Texture> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)OPTIONAL_SINGLE_ITEM_CODEC.optionalFieldOf("item", (Object)DEFAULT_STACK).forGetter(Texture::stack)).apply((Applicative)instance, Texture::new));
    public static final Texture DEFAULT = new Texture(DEFAULT_STACK);
    public static final Texture EMPTY = new Texture(ItemStack.EMPTY);
    public static final Texture DEV_TEST_1 = new Texture(new ItemStack((ItemLike)Blocks.GRASS_BLOCK));
    public static final Texture DEV_TEST_2 = new Texture(new ItemStack((ItemLike)Blocks.LIGHT_BLUE_STAINED_GLASS));

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Texture)) return false;
        Texture other = (Texture)obj;
        if (!ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)other.stack)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.stack);
    }
}

