/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import shetiphian.multibeds.common.item.ItemBedCustomization;

public record Bedding(ItemStack blanket, ItemStack pillow, ItemStack sheet, boolean mirrored) {
    public static final Codec<Bedding> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.optionalFieldOf("blanket", (Object)ItemStack.EMPTY).forGetter(bedding -> bedding.blanket), (App)ItemStack.CODEC.optionalFieldOf("pillow", (Object)ItemStack.EMPTY).forGetter(bedding -> bedding.pillow), (App)ItemStack.CODEC.optionalFieldOf("sheet", (Object)ItemStack.EMPTY).forGetter(bedding -> bedding.sheet), (App)Codec.BOOL.optionalFieldOf("mirrored", (Object)false).forGetter(bedding -> bedding.mirrored)).apply((Applicative)instance, Bedding::new));
    public static final Bedding EMPTY = new Bedding(ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, false);

    public Bedding {
        ItemBedCustomization ibc;
        Item item;
        if (!blanket.isEmpty() && !(blanket.getItem() instanceof BannerItem)) {
            mirrored = false;
            item = blanket.getItem();
            if (!(item instanceof ItemBedCustomization) || (ibc = (ItemBedCustomization)item).getType() != ItemBedCustomization.EnumType.BLANKET) {
                blanket = ItemStack.EMPTY;
            }
        }
        if (!(pillow.isEmpty() || (item = pillow.getItem()) instanceof ItemBedCustomization && (ibc = (ItemBedCustomization)item).getType() == ItemBedCustomization.EnumType.PILLOW)) {
            pillow = ItemStack.EMPTY;
        }
        if (!(sheet.isEmpty() || (item = sheet.getItem()) instanceof ItemBedCustomization && (ibc = (ItemBedCustomization)item).getType() == ItemBedCustomization.EnumType.SHEET)) {
            sheet = ItemStack.EMPTY;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Bedding)) return false;
        Bedding other = (Bedding)obj;
        if (!ItemStack.isSameItemSameComponents((ItemStack)this.blanket, (ItemStack)other.blanket)) return false;
        if (!ItemStack.isSameItemSameComponents((ItemStack)this.pillow, (ItemStack)other.pillow)) return false;
        if (!ItemStack.isSameItemSameComponents((ItemStack)this.sheet, (ItemStack)other.sheet)) return false;
        if (this.mirrored != other.mirrored) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.blanket, this.pillow, this.sheet, this.mirrored);
    }
}

