/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.block;

import com.google.common.collect.Table;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import shetiphian.core.common.BlockLightingHelper;
import shetiphian.core.common.Helpers;
import shetiphian.core.common.IColored;
import shetiphian.core.common.block.IExtendedAwarenessBlock;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.common.block.BlockBedExtra;
import shetiphian.multibeds.common.block.HitBoxHelper;
import shetiphian.multibeds.common.block.ILighting;
import shetiphian.multibeds.common.item.ItemBedCustomization;
import shetiphian.multibeds.common.item.ItemBeddingPackage;
import shetiphian.multibeds.common.item.ItemBlockMultiBed;
import shetiphian.multibeds.common.item.ItemEmbroideryThread;
import shetiphian.multibeds.common.misc.EnumBedStyle;
import shetiphian.multibeds.common.tileentity.TileEntityMultiBed;

public class BlockMultiBed
extends BedBlock
implements IColored,
IExtendedAwarenessBlock,
ILighting,
SimpleWaterloggedBlock {
    private static final MapCodec<BedBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EnumBedStyle.CODEC.fieldOf("bed_style").forGetter(bedBlock -> ((BlockMultiBed)bedBlock).getBedStyle())).apply((Applicative)instance, BlockMultiBed::new));
    private final EnumBedStyle enumBedStyle;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    static final Table<String, Direction, VoxelShape> HITBOXES = new HitBoxHelper().loadBedBoxes().get();
    static final Map<String, VoxelShape> BOXCACHE = new HashMap<String, VoxelShape>();
    private static final VoxelShape SHAPE_BASE = Block.box((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)7.0, (double)14.0);
    private static final VoxelShape SHAPE_SLAB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape SHAPE_CUSTOM = Block.box((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape SHAPE_EXT = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);

    public MapCodec<BedBlock> codec() {
        return CODEC;
    }

    public BlockMultiBed(EnumBedStyle style) {
        super(DyeColor.WHITE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LIGHT_GRAY_BED).lightLevel(BlockLightingHelper::getLightValue));
        this.enumBedStyle = style;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)PART, (Comparable)BedPart.FOOT)).setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockLightingHelper.LIGHTING, (Comparable)BlockLightingHelper.PackedData.UNKNOWEN));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED, BlockLightingHelper.LIGHTING});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)Roster.Tiles.BED.get()).create(pos, state);
    }

    public EnumBedStyle getBedStyle() {
        return this.enumBedStyle;
    }

    public MapColor getMapColor(BlockState state, BlockGetter world, BlockPos pos) {
        TileEntityMultiBed tile = BlockMultiBed.getTile(world, pos);
        return tile != null ? tile.getBlanketType().getMapColor() : DyeColor.WHITE.getMapColor();
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        String cacheKey = BlockMultiBed.getShapeKey(state, world, pos, this.enumBedStyle, true);
        if (!BOXCACHE.containsKey(cacheKey)) {
            BOXCACHE.put(cacheKey, this.buildShape(state, world, pos, context, true));
        }
        return BOXCACHE.get(cacheKey);
    }

    static String getShapeKey(BlockState state, BlockGetter world, BlockPos pos, EnumBedStyle style, boolean collision) {
        String type = "single:single";
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof TileEntityMultiBed) {
            type = ((TileEntityMultiBed)tile).getModelType();
        }
        return (collision ? "collision:" : "base:") + String.valueOf((Object)style) + ":" + type + ":" + String.valueOf(state.getValue((Property)PART)) + ":" + ((Direction)state.getValue((Property)FACING)).getName();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        String cacheKey = BlockMultiBed.getShapeKey(state, world, pos, this.enumBedStyle, false);
        if (!BOXCACHE.containsKey(cacheKey)) {
            BOXCACHE.put(cacheKey, this.buildShape(state, world, pos, context, false));
        }
        return BOXCACHE.get(cacheKey);
    }

    private VoxelShape buildShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context, boolean collision) {
        if (!HITBOXES.isEmpty()) {
            String base;
            Direction dir = (Direction)state.getValue((Property)FACING);
            boolean isFoot = state.getValue((Property)PART) == BedPart.FOOT;
            String typeBunk = "single";
            String typeGang = "single";
            BlockEntity tile = world.getBlockEntity(pos);
            if (tile instanceof TileEntityMultiBed) {
                String[] types = ((TileEntityMultiBed)tile).getModelType().split("#");
                typeBunk = types[0];
                typeGang = types[1];
            }
            boolean isBunked = !typeBunk.equalsIgnoreCase("single");
            VoxelShape[] parts = new VoxelShape[6];
            String mattress = (String)(this.enumBedStyle.hasCustomMattress() ? String.valueOf((Object)this.enumBedStyle) + "_" : "") + "mattress_" + typeGang + (isFoot ? "_foot" : "_head");
            VoxelShape voxelShape = parts[2] = collision ? SHAPE_EXT : (VoxelShape)HITBOXES.get((Object)mattress, (Object)dir);
            if (!isFoot) {
                String pillow = "pillow_" + (typeGang.equalsIgnoreCase("single") ? "middle" : typeGang);
                parts[3] = (VoxelShape)HITBOXES.get((Object)pillow, (Object)dir);
                if (typeBunk.equalsIgnoreCase("middle") || typeBunk.equalsIgnoreCase("top")) {
                    if (typeGang.contains("left") || typeGang.contains("single")) {
                        parts[4] = (VoxelShape)HITBOXES.get((Object)(String.valueOf((Object)this.enumBedStyle) + "_rail_left"), (Object)dir);
                    }
                    if (typeGang.contains("right") || typeGang.contains("single")) {
                        parts[5] = (VoxelShape)HITBOXES.get((Object)(String.valueOf((Object)this.enumBedStyle) + "_rail_right"), (Object)dir);
                    }
                }
            }
            if (this.enumBedStyle == EnumBedStyle.CUSTOM) {
                return Shapes.or((VoxelShape)SHAPE_CUSTOM, (VoxelShape[])((VoxelShape[])Arrays.stream(parts).filter(Objects::nonNull).toArray(VoxelShape[]::new)));
            }
            if (this.enumBedStyle == EnumBedStyle.SLAB) {
                return Shapes.or((VoxelShape)SHAPE_SLAB, (VoxelShape[])((VoxelShape[])Arrays.stream(parts).filter(Objects::nonNull).toArray(VoxelShape[]::new)));
            }
            if (this.enumBedStyle.hasCustomPillow()) {
                parts[3] = (VoxelShape)HITBOXES.get((Object)(String.valueOf((Object)this.enumBedStyle) + "_pillow_" + typeGang), (Object)dir);
            }
            if (!(base = this.enumBedStyle.getBaseType()).equalsIgnoreCase("none")) {
                parts[0] = (VoxelShape)HITBOXES.get((Object)("base_" + base + "_" + typeGang + (isFoot ? "_foot" : "_head")), (Object)dir);
            }
            String frame = String.valueOf((Object)this.enumBedStyle) + "_" + (String)(isBunked ? "bunk_" + typeBunk : typeGang) + (isFoot ? "_foot" : "_head");
            if (this.enumBedStyle.hasComboModels()) {
                frame = String.valueOf((Object)this.enumBedStyle) + "_" + (String)(isBunked ? "bunk_" + typeBunk + "_" + typeGang : typeGang) + (isFoot ? "_foot" : "_head");
            }
            parts[1] = (VoxelShape)HITBOXES.get((Object)frame, (Object)dir);
            return Shapes.or((VoxelShape)SHAPE_BASE, (VoxelShape[])((VoxelShape[])Arrays.stream(parts).filter(Objects::nonNull).toArray(VoxelShape[]::new)));
        }
        return super.getShape(state, world, pos, context);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state != null) {
            return (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
        }
        return state;
    }

    public ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!heldItem.isEmpty()) {
            Item item = heldItem.getItem();
            if (item instanceof ItemBedCustomization || item instanceof ItemBeddingPackage || item instanceof ItemEmbroideryThread) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (item instanceof BannerItem && ItemBedCustomization.putOnBed(heldItem.copy(), player, world, pos, hit.getDirection(), player.isShiftKeyDown())) {
                if (!player.getAbilities().instabuild) {
                    heldItem.shrink(1);
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(heldItem, state, world, pos, player, hand, hit);
    }

    public void attack(BlockState state, Level world, BlockPos pos, Player player) {
        if (player != null && player.isShiftKeyDown() && !world.isClientSide()) {
            this.removeBedding(world, pos, player);
        }
        super.attack(state, world, pos, player);
    }

    private void removeBedding(Level world, BlockPos pos, Player player) {
        TileEntityMultiBed[] bedTiles = BlockMultiBed.getTiles((BlockGetter)world, pos);
        if (bedTiles != null) {
            int half;
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            boolean dropped = false;
            for (half = 0; half < 2; ++half) {
                if (dropped || !bedTiles[half].hasBlanket()) continue;
                dropped = true;
                drops.add(bedTiles[half].getBlanketItem());
                bedTiles[0].removeBlanket();
                bedTiles[1].removeBlanket();
            }
            dropped = false;
            for (half = 0; half < 2; ++half) {
                if (dropped || !bedTiles[half].hasPillow()) continue;
                dropped = true;
                drops.add(bedTiles[half].getPillowItem());
                bedTiles[0].removePillow();
                bedTiles[1].removePillow();
            }
            dropped = false;
            for (half = 0; half < 2; ++half) {
                if (dropped || !bedTiles[half].hasSheet()) continue;
                dropped = true;
                drops.add(bedTiles[half].getSheetItem());
                bedTiles[0].removeSheet();
                bedTiles[1].removeSheet();
            }
            if (!drops.isEmpty()) {
                Helpers.syncTile((BlockEntity)bedTiles[0]);
                Helpers.syncTile((BlockEntity)bedTiles[1]);
                SoundType soundtype = SoundType.WOOL;
                world.playSound(player, pos, soundtype.getBreakSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                for (ItemStack stack : drops) {
                    Helpers.giveItem((Player)player, (ItemStack)stack);
                }
            }
        }
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntityMultiBed[] tiles;
        BlockPos blockpos = pos.relative((Direction)state.getValue((Property)FACING));
        world.setBlock(blockpos, (BlockState)((BlockState)state.setValue((Property)PART, (Comparable)BedPart.HEAD)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(blockpos).getType() == Fluids.WATER)), 3);
        world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)PART, (Comparable)BedPart.FOOT)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos).getType() == Fluids.WATER)), 3);
        if (this.enumBedStyle.hasTopper()) {
            this.addBedExtraBlock(world, blockpos.above(), world.getBlockState(blockpos));
            this.addBedExtraBlock(world, pos.above(), world.getBlockState(pos));
        }
        if ((tiles = BlockMultiBed.getTiles((BlockGetter)world, pos)) != null) {
            CompoundTag nbtTag = new CompoundTag();
            if (tiles[0].getBlockPos() == pos) {
                tiles[0].buildNBT(nbtTag, (HolderLookup.Provider)world.registryAccess());
                tiles[1].processNBT(nbtTag, (HolderLookup.Provider)world.registryAccess());
            } else {
                tiles[1].buildNBT(nbtTag, (HolderLookup.Provider)world.registryAccess());
                tiles[0].processNBT(nbtTag, (HolderLookup.Provider)world.registryAccess());
            }
            Helpers.syncTile((BlockEntity)tiles[0]);
            Helpers.syncTile((BlockEntity)tiles[1]);
        }
        this.setLighting(state, world, pos, ItemBlockMultiBed.getTextureStack(stack));
        world.blockUpdated(pos, Blocks.AIR);
        state.updateNeighbourShapes((LevelAccessor)world, pos, 3);
    }

    private void addBedExtraBlock(Level world, BlockPos pos, BlockState bed) {
        if (world.getBlockState(pos).canBeReplaced()) {
            world.setBlock(pos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((Block)Roster.Blocks.BEXTRA.get()).defaultBlockState().setValue(BlockBedExtra.BEDSTYLE, (Comparable)((Object)this.enumBedStyle))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos).getType() == Fluids.WATER))).setValue((Property)BlockLightingHelper.LIGHTING, (Comparable)((BlockLightingHelper.PackedData)bed.getValue((Property)BlockLightingHelper.LIGHTING)))).setValue((Property)FACING, (Comparable)((Direction)bed.getValue((Property)FACING)))).setValue((Property)PART, (Comparable)((BedPart)bed.getValue((Property)PART))), 3);
        }
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos neighbor, boolean isMoving) {
        TileEntityMultiBed tile;
        BlockPos topper;
        super.neighborChanged(state, world, pos, block, neighbor, isMoving);
        if (this.enumBedStyle.hasTopper() && world.getBlockState(topper = pos.above()).getBlock() != Roster.Blocks.BEXTRA.get()) {
            this.addBedExtraBlock(world, topper, state);
        }
        if ((tile = BlockMultiBed.getTile((BlockGetter)world, pos)) != null) {
            if (neighbor != pos.relative((Direction)state.getValue((Property)FACING))) {
                Helpers.syncTile((BlockEntity)tile);
            }
            this.setLighting(state, world, pos, tile.getTextureBlock());
        }
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        TileEntityMultiBed tile = BlockMultiBed.getTile((BlockGetter)world, pos);
        return ItemBlockMultiBed.createStack((Block)this, tile != null ? tile.getTextureBlock() : ItemStack.EMPTY);
    }

    public static BlockPos[] getBlocks(BlockGetter world, BlockPos pos) {
        BlockPos[] bedPos = new BlockPos[]{pos, pos};
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() instanceof BlockMultiBed) {
            if (state.getValue((Property)BedBlock.PART) == BedPart.FOOT) {
                bedPos[0] = pos.relative((Direction)state.getValue((Property)BedBlock.FACING));
            } else {
                bedPos[1] = pos.relative(((Direction)state.getValue((Property)BedBlock.FACING)).getOpposite());
            }
        }
        return bedPos;
    }

    private static TileEntityMultiBed getTile(BlockGetter world, BlockPos pos) {
        BlockEntity tile = world.getBlockEntity(pos);
        return tile instanceof TileEntityMultiBed ? (TileEntityMultiBed)tile : null;
    }

    public static TileEntityMultiBed[] getTiles(BlockGetter world, BlockPos pos) {
        BlockPos[] bedBlocks = BlockMultiBed.getBlocks(world, pos);
        TileEntityMultiBed[] tiles = new TileEntityMultiBed[]{BlockMultiBed.getTile(world, bedBlocks[0]), BlockMultiBed.getTile(world, bedBlocks[1])};
        return tiles[0] != null && tiles[1] != null ? tiles : null;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public int getColorFor(IColored.Data data, int index) {
        TileEntityMultiBed tile;
        if (index > -1 && index < 3 && data.world != null && data.pos != null && (tile = BlockMultiBed.getTile((BlockGetter)data.world, data.pos)) != null) {
            if (index == 0) {
                return tile.getMaterialColor();
            }
            if (index == 1 && tile.hasSheet()) {
                return tile.getSheetColor();
            }
            if (index == 2 && tile.hasPillow()) {
                return tile.getPillowColor();
            }
        }
        return 0xFFFFFF;
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return state;
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public ItemStack getPickBlock(BlockState state, LevelReader world, BlockPos pos, Player player, HitResult target) {
        ItemStack bedding;
        if (player != null && player.getAbilities().instabuild && player.isShiftKeyDown() && !(bedding = ItemBeddingPackage.createFor(BlockMultiBed.getTiles((BlockGetter)world, pos))).isEmpty()) {
            return bedding;
        }
        return this.getCloneItemStack(world, pos, state);
    }
}

