/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import shetiphian.core.common.rgb16.BlockRGB16;
import shetiphian.core.common.rgb16.TileEntityRGB16;
import shetiphian.multibeds.Roster;

public class BlockHanger
extends BlockRGB16
implements SimpleWaterloggedBlock {
    private static final MapCodec<BlockHanger> CODEC = BlockHanger.simpleCodec(instance -> new BlockHanger());
    private static final EnumProperty<EnumAttached> ATTACHED = EnumProperty.create((String)"attached", EnumAttached.class);
    private static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Shapes.or((VoxelShape)Block.box((double)2.0, (double)6.0, (double)0.0, (double)14.0, (double)11.0, (double)16.0), (VoxelShape)Block.box((double)6.0, (double)11.0, (double)0.0, (double)10.0, (double)15.0, (double)3.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)6.0, (double)2.0, (double)16.0, (double)11.0, (double)14.0), (VoxelShape)Block.box((double)13.0, (double)11.0, (double)6.0, (double)16.0, (double)15.0, (double)10.0)), Shapes.or((VoxelShape)Block.box((double)2.0, (double)6.0, (double)0.0, (double)14.0, (double)11.0, (double)16.0), (VoxelShape)Block.box((double)6.0, (double)11.0, (double)13.0, (double)10.0, (double)15.0, (double)16.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)6.0, (double)2.0, (double)16.0, (double)11.0, (double)14.0), (VoxelShape)Block.box((double)0.0, (double)11.0, (double)6.0, (double)3.0, (double)15.0, (double)10.0)), Shapes.or((VoxelShape)Block.box((double)2.0, (double)6.0, (double)-4.0, (double)14.0, (double)11.0, (double)16.0), (VoxelShape)Block.box((double)6.0, (double)11.0, (double)-4.0, (double)10.0, (double)16.0, (double)1.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)6.0, (double)2.0, (double)20.0, (double)11.0, (double)14.0), (VoxelShape)Block.box((double)17.0, (double)11.0, (double)6.0, (double)20.0, (double)16.0, (double)10.0)), Shapes.or((VoxelShape)Block.box((double)2.0, (double)6.0, (double)0.0, (double)14.0, (double)11.0, (double)20.0), (VoxelShape)Block.box((double)6.0, (double)11.0, (double)17.0, (double)10.0, (double)16.0, (double)20.0)), Shapes.or((VoxelShape)Block.box((double)-4.0, (double)6.0, (double)2.0, (double)16.0, (double)11.0, (double)14.0), (VoxelShape)Block.box((double)-4.0, (double)11.0, (double)6.0, (double)1.0, (double)16.0, (double)10.0)), Shapes.or((VoxelShape)Block.box((double)2.0, (double)6.0, (double)-6.0, (double)14.0, (double)11.0, (double)16.0), (VoxelShape)Block.box((double)6.0, (double)11.0, (double)-6.0, (double)10.0, (double)17.0, (double)-3.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)6.0, (double)2.0, (double)22.0, (double)11.0, (double)14.0), (VoxelShape)Block.box((double)19.0, (double)11.0, (double)6.0, (double)22.0, (double)17.0, (double)10.0)), Shapes.or((VoxelShape)Block.box((double)2.0, (double)6.0, (double)0.0, (double)14.0, (double)11.0, (double)22.0), (VoxelShape)Block.box((double)6.0, (double)11.0, (double)19.0, (double)10.0, (double)17.0, (double)22.0)), Shapes.or((VoxelShape)Block.box((double)-6.0, (double)6.0, (double)2.0, (double)16.0, (double)11.0, (double)14.0), (VoxelShape)Block.box((double)-6.0, (double)11.0, (double)6.0, (double)-3.0, (double)17.0, (double)10.0)), Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)-2.0, (double)14.0, (double)11.0, (double)16.0), (VoxelShape)Block.box((double)6.0, (double)11.0, (double)-2.0, (double)10.0, (double)15.0, (double)3.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)2.0, (double)18.0, (double)11.0, (double)14.0), (VoxelShape)Block.box((double)13.0, (double)11.0, (double)6.0, (double)18.0, (double)15.0, (double)10.0)), Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)11.0, (double)18.0), (VoxelShape)Block.box((double)6.0, (double)11.0, (double)13.0, (double)10.0, (double)15.0, (double)18.0)), Shapes.or((VoxelShape)Block.box((double)-2.0, (double)0.0, (double)2.0, (double)16.0, (double)11.0, (double)14.0), (VoxelShape)Block.box((double)-2.0, (double)11.0, (double)6.0, (double)3.0, (double)15.0, (double)10.0)), Shapes.or((VoxelShape)Block.box((double)2.0, (double)-8.0, (double)-2.0, (double)14.0, (double)11.0, (double)16.0), (VoxelShape)Block.box((double)6.0, (double)11.0, (double)-2.0, (double)10.0, (double)15.0, (double)3.0)), Shapes.or((VoxelShape)Block.box((double)0.0, (double)-8.0, (double)2.0, (double)18.0, (double)11.0, (double)14.0), (VoxelShape)Block.box((double)13.0, (double)11.0, (double)6.0, (double)18.0, (double)15.0, (double)10.0)), Shapes.or((VoxelShape)Block.box((double)2.0, (double)-8.0, (double)0.0, (double)14.0, (double)11.0, (double)18.0), (VoxelShape)Block.box((double)6.0, (double)11.0, (double)13.0, (double)10.0, (double)15.0, (double)18.0)), Shapes.or((VoxelShape)Block.box((double)-2.0, (double)-8.0, (double)2.0, (double)16.0, (double)11.0, (double)14.0), (VoxelShape)Block.box((double)-2.0, (double)11.0, (double)6.0, (double)3.0, (double)15.0, (double)10.0))};

    public MapCodec<BlockHanger> codec() {
        return CODEC;
    }

    public BlockHanger() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GRAY).strength(0.2f).noOcclusion().ignitedByLava().pushReaction(PushReaction.DESTROY), (pos, state) -> new TileEntityRGB16((BlockEntityType)Roster.Tiles.RGB16.get(), pos, state), new int[0]);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(ATTACHED, (Comparable)((Object)EnumAttached.BLOCK))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ATTACHED, FACING, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES[((EnumAttached)((Object)state.getValue(ATTACHED))).ordinal() * 4 + ((Direction)state.getValue((Property)FACING)).get2DDataValue()];
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction face = context.getClickedFace();
        Direction direction = face.getAxis() == Direction.Axis.Y ? context.getHorizontalDirection().getOpposite() : face;
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(ATTACHED, (Comparable)((Object)this.getAttachment((LevelAccessor)world, pos, direction, face != Direction.UP)))).setValue((Property)FACING, (Comparable)direction)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos).getType() == Fluids.WATER));
    }

    private EnumAttached getAttachment(LevelAccessor world, BlockPos pos, Direction facing, boolean horizontals) {
        double distance;
        VoxelShape shape;
        BlockPos oPos;
        EnumAttached attached;
        boolean unusableGround = this.isUnusableGround(world, pos.below());
        EnumAttached enumAttached = attached = unusableGround ? EnumAttached.BLOCK : EnumAttached.GROUND;
        if (horizontals || unusableGround) {
            oPos = pos.relative(facing.getOpposite());
            shape = world.getBlockState(oPos).getBlockSupportShape((BlockGetter)world, oPos);
            double d = distance = facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 1.0 - shape.max(facing.getAxis()) : shape.min(facing.getAxis());
            EnumAttached enumAttached2 = distance <= 0.125 ? EnumAttached.BLOCK : (distance <= 0.25 ? EnumAttached.WALL : (attached = distance <= 0.375 ? EnumAttached.POST : attached));
        }
        if (attached == EnumAttached.GROUND) {
            oPos = pos.relative(Direction.DOWN);
            shape = world.getBlockState(oPos).getBlockSupportShape((BlockGetter)world, oPos);
            distance = 1.0 - shape.max(Direction.Axis.Y);
            attached = distance <= 0.125 ? EnumAttached.GROUND : (distance <= 0.5 ? EnumAttached.GROUND_TALL : EnumAttached.BLOCK);
        }
        return attached;
    }

    private boolean isUnusableGround(LevelAccessor world, BlockPos pos) {
        if (!world.isEmptyBlock(pos)) {
            BlockState state = world.getBlockState(pos);
            return state.canBeReplaced() || state.getBlock() instanceof BlockHanger;
        }
        return true;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        state = (BlockState)state.setValue(ATTACHED, (Comparable)((Object)this.getAttachment(world, pos, (Direction)state.getValue((Property)FACING), !((EnumAttached)((Object)state.getValue(ATTACHED))).isGround() || this.isUnusableGround(world, pos.below()))));
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public static enum EnumAttached implements StringRepresentable
    {
        BLOCK("block"),
        WALL("wall"),
        POST("post"),
        GROUND("ground"),
        GROUND_TALL("ground_tall");

        private final String name;

        private EnumAttached(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        private boolean isGround() {
            return this == GROUND || this == GROUND_TALL;
        }
    }
}

