/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.block;

import com.google.common.collect.Table;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import shetiphian.core.common.BlockLightingHelper;
import shetiphian.core.common.Helpers;
import shetiphian.core.common.IColored;
import shetiphian.multibeds.common.block.HitBoxHelper;
import shetiphian.multibeds.common.block.ILighting;
import shetiphian.multibeds.common.item.ItemBlockLadder;
import shetiphian.multibeds.common.item.ItemBlockMultiBed;
import shetiphian.multibeds.common.tileentity.TileEntityLadder;

public class BlockBunkLadder
extends LadderBlock
implements EntityBlock,
IColored,
ILighting {
    private static final MapCodec<LadderBlock> CODEC = BlockBunkLadder.simpleCodec(instance -> new BlockBunkLadder());
    private static final Table<String, Direction, VoxelShape> HITBOXES = new HitBoxHelper().loadLadderBoxes().get();
    private static final Map<String, VoxelShape> BOXCACHE = new HashMap<String, VoxelShape>();

    public MapCodec<LadderBlock> codec() {
        return CODEC;
    }

    public BlockBunkLadder() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOL).forceSolidOff().noOcclusion().pushReaction(PushReaction.DESTROY).sound(SoundType.WOOD).strength(0.7f, 0.5f).lightLevel(BlockLightingHelper::getLightValue));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BlockLightingHelper.LIGHTING, (Comparable)BlockLightingHelper.PackedData.UNKNOWEN));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockLightingHelper.LIGHTING});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityLadder(pos, state);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> SOUTH_AABB;
            case Direction.SOUTH -> NORTH_AABB;
            case Direction.WEST -> EAST_AABB;
            default -> WEST_AABB;
        };
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        String cacheKey;
        String type = "single";
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof TileEntityLadder) {
            type = ((TileEntityLadder)tile).getModelType();
        }
        if (!BOXCACHE.containsKey(cacheKey = type + ":" + ((Direction)state.getValue((Property)FACING)).getName())) {
            VoxelShape shape = null;
            if (!HITBOXES.isEmpty()) {
                shape = (VoxelShape)HITBOXES.get((Object)("ladder_" + type), (Object)state.getValue((Property)FACING));
            }
            if (shape == null) {
                shape = this.getCollisionShape(state, world, pos, context);
            }
            BOXCACHE.put(cacheKey, shape);
        }
        return BOXCACHE.get(cacheKey);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return true;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state != null) {
            return (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)).getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
        }
        return state;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntityLadder tile = BlockBunkLadder.getTile((BlockGetter)world, pos);
        if (tile != null) {
            Helpers.syncTile((BlockEntity)tile);
        }
        this.setLighting(state, world, pos, ItemBlockMultiBed.getTextureStack(stack));
        world.blockUpdated(pos, Blocks.AIR);
        state.updateNeighbourShapes((LevelAccessor)world, pos, 3);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos neighbor, boolean isMoving) {
        super.neighborChanged(state, world, pos, block, neighbor, isMoving);
        TileEntityLadder tile = BlockBunkLadder.getTile((BlockGetter)world, pos);
        if (tile != null) {
            Helpers.syncTile((BlockEntity)tile);
            this.setLighting(state, world, pos, tile.getTextureBlock());
        }
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        TileEntityLadder tile = BlockBunkLadder.getTile((BlockGetter)world, pos);
        return ItemBlockLadder.createStack((Block)this, tile != null ? tile.getTextureBlock() : ItemStack.EMPTY);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    private static TileEntityLadder getTile(BlockGetter world, BlockPos pos) {
        BlockEntity tile = world.getBlockEntity(pos);
        return tile instanceof TileEntityLadder ? (TileEntityLadder)tile : null;
    }

    public int getColorFor(IColored.Data data, int index) {
        TileEntityLadder tile;
        if (index > -1 && index < 3 && data.world != null && data.pos != null && (tile = BlockBunkLadder.getTile((BlockGetter)data.world, data.pos)) != null && index == 0) {
            return tile.getMaterialColor();
        }
        return -1;
    }
}

