/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import shetiphian.core.common.BlockLightingHelper;
import shetiphian.core.common.IColored;
import shetiphian.core.common.block.IExtendedAwarenessBlock;
import shetiphian.core.platform.Services;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.common.block.BlockMultiBed;
import shetiphian.multibeds.common.block.ILighting;
import shetiphian.multibeds.common.misc.EnumBedStyle;
import shetiphian.multibeds.common.tileentity.TileEntityMultiBed;

public class BlockBedExtra
extends Block
implements EntityBlock,
IColored,
IExtendedAwarenessBlock,
ILighting,
SimpleWaterloggedBlock {
    private static final MapCodec<BlockBedExtra> CODEC = BlockBedExtra.simpleCodec(instance -> new BlockBedExtra());
    public static final EnumProperty<EnumBedStyle> BEDSTYLE = EnumProperty.create((String)"bed", EnumBedStyle.class);

    public MapCodec<BlockBedExtra> codec() {
        return CODEC;
    }

    public BlockBedExtra() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LIGHT_GRAY_BED).noLootTable().lightLevel(BlockLightingHelper::getLightValue));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockMultiBed.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockLightingHelper.LIGHTING, (Comparable)BlockLightingHelper.PackedData.UNKNOWEN));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BEDSTYLE, BlockMultiBed.WATERLOGGED, BlockLightingHelper.LIGHTING, BlockMultiBed.FACING, BlockMultiBed.PART});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)Roster.Tiles.BEXTRA.get()).create(pos, state);
    }

    public MapColor getMapColor(BlockState state, BlockGetter world, BlockPos pos) {
        MapColor mapColor;
        state = world.getBlockState(pos = pos.below());
        Block block = state.getBlock();
        if (block instanceof IExtendedAwarenessBlock) {
            IExtendedAwarenessBlock aware = (IExtendedAwarenessBlock)block;
            mapColor = aware.getMapColor(state, world, pos);
        } else {
            mapColor = DyeColor.WHITE.getMapColor();
        }
        return mapColor;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        BlockState bedState = world.getBlockState(pos = pos.below());
        if (bedState.getBlock() instanceof BlockMultiBed) {
            String cacheKey = BlockMultiBed.getShapeKey(bedState, world, pos, (EnumBedStyle)((Object)state.getValue(BEDSTYLE)), true) + ":topper";
            if (!BlockMultiBed.BOXCACHE.containsKey(cacheKey)) {
                BlockMultiBed.BOXCACHE.put(cacheKey, this.buildShape(bedState, cacheKey));
            }
            return BlockMultiBed.BOXCACHE.get(cacheKey);
        }
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        BlockState bedState = world.getBlockState(pos = pos.below());
        if (bedState.getBlock() instanceof BlockMultiBed) {
            String cacheKey = BlockMultiBed.getShapeKey(bedState, world, pos, (EnumBedStyle)((Object)state.getValue(BEDSTYLE)), false) + ":topper";
            if (!BlockMultiBed.BOXCACHE.containsKey(cacheKey)) {
                BlockMultiBed.BOXCACHE.put(cacheKey, this.buildShape(bedState, cacheKey));
            }
            return BlockMultiBed.BOXCACHE.get(cacheKey);
        }
        return Shapes.empty();
    }

    private VoxelShape buildShape(BlockState state, String cacheKey) {
        String[] types;
        String[] data = cacheKey.split(":");
        if (data.length == 6 && (types = data[2].split("#")).length == 2) {
            VoxelShape parts = null;
            if (types[0].equalsIgnoreCase("single") || types[0].equalsIgnoreCase("top")) {
                parts = (VoxelShape)BlockMultiBed.HITBOXES.get((Object)(data[1] + "_topper_" + types[1] + "_" + data[3]), (Object)state.getValue((Property)BlockMultiBed.FACING));
            }
            if (parts != null) {
                return Shapes.or((VoxelShape)Shapes.empty(), parts);
            }
        }
        return Shapes.empty();
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        if (state.getValue(BEDSTYLE) == EnumBedStyle.CREW && context.getItemInHand().is((Item)Roster.Items.CREW.get())) {
            return state.getValue((Property)BlockMultiBed.FACING) == context.getHorizontalDirection();
        }
        return super.canBeReplaced(state, context);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state != null) {
            return (BlockState)state.setValue((Property)BlockMultiBed.WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
        }
        return state;
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.isClientSide) {
            if (!player.isCreative()) {
                world.destroyBlock(pos.below(), true, (Entity)player);
            } else {
                BlockPos[] bedBlocks = BlockMultiBed.getBlocks((BlockGetter)world, pos.below());
                world.setBlock(bedBlocks[0], Blocks.AIR.defaultBlockState(), 35);
                world.setBlock(bedBlocks[1], Blocks.AIR.defaultBlockState(), 35);
                world.levelEvent(player, 2001, pos, Block.getId((BlockState)state));
            }
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hitResult) {
        pos = pos.below();
        hitResult = new BlockHitResult(hitResult.getLocation(), hitResult.getDirection(), pos, hitResult.isInside());
        return world.getBlockState(pos).useWithoutItem(world, player, hitResult);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        pos = pos.below();
        hitResult = new BlockHitResult(hitResult.getLocation(), hitResult.getDirection(), pos, hitResult.isInside());
        return world.getBlockState(pos).useItemOn(stack, world, player, hand, hitResult);
    }

    public void attack(BlockState state, Level world, BlockPos pos, Player player) {
        pos = pos.below();
        world.getBlockState(pos).attack(world, pos, player);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos neighbor, boolean isMoving) {
        BlockMultiBed multiBedBase;
        BlockState bedState;
        Block block2;
        BlockEntity tile = world.getBlockEntity(pos.below());
        if (tile instanceof TileEntityMultiBed) {
            this.setLighting(state, world, pos, ((TileEntityMultiBed)tile).getTextureBlock());
        }
        if ((block2 = (bedState = world.getBlockState(pos.below())).getBlock()) instanceof BlockMultiBed && (multiBedBase = (BlockMultiBed)block2).getBedStyle().hasTopper()) {
            BlockState newState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((Block)Roster.Blocks.BEXTRA.get()).defaultBlockState().setValue(BEDSTYLE, (Comparable)((Object)multiBedBase.getBedStyle()))).setValue((Property)BlockMultiBed.WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos.above()).getType() == Fluids.WATER))).setValue((Property)BlockLightingHelper.LIGHTING, (Comparable)((BlockLightingHelper.PackedData)bedState.getValue((Property)BlockLightingHelper.LIGHTING)))).setValue((Property)BlockMultiBed.FACING, (Comparable)((Direction)bedState.getValue((Property)BlockMultiBed.FACING)))).setValue((Property)BlockMultiBed.PART, (Comparable)((BedPart)bedState.getValue((Property)BlockMultiBed.PART)));
            if (newState != state) {
                world.setBlock(pos, newState, 3);
            }
            return;
        }
        world.removeBlock(pos, false);
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state) {
        pos = pos.below();
        state = world.getBlockState(pos);
        return state.getBlock().getCloneItemStack(world, pos, state);
    }

    public ItemStack getPickBlock(BlockState state, LevelReader world, BlockPos pos, Player player, HitResult target) {
        pos = pos.below();
        return Services.COMMON.getPickBlock(world.getBlockState(pos), world, pos, player, target);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public int getColorFor(IColored.Data data, int index) {
        BlockPos pos;
        BlockState state;
        if (index > -1 && index < 3 && data.world != null && data.pos != null && (state = data.world.getBlockState(pos = data.pos.below())).getBlock() instanceof BlockMultiBed) {
            return 0xFF000000 | ((BlockMultiBed)state.getBlock()).getColorFor(data, index);
        }
        return -1;
    }
}

