/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LoomBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import shetiphian.core.common.inventory.MenuProviderWithData;
import shetiphian.core.platform.Services;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.common.block.BlockMultiBed;
import shetiphian.multibeds.common.component.Artwork;
import shetiphian.multibeds.common.inventory.ContainerProviders;
import shetiphian.multibeds.common.item.ItemBedCustomization;
import shetiphian.multibeds.common.item.ItemBlanket;
import shetiphian.multibeds.common.item.ItemBuilderKit;
import shetiphian.multibeds.mixins.MB_Accessor_PoiType;

public class EventHandler {
    public static void injectBedPOI() {
        Block[] allBeds = (Block[])Roster.Blocks.BED_MAP.values().stream().map(Supplier::get).toArray(Block[]::new);
        ImmutableSet states = ImmutableSet.copyOf((Collection)Arrays.stream(allBeds).flatMap(block -> block.getStateDefinition().getPossibleStates().stream()).filter(state -> state.getValue((Property)BedBlock.PART) == BedPart.HEAD).collect(Collectors.toSet()));
        try {
            Map<BlockState, Holder<PoiType>> poimap = MB_Accessor_PoiType.getPoiMap();
            BuiltInRegistries.POINT_OF_INTEREST_TYPE.getHolder(PoiTypes.HOME).ifPresent(arg_0 -> EventHandler.lambda$injectBedPOI$4((Set)states, poimap, arg_0));
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    protected InteractionResult onPlayerRightClickBlock(Player player, Level world, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack heldItem;
        if (player != null && !(heldItem = player.getItemInHand(hand)).isEmpty()) {
            BlockPos pos = hitResult.getBlockPos();
            BlockState state = world.getBlockState(pos);
            Block block = state.getBlock();
            if (player.isShiftKeyDown() && heldItem.getItem() instanceof BannerItem && block instanceof BlockMultiBed && ItemBedCustomization.putOnBed(heldItem.copy(), player, world, pos, hitResult.getDirection(), true)) {
                if (!player.getAbilities().instabuild) {
                    heldItem.shrink(1);
                }
                player.swing(hand);
                return InteractionResult.SUCCESS;
            }
            if (heldItem.getItem() instanceof ItemBlanket && block instanceof LoomBlock) {
                Services.COMMON.openMenu(player, (MenuProviderWithData)new ContainerProviders.BlanketLoom(pos));
                return InteractionResult.SUCCESS;
            }
            if (heldItem.getItem() instanceof ItemBuilderKit && ((ItemBuilderKit)heldItem.getItem()).handleRightClick(world, player, hand)) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    protected InteractionResultHolder<ItemStack> onPlayerRightClickItem(Player player, Level world, InteractionHand hand) {
        ItemStack heldItem;
        if (player != null && !(heldItem = player.getItemInHand(hand)).isEmpty() && heldItem.getItem() instanceof ItemBuilderKit && ((ItemBuilderKit)heldItem.getItem()).handleRightClick(world, player, hand)) {
            return InteractionResultHolder.success((Object)heldItem);
        }
        return InteractionResultHolder.pass((Object)ItemStack.EMPTY);
    }

    public static void onModifyLoot(List<ItemStack> generatedLoot, LootContext context) {
        Artwork artwork;
        BlockEntity tile;
        BlockState state = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
        if (state != null && state.getBlock() instanceof AbstractBannerBlock && (tile = (BlockEntity)context.getParamOrNull(LootContextParams.BLOCK_ENTITY)) != null && (artwork = (Artwork)tile.components().get((DataComponentType)Roster.Components.ARTWORK_DATA.get())) != null) {
            for (ItemStack stack : generatedLoot) {
                if (stack.isEmpty() || !(stack.getItem() instanceof BannerItem)) continue;
                stack.set((DataComponentType)Roster.Components.ARTWORK_DATA.get(), (Object)artwork);
            }
        }
    }

    private static /* synthetic */ void lambda$injectBedPOI$4(Set states, Map poimap, Holder.Reference home) {
        states.forEach(state -> {
            if (!poimap.containsKey(state)) {
                poimap.put(state, home);
            }
        });
    }
}

