/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.render;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.common.ColorHelper;
import shetiphian.multibeds.client.model.CacheBuilder;
import shetiphian.multibeds.client.render.CustomArtTextures;
import shetiphian.multibeds.common.block.BlockMultiBed;
import shetiphian.multibeds.common.misc.EnumBedStyle;
import shetiphian.multibeds.common.tileentity.TileEntityMultiBed;

public class RenderArtOnBed
implements BlockEntityRenderer<TileEntityMultiBed> {
    private static final Table<String, Direction, Boolean> MODEL_CACHE = HashBasedTable.create();
    private static final Map<int[], int[]> VERTEX_CACHE = new HashMap<int[], int[]>();
    private static final BlockColors BLOCK_COLORS = Minecraft.getInstance().getBlockColors();
    private static final ModelBlockRenderer RENDERER = Minecraft.getInstance().getBlockRenderer().getModelRenderer();

    public static void rebuildCache() {
        MODEL_CACHE.clear();
        VERTEX_CACHE.clear();
    }

    public void render(TileEntityMultiBed tile, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Triple<String, Byte, byte[]> artData;
        BakedModel model;
        String key;
        if (tile.getBannerEntity() == null && tile.getArtData() == null) {
            return;
        }
        Direction facing = tile.getFacing();
        if (tile.getLevel() == null) {
            return;
        }
        BlockState state = tile.getBlockState();
        if (!(state.getBlock() instanceof BlockMultiBed)) {
            return;
        }
        EnumBedStyle style = EnumBedStyle.byBlock(state.getBlock());
        String half = state.getValue((Property)BlockMultiBed.PART) == BedPart.FOOT ? "_foot" : "_head";
        String common = style.useCenteredCommon() ? "common_ctr" : "common";
        BannerBlockEntity banner = tile.getBannerEntity();
        if (banner != null) {
            String[] types = tile.getModelType().split("#");
            String typeBlanket = (types[1].equalsIgnoreCase("middle") ? "" : (!types[0].equalsIgnoreCase("single") || style.useShortBlanket() ? "alt_" : "")) + types[1];
            key = common + "/banner" + (tile.isMirrored() ? "-_" : "_") + typeBlanket + half;
            model = CacheBuilder.getBed(key, "default", facing, "minecraft:white_wool");
            if (model != null) {
                this.localizeModelUVs(model, key, facing, state);
                Object values = ColorHelper.colorToRGB((int)banner.getBaseColor().getTextureDiffuseColor());
                VertexConsumer vertexBuilder = Sheets.BANNER_BASE.buffer(buffer, RenderType::entityTranslucent);
                RENDERER.renderModel(matrixStack.last(), vertexBuilder, state, model, values[0], values[1], values[2], combinedLight, combinedOverlay);
                values = banner.getPatterns().layers().iterator();
                while (values.hasNext()) {
                    BannerPatternLayers.Layer layer = (BannerPatternLayers.Layer)values.next();
                    float[] values2 = ColorHelper.colorToRGB((int)layer.color().getTextureDiffuseColor());
                    Material material = Sheets.getBannerMaterial((Holder)layer.pattern());
                    VertexConsumer vertexBuilder2 = material.buffer(buffer, RenderType::entityTranslucent);
                    RENDERER.renderModel(matrixStack.last(), vertexBuilder2, state, model, values2[0], values2[1], values2[2], combinedLight, combinedOverlay);
                }
            }
        }
        if ((artData = tile.getArtData()) != null) {
            ResourceLocation texture = CustomArtTextures.TEXTURES.getResourceLocation((String)artData.getLeft(), (Byte)artData.getMiddle(), (byte[])artData.getRight());
            key = common + "/art_custom" + half;
            model = CacheBuilder.getBed(key, "default", facing, texture.toString());
            if (model != null) {
                this.localizeModelUVs(model, key, facing, state);
                VertexConsumer builder = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)texture));
                int color = BLOCK_COLORS.getColor(state, null, null, 0);
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                RENDERER.renderModel(matrixStack.last(), builder, state, model, red, green, blue, combinedLight, combinedOverlay);
            }
        }
    }

    private void localizeModelUVs(BakedModel model, String key, Direction facing, BlockState state) {
        if (model != null && !MODEL_CACHE.contains((Object)key, (Object)facing)) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
            List quads = model.getQuads(state, null, RandomSource.create());
            for (BakedQuad quad : quads) {
                TextureAtlasSprite sprite = quad.getSprite();
                int[] vertex = quad.getVertices();
                int vertexOffset = vertex.length / 4;
                if (!VERTEX_CACHE.containsKey(vertex)) {
                    VERTEX_CACHE.put(vertex, (int[])vertex.clone());
                }
                int[] dVertex = VERTEX_CACHE.get(vertex);
                for (int vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
                    float u = Float.intBitsToFloat(dVertex[vertexIndex * vertexOffset + 4]);
                    float v = Float.intBitsToFloat(dVertex[vertexIndex * vertexOffset + 5]);
                    u = (u - sprite.getU0()) / (sprite.getU1() - sprite.getU0());
                    v = (v - sprite.getV0()) / (sprite.getV1() - sprite.getV0());
                    vertex[vertexIndex * vertexOffset + 4] = Float.floatToRawIntBits(u);
                    vertex[vertexIndex * vertexOffset + 5] = Float.floatToRawIntBits(v);
                }
            }
            MODEL_CACHE.put((Object)key, (Object)facing, (Object)true);
        }
    }
}

