/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.render;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.NativeImage;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import shetiphian.multibeds.MultiBeds;
import shetiphian.multibeds.common.misc.Embroidery;

class CustomArtTextures {
    static final Cache TEXTURES = new Cache();

    CustomArtTextures() {
    }

    static class Cache {
        private final Map<String, CacheEntry> cacheMap = Maps.newLinkedHashMap();

        private Cache() {
        }

        ResourceLocation getResourceLocation(String id, byte palette, byte[] indices) {
            if (Strings.isNullOrEmpty((String)id)) {
                return MissingTextureAtlasSprite.getLocation();
            }
            CacheEntry cacheEntry = this.cacheMap.get(id);
            if (cacheEntry == null) {
                if (this.cacheMap.size() >= 256 && !this.freeCacheSlot()) {
                    return MissingTextureAtlasSprite.getLocation();
                }
                int canvasScale = Embroidery.getCanvasScale(indices);
                NativeImage image = new NativeImage(canvasScale, canvasScale, true);
                for (int row = 0; row < canvasScale; ++row) {
                    for (int col = 0; col < canvasScale; ++col) {
                        int javaColor = Embroidery.getColorAt(palette, indices, canvasScale * row + col);
                        int vA = (javaColor & 0xFF000000) >> 24;
                        int vR = (javaColor & 0xFF0000) >> 16;
                        int vG = (javaColor & 0xFF00) >> 8;
                        int vB = javaColor & 0xFF;
                        int mojangColor = (vA << 24) + (vB << 16) + (vG << 8) + vR;
                        image.setPixelRGBA(col, row, mojangColor);
                    }
                }
                cacheEntry = new CacheEntry(new AtomicLong(), MultiBeds.RESOURCE.apply(id));
                Minecraft.getInstance().getTextureManager().register(cacheEntry.textureLocation, (AbstractTexture)new DynamicTexture(image));
                this.cacheMap.put(id, cacheEntry);
            }
            cacheEntry.lastUseMillis.set(Util.getMillis());
            return cacheEntry.textureLocation;
        }

        private boolean freeCacheSlot() {
            long i = Util.getMillis();
            Iterator<String> iterator = this.cacheMap.keySet().iterator();
            while (iterator.hasNext()) {
                String s = iterator.next();
                CacheEntry cacheEntry = this.cacheMap.get(s);
                if (i - cacheEntry.lastUseMillis.get() <= 5000L) continue;
                Minecraft.getInstance().getTextureManager().release(cacheEntry.textureLocation);
                iterator.remove();
                return true;
            }
            return this.cacheMap.size() < 256;
        }
    }

    private record CacheEntry(AtomicLong lastUseMillis, ResourceLocation textureLocation) {
    }
}

