/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.model;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import shetiphian.core.client.model.IPartData;
import shetiphian.multibeds.MultiBeds;
import shetiphian.multibeds.client.model.PartData;
import shetiphian.multibeds.common.misc.EnumBedStyle;
import shetiphian.multibeds.common.misc.EnumBlanket;
import shetiphian.multibeds.common.misc.EnumSpreadArt;

final class Parts {
    static final List<ResourceLocation> BED_TEXTURES = Parts.getBedTextures();
    static final List<IPartData> BED_MODELS = Parts.getBedModels();
    static final List<IPartData> LADDER_MODELS = Parts.getLadderModels();

    Parts() {
    }

    static String getMattressTexture() {
        return MultiBeds.IDSTRING.apply("block/mattress");
    }

    static String getPillowTexture() {
        return MultiBeds.IDSTRING.apply("block/pillow");
    }

    private static String getDefaultPillowTexture() {
        return MultiBeds.IDSTRING.apply("block/pillow_bare");
    }

    static String getSheetTexture() {
        return MultiBeds.IDSTRING.apply("block/fitted_sheet");
    }

    static String getBlanketTexture(EnumBlanket blanket) {
        return MultiBeds.IDSTRING.apply("block/blanket/" + (blanket == EnumBlanket.BANNER ? ".banner" : blanket.getSerializedName()));
    }

    static String getArtTexture(EnumSpreadArt art) {
        return MultiBeds.IDSTRING.apply("block/art/" + (art == EnumSpreadArt.CUSTOM ? ".custom" : art.getSerializedName()));
    }

    private static List<ResourceLocation> getBedTextures() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        list.add(ResourceLocation.parse((String)Parts.getMattressTexture()));
        list.add(ResourceLocation.parse((String)Parts.getPillowTexture()));
        list.add(ResourceLocation.parse((String)Parts.getDefaultPillowTexture()));
        list.add(ResourceLocation.parse((String)Parts.getSheetTexture()));
        for (EnumBlanket enumBlanket : EnumBlanket.values()) {
            if (enumBlanket == EnumBlanket.NONE) continue;
            list.add(ResourceLocation.parse((String)Parts.getBlanketTexture(enumBlanket)));
        }
        for (Enum enum_ : EnumSpreadArt.values()) {
            if (enum_ == EnumSpreadArt.NONE) continue;
            list.add(ResourceLocation.parse((String)Parts.getArtTexture((EnumSpreadArt)enum_)));
        }
        return list;
    }

    private static List<IPartData> getBedModels() {
        ArrayList<IPartData> list = new ArrayList<IPartData>();
        String[] typesGang = new String[]{"single", "left", "middle", "right"};
        String[] typesBunk = new String[]{"bottom", "middle", "top"};
        for (String string : typesGang) {
            list.add(new PartData("base/slat_" + string + "_foot"));
            list.add(new PartData("base/slat_" + string + "_head"));
            if (!string.equals("single")) {
                list.add(new PartData("common/pillow_" + string, Parts.getDefaultPillowTexture()));
            }
            list.add(new PartData("common/mattress_" + string + "_foot", Parts.getMattressTexture()));
            list.add(new PartData("common/mattress_" + string + "_head", Parts.getMattressTexture()));
        }
        for (String string : new String[]{"common/", "common_ctr/"}) {
            list.add(new PartData(string + "art"));
            list.add(new PartData(string + "art_custom_foot"));
            list.add(new PartData(string + "art_custom_head"));
            for (String gang : typesGang) {
                list.add(new PartData(string + "banner_" + gang + "_foot", Parts.getBlanketTexture(EnumBlanket.PLAIN_WHITE)));
                list.add(new PartData(string + "banner-_" + gang + "_foot", Parts.getBlanketTexture(EnumBlanket.PLAIN_WHITE)));
                list.add(new PartData(string + "banner_" + gang + "_head", Parts.getBlanketTexture(EnumBlanket.PLAIN_WHITE)));
                list.add(new PartData(string + "banner-_" + gang + "_head", Parts.getBlanketTexture(EnumBlanket.PLAIN_WHITE)));
                list.add(new PartData(string + "blanket_" + gang + "_foot", Parts.getBlanketTexture(EnumBlanket.PLAIN_RED)));
                list.add(new PartData(string + "blanket_" + gang + "_head", Parts.getBlanketTexture(EnumBlanket.PLAIN_RED)));
                if (gang.equals("middle")) continue;
                list.add(new PartData(string + "banner_alt_" + gang + "_foot", Parts.getBlanketTexture(EnumBlanket.PLAIN_WHITE)));
                list.add(new PartData(string + "banner-_alt_" + gang + "_foot", Parts.getBlanketTexture(EnumBlanket.PLAIN_WHITE)));
                list.add(new PartData(string + "banner_alt_" + gang + "_head", Parts.getBlanketTexture(EnumBlanket.PLAIN_WHITE)));
                list.add(new PartData(string + "banner-_alt_" + gang + "_head", Parts.getBlanketTexture(EnumBlanket.PLAIN_WHITE)));
                list.add(new PartData(string + "blanket_alt_" + gang + "_foot", Parts.getBlanketTexture(EnumBlanket.PLAIN_RED)));
                list.add(new PartData(string + "blanket_alt_" + gang + "_head", Parts.getBlanketTexture(EnumBlanket.PLAIN_RED)));
            }
        }
        for (EnumBedStyle enumBedStyle : EnumBedStyle.values()) {
            for (String gang : typesGang) {
                if (enumBedStyle.hasComboModels()) {
                    list.add(new PartData(String.valueOf((Object)enumBedStyle) + "/bed_" + gang + "_foot"));
                    list.add(new PartData(String.valueOf((Object)enumBedStyle) + "/bed_" + gang + "_head"));
                } else {
                    list.add(new PartData(String.valueOf((Object)enumBedStyle) + "/" + gang + "_foot"));
                    list.add(new PartData(String.valueOf((Object)enumBedStyle) + "/" + gang + "_head"));
                }
                if (enumBedStyle.hasTopper()) {
                    list.add(new PartData(String.valueOf((Object)enumBedStyle) + "/topper_" + gang + "_foot"));
                    list.add(new PartData(String.valueOf((Object)enumBedStyle) + "/topper_" + gang + "_head"));
                }
                if (enumBedStyle.hasCustomPillow()) {
                    list.add(new PartData(String.valueOf((Object)enumBedStyle) + "/pillow_" + gang + "_foot", Parts.getMattressTexture()));
                    list.add(new PartData(String.valueOf((Object)enumBedStyle) + "/pillow_" + gang + "_head", Parts.getMattressTexture()));
                }
                if (enumBedStyle.hasCustomMattress()) {
                    list.add(new PartData(String.valueOf((Object)enumBedStyle) + "/mattress_" + gang + "_foot", Parts.getMattressTexture()));
                    list.add(new PartData(String.valueOf((Object)enumBedStyle) + "/mattress_" + gang + "_head", Parts.getMattressTexture()));
                }
                if (!enumBedStyle.isGangable()) break;
            }
            if (!enumBedStyle.isBunkable()) continue;
            list.add(new PartData(String.valueOf((Object)enumBedStyle) + "/bunk_rail_left"));
            list.add(new PartData(String.valueOf((Object)enumBedStyle) + "/bunk_rail_right"));
            for (String bunk : typesBunk) {
                if (enumBedStyle.hasComboModels()) {
                    for (String gang : typesGang) {
                        list.add(new PartData(String.valueOf((Object)enumBedStyle) + "/bunk_" + bunk + "_" + gang + "_foot"));
                        list.add(new PartData(String.valueOf((Object)enumBedStyle) + "/bunk_" + bunk + "_" + gang + "_head"));
                    }
                    continue;
                }
                list.add(new PartData(String.valueOf((Object)enumBedStyle) + "/bunk_" + bunk + "_foot"));
                list.add(new PartData(String.valueOf((Object)enumBedStyle) + "/bunk_" + bunk + "_head"));
            }
        }
        list.add(new PartData("item/parts/pillow", Parts.getDefaultPillowTexture()));
        list.add(new PartData("item/parts/mattress", Parts.getMattressTexture()));
        list.add(new PartData("item/parts/base_slat"));
        for (EnumBedStyle enumBedStyle : EnumBedStyle.values()) {
            list.add(new PartData("item/parts/bed_" + String.valueOf((Object)enumBedStyle)));
            if (enumBedStyle.hasCustomPillow()) {
                list.add(new PartData("item/parts/pillow_" + String.valueOf((Object)enumBedStyle), Parts.getMattressTexture()));
            }
            if (!enumBedStyle.hasCustomMattress()) continue;
            list.add(new PartData("item/parts/mattress_" + String.valueOf((Object)enumBedStyle), Parts.getMattressTexture()));
        }
        list.add(new PartData("item/parts/blanket"));
        list.add(new PartData("item/parts/blanket_alt"));
        list.add(new PartData("item/parts/blanket_art"));
        list.add(new PartData("item/parts/blanket_ctr"));
        list.add(new PartData("item/parts/blanket_ctr_alt"));
        list.add(new PartData("item/parts/blanket_art_ctr"));
        return list;
    }

    private static List<IPartData> getLadderModels() {
        ArrayList<IPartData> list = new ArrayList<IPartData>();
        list.add(new PartData("ladder/bottom"));
        list.add(new PartData("ladder/middle"));
        list.add(new PartData("ladder/single"));
        list.add(new PartData("ladder/top"));
        list.add(new PartData("ladder/inventory"));
        return list;
    }
}

