/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;
import shetiphian.core.client.ClientHelpers;
import shetiphian.core.client.model.AssembledBakedModel;
import shetiphian.core.client.model.data.RenderData;
import shetiphian.core.common.UseContext;
import shetiphian.multibeds.client.model.BaseModel;
import shetiphian.multibeds.client.model.CacheBuilder;
import shetiphian.multibeds.client.model.ModelProperties;
import shetiphian.multibeds.common.block.BlockBunkLadder;
import shetiphian.multibeds.common.component.Texture;
import shetiphian.multibeds.common.item.ItemBlockLadder;

final class ModelLadder
extends BaseModel {
    static final BakedModel INSTANCE = new ModelLadder();

    ModelLadder() {
    }

    public List<BakedModel> handleBlockState(BlockState state, Direction side, RandomSource rand, RenderData data, RenderType layer) {
        ItemStack materialItem;
        CompoundTag nbtTag;
        if (!(state.getBlock() instanceof BlockBunkLadder)) {
            return Collections.emptyList();
        }
        String ladderType = "single";
        if (data.has(ModelProperties.NBT) && (nbtTag = (CompoundTag)data.get(ModelProperties.NBT)) != null && nbtTag.contains("ladder_type")) {
            ladderType = nbtTag.getString("ladder_type");
        }
        if ((materialItem = (ItemStack)ModelProperties.TEXTURE.getOrElse(data, (Object)ItemStack.EMPTY)).isEmpty()) {
            materialItem = Texture.DEFAULT_STACK;
        }
        String material = CacheBuilder.INSTANCE.getTexture(materialItem);
        Direction facing = (Direction)state.getValue((Property)BlockBunkLadder.FACING);
        BlockState materialState = UseContext.getBlockPlacementStateFor((ItemStack)materialItem, (Level)Minecraft.getInstance().level);
        boolean doRender = layer == (ClientHelpers.isTranslucent((BlockState)materialState) ? RenderType.translucent() : (ClientHelpers.isCutout((BlockState)materialState) ? RenderType.cutout() : RenderType.solid()));
        ArrayList<BakedModel> list = new ArrayList<BakedModel>();
        if (doRender) {
            ModelLadder.add(list, "ladder/" + ladderType, material, facing, material);
        }
        return list;
    }

    private static void add(List<BakedModel> list, String part, String key, Direction facing, String particle) {
        BakedModel model = CacheBuilder.getLadder(part, key, facing, particle);
        if (model != null) {
            list.add(model);
        }
    }

    public ItemOverrides getOverrides() {
        return new ItemOverrides(this, CacheBuilder.INSTANCE.getModelBaker(), null, Collections.emptyList()){

            public BakedModel resolve(BakedModel model, ItemStack stack, ClientLevel world, LivingEntity entity, int seed) {
                return ItemHandler.INSTANCE.getModel(stack, model);
            }
        };
    }

    private static class ItemHandler {
        static ItemHandler INSTANCE = new ItemHandler();
        private static ItemTransforms transforms;

        private ItemHandler() {
        }

        BakedModel getModel(ItemStack stack, BakedModel original) {
            if (!stack.isEmpty() && stack.getItem() instanceof ItemBlockLadder) {
                ItemStack materialItem;
                String material;
                String modelKey;
                if (transforms == null) {
                    this.buildTransforms();
                }
                if (!CacheBuilder.INSTANCE.ITEM_CACHE.containsKey(modelKey = "ladder::" + (material = CacheBuilder.INSTANCE.getTexture(materialItem = ItemBlockLadder.getTextureStack(stack))))) {
                    ArrayList<BakedModel> list = new ArrayList<BakedModel>();
                    ModelLadder.add(list, "ladder/inventory", material, Direction.SOUTH, material);
                    CacheBuilder.INSTANCE.ITEM_CACHE.put(modelKey, new AssembledBakedModel(list, new ItemTransforms[]{transforms}).setItemLayers(new RenderType[]{Sheets.translucentCullBlockSheet()}));
                }
                return (BakedModel)CacheBuilder.INSTANCE.ITEM_CACHE.get(modelKey);
            }
            return original;
        }

        private void buildTransforms() {
            ItemTransform thirdperson = this.create(75.0f, 135.0f, 0.0f, 0.0f, 2.5f, 0.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform firstperson = this.create(0.0f, 135.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.4f, 0.4f, 0.4f);
            ItemTransform gui = this.create(30.0f, 225.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.625f, 0.625f, 0.625f);
            ItemTransform ground = this.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.25f, 0.25f, 0.25f);
            ItemTransform head = ItemTransform.NO_TRANSFORM;
            ItemTransform fixed = this.create(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            transforms = new ItemTransforms(thirdperson, thirdperson, firstperson, firstperson, head, gui, ground, fixed);
        }

        private ItemTransform create(float rX, float rY, float rZ, float tX, float tY, float tZ, float sX, float sY, float sZ) {
            Vector3f rotation = new Vector3f(rX, rY, rZ);
            Vector3f translation = new Vector3f(tX, tY, tZ);
            translation.mul(0.0625f);
            translation.set(Mth.clamp((float)translation.x, (float)-5.0f, (float)5.0f), Mth.clamp((float)translation.y, (float)-5.0f, (float)5.0f), Mth.clamp((float)translation.z, (float)-5.0f, (float)5.0f));
            Vector3f scale = new Vector3f(sX, sY, sZ);
            scale.set(Mth.clamp((float)scale.x, (float)-4.0f, (float)4.0f), Mth.clamp((float)scale.y, (float)-4.0f, (float)4.0f), Mth.clamp((float)scale.z, (float)-4.0f, (float)4.0f));
            return new ItemTransform(rotation, translation, scale);
        }
    }
}

