/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import shetiphian.core.client.ClientHelpers;
import shetiphian.core.client.model.data.RenderData;
import shetiphian.core.common.UseContext;
import shetiphian.multibeds.client.model.BaseModel;
import shetiphian.multibeds.client.model.CacheBuilder;
import shetiphian.multibeds.client.model.ModelProperties;
import shetiphian.multibeds.common.block.BlockBedExtra;
import shetiphian.multibeds.common.block.BlockMultiBed;
import shetiphian.multibeds.common.component.Texture;
import shetiphian.multibeds.common.misc.EnumBedStyle;

final class ModelBedExtra
extends BaseModel {
    static final BakedModel INSTANCE = new ModelBedExtra();

    ModelBedExtra() {
    }

    public List<BakedModel> handleBlockState(BlockState state, Direction direction, RandomSource randomSource, RenderData data, RenderType layer) {
        ItemStack materialItem;
        CompoundTag nbtTag;
        if (!(state.getBlock() instanceof BlockBedExtra)) {
            return Collections.emptyList();
        }
        String typeBunk = "single";
        String typeGang = "single";
        if (data.has(ModelProperties.NBT) && (nbtTag = (CompoundTag)data.get(ModelProperties.NBT)) != null && nbtTag.contains("bed_type")) {
            String[] types = nbtTag.getString("bed_type").split("#");
            typeBunk = types[0];
            typeGang = types[1];
        }
        if ((materialItem = (ItemStack)ModelProperties.TEXTURE.getOrElse(data, (Object)ItemStack.EMPTY)).isEmpty()) {
            materialItem = Texture.DEFAULT_STACK;
        }
        boolean isHead = state.getValue((Property)BlockMultiBed.PART) == BedPart.HEAD;
        String material = CacheBuilder.INSTANCE.getTexture(materialItem);
        String half = !isHead ? "_foot" : "_head";
        Direction facing = (Direction)state.getValue((Property)BlockMultiBed.FACING);
        EnumBedStyle style = (EnumBedStyle)((Object)state.getValue(BlockBedExtra.BEDSTYLE));
        String base = style.getBaseType();
        BlockState materialState = UseContext.getBlockPlacementStateFor((ItemStack)materialItem, (Level)Minecraft.getInstance().level);
        boolean renderFrame = layer == (ClientHelpers.isTranslucent((BlockState)materialState) ? RenderType.translucent() : (ClientHelpers.isCutout((BlockState)materialState) ? RenderType.cutout() : RenderType.solid()));
        ArrayList<BakedModel> list = new ArrayList<BakedModel>();
        if (renderFrame && (typeBunk.equalsIgnoreCase("single") || typeBunk.equalsIgnoreCase("top"))) {
            ModelBedExtra.add(list, String.valueOf((Object)style) + "/topper_" + typeGang + half, material, facing, material);
        }
        return list;
    }

    private static void add(List<BakedModel> list, String part, String key, Direction facing, String particle) {
        BakedModel model = CacheBuilder.getBed(part, key, facing, particle);
        if (model != null) {
            list.add(model);
        }
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }
}

