/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Vector3f;
import shetiphian.core.client.ClientHelpers;
import shetiphian.core.client.model.AssembledBakedModel;
import shetiphian.core.client.model.data.RenderData;
import shetiphian.core.common.UseContext;
import shetiphian.multibeds.client.model.BaseModel;
import shetiphian.multibeds.client.model.CacheBuilder;
import shetiphian.multibeds.client.model.ModelProperties;
import shetiphian.multibeds.client.model.Parts;
import shetiphian.multibeds.common.block.BlockMultiBed;
import shetiphian.multibeds.common.component.Texture;
import shetiphian.multibeds.common.item.ItemBlanket;
import shetiphian.multibeds.common.item.ItemBlockMultiBed;
import shetiphian.multibeds.common.misc.EnumBedStyle;
import shetiphian.multibeds.common.misc.EnumBlanket;
import shetiphian.multibeds.common.misc.EnumSpreadArt;

final class ModelBed
extends BaseModel {
    static final BakedModel INSTANCE = new ModelBed();

    ModelBed() {
    }

    public List<BakedModel> handleBlockState(BlockState state, Direction direction, RandomSource randomSource, RenderData data, RenderType layer) {
        String common;
        ItemStack materialItem;
        CompoundTag nbtTag;
        if (!(state.getBlock() instanceof BlockMultiBed)) {
            return Collections.emptyList();
        }
        String typeBunk = "single";
        String typeGang = "single";
        boolean hasSheet = false;
        boolean hasPillowCase = false;
        EnumBlanket blanket = EnumBlanket.NONE;
        EnumSpreadArt art = EnumSpreadArt.NONE;
        if (data.has(ModelProperties.NBT) && (nbtTag = (CompoundTag)data.get(ModelProperties.NBT)) != null) {
            if (nbtTag.contains("bed_type")) {
                String[] types = nbtTag.getString("bed_type").split("#");
                typeBunk = types[0];
                typeGang = types[1];
            }
            if (nbtTag.contains("has_sheet")) {
                hasSheet = nbtTag.getBoolean("has_sheet");
            }
            if (nbtTag.contains("has_pillowcase")) {
                hasPillowCase = nbtTag.getBoolean("has_pillowcase");
            }
            if (nbtTag.contains("blanket_type")) {
                blanket = EnumBlanket.byName(nbtTag.getString("blanket_type"));
            }
            if (nbtTag.contains("art_type")) {
                art = EnumSpreadArt.byName(nbtTag.getString("art_type"));
            }
        }
        if ((materialItem = (ItemStack)ModelProperties.TEXTURE.getOrElse(data, (Object)ItemStack.EMPTY)).isEmpty()) {
            materialItem = Texture.DEFAULT_STACK;
        }
        boolean isBunked = !typeBunk.equalsIgnoreCase("single");
        boolean isHead = state.getValue((Property)BlockMultiBed.PART) == BedPart.HEAD;
        String material = CacheBuilder.INSTANCE.getTexture(materialItem);
        String half = !isHead ? "_foot" : "_head";
        Direction facing = (Direction)state.getValue((Property)BlockMultiBed.FACING);
        EnumBedStyle style = EnumBedStyle.byBlock(state.getBlock());
        String base = style.getBaseType();
        BlockState materialState = UseContext.getBlockPlacementStateFor((ItemStack)materialItem, (Level)Minecraft.getInstance().level);
        boolean renderFrame = layer == (ClientHelpers.isTranslucent((BlockState)materialState) ? RenderType.translucent() : (ClientHelpers.isCutout((BlockState)materialState) ? RenderType.cutout() : RenderType.solid()));
        ArrayList<BakedModel> list = new ArrayList<BakedModel>();
        if (renderFrame) {
            Object typeLegs;
            if (!base.equalsIgnoreCase("none")) {
                ModelBed.add(list, "base/" + base + "_" + typeGang + half, material, facing, material);
            }
            Object object = typeLegs = style.isBunkable() && isBunked ? "bunk_" + typeBunk : typeGang;
            if (style.hasComboModels()) {
                typeLegs = isBunked ? "bunk_" + typeBunk + "_" + typeGang : "bed_" + typeGang;
            }
            ModelBed.add(list, String.valueOf((Object)style) + "/" + (String)typeLegs + half, material, facing, material);
            if (isHead && isBunked && (typeBunk.equalsIgnoreCase("middle") || typeBunk.equalsIgnoreCase("top"))) {
                if (typeGang.contains("left") || typeGang.contains("single")) {
                    ModelBed.add(list, String.valueOf((Object)style) + "/bunk_rail_left", material, facing, material);
                }
                if (typeGang.contains("right") || typeGang.contains("single")) {
                    ModelBed.add(list, String.valueOf((Object)style) + "/bunk_rail_right", material, facing, material);
                }
            }
        }
        String string = common = style.useCenteredCommon() ? "common_ctr" : "common";
        if (layer == RenderType.solid()) {
            if (style.hasCustomMattress()) {
                ModelBed.add(list, String.valueOf((Object)style) + "/mattress_" + typeGang + half, hasSheet ? Parts.getSheetTexture() : "default", facing, material);
            } else {
                ModelBed.add(list, "common/mattress_" + typeGang + half, hasSheet ? Parts.getSheetTexture() : "default", facing, material);
            }
            if (style.hasCustomPillow()) {
                ModelBed.add(list, String.valueOf((Object)style) + "/pillow_" + typeGang + half, hasPillowCase ? Parts.getSheetTexture() : "default", facing, material);
            } else if (isHead) {
                String typePillow = typeGang.equalsIgnoreCase("single") ? "middle" : typeGang;
                ModelBed.add(list, "common/pillow_" + typePillow, hasPillowCase ? Parts.getPillowTexture() : "default", facing, material);
            }
            if (blanket != EnumBlanket.NONE && blanket != EnumBlanket.BANNER) {
                String typeBlanket = (typeGang.equalsIgnoreCase("middle") ? "" : (isBunked || style.useShortBlanket() ? "alt_" : "")) + typeGang;
                ModelBed.add(list, common + "/blanket_" + typeBlanket + half, Parts.getBlanketTexture(blanket), facing, material);
            }
        }
        if (layer == RenderType.translucent() && blanket != EnumBlanket.NONE && !isHead && art != EnumSpreadArt.NONE && art != EnumSpreadArt.CUSTOM) {
            ModelBed.add(list, common + "/art", Parts.getArtTexture(art), facing, material);
        }
        return list;
    }

    private static void add(List<BakedModel> list, String part, String key, Direction facing, String particle) {
        BakedModel model = CacheBuilder.getBed(part, key, facing, particle);
        if (model != null) {
            list.add(model);
        }
    }

    public List<BakedModel> getItemParts(ItemStack stack, RandomSource random, boolean cull) {
        return super.getItemParts(stack, random, cull);
    }

    public ItemOverrides getOverrides() {
        return new ItemOverrides(this, CacheBuilder.INSTANCE.getModelBaker(), null, Collections.emptyList()){

            public BakedModel resolve(BakedModel model, ItemStack stack, ClientLevel world, LivingEntity entity, int seed) {
                return ItemHandler.INSTANCE.getModel(stack, model);
            }
        };
    }

    private static class ItemHandler {
        static ItemHandler INSTANCE = new ItemHandler();
        private static ItemTransforms transforms;
        private static ItemTransforms transforms_tall;

        private ItemHandler() {
        }

        BakedModel getModel(ItemStack stack, BakedModel original) {
            Item item;
            if (!stack.isEmpty() && (item = stack.getItem()) instanceof ItemBlockMultiBed) {
                ItemBlockMultiBed bed = (ItemBlockMultiBed)item;
                if (transforms == null) {
                    this.buildTransforms();
                }
                EnumBedStyle style = EnumBedStyle.byBlock(bed.getBlock());
                ItemStack materialItem = ItemBlockMultiBed.getTextureStack(stack);
                String material = CacheBuilder.INSTANCE.getTexture(materialItem);
                String modelKey = String.valueOf((Object)style) + "::" + material;
                boolean hasSheet = false;
                boolean hasPillow = false;
                Pair<EnumBlanket, EnumSpreadArt> blanket = ItemBlanket.NO_DATA;
                if (bed.hasBedding(stack)) {
                    hasSheet = !bed.getSheet(stack).isEmpty();
                    hasPillow = !bed.getPillow(stack).isEmpty();
                    modelKey = modelKey + "::" + (hasSheet ? "s" : "") + (hasPillow ? "p" : "");
                    if (!bed.getBlanket(stack).isEmpty()) {
                        blanket = ItemBlanket.getBlanketData(bed.getBlanket(stack));
                        modelKey = modelKey + "::" + ((EnumBlanket)((Object)blanket.getLeft())).getSerializedName() + ":" + ((EnumSpreadArt)((Object)blanket.getRight())).getSerializedName();
                    }
                }
                if (!CacheBuilder.INSTANCE.ITEM_CACHE.containsKey(modelKey)) {
                    String centered = style.useCenteredCommon() ? "_ctr" : "";
                    ArrayList<BakedModel> list = new ArrayList<BakedModel>();
                    if (blanket.getLeft() != EnumBlanket.NONE) {
                        ModelBed.add(list, "item/parts/blanket" + centered + (style.useShortBlanket() ? "_alt" : ""), Parts.getBlanketTexture((EnumBlanket)((Object)blanket.getLeft())), Direction.SOUTH, material);
                        if (blanket.getRight() != EnumSpreadArt.NONE) {
                            ModelBed.add(list, "item/parts/blanket_art" + centered, Parts.getArtTexture((EnumSpreadArt)((Object)blanket.getRight())), Direction.SOUTH, material);
                        }
                    }
                    if (style.hasCustomPillow()) {
                        ModelBed.add(list, "item/parts/pillow_" + String.valueOf((Object)style), hasPillow ? Parts.getSheetTexture() : "default", Direction.SOUTH, material);
                    } else {
                        ModelBed.add(list, "item/parts/pillow", hasPillow ? Parts.getPillowTexture() : "default", Direction.SOUTH, material);
                    }
                    if (style.hasCustomMattress()) {
                        ModelBed.add(list, "item/parts/mattress_" + String.valueOf((Object)style), hasSheet ? Parts.getSheetTexture() : "default", Direction.SOUTH, material);
                    } else {
                        ModelBed.add(list, "item/parts/mattress", hasSheet ? Parts.getSheetTexture() : "default", Direction.SOUTH, material);
                    }
                    if (!style.getBaseType().equalsIgnoreCase("none")) {
                        ModelBed.add(list, "item/parts/base_" + style.getBaseType(), material, Direction.SOUTH, material);
                    }
                    ModelBed.add(list, "item/parts/bed_" + String.valueOf((Object)style), material, Direction.SOUTH, material);
                    CacheBuilder.INSTANCE.ITEM_CACHE.put(modelKey, new AssembledBakedModel(list, new ItemTransforms[]{style.hasTopper() ? transforms_tall : transforms}).setItemLayers(new RenderType[]{Sheets.translucentCullBlockSheet()}));
                }
                return (BakedModel)CacheBuilder.INSTANCE.ITEM_CACHE.get(modelKey);
            }
            return original;
        }

        private void buildTransforms() {
            ItemTransform thirdperson = this.create(30.0f, 160.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.23f, 0.23f, 0.23f);
            ItemTransform firstperson = this.create(30.0f, 160.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.375f, 0.375f, 0.375f);
            ItemTransform gui = this.create(30.0f, 160.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f);
            ItemTransform ground = this.create(0.0f, 0.0f, 0.0f, 0.0f, 3.0f, 0.0f, 0.2f, 0.2f, 0.2f);
            ItemTransform head = ItemTransform.NO_TRANSFORM;
            ItemTransform fixed = this.create(270.0f, 0.0f, 0.0f, 0.0f, 0.0f, -2.0f, 0.5f, 0.5f, 0.5f);
            transforms = new ItemTransforms(thirdperson, thirdperson, firstperson, firstperson, head, gui, ground, fixed);
            gui = this.create(30.0f, 140.0f, 0.0f, 0.0f, -2.25f, 0.0f, 0.35f, 0.35f, 0.35f);
            transforms_tall = new ItemTransforms(thirdperson, thirdperson, firstperson, firstperson, head, gui, ground, fixed);
        }

        private ItemTransform create(float rX, float rY, float rZ, float tX, float tY, float tZ, float sX, float sY, float sZ) {
            Vector3f rotation = new Vector3f(rX, rY, rZ);
            Vector3f translation = new Vector3f(tX, tY, tZ);
            translation.mul(0.0625f);
            translation.set(Mth.clamp((float)translation.x, (float)-5.0f, (float)5.0f), Mth.clamp((float)translation.y, (float)-5.0f, (float)5.0f), Mth.clamp((float)translation.z, (float)-5.0f, (float)5.0f));
            Vector3f scale = new Vector3f(sX, sY, sZ);
            scale.set(Mth.clamp((float)scale.x, (float)-4.0f, (float)4.0f), Mth.clamp((float)scale.y, (float)-4.0f, (float)4.0f), Mth.clamp((float)scale.z, (float)-4.0f, (float)4.0f));
            return new ItemTransform(rotation, translation, scale);
        }
    }
}

