/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.misc;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import shetiphian.multibeds.common.misc.Embroidery;

public class WIPProject {
    private final byte[] preview;
    private final byte palette;
    private final String[] layers;
    private final boolean[] visible;
    private final int canvasScale;

    public WIPProject(byte[] preview, byte palette, byte[][] layers, boolean[] visible, int canvasScale) {
        this(preview, palette, WIPProject.convert(palette, layers), visible, canvasScale);
    }

    private static String[] convert(byte palette, byte[][] layers) {
        String[] layerTags = new String[layers.length];
        for (int index = 0; index < layers.length; ++index) {
            layerTags[index] = Embroidery.fromUncompressed(palette, layers[index]).buildShareTag(new String[0]);
        }
        return layerTags;
    }

    private WIPProject(byte[] preview, byte palette, String[] layers, boolean[] visible, int canvasScale) {
        this.preview = preview;
        this.palette = palette;
        this.layers = layers;
        this.visible = visible;
        this.canvasScale = canvasScale;
    }

    public byte[] getPreview() {
        return this.preview;
    }

    public byte getPalette() {
        return this.palette;
    }

    public byte[] getLayer(int index) {
        Embroidery embroidery;
        if (index >= 0 && index < this.layers.length && !(embroidery = Embroidery.fromShareTag(this.layers[index])).isEmpty()) {
            return embroidery.getUncompressedIndices();
        }
        return new byte[this.canvasScale * this.canvasScale];
    }

    public boolean isVisible(int index) {
        if (index >= 0 && index < this.layers.length) {
            return this.visible[index];
        }
        return true;
    }

    public int getCanvasScale() {
        return this.canvasScale;
    }

    public static WIPProject fromNbtTag(CompoundTag tag) {
        ListTag layerList = tag.getList("layers", 10);
        String[] layers = new String[layerList.size()];
        boolean[] visible = new boolean[layerList.size()];
        AtomicInteger index = new AtomicInteger();
        layerList.forEach(layerTag -> {
            layers[index.get()] = ((CompoundTag)layerTag).getString("data");
            visible[index.get()] = ((CompoundTag)layerTag).getBoolean("visible");
            index.getAndIncrement();
        });
        return new WIPProject(tag.getByteArray("preview"), tag.getByte("palette"), layers, visible, (int)tag.getByte("scale"));
    }

    public CompoundTag writeToNbt() {
        CompoundTag tag = new CompoundTag();
        tag.putByteArray("preview", this.preview);
        tag.putByte("palette", this.palette);
        ListTag layerList = new ListTag();
        for (int index = 0; index < this.layers.length; ++index) {
            CompoundTag layerTag = new CompoundTag();
            layerTag.putString("data", this.layers[index]);
            layerTag.putBoolean("visible", this.isVisible(index));
            layerList.add((Object)layerTag);
        }
        tag.put("layers", (Tag)layerList);
        tag.putByte("scale", (byte)this.canvasScale);
        return tag;
    }
}

