/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.misc;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import shetiphian.multibeds.common.component.Texture;
import shetiphian.multibeds.common.item.ItemBedCustomization;
import shetiphian.multibeds.common.item.ItemBlanket;
import shetiphian.multibeds.common.item.ItemEmbroideryThread;
import shetiphian.multibeds.common.misc.EnumSpreadArt;
import shetiphian.multibeds.common.tileentity.TileEntityLadder;
import shetiphian.multibeds.common.tileentity.TileEntityMultiBed;

public class TextureInfoHelper {
    public static List<Component> getHUD(TileEntityMultiBed bed, boolean textures) {
        ArrayList<Component> lines = new ArrayList<Component>();
        if (textures) {
            TextureInfoHelper.addTextureInfo(lines, bed.getTextureBlock());
        } else {
            ItemStack sheet;
            ItemStack pillow;
            DyeColor color;
            if (bed.hasBlanket()) {
                ItemStack blanket = bed.getBlanketItem();
                if (blanket.getItem() instanceof ItemBlanket) {
                    color = ((ItemBlanket)blanket.getItem()).getColor(blanket);
                    String pattern = ItemBlanket.getPatternName(blanket);
                    if (pattern.equalsIgnoreCase("plain")) {
                        lines.add((Component)Component.literal((String)" + ").append((Component)Component.translatable((String)("color." + color.getName()))).append(" ").append((Component)Component.translatable((String)"item.multibeds.blanket")));
                    } else {
                        lines.add((Component)Component.literal((String)" + ").append((Component)Component.translatable((String)("color." + color.getName()))).append(" ").append((Component)Component.translatable((String)("misc.multibeds.pattern." + pattern))).append(" ").append((Component)Component.translatable((String)"item.multibeds.blanket")));
                    }
                } else if (blanket.getItem() instanceof BannerItem) {
                    lines.add((Component)Component.literal((String)" + ").append((Component)Component.translatable((String)blanket.getDescriptionId())));
                }
                EnumSpreadArt art = ItemEmbroideryThread.getArtwork(blanket);
                if (art != EnumSpreadArt.NONE) {
                    lines.add((Component)Component.literal((String)" * ").append((Component)Component.translatable((String)"misc.multibeds.art")).append(": ").append((Component)Component.translatable((String)("misc.multibeds.art." + art.getSerializedName()))));
                }
            }
            if (bed.hasPillow() && (pillow = bed.getPillowItem()).getItem() instanceof ItemBedCustomization) {
                color = ((ItemBedCustomization)pillow.getItem()).getColor(pillow);
                lines.add((Component)Component.literal((String)" + ").append((Component)Component.translatable((String)("color." + color.getName()))).append(" ").append((Component)Component.translatable((String)"item.multibeds.pillow")));
            }
            if (bed.hasSheet() && (sheet = bed.getSheetItem()).getItem() instanceof ItemBedCustomization) {
                color = ((ItemBedCustomization)sheet.getItem()).getColor(sheet);
                lines.add((Component)Component.literal((String)" + ").append((Component)Component.translatable((String)("color." + color.getName()))).append(" ").append((Component)Component.translatable((String)"item.multibeds.sheet")));
            }
        }
        return lines;
    }

    public static List<Component> getHUD(TileEntityLadder ladder) {
        ArrayList<Component> lines = new ArrayList<Component>();
        TextureInfoHelper.addTextureInfo(lines, ladder.getTextureBlock());
        return lines;
    }

    public static void addTextureInfo(List<Component> lines, ItemStack textureItem) {
        if (!textureItem.isEmpty()) {
            lines.add((Component)Component.literal((String)" * ").append((Component)Component.translatable((String)textureItem.getDescriptionId())));
        } else {
            TextureInfoHelper.addTextureError(lines, new String[0]);
        }
    }

    private static void addTextureError(List<Component> lines, String ... invalid) {
        if (invalid.length == 0) {
            lines.add((Component)Component.literal((String)" * \u26a0 ").append((Component)Component.translatable((String)"info.shetiphian.texture.missing")).append(" \u26a0"));
        } else {
            lines.add((Component)Component.literal((String)" * \u26a0 ").append((Component)Component.translatable((String)"info.shetiphian.texture.invalid")).append(" \u26a0"));
            if (!Strings.isNullOrEmpty((String)invalid[0])) {
                lines.add((Component)Component.literal((String)" ** ").append((Component)Component.translatable((String)invalid[0])));
            }
        }
        lines.add((Component)Component.literal((String)" ** ").append((Component)Component.translatable((String)"info.shetiphian.texture.defaulted")).append((Component)Component.literal((String)" ")).append((Component)Component.translatable((String)Texture.DEFAULT_STACK.getDescriptionId())));
    }
}

