/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.misc;

import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.slf4j.Logger;
import shetiphian.core.common.NBTFile;
import shetiphian.core.platform.Services;
import shetiphian.multibeds.MultiBeds;
import shetiphian.multibeds.client.misc.WIPProject;
import shetiphian.multibeds.common.misc.Embroidery;

public class EmbroideryData {
    public static final EmbroideryData INSTANCE = new EmbroideryData();
    private final HashMap<String, Embroidery> personal = new HashMap();
    private final HashMap<String, Embroidery> favorite = new HashMap();
    private final HashMap<String, Embroidery> session = new HashMap();
    private final HashMap<String, Embroidery> webpage = new HashMap();
    private final HashMap<String, WIPProject> projects = new HashMap();
    private boolean needsSaving = false;
    private boolean isLoaded = false;
    private String saveDir = null;

    public static boolean has(String name) {
        return EmbroideryData.INSTANCE.personal.containsKey(name);
    }

    public static void save(String name, Embroidery embroidery) {
        EmbroideryData.INSTANCE.personal.put(name, embroidery);
        EmbroideryData.INSTANCE.needsSaving = true;
    }

    public static void delete(String name) {
        EmbroideryData.INSTANCE.personal.remove(name);
        EmbroideryData.INSTANCE.needsSaving = true;
    }

    public static Set<String> getNames() {
        return EmbroideryData.INSTANCE.personal.keySet();
    }

    public static Embroidery get(String name) {
        return EmbroideryData.INSTANCE.personal.get(name);
    }

    public static void favorite(String name, Embroidery embroidery) {
        EmbroideryData.INSTANCE.favorite.put(name, embroidery);
        EmbroideryData.INSTANCE.needsSaving = true;
    }

    public static void unfavorite(String name) {
        EmbroideryData.INSTANCE.favorite.remove(name);
        EmbroideryData.INSTANCE.needsSaving = true;
    }

    public static Set<String> getFavorites() {
        return EmbroideryData.INSTANCE.favorite.keySet();
    }

    public static Embroidery getFavorite(String name) {
        return EmbroideryData.INSTANCE.favorite.get(name);
    }

    public static void addSessionItem(String name, Embroidery embroidery) {
        EmbroideryData.INSTANCE.session.put(name, embroidery);
    }

    public static Set<String> getSessionItems() {
        return EmbroideryData.INSTANCE.session.keySet();
    }

    public static Embroidery getSessionItem(String name) {
        return EmbroideryData.INSTANCE.session.get(name);
    }

    public static Set<String> getWebItems() {
        return EmbroideryData.INSTANCE.webpage.keySet();
    }

    public static Embroidery getWebItem(String name) {
        return EmbroideryData.INSTANCE.webpage.get(name);
    }

    public static boolean hasProject(String name) {
        return EmbroideryData.INSTANCE.projects.containsKey(name);
    }

    public static void saveProject(String name, WIPProject project) {
        EmbroideryData.INSTANCE.projects.put(name, project);
        EmbroideryData.INSTANCE.needsSaving = true;
    }

    public static void deleteProject(String name) {
        EmbroideryData.INSTANCE.projects.remove(name);
        EmbroideryData.INSTANCE.needsSaving = true;
    }

    public static Set<String> getProjects() {
        return EmbroideryData.INSTANCE.projects.keySet();
    }

    public static WIPProject getProject(String name) {
        return EmbroideryData.INSTANCE.projects.get(name);
    }

    public void saveData() {
        if (this.needsSaving && this.isLoaded) {
            MultiBeds.LOGGER.debug("Saving Embroidery Data");
            CompoundTag fileNBT = new CompoundTag();
            for (Map.Entry<String, Embroidery> entry : this.personal.entrySet()) {
                fileNBT.putString(entry.getKey(), entry.getValue().buildShareTag(new String[0]));
            }
            ListTag favoritesNBT = new ListTag();
            for (String string : EmbroideryData.getFavorites()) {
                favoritesNBT.add((Object)StringTag.valueOf((String)string));
            }
            fileNBT.put("FavoritesList", (Tag)favoritesNBT);
            fileNBT.put("ByteArrayImport", (Tag)new CompoundTag());
            NBTFile.write((CompoundTag)fileNBT, (File)this.getSaveFile(false), (Logger)MultiBeds.LOGGER);
            fileNBT = new CompoundTag();
            for (Map.Entry entry : this.projects.entrySet()) {
                fileNBT.put((String)entry.getKey(), (Tag)((WIPProject)entry.getValue()).writeToNbt());
            }
            NBTFile.write((CompoundTag)fileNBT, (File)this.getSaveFile(true), (Logger)MultiBeds.LOGGER);
            this.needsSaving = false;
            MultiBeds.LOGGER.info("Embroidery Data Saved");
        }
    }

    public void loadData() {
        this.loadPersistentData();
        this.loadUrlData();
    }

    private void loadPersistentData() {
        Embroidery embroidery2;
        MultiBeds.LOGGER.debug("Loading Embroidery Data");
        this.saveDir = Services.PLATFORM.getGameDir().toString() + File.separator + ".persistent" + File.separator + "multibeds";
        this.personal.clear();
        this.favorite.clear();
        CompoundTag fileNBT = NBTFile.read((File)this.getSaveFile(false), (Logger)MultiBeds.LOGGER);
        ListTag favoritesNBT = null;
        CompoundTag importNBT = null;
        for (Object name : fileNBT.getAllKeys()) {
            if (((String)name).equals("FavoritesList") && fileNBT.get((String)name) instanceof ListTag) {
                favoritesNBT = fileNBT.getList("FavoritesList", 8);
                continue;
            }
            if (((String)name).equals("ByteArrayImport") && fileNBT.get((String)name) instanceof CompoundTag) {
                importNBT = fileNBT.getCompound((String)name);
            }
            try {
                embroidery2 = Embroidery.fromShareTag(fileNBT.getString((String)name));
                if (embroidery2.isEmpty()) continue;
                this.personal.put((String)name, embroidery2);
            }
            catch (Exception embroidery2) {}
        }
        if (favoritesNBT != null) {
            for (int index = 0; index < favoritesNBT.size(); ++index) {
                String entry = favoritesNBT.getString(index);
                String[] name = entry.split(":");
                if (name.length != 2) continue;
                if (name[0].equalsIgnoreCase("inc")) {
                    this.favorite.put(entry, null);
                    continue;
                }
                if (!name[0].equalsIgnoreCase("per") || !this.personal.containsKey(name[1])) continue;
                this.favorite.put(entry, this.personal.get(name[1]));
            }
        }
        if (importNBT != null) {
            for (Object name : importNBT.getAllKeys()) {
                try {
                    embroidery2 = Embroidery.fromUncompressed((byte)0, importNBT.getByteArray((String)name));
                    name = "imp:" + (String)name;
                    while (this.session.containsKey(name)) {
                        name = (String)name + "_";
                    }
                    this.session.put((String)name, embroidery2);
                }
                catch (Exception exception) {}
            }
        }
        this.projects.clear();
        fileNBT = NBTFile.read((File)this.getSaveFile(true), (Logger)MultiBeds.LOGGER);
        for (Object name : fileNBT.getAllKeys()) {
            try {
                this.projects.put((String)name, WIPProject.fromNbtTag(fileNBT.getCompound((String)name)));
            }
            catch (Exception exception) {}
        }
        this.isLoaded = true;
        MultiBeds.LOGGER.info("Embroidery Data Loaded");
    }

    private File getSaveFile(boolean projects) {
        File file = new File(this.saveDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(file = new File(this.saveDir, projects ? "projects.dat" : "embroidery.dat")).exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception error) {
                MultiBeds.LOGGER.error("Could Not Read or Create File: " + String.valueOf(file), (Throwable)error);
            }
            NBTFile.write((CompoundTag)new CompoundTag(), (File)file, (Logger)MultiBeds.LOGGER);
        }
        return file;
    }

    private void loadUrlData() {
        this.process("https://gist.githubusercontent.com/Fruzstrated/ee01d31ff5208027f88c0dbc3543b43a/raw");
        this.process("https://gist.githubusercontent.com/ShetiPhian/657d2933fbeed6f49bfe95294a589e5b/raw");
    }

    private void process(String address) {
        Map json = null;
        try {
            URL url = new URL(address);
            InputStream con = url.openStream();
            String data = new String(ByteStreams.toByteArray((InputStream)con), StandardCharsets.UTF_8);
            con.close();
            json = (Map)new Gson().fromJson(data, Map.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (json != null) {
            for (Map.Entry entry : json.entrySet()) {
                if (!(entry.getValue() instanceof String)) continue;
                try {
                    Embroidery embroidery = Embroidery.fromShareTag((String)entry.getValue());
                    if (embroidery.isEmpty()) continue;
                    this.webpage.put((String)entry.getKey(), embroidery);
                }
                catch (Exception exception) {}
            }
            try {
                this.loadSet((Map)json.get("previews"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.processTimed((Map)json.get("timed"), json);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void processTimed(Map<String, Object> timed, Map<String, Object> json) {
        if (timed != null) {
            int month = Calendar.getInstance().get(2) + 1;
            int day = Calendar.getInstance().get(5);
            for (String date : timed.keySet()) {
                boolean inRange;
                block12: {
                    inRange = false;
                    if (date.contains("-")) {
                        String[] range = date.split("-");
                        String[] start_month_day = range[0].split("/");
                        String[] end_month_day = range[1].split("/");
                        try {
                            int start_month = Integer.parseInt(start_month_day[0]);
                            int start_day = Integer.parseInt(start_month_day[1]);
                            int end_month = Integer.parseInt(end_month_day[0]);
                            int end_day = Integer.parseInt(end_month_day[1]);
                            if (start_month > end_month) {
                                inRange = month >= start_month || month <= end_month;
                            } else {
                                boolean bl = inRange = month >= start_month && month <= end_month;
                            }
                            if (!inRange) break block12;
                            if (start_day > end_day) {
                                inRange = day >= start_day || day <= end_day;
                                break block12;
                            }
                            inRange = day >= start_day && day <= end_day;
                        }
                        catch (Exception exception) {}
                    } else {
                        String[] month_day = date.split("/");
                        try {
                            if (month == Integer.parseInt(month_day[0]) && day == Integer.parseInt(month_day[1])) {
                                inRange = true;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (!inRange) continue;
                this.loadSet((Map)json.get(date));
            }
        }
    }

    private void loadSet(Map<String, String> set) {
        for (Map.Entry<String, String> entry : set.entrySet()) {
            try {
                Embroidery embroidery = Embroidery.fromShareTag(entry.getValue());
                if (embroidery.isEmpty()) continue;
                this.webpage.put(entry.getKey(), embroidery);
            }
            catch (Exception exception) {}
        }
    }
}

