/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.gui;

import com.google.common.base.Strings;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.Tesselator;
import java.awt.Point;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import shetiphian.core.client.gui.AbstractWidgetList;
import shetiphian.core.client.gui.GuiHelper;
import shetiphian.core.common.StringUtil;
import shetiphian.core.platform.Services;
import shetiphian.multibeds.MultiBeds;
import shetiphian.multibeds.client.gui.EmbroideryPage_Draw;
import shetiphian.multibeds.client.gui.EmbroideryPage_Scale;
import shetiphian.multibeds.client.gui.Textures;
import shetiphian.multibeds.client.misc.EmbroideryData;
import shetiphian.multibeds.client.misc.WIPProject;
import shetiphian.multibeds.common.item.ItemEmbroideryThread;
import shetiphian.multibeds.common.misc.Embroidery;
import shetiphian.multibeds.common.misc.EnumSpreadArt;
import shetiphian.multibeds.common.tileentity.TileEntityMultiBed;
import shetiphian.multibeds.network.PacketEmbroidery;
import shetiphian.multibeds.network.PacketShareTag;

public class GuiEmbroidery
extends Screen {
    private final String TEXT_CREATE = I18n.get((String)"gui.multibeds.embroidery.create", (Object[])new Object[0]);
    private final String TEXT_CREATE_INFO = I18n.get((String)"gui.multibeds.embroidery.create.info", (Object[])new Object[0]);
    private final String TEXT_PASTE_TAG = I18n.get((String)"gui.multibeds.embroidery.paste_tag", (Object[])new Object[0]);
    private final String TEXT_APPLY = I18n.get((String)"gui.multibeds.embroidery.button.apply", (Object[])new Object[0]);
    private final String TEXT_APPLY_INFO = I18n.get((String)"gui.multibeds.embroidery.apply.info", (Object[])new Object[0]);
    private final String TEXT_REMOVE = I18n.get((String)"gui.multibeds.embroidery.button.remove", (Object[])new Object[0]);
    private final String TEXT_REMOVE_INFO = I18n.get((String)"gui.multibeds.embroidery.remove.info", (Object[])new Object[0]);
    private final String TEXT_ERROR_NO_SELECTION = I18n.get((String)"gui.multibeds.embroidery.error.no_selection", (Object[])new Object[0]);
    private final String TEXT_ERROR_NO_THREAD = I18n.get((String)"gui.multibeds.embroidery.error.no_thread", (Object[])new Object[0]);
    private final String TEXT_ERROR_NO_ART = I18n.get((String)"gui.multibeds.embroidery.error.no_art", (Object[])new Object[0]);
    private final String TEXT_ERROR_NO_BED = I18n.get((String)"gui.multibeds.embroidery.error.no_bed", (Object[])new Object[0]);
    private final String TEXT_COPY = I18n.get((String)"gui.multibeds.embroidery.copy", (Object[])new Object[0]);
    private final String TEXT_EDIT = I18n.get((String)"gui.multibeds.embroidery.edit", (Object[])new Object[0]);
    private final String TEXT_DELETE = I18n.get((String)"gui.multibeds.embroidery.delete", (Object[])new Object[0]);
    private final String TEXT_FAVORITE = I18n.get((String)"gui.multibeds.embroidery.favorite", (Object[])new Object[0]);
    private final String TEXT_UNFAVORITE = I18n.get((String)"gui.multibeds.embroidery.unfavorite", (Object[])new Object[0]);
    private final String TEXT_SHARE = I18n.get((String)"gui.multibeds.embroidery.share", (Object[])new Object[0]);
    private final String TEXT_TAB_EMBEDDED = I18n.get((String)"gui.multibeds.embroidery.tab.embedded", (Object[])new Object[0]);
    private final String TEXT_TAB_CUSTOM = I18n.get((String)"gui.multibeds.embroidery.tab.custom", (Object[])new Object[0]);
    private final String TEXT_TAB_FAVORITE = I18n.get((String)"gui.multibeds.embroidery.tab.favorite", (Object[])new Object[0]);
    private final String TEXT_TAB_SESSION = I18n.get((String)"gui.multibeds.embroidery.tab.session", (Object[])new Object[0]);
    private final String TEXT_TAB_WEB = I18n.get((String)"gui.multibeds.embroidery.tab.web", (Object[])new Object[0]);
    private final String TEXT_TAB_PROJECT = I18n.get((String)"gui.multibeds.embroidery.tab.projects", (Object[])new Object[0]);
    final EmbroideryPage_Draw pageDraw = new EmbroideryPage_Draw(this);
    final EmbroideryPage_Scale pageScale = new EmbroideryPage_Scale(this);
    private final WidgetEntry buttonCreateNew = new WidgetEntryNew();
    private final WidgetEntry buttonPasteShare = new WidgetEntryPasteShareTag();
    private final BlockPos pos;
    private final boolean bedClicked;
    private final boolean canApply;
    private final boolean canRemove;
    private final EnumSpreadArt currentArt;
    private final int xSize = 230;
    private final int ySize = 160;
    private int guiLeft;
    private int guiTop;
    private String lastToolTip;
    private int countToolTip;
    ActivePage activePage = ActivePage.SELECT;
    boolean scaleLayer = false;
    private WidgetList listBuiltIn;
    private WidgetList listCustom;
    private WidgetList listFavorite;
    private WidgetList listSession;
    private WidgetList listWebpage;
    private WidgetList listProjects;
    private WidgetList selectedWidgetList;
    private WidgetEntry selectedWidget;
    private WidgetEntry hoveredWidget;
    private Point tabBuiltin;
    private Point tabCustom;
    private Point tabFavorite;
    private Point tabSession;
    private Point tabWebpage;
    private Point tabProjects;
    private Point btnApply;
    private Point btnRemove;
    private final Point btnCopy = new Point();
    private final Point btnDelete = new Point();
    private final Point btnFavorite = new Point();
    private final Point btnShare = new Point();
    private boolean isWebpageTabEnabled;

    public GuiEmbroidery(BlockPos pos, boolean hasThread, TileEntityMultiBed[] tiles) {
        super((Component)Component.empty());
        this.pos = pos;
        this.bedClicked = tiles != null;
        this.canApply = hasThread && this.bedClicked;
        boolean bl = this.canRemove = this.bedClicked && (tiles[0].hasArt() || tiles[1].hasArt());
        EnumSpreadArt enumSpreadArt = this.canRemove ? (tiles[0].hasArt() ? tiles[0].getArtType() : tiles[1].getArtType()) : (this.currentArt = EnumSpreadArt.NONE);
        if (this.currentArt == EnumSpreadArt.CUSTOM) {
            Embroidery embroidery;
            Embroidery embroidery2 = embroidery = tiles[0].hasArt() ? ItemEmbroideryThread.getArtworkEmbroidery(tiles[0].getBlanketItem()) : ItemEmbroideryThread.getArtworkEmbroidery(tiles[1].getBlanketItem());
            if (embroidery != null) {
                this.selectedWidget = new WidgetEntryBytes(this, "Current", embroidery);
            }
        }
    }

    protected void init() {
        super.init();
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        this.listBuiltIn = new WidgetList(this, this.minecraft, this.guiLeft + 96, this.guiTop + 16, 112, 128);
        this.listCustom = new WidgetList(this, this.minecraft, this.guiLeft + 96, this.guiTop + 16, 112, 128);
        this.listFavorite = new WidgetList(this, this.minecraft, this.guiLeft + 96, this.guiTop + 16, 112, 128);
        this.listSession = new WidgetList(this, this.minecraft, this.guiLeft + 96, this.guiTop + 16, 112, 128);
        this.listWebpage = new WidgetList(this, this.minecraft, this.guiLeft + 96, this.guiTop + 16, 112, 128);
        this.listProjects = new WidgetList(this, this.minecraft, this.guiLeft + 96, this.guiTop + 16, 112, 128);
        this.tabBuiltin = new Point(215 + this.guiLeft, 32 + this.guiTop);
        this.tabCustom = new Point(215 + this.guiLeft, 48 + this.guiTop);
        this.tabFavorite = new Point(215 + this.guiLeft, 64 + this.guiTop);
        this.tabSession = new Point(215 + this.guiLeft, 80 + this.guiTop);
        this.tabWebpage = new Point(215 + this.guiLeft, 96 + this.guiTop);
        this.tabProjects = new Point(215 + this.guiLeft, 112 + this.guiTop);
        this.btnApply = new Point(16 + this.guiLeft, 112 + this.guiTop);
        this.btnRemove = new Point(16 + this.guiLeft, 128 + this.guiTop);
        for (EnumSpreadArt art : EnumSpreadArt.values()) {
            if (art == EnumSpreadArt.NONE || art == EnumSpreadArt.CUSTOM) continue;
            if (art == this.currentArt) {
                WidgetEntryArt widgetEntryArt = new WidgetEntryArt(this, art);
                this.listBuiltIn.addEntry(widgetEntryArt);
                this.selectedWidget = widgetEntryArt;
                this.listBuiltIn.setSelected((AbstractSelectionList.Entry)widgetEntryArt);
                continue;
            }
            this.listBuiltIn.addEntry(new WidgetEntryArt(this, art));
        }
        this.buildListCustom();
        this.buildListFavorite();
        this.buildListSession();
        this.buildListWebpage();
        this.buildListProjects();
        if (!this.isWebpageTabEnabled) {
            this.tabBuiltin.translate(0, 8);
            this.tabCustom.translate(0, 8);
            this.tabFavorite.translate(0, 8);
            this.tabSession.translate(0, 8);
            this.tabProjects.translate(0, -8);
        }
        this.updateSelectedWidgetList(this.listFavorite.children().isEmpty() ? this.listBuiltIn : this.listFavorite, false);
        this.pageDraw.init();
        this.pageScale.init();
    }

    void buildListCustom() {
        this.listCustom.children().clear();
        this.listCustom.addEntry(this.buttonCreateNew);
        for (String name : EmbroideryData.getNames()) {
            this.listCustom.addEntry(new WidgetEntryBytes(this, name, EmbroideryData.get(name)));
        }
        Collections.sort(this.listCustom.children());
    }

    private void buildListFavorite() {
        this.listFavorite.children().clear();
        for (String name : EmbroideryData.getFavorites()) {
            Embroidery embroidery;
            String[] entry = name.split(":");
            if (entry.length != 2) continue;
            if (entry[0].equalsIgnoreCase("inc")) {
                EnumSpreadArt art = EnumSpreadArt.byName(entry[1]);
                if (art == EnumSpreadArt.NONE || art == EnumSpreadArt.CUSTOM) continue;
                this.listFavorite.addEntry(new WidgetEntryArt(this, art));
                continue;
            }
            if (!entry[0].equalsIgnoreCase("per") || (embroidery = EmbroideryData.getFavorite(name)) == null) continue;
            this.listFavorite.addEntry(new WidgetEntryBytes(this, entry[1], embroidery));
        }
        Collections.sort(this.listFavorite.children());
    }

    private void buildListSession() {
        this.listSession.children().clear();
        this.listSession.addEntry(this.buttonPasteShare);
        for (String name : EmbroideryData.getSessionItems()) {
            this.listSession.addEntry(new WidgetEntryBytes(this, name, EmbroideryData.getSessionItem(name)));
        }
    }

    private void buildListWebpage() {
        this.listWebpage.children().clear();
        for (String name : EmbroideryData.getWebItems()) {
            this.listWebpage.addEntry(new WidgetEntryBytes(this, name, EmbroideryData.getWebItem(name)));
        }
        Collections.sort(this.listWebpage.children());
        this.isWebpageTabEnabled = !this.listWebpage.children().isEmpty();
    }

    void buildListProjects() {
        this.listProjects.children().clear();
        for (String name : EmbroideryData.getProjects()) {
            this.listProjects.addEntry(new WidgetProject(this, name, EmbroideryData.getProject(name)));
        }
        Collections.sort(this.listProjects.children());
    }

    private boolean updateSelectedWidgetList(WidgetList widgetList, boolean setSelected) {
        if (this.selectedWidgetList != widgetList) {
            this.selectedWidgetList = widgetList;
            if (setSelected) {
                this.selectedWidget = (WidgetEntry)this.selectedWidgetList.getSelected();
            }
            int x = 16 + this.guiLeft;
            int y = 88 + this.guiTop;
            if (this.selectedWidgetList == this.listBuiltIn) {
                this.btnCopy.setLocation(x + 16, y);
                this.btnShare.setLocation(0, 0);
                this.btnFavorite.setLocation(x + 32, y);
                this.btnDelete.setLocation(0, 0);
            } else if (this.selectedWidgetList == this.listCustom) {
                this.btnCopy.setLocation(x + 16, y);
                this.btnShare.setLocation(x + 32, y);
                this.btnFavorite.setLocation(x + 48, y);
                this.btnDelete.setLocation(x, y);
            } else if (this.selectedWidgetList == this.listFavorite) {
                this.btnCopy.setLocation(x + 24, y);
                this.btnShare.setLocation(x + 40, y);
                this.btnFavorite.setLocation(x + 8, y);
                this.btnDelete.setLocation(0, 0);
            } else if (this.selectedWidgetList == this.listSession) {
                this.btnCopy.setLocation(x + 16, y);
                this.btnShare.setLocation(x + 32, y);
                this.btnFavorite.setLocation(0, 0);
                this.btnDelete.setLocation(0, 0);
            } else if (this.selectedWidgetList == this.listWebpage) {
                this.btnCopy.setLocation(x + 24, y);
                this.btnShare.setLocation(0, 0);
                this.btnFavorite.setLocation(0, 0);
                this.btnDelete.setLocation(0, 0);
            } else if (this.selectedWidgetList == this.listProjects) {
                this.btnCopy.setLocation(x + 16, y);
                this.btnShare.setLocation(0, 0);
                this.btnFavorite.setLocation(0, 0);
                this.btnDelete.setLocation(x + 32, y);
            }
            return true;
        }
        return false;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ResourceLocation guiTexture = Textures.EMBROIDERY.get();
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.guiLeft, (double)this.guiTop, (int)0, (int)0, (int)239, (int)158, (ResourceLocation)guiTexture);
        if (this.activePage == ActivePage.DRAW) {
            this.pageDraw.render(graphics, mouseX, mouseY, partialTicks);
        }
        if (this.activePage == ActivePage.SCALE || this.activePage == ActivePage.DRAW && this.scaleLayer) {
            this.pageScale.render(graphics, mouseX, mouseY, partialTicks);
        }
        if (this.activePage == ActivePage.SELECT) {
            boolean hasSelection;
            WidgetEntry draw;
            String tooltip = "";
            this.selectedWidgetList.render(graphics, mouseX, mouseY, partialTicks);
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.guiLeft + 95), (double)(this.guiTop + 4), (int)96, (int)4, (int)118, (int)12, (ResourceLocation)guiTexture);
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.guiLeft + 95), (double)(this.guiTop + 144), (int)96, (int)144, (int)118, (int)12, (ResourceLocation)guiTexture);
            WidgetEntry widgetEntry = draw = this.hoveredWidget != null ? this.hoveredWidget : this.selectedWidget;
            if (draw != null) {
                draw.renderPreview(graphics, this.guiLeft + 16, this.guiTop + 16);
            }
            this.hoveredWidget = null;
            boolean isActive = this.selectedWidgetList == this.listBuiltIn;
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.tabBuiltin.x, (double)this.tabBuiltin.y, (int)208, (int)(isActive ? 240 : 224), (int)16, (int)16, (ResourceLocation)guiTexture);
            GuiHelper.drawTextureScaled((GuiGraphics)graphics, (double)(this.tabBuiltin.x + (isActive ? 2 : 1)), (double)(this.tabBuiltin.y + 2), (int)0, (int)208, (int)16, (int)16, (double)0.7, (ResourceLocation)guiTexture);
            isActive = this.selectedWidgetList == this.listCustom;
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.tabCustom.x, (double)this.tabCustom.y, (int)208, (int)(isActive ? 240 : 224), (int)16, (int)16, (ResourceLocation)guiTexture);
            GuiHelper.drawTextureScaled((GuiGraphics)graphics, (double)(this.tabCustom.x + (isActive ? 2 : 1)), (double)(this.tabCustom.y + 2), (int)16, (int)208, (int)16, (int)16, (double)0.7, (ResourceLocation)guiTexture);
            isActive = this.selectedWidgetList == this.listFavorite;
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.tabFavorite.x, (double)this.tabFavorite.y, (int)208, (int)(isActive ? 240 : 224), (int)16, (int)16, (ResourceLocation)guiTexture);
            GuiHelper.drawTextureScaled((GuiGraphics)graphics, (double)(this.tabFavorite.x + (isActive ? 2 : 1)), (double)(this.tabFavorite.y + 2), (int)48, (int)208, (int)16, (int)16, (double)0.7, (ResourceLocation)guiTexture);
            isActive = this.selectedWidgetList == this.listSession;
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.tabSession.x, (double)this.tabSession.y, (int)208, (int)(isActive ? 240 : 224), (int)16, (int)16, (ResourceLocation)guiTexture);
            GuiHelper.drawTextureScaled((GuiGraphics)graphics, (double)(this.tabSession.x + (isActive ? 2 : 1)), (double)(this.tabSession.y + 2), (int)32, (int)208, (int)16, (int)16, (double)0.7, (ResourceLocation)guiTexture);
            if (this.isWebpageTabEnabled) {
                isActive = this.selectedWidgetList == this.listWebpage;
                GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.tabWebpage.x, (double)this.tabWebpage.y, (int)208, (int)(isActive ? 240 : 224), (int)16, (int)16, (ResourceLocation)guiTexture);
                GuiHelper.drawTextureScaled((GuiGraphics)graphics, (double)(this.tabWebpage.x + (isActive ? 2 : 1)), (double)(this.tabWebpage.y + 2), (int)64, (int)208, (int)16, (int)16, (double)0.7, (ResourceLocation)guiTexture);
            }
            boolean isProject = this.selectedWidgetList == this.listProjects;
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.tabProjects.x, (double)this.tabProjects.y, (int)208, (int)(isProject ? 240 : 224), (int)16, (int)16, (ResourceLocation)guiTexture);
            GuiHelper.drawTextureScaled((GuiGraphics)graphics, (double)(this.tabProjects.x + (isProject ? 2 : 1)), (double)(this.tabProjects.y + 2), (int)0, (int)192, (int)16, (int)16, (double)0.7, (ResourceLocation)guiTexture);
            if (this.isMouseOverArea(mouseX, mouseY, this.tabBuiltin, 16, 16)) {
                tooltip = this.TEXT_TAB_EMBEDDED;
            }
            if (this.isMouseOverArea(mouseX, mouseY, this.tabCustom, 16, 16)) {
                tooltip = this.TEXT_TAB_CUSTOM;
            }
            if (this.isMouseOverArea(mouseX, mouseY, this.tabFavorite, 16, 16)) {
                tooltip = this.TEXT_TAB_FAVORITE;
            }
            if (this.isMouseOverArea(mouseX, mouseY, this.tabSession, 16, 16)) {
                tooltip = this.TEXT_TAB_SESSION;
            }
            if (this.isWebpageTabEnabled && this.isMouseOverArea(mouseX, mouseY, this.tabWebpage, 16, 16)) {
                tooltip = this.TEXT_TAB_WEB;
            }
            if (this.isMouseOverArea(mouseX, mouseY, this.tabProjects, 16, 16)) {
                tooltip = this.TEXT_TAB_PROJECT;
            }
            boolean bl = hasSelection = this.selectedWidget != null;
            if (this.isMouseOverArea(mouseX, mouseY, this.btnApply, 64, 16)) {
                tooltip = this.canApply ? (!hasSelection ? this.TEXT_ERROR_NO_SELECTION : this.TEXT_APPLY_INFO) : (this.bedClicked ? this.TEXT_ERROR_NO_THREAD : this.TEXT_ERROR_NO_BED);
                GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.btnApply.x, (double)this.btnApply.y, (int)80, (int)(hasSelection && this.canApply ? 224 : 208), (int)64, (int)16, (ResourceLocation)guiTexture);
            } else {
                GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.btnApply.x, (double)this.btnApply.y, (int)80, (int)(hasSelection && this.canApply ? 240 : 208), (int)64, (int)16, (ResourceLocation)guiTexture);
            }
            if (this.isMouseOverArea(mouseX, mouseY, this.btnRemove, 64, 16)) {
                tooltip = this.canRemove ? this.TEXT_REMOVE_INFO : (this.bedClicked ? this.TEXT_ERROR_NO_ART : this.TEXT_ERROR_NO_BED);
                GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.btnRemove.x, (double)this.btnRemove.y, (int)144, (int)(this.canRemove ? 224 : 208), (int)64, (int)16, (ResourceLocation)guiTexture);
            } else {
                GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.btnRemove.x, (double)this.btnRemove.y, (int)144, (int)(this.canRemove ? 240 : 208), (int)64, (int)16, (ResourceLocation)guiTexture);
            }
            if (hasSelection) {
                if (this.isActive(this.btnCopy)) {
                    if (this.isMouseOverArea(mouseX, mouseY, this.btnCopy, 16)) {
                        tooltip = isProject ? this.TEXT_EDIT : this.TEXT_COPY;
                        GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.btnCopy.x, (double)this.btnCopy.y, (int)16, (int)224, (int)16, (int)16, (ResourceLocation)guiTexture);
                    } else {
                        GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.btnCopy.x, (double)this.btnCopy.y, (int)16, (int)240, (int)16, (int)16, (ResourceLocation)guiTexture);
                    }
                }
                if (this.isActive(this.btnDelete)) {
                    if (this.isMouseOverArea(mouseX, mouseY, this.btnDelete, 16)) {
                        tooltip = this.TEXT_DELETE;
                        GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.btnDelete.x, (double)this.btnDelete.y, (int)0, (int)224, (int)16, (int)16, (ResourceLocation)guiTexture);
                    } else {
                        GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.btnDelete.x, (double)this.btnDelete.y, (int)0, (int)240, (int)16, (int)16, (ResourceLocation)guiTexture);
                    }
                }
                if (this.isActive(this.btnFavorite)) {
                    boolean shift;
                    boolean mouseOverArea = this.isMouseOverArea(mouseX, mouseY, this.btnFavorite, 16);
                    boolean bl2 = shift = this.selectedWidgetList == this.listFavorite != mouseOverArea;
                    if (mouseOverArea) {
                        tooltip = shift ? this.TEXT_FAVORITE : this.TEXT_UNFAVORITE;
                    }
                    GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.btnFavorite.x, (double)this.btnFavorite.y, (int)48, (int)(shift ? 224 : 240), (int)16, (int)16, (ResourceLocation)guiTexture);
                }
                if (this.isActive(this.btnShare)) {
                    if (this.isMouseOverArea(mouseX, mouseY, this.btnShare, 16)) {
                        tooltip = this.TEXT_SHARE;
                        GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.btnShare.x, (double)this.btnShare.y, (int)32, (int)224, (int)16, (int)16, (ResourceLocation)guiTexture);
                    } else {
                        GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.btnShare.x, (double)this.btnShare.y, (int)32, (int)240, (int)16, (int)16, (ResourceLocation)guiTexture);
                    }
                }
            }
            graphics.drawCenteredString(this.font, this.TEXT_APPLY, this.btnApply.x + 32, this.btnApply.y + 4, hasSelection && this.canApply ? 0xFFFFFF : -6250336);
            graphics.drawCenteredString(this.font, this.TEXT_REMOVE, this.btnRemove.x + 32, this.btnRemove.y + 5, this.canRemove ? 0xFFFFFF : -6250336);
            if (this.selectedWidgetList == this.listCustom && this.buttonCreateNew.isMouseOver(mouseX, mouseY)) {
                tooltip = this.TEXT_CREATE_INFO;
            }
            if (!Strings.isNullOrEmpty((String)tooltip)) {
                if (!tooltip.equals(this.lastToolTip)) {
                    this.lastToolTip = tooltip;
                    this.countToolTip = 0;
                } else {
                    ++this.countToolTip;
                }
                if (this.countToolTip >= 40) {
                    this.countToolTip = 40;
                    ArrayList lines = new ArrayList();
                    StringUtil.multiLineTooltip((String)tooltip, lines);
                    graphics.renderComponentTooltip(this.font, lines, this.guiLeft, this.guiTop + this.ySize + 10);
                }
            }
        }
    }

    private boolean isActive(Point button) {
        return button.x != 0 && button.y != 0;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        switch (this.activePage.ordinal()) {
            case 1: {
                if (!this.pageDraw.keyPressed(keyCode, scanCode, modifiers)) break;
                return true;
            }
            case 0: {
                if (!this.selectedWidgetList.keyPressed(keyCode, scanCode, modifiers)) break;
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean shouldCloseOnEsc() {
        return this.activePage == ActivePage.SELECT;
    }

    public void removed() {
        EmbroideryData.INSTANCE.saveData();
        super.removed();
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        switch (this.activePage.ordinal()) {
            case 1: {
                if (!this.scaleLayer) {
                    if (!this.pageDraw.keyReleased(keyCode, scanCode, modifiers)) break;
                    return true;
                }
            }
            case 2: {
                if (!this.pageScale.keyReleased(keyCode, scanCode, modifiers)) break;
                return true;
            }
            case 0: {
                if (!this.selectedWidgetList.keyReleased(keyCode, scanCode, modifiers)) break;
                return true;
            }
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char character, int value) {
        switch (this.activePage.ordinal()) {
            case 1: {
                if (this.scaleLayer) break;
                return this.pageDraw.charTyped(character, value);
            }
            case 0: {
                if (!this.selectedWidgetList.charTyped(character, value)) break;
                return true;
            }
        }
        return super.charTyped(character, value);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        switch (this.activePage.ordinal()) {
            case 1: {
                if (!this.scaleLayer) {
                    return this.pageDraw.mouseClicked(mouseX, mouseY, button);
                }
            }
            case 2: {
                return this.pageScale.mouseClicked(mouseX, mouseY, button);
            }
            case 0: {
                if (this.selectedWidgetList.mouseClicked(mouseX, mouseY, button)) {
                    return true;
                }
                if (button != 0) break;
                if (this.isMouseOverArea(mouseX, mouseY, this.tabBuiltin, 16)) {
                    return this.updateSelectedWidgetList(this.listBuiltIn, true);
                }
                if (this.isMouseOverArea(mouseX, mouseY, this.tabCustom, 16)) {
                    return this.updateSelectedWidgetList(this.listCustom, true);
                }
                if (this.isMouseOverArea(mouseX, mouseY, this.tabFavorite, 16)) {
                    return this.updateSelectedWidgetList(this.listFavorite, true);
                }
                if (this.isMouseOverArea(mouseX, mouseY, this.tabSession, 16)) {
                    return this.updateSelectedWidgetList(this.listSession, true);
                }
                if (this.isWebpageTabEnabled && this.isMouseOverArea(mouseX, mouseY, this.tabWebpage, 16)) {
                    return this.updateSelectedWidgetList(this.listWebpage, true);
                }
                if (this.isMouseOverArea(mouseX, mouseY, this.tabProjects, 16)) {
                    return this.updateSelectedWidgetList(this.listProjects, true);
                }
                if (this.isMouseOverArea(mouseX, mouseY, this.btnApply, 64, 16)) {
                    if (this.canApply && this.selectedWidget != null) {
                        Services.NETWORK.sendToServer((CustomPacketPayload)new PacketEmbroidery(this.pos, this.selectedWidget.getArt(), this.selectedWidget.getEmbroidery()));
                        this.minecraft.player.closeContainer();
                        return true;
                    }
                    return false;
                }
                if (this.isMouseOverArea(mouseX, mouseY, this.btnRemove, 64, 16)) {
                    if (this.canRemove) {
                        Services.NETWORK.sendToServer((CustomPacketPayload)new PacketEmbroidery(this.pos, EnumSpreadArt.NONE, Embroidery.EMPTY));
                        this.minecraft.player.closeContainer();
                    }
                    return true;
                }
                if (this.isActive(this.btnCopy) && this.isMouseOverArea(mouseX, mouseY, this.btnCopy, 16)) {
                    if (this.selectedWidget != null) {
                        if (this.selectedWidget instanceof WidgetProject) {
                            this.pageDraw.loadProject(this.selectedWidget.id, ((WidgetProject)this.selectedWidget).project);
                            this.activePage = ActivePage.DRAW;
                            return true;
                        }
                        byte palette = 0;
                        byte[] indices = null;
                        if (this.selectedWidget instanceof WidgetEntryArt) {
                            Embroidery embroidery = Embroidery.fromShareTag(this.selectedWidget.getShareTag());
                            if (!embroidery.isEmpty()) {
                                palette = embroidery.palette();
                                indices = embroidery.getUncompressedIndices();
                            }
                        } else {
                            WidgetEntry widgetEntry = this.selectedWidget;
                            if (widgetEntry instanceof WidgetEntryBytes) {
                                WidgetEntryBytes widgetEntryBytes = (WidgetEntryBytes)widgetEntry;
                                palette = widgetEntryBytes.palette;
                                indices = widgetEntryBytes.indices;
                            }
                        }
                        if (indices != null && Embroidery.getBaseCanvasArraySize(indices) > -1) {
                            if (Screen.hasControlDown()) {
                                this.pageScale.setImage(this.selectedWidget.id, palette, indices, Embroidery.getCanvasScale(indices));
                                this.activePage = ActivePage.SCALE;
                            } else {
                                this.pageDraw.setImage(this.selectedWidget.id, palette, indices, Embroidery.getCanvasScale(indices));
                                this.activePage = ActivePage.DRAW;
                            }
                            return true;
                        }
                    }
                    return false;
                }
                if (this.isActive(this.btnDelete) && this.isMouseOverArea(mouseX, mouseY, this.btnDelete, 16)) {
                    if (this.selectedWidget != null && GuiEmbroidery.hasAltDown()) {
                        this.selectedWidgetList.children().remove(this.selectedWidget);
                        if (this.selectedWidgetList == this.listCustom) {
                            EmbroideryData.delete(this.selectedWidget.id);
                        } else if (this.selectedWidgetList == this.listProjects) {
                            EmbroideryData.deleteProject(this.selectedWidget.id);
                        }
                        this.selectedWidgetList.setSelected(null);
                        return true;
                    }
                    return false;
                }
                if (this.isActive(this.btnFavorite) && this.isMouseOverArea(mouseX, mouseY, this.btnFavorite, 16)) {
                    if (this.selectedWidget != null) {
                        String name = (this.selectedWidget instanceof WidgetEntryArt ? "inc:" : "per:") + this.selectedWidget.id;
                        if (this.selectedWidgetList == this.listFavorite) {
                            this.selectedWidgetList.children().remove(this.selectedWidget);
                            this.selectedWidgetList.setSelected(null);
                            EmbroideryData.unfavorite(name);
                        } else {
                            EmbroideryData.favorite(name, this.selectedWidget.getEmbroidery());
                            this.listFavorite.addEntry(this.selectedWidget);
                        }
                        return true;
                    }
                    return false;
                }
                if (!this.isActive(this.btnShare) || !this.isMouseOverArea(mouseX, mouseY, this.btnShare, 16)) break;
                if (this.selectedWidget != null) {
                    if (GuiEmbroidery.hasAltDown() && !GuiEmbroidery.hasShiftDown()) {
                        Services.NETWORK.sendToServer((CustomPacketPayload)new PacketShareTag(this.selectedWidget.id, this.selectedWidget.getEmbroidery(), false));
                    } else if (GuiEmbroidery.hasAltDown() && GuiEmbroidery.hasShiftDown()) {
                        Services.NETWORK.sendToServer((CustomPacketPayload)new PacketShareTag(this.selectedWidget.id, this.selectedWidget.getEmbroidery(), true));
                    } else {
                        String tagOutput = this.selectedWidget.id + ":" + this.selectedWidget.getShareTag();
                        Minecraft.getInstance().keyboardHandler.setClipboard(tagOutput);
                        MultiBeds.LOGGER.info("Copied ShareTag: " + tagOutput);
                    }
                    return true;
                }
                return false;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double accelX, double accelY) {
        switch (this.activePage.ordinal()) {
            case 1: {
                if (this.scaleLayer) break;
                return this.pageDraw.mouseDragged(mouseX, mouseY, button);
            }
            case 0: {
                if (!this.selectedWidgetList.mouseDragged(mouseX, mouseY, button, accelX, accelY)) break;
                return true;
            }
        }
        return super.mouseDragged(mouseX, mouseY, button, accelX, accelY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (!this.scaleLayer && this.activePage == ActivePage.DRAW) {
            return this.pageDraw.mouseReleased(mouseX, mouseY, button);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double hScroll, double vScroll) {
        if (this.activePage == ActivePage.SELECT && this.selectedWidgetList.mouseScrolled(mouseX, mouseY, hScroll, vScroll)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, hScroll, vScroll);
    }

    private boolean isMouseOverArea(double mouseX, double mouseY, Point point, int size) {
        return this.isMouseOverArea(mouseX, mouseY, point.x, point.y, size, size);
    }

    private boolean isMouseOverArea(double mouseX, double mouseY, Point point, int sizeX, int sizeY) {
        return this.isMouseOverArea(mouseX, mouseY, point.x, point.y, sizeX, sizeY);
    }

    private boolean isMouseOverArea(double mouseX, double mouseY, int x, int y, int sizeX, int sizeY) {
        return mouseX >= (double)x && mouseX < (double)(x + sizeX) && mouseY >= (double)y && mouseY < (double)(y + sizeY);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public Minecraft getMinecraft() {
        return this.minecraft;
    }

    private class WidgetEntryNew
    extends WidgetFunctionButton {
        private WidgetEntryNew() {
            super(GuiEmbroidery.this, "gui.multibeds.embroidery.create");
        }

        private int getSize() {
            return Screen.hasAltDown() ? 24 : (Screen.hasShiftDown() ? 32 : (Screen.hasControlDown() ? 12 : 16));
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            GuiEmbroidery.this.pageDraw.setImage("unnamed", (byte)0, null, this.getSize());
            GuiEmbroidery.this.activePage = ActivePage.DRAW;
            return true;
        }

        @Override
        protected String getDisplayName() {
            return super.getDisplayName() + " (" + this.getSize() + "x)";
        }
    }

    private abstract class WidgetEntry
    extends AbstractWidgetList.AWLEntry<WidgetEntry>
    implements Comparable<WidgetEntry> {
        private final String id;
        private final String displayName;

        WidgetEntry(String id) {
            this(id, id);
        }

        WidgetEntry(String id, String displayName) {
            this.id = id.toLowerCase(Locale.ROOT);
            this.displayName = displayName;
        }

        String getDisplayName() {
            return this.displayName;
        }

        public void render(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            if (hovered) {
                GuiEmbroidery.this.hoveredWidget = this;
                RenderSystem.enableBlend();
                GuiHelper.drawGradientRect((GuiGraphics)graphics, (double)left, (double)top, (double)(left + width - 3), (double)((float)top + (float)height / 2.0f), (int)-2130706688, (int)-2130706688, (int)-256, (int)-256);
                GuiHelper.drawGradientRect((GuiGraphics)graphics, (double)left, (double)((float)top + (float)height / 2.0f), (double)(left + width - 3), (double)(top + height), (int)-256, (int)-256, (int)-2130706688, (int)-2130706688);
            }
            graphics.drawCenteredString(GuiEmbroidery.this.font, this.getDisplayName(), left + width / 2, top, 0xFFFFFF);
        }

        abstract void renderPreview(GuiGraphics var1, int var2, int var3);

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (button == 0) {
                GuiEmbroidery.this.selectedWidgetList.setSelected((AbstractSelectionList.Entry)this);
                GuiEmbroidery.this.selectedWidget = this;
                return true;
            }
            return false;
        }

        EnumSpreadArt getArt() {
            return EnumSpreadArt.CUSTOM;
        }

        Embroidery getEmbroidery() {
            return Embroidery.EMPTY;
        }

        String getShareTag() {
            return "";
        }

        @Override
        public int compareTo(WidgetEntry other) {
            String otherName = other instanceof WidgetFunctionButton ? "" : other.id.toLowerCase();
            return this instanceof WidgetFunctionButton ? "".compareTo(otherName) : this.id.toLowerCase().compareTo(otherName);
        }
    }

    private class WidgetEntryPasteShareTag
    extends WidgetFunctionButton {
        private final DateFormat timestamp;

        private WidgetEntryPasteShareTag() {
            super(GuiEmbroidery.this, "gui.multibeds.embroidery.paste_tag");
            this.timestamp = new SimpleDateFormat("HH:mm:ss");
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            Embroidery embroidery;
            String clipboard = Minecraft.getInstance().keyboardHandler.getClipboard();
            if (!Strings.isNullOrEmpty((String)clipboard) && !(embroidery = Embroidery.fromShareTag(clipboard = clipboard.replaceAll("\"", "").trim())).isEmpty()) {
                Object name = Embroidery.getNameFromShareTag(clipboard);
                if (Strings.isNullOrEmpty((String)name)) {
                    name = "pst:" + this.timestamp.format(Calendar.getInstance().getTime());
                }
                GuiEmbroidery.this.listSession.addEntry(new WidgetEntryBytes(GuiEmbroidery.this, (String)name, embroidery));
            }
            return true;
        }
    }

    static enum ActivePage {
        SELECT,
        DRAW,
        SCALE;

    }

    private class WidgetEntryBytes
    extends WidgetEntry {
        private final Embroidery embroidery;
        private final byte palette;
        private final byte[] indices;
        private final int canvasScale;
        private final String shareTag;

        WidgetEntryBytes(GuiEmbroidery guiEmbroidery, String name, Embroidery embroidery) {
            super(name);
            this.embroidery = embroidery;
            this.palette = embroidery.palette();
            this.shareTag = embroidery.buildShareTag(new String[0]);
            this.indices = embroidery.getUncompressedIndices();
            this.canvasScale = Embroidery.getCanvasScale(this.indices);
        }

        @Override
        void renderPreview(GuiGraphics graphics, int posX, int posY) {
            double pixelSize = 64.0 / (double)this.canvasScale;
            for (int row = 0; row < this.canvasScale; ++row) {
                for (int col = 0; col < this.canvasScale; ++col) {
                    double x = (double)posX + (double)col * pixelSize;
                    double y = (double)posY + (double)row * pixelSize;
                    GuiHelper.drawRect((GuiGraphics)graphics, (double)x, (double)y, (double)(x + pixelSize), (double)(y + pixelSize), (int)Embroidery.getColorAt(this.palette, this.indices, this.canvasScale * row + col));
                }
            }
        }

        @Override
        public String getShareTag() {
            return this.shareTag;
        }

        @Override
        Embroidery getEmbroidery() {
            return this.embroidery;
        }
    }

    private class WidgetList
    extends AbstractWidgetList<WidgetEntry> {
        private WidgetList(GuiEmbroidery guiEmbroidery, Minecraft mc, int x, int y, int width, int height) {
            super(mc, x, y, width, height, 12);
            this.setFadeColors(0, 0);
            this.setScrollBarColors(Integer.MIN_VALUE, -2130706433, -1073741824);
            this.setSelectionBoxColors(Integer.MIN_VALUE, 0, 0);
        }

        protected int addEntry(WidgetEntry entry) {
            return this.children().contains(entry) ? -1 : super.addEntry((AbstractSelectionList.Entry)entry);
        }

        protected void renderBackground(GuiGraphics graphics, Tesselator tessellator) {
        }

        protected void renderHoleBackground(GuiGraphics graphics, Tesselator tessellator, int y0, int y1) {
        }
    }

    private class WidgetEntryArt
    extends WidgetEntry {
        private final EnumSpreadArt art;
        private final ResourceLocation location;

        private WidgetEntryArt(GuiEmbroidery guiEmbroidery, EnumSpreadArt art) {
            super(art.getSerializedName(), I18n.get((String)("misc.multibeds.art." + art.getSerializedName()), (Object[])new Object[0]));
            this.art = art;
            this.location = MultiBeds.RESOURCE.apply("textures/block/art/" + art.getSerializedName() + ".png");
        }

        @Override
        void renderPreview(GuiGraphics graphics, int posX, int posY) {
            GuiHelper.drawTextureScaled((GuiGraphics)graphics, (double)posX, (double)posY, (int)0, (int)0, (int)16, (int)16, (double)4.0, (int)16, (int)16, (ResourceLocation)this.location);
        }

        @Override
        String getShareTag() {
            return this.art.getShareTag();
        }

        @Override
        EnumSpreadArt getArt() {
            return this.art;
        }
    }

    private class WidgetProject
    extends WidgetEntry {
        private final WIPProject project;

        private WidgetProject(GuiEmbroidery guiEmbroidery, String name, WIPProject project) {
            super(name);
            this.project = project;
        }

        @Override
        void renderPreview(GuiGraphics graphics, int posX, int posY) {
            int canvasScale = this.project.getCanvasScale();
            byte[] indices = this.project.getPreview();
            byte palette = this.project.getPalette();
            double pixelSize = 64.0 / (double)canvasScale;
            for (int row = 0; row < canvasScale; ++row) {
                for (int col = 0; col < canvasScale; ++col) {
                    double x = (double)posX + (double)col * pixelSize;
                    double y = (double)posY + (double)row * pixelSize;
                    GuiHelper.drawRect((GuiGraphics)graphics, (double)x, (double)y, (double)(x + pixelSize), (double)(y + pixelSize), (int)Embroidery.getColorAt(palette, indices, canvasScale * row + col));
                }
            }
        }

        @Override
        Embroidery getEmbroidery() {
            return Embroidery.fromUncompressed(this.project.getPalette(), this.project.getPreview());
        }
    }

    private abstract class WidgetFunctionButton
    extends WidgetEntry {
        WidgetFunctionButton(GuiEmbroidery guiEmbroidery, String name) {
            super(name, I18n.get((String)name, (Object[])new Object[0]));
        }

        @Override
        public void render(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.render(graphics, index, top, left, width, height, mouseX, mouseY, hovered, partialTicks);
            GuiHelper.drawTextureScaled((GuiGraphics)graphics, (double)(left + 4), (double)top, (int)64, (int)224, (int)16, (int)16, (double)0.5, (ResourceLocation)Textures.EMBROIDERY.get());
        }

        @Override
        void renderPreview(GuiGraphics graphics, int posX, int posY) {
        }
    }
}

