/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import shetiphian.core.client.gui.EntityGuiItem;
import shetiphian.core.client.gui.GuiHelper;
import shetiphian.core.client.gui.RenderGuiItem;
import shetiphian.multibeds.client.gui.Textures;
import shetiphian.multibeds.common.inventory.ContainerBuilder;
import shetiphian.multibeds.common.misc.EnumBedStyle;

public class GuiBuilder
extends AbstractContainerScreen<ContainerBuilder> {
    private final Player player;
    private EntityGuiItem displayItem = null;
    private Component displayName = Component.empty();
    private boolean doubleTall = false;

    public GuiBuilder(ContainerBuilder screenContainer, Inventory inv, Component title) {
        super((AbstractContainerMenu)screenContainer, inv, title);
        this.player = inv.player;
        this.imageWidth = 182;
        this.imageHeight = 233;
        ((ContainerBuilder)this.menu).setInventoryChangeCallback(this::updatePreview);
        this.updatePreview();
    }

    public void init() {
        super.init();
        this.clearWidgets();
        if (((ContainerBuilder)this.menu).getBuilderMode() == ContainerBuilder.BuilderMode.BED) {
            this.addRenderableWidget(new ButtonIndex(this.leftPos + 44, this.topPos + 11, -1));
            this.addRenderableWidget(new ButtonIndex(this.leftPos + 128, this.topPos + 11, 1));
        }
    }

    private void updatePreview() {
        try {
            this.displayItem = new EntityGuiItem(this.player.level(), 0.0, 0.0, 0.0, ((ContainerBuilder)this.menu).getPreviewItem().copy().split(1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (((ContainerBuilder)this.menu).getBuilderMode() == ContainerBuilder.BuilderMode.BED) {
            EnumBedStyle style = EnumBedStyle.byIndex(((ContainerBuilder)this.menu).getBedStyleIndex());
            this.displayName = Component.translatable((String)("block.multibeds." + String.valueOf((Object)style)));
            this.doubleTall = style.hasTopper();
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
        if (this.displayItem != null) {
            int top = this.topPos + (((ContainerBuilder)this.menu).getBuilderMode() == ContainerBuilder.BuilderMode.BED ? (this.doubleTall ? 96 : 82) : 88);
            RenderGuiItem.render((EntityGuiItem)this.displayItem, (GuiGraphics)graphics, (boolean)true, (float)160.0f, (float)0.0f, (float)0.0f, (float)(this.leftPos + 91), (float)top, (float)50.0f, (float)-120.0f, (float)120.0f, (float)120.0f);
        }
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        ResourceLocation texture = Textures.BED_KIT.get();
        GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.leftPos, (double)this.topPos, (int)0, (int)23, (int)this.imageWidth, (int)this.imageHeight, (ResourceLocation)texture);
        Slot slot = ((ContainerBuilder)this.menu).getSlotBaseItem();
        if (!slot.hasItem() && ((ContainerBuilder)this.menu).getBuilderMode() == ContainerBuilder.BuilderMode.BED) {
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.leftPos + slot.x), (double)(this.topPos + slot.y), (int)224, (int)16, (int)16, (int)16, (ResourceLocation)texture);
        }
        if (!(slot = ((ContainerBuilder)this.menu).getSlotMaterial()).hasItem()) {
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.leftPos + slot.x), (double)(this.topPos + slot.y), (int)240, (int)16, (int)16, (int)16, (ResourceLocation)texture);
        }
        graphics.drawCenteredString(this.font, this.displayName, this.width / 2, this.topPos + 11, texture.getPath().startsWith("textures/gui/vanilla/") ? 0x404040 : 0xC0C0C0);
    }

    protected void renderLabels(GuiGraphics graphics, int x, int y) {
    }

    private class ButtonIndex
    extends Button
    implements GuiEventListener {
        private int shift;

        private ButtonIndex(int posX, int posY, int indexShift) {
            super(posX, posY, 12, 9, (Component)Component.empty(), null, DEFAULT_NARRATION);
            this.shift = indexShift;
        }

        public void onPress() {
            if (this.isHovered) {
                int index = ((ContainerBuilder)GuiBuilder.this.menu).getBedStyleIndex();
                int max = EnumBedStyle.values().length - 1;
                index += this.shift;
                MultiPlayerGameMode controller = Minecraft.getInstance().gameMode;
                if (controller != null) {
                    controller.handleInventoryButtonClick(((ContainerBuilder)((GuiBuilder)GuiBuilder.this).menu).containerId, index < 0 ? max : (index > max ? 0 : index));
                }
            }
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            int index = (this.shift > 0 ? 1 : 0) + (this.isHovered ? 2 : 0);
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.getX(), (double)this.getY(), (int)(194 + index * 16), (int)5, (int)this.width, (int)this.height, (ResourceLocation)Textures.BED_KIT.get());
        }
    }
}

