/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import shetiphian.core.client.gui.AbstractWidgetList;
import shetiphian.core.client.gui.GuiHelper;
import shetiphian.multibeds.MultiBeds;
import shetiphian.multibeds.client.gui.Textures;
import shetiphian.multibeds.common.inventory.ContainerBlanketLoom;
import shetiphian.multibeds.common.misc.EnumBlanket;

public class GuiBlanketLoom
extends AbstractContainerScreen<ContainerBlanketLoom> {
    private static final Map<EnumBlanket, ResourceLocation> BLANKET_TEXTURES = new HashMap<EnumBlanket, ResourceLocation>();
    private WidgetList patternWidgetList;

    public GuiBlanketLoom(ContainerBlanketLoom container, Inventory playerInv, Component title) {
        super((AbstractContainerMenu)container, playerInv, title);
        if (BLANKET_TEXTURES.isEmpty()) {
            for (EnumBlanket blanket : EnumBlanket.values()) {
                if (blanket == EnumBlanket.NONE || blanket == EnumBlanket.BANNER) continue;
                BLANKET_TEXTURES.put(blanket, MultiBeds.RESOURCE.apply("textures/block/blanket/" + blanket.getSerializedName() + ".png"));
            }
        }
        this.imageWidth = 214;
        this.imageHeight = 256;
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.patternWidgetList = new WidgetList(this, this.minecraft, this.leftPos + 96, this.topPos + 16, 96, 128);
        for (EnumBlanket.Pattern pattern : EnumBlanket.Pattern.values()) {
            this.patternWidgetList.addEntry(new WidgetEntry(pattern));
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        ResourceLocation guiTexture = Textures.BLANKET_LOOM.get();
        int winLeft = (this.width - this.imageWidth) / 2;
        int winTop = (this.height - this.imageHeight) / 2;
        GuiHelper.drawTexture((GuiGraphics)graphics, (double)winLeft, (double)winTop, (int)0, (int)0, (int)this.imageWidth, (int)this.imageHeight, (ResourceLocation)guiTexture);
        Slot slot = ((ContainerBlanketLoom)this.menu).getSlotBlanket();
        if (!slot.hasItem()) {
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(winLeft + slot.x), (double)(winTop + slot.y), (int)240, (int)32, (int)16, (int)16, (ResourceLocation)guiTexture);
        }
        if (!(slot = ((ContainerBlanketLoom)this.menu).getSlotDye()).hasItem()) {
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(winLeft + slot.x), (double)(winTop + slot.y), (int)240, (int)0, (int)16, (int)16, (ResourceLocation)guiTexture);
        }
        if (!(slot = ((ContainerBlanketLoom)this.menu).getSlotString()).hasItem()) {
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)(winLeft + slot.x), (double)(winTop + slot.y), (int)240, (int)16, (int)16, (int)16, (ResourceLocation)guiTexture);
        }
        this.patternWidgetList.render(graphics, mouseX, mouseY, partialTicks);
        GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.leftPos + 95), (double)(this.topPos + 4), (int)96, (int)4, (int)102, (int)12, (ResourceLocation)guiTexture);
        GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.leftPos + 95), (double)(this.topPos + 144), (int)96, (int)144, (int)102, (int)12, (ResourceLocation)guiTexture);
        EnumBlanket blanket = ((ContainerBlanketLoom)this.menu).getEnumBlanket();
        if (blanket != EnumBlanket.NONE && blanket != EnumBlanket.BANNER) {
            GuiHelper.drawTextureScaled((GuiGraphics)graphics, (double)(this.leftPos + 18), (double)(this.topPos + 25), (int)1, (int)0, (int)30, (int)23, (double)2.0, (int)32, (int)32, (ResourceLocation)BLANKET_TEXTURES.get((Object)blanket));
            if (this.patternWidgetList.getSelected() == null || ((WidgetEntry)this.patternWidgetList.getSelected()).pattern != blanket.getPattern()) {
                for (WidgetEntry entry : this.patternWidgetList.children()) {
                    if (entry.pattern != blanket.getPattern()) continue;
                    this.patternWidgetList.setSelected((AbstractSelectionList.Entry)entry);
                    break;
                }
            }
        } else if (this.patternWidgetList.getSelected() != null) {
            this.patternWidgetList.setSelected(null);
        }
    }

    protected void renderLabels(GuiGraphics graphics, int x, int y) {
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.patternWidgetList.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.patternWidgetList.keyReleased(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char character, int value) {
        if (this.patternWidgetList.charTyped(character, value)) {
            return true;
        }
        return super.charTyped(character, value);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.patternWidgetList.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double accelX, double accelY) {
        if (this.patternWidgetList.mouseDragged(mouseX, mouseY, button, accelX, accelY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, accelX, accelY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double hScroll, double vScroll) {
        if (this.patternWidgetList.mouseScrolled(mouseX, mouseY, hScroll, vScroll)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, hScroll, vScroll);
    }

    private class WidgetList
    extends AbstractWidgetList<WidgetEntry> {
        private WidgetList(GuiBlanketLoom guiBlanketLoom, Minecraft mc, int x, int y, int width, int height) {
            super(mc, x, y, width, height, 12);
            this.setFadeColors(0, 0);
            this.setScrollBarColors(Integer.MIN_VALUE, -2130706433, -1073741824);
            this.setSelectionBoxColors(Integer.MIN_VALUE, 0, 0);
        }

        protected int addEntry(WidgetEntry entry) {
            return this.children().contains((Object)entry) ? -1 : super.addEntry((AbstractSelectionList.Entry)entry);
        }

        protected void renderBackground(GuiGraphics graphics, Tesselator tessellator) {
        }

        protected void renderHoleBackground(GuiGraphics graphics, Tesselator tessellator, int y0, int y1) {
        }
    }

    private class WidgetEntry
    extends AbstractWidgetList.AWLEntry<WidgetEntry> {
        private final EnumBlanket.Pattern pattern;
        private final String name;

        private WidgetEntry(EnumBlanket.Pattern pattern) {
            this.pattern = pattern;
            StringBuilder stringBuffer = new StringBuilder();
            String patternName = pattern.getSerializedName().replaceAll("_", " ");
            int character = 32;
            for (int i = 0; i < patternName.length(); ++i) {
                if (character == 32 && patternName.charAt(i) != ' ') {
                    stringBuffer.append(Character.toUpperCase(patternName.charAt(i)));
                } else {
                    stringBuffer.append(patternName.charAt(i));
                }
                character = patternName.charAt(i);
            }
            this.name = stringBuffer.toString().trim();
        }

        private String getDisplayName() {
            return this.name;
        }

        public void render(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            boolean hasString = ((ContainerBlanketLoom)GuiBlanketLoom.this.menu).getSlotString().hasItem();
            if (hovered && hasString) {
                RenderSystem.enableBlend();
                GuiHelper.drawGradientRect((GuiGraphics)graphics, (double)left, (double)top, (double)(left + width - 3), (double)((float)top + (float)height / 2.0f), (int)-2130706688, (int)-2130706688, (int)-256, (int)-256);
                GuiHelper.drawGradientRect((GuiGraphics)graphics, (double)left, (double)((float)top + (float)height / 2.0f), (double)(left + width - 3), (double)(top + height), (int)-256, (int)-256, (int)-2130706688, (int)-2130706688);
            }
            int color = hasString ? 0xFFFFFF : 0xAAAAAA;
            graphics.drawCenteredString(GuiBlanketLoom.this.font, this.getDisplayName(), left + width / 2, top, color);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (button == 0 && !((ContainerBlanketLoom)GuiBlanketLoom.this.menu).getSlotString().getItem().isEmpty()) {
                GuiBlanketLoom.this.patternWidgetList.setSelected((AbstractSelectionList.Entry)this);
                MultiPlayerGameMode controller = Minecraft.getInstance().gameMode;
                if (controller != null) {
                    controller.handleInventoryButtonClick(((ContainerBlanketLoom)((GuiBlanketLoom)GuiBlanketLoom.this).menu).containerId, this.pattern.ordinal());
                    return true;
                }
            }
            return false;
        }
    }
}

