/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.gui;

import com.google.common.base.Strings;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import shetiphian.core.client.gui.GuiHelper;
import shetiphian.core.common.StringUtil;
import shetiphian.multibeds.Configs;
import shetiphian.multibeds.client.gui.GuiEmbroidery;
import shetiphian.multibeds.client.gui.Textures;
import shetiphian.multibeds.common.misc.Embroidery;

class EmbroideryPage_Scale {
    private final String TEXT_THEME = I18n.get((String)"gui.multibeds.embroidery.draw.theme", (Object[])new Object[0]);
    private final String TEXT_SAVE = I18n.get((String)"gui.multibeds.embroidery.scale.save", (Object[])new Object[0]);
    private final String TEXT_EXIT = I18n.get((String)"gui.multibeds.embroidery.scale.exit", (Object[])new Object[0]);
    private final String TEXT_X12 = I18n.get((String)"gui.multibeds.embroidery.scale.x12", (Object[])new Object[0]);
    private final String TEXT_X16 = I18n.get((String)"gui.multibeds.embroidery.scale.x16", (Object[])new Object[0]);
    private final String TEXT_X24 = I18n.get((String)"gui.multibeds.embroidery.scale.x24", (Object[])new Object[0]);
    private final String TEXT_X32 = I18n.get((String)"gui.multibeds.embroidery.scale.x32", (Object[])new Object[0]);
    private final String TEXT_CROP = I18n.get((String)"gui.multibeds.embroidery.scale.crop", (Object[])new Object[0]);
    private final String TEXT_INCREASE = I18n.get((String)"gui.multibeds.embroidery.scale.increase", (Object[])new Object[0]);
    private final String TEXT_DECREASE = I18n.get((String)"gui.multibeds.embroidery.scale.decrease", (Object[])new Object[0]);
    private final String TEXT_IMPORT = I18n.get((String)"gui.multibeds.embroidery.scale.import", (Object[])new Object[0]);
    private final GuiEmbroidery parent;
    private final int xSize = 240;
    private final int ySize = 156;
    private int guiLeft;
    private int guiTop;
    private final Font font;
    private byte sourcePalette;
    private byte[] sourceIndices = new byte[256];
    private byte[] scaledIndices = new byte[256];
    private byte[] outputIndices = new byte[256];
    private String name;
    private String lastToolTip;
    private int countToolTip;
    private boolean canvasSizeLock;
    private int sourceCanvasScale;
    private int scaledCanvasScale;
    private int outputCanvasScale;
    private double sourceCanvasPixel;
    private double outputCanvasPixel;
    private final int[] sourceCanvasArraySize = new int[2];
    private final int[] scaledCanvasArraySize = new int[2];
    private final int[] outputCanvasArraySize = new int[2];
    private int selectedCanvasSize;
    private int selectedImageScale = 1;
    private final byte[] selectedImageOffset = new byte[]{0, 0, 0};
    private Point theme;
    private Point save;
    private Point close;
    private Point x12;
    private Point x16;
    private Point x24;
    private Point x32;
    private Point sourceCanvas;
    private Point outputCanvas;
    private Point crop;
    private Point increase;
    private Point decrease;

    EmbroideryPage_Scale(GuiEmbroidery parent) {
        this.parent = parent;
        this.font = Minecraft.getInstance().font;
    }

    void init() {
        this.guiLeft = (this.parent.width - this.xSize) / 2;
        this.guiTop = (this.parent.height - this.ySize) / 2;
        this.theme = new Point(7 + this.guiLeft, 6 + this.guiTop);
        this.save = new Point(202 + this.guiLeft, 6 + this.guiTop);
        this.close = new Point(218 + this.guiLeft, 6 + this.guiTop);
        this.x12 = new Point(112 + this.guiLeft, 38 + this.guiTop);
        this.x16 = new Point(112 + this.guiLeft, 58 + this.guiTop);
        this.x24 = new Point(112 + this.guiLeft, 78 + this.guiTop);
        this.x32 = new Point(112 + this.guiLeft, 98 + this.guiTop);
        this.sourceCanvas = new Point(11 + this.guiLeft, 28 + this.guiTop);
        this.outputCanvas = new Point(133 + this.guiLeft, 28 + this.guiTop);
        this.decrease = new Point(140 + this.guiLeft, 129 + this.guiTop);
        this.increase = new Point(this.decrease.x + 32, this.decrease.y);
        this.crop = new Point(this.increase.x + 24, this.increase.y);
    }

    void setImage(String name, byte palette, byte[] indices, int canvasScale) {
        this.name = name;
        this.sourceCanvasScale = canvasScale;
        this.sourceCanvasPixel = 96.0 / (double)this.sourceCanvasScale;
        this.sourceCanvasArraySize[0] = this.sourceCanvasScale * this.sourceCanvasScale;
        this.sourceCanvasArraySize[1] = this.sourceCanvasArraySize[0] + this.sourceCanvasArraySize[0] / 8;
        this.sourcePalette = palette;
        if (indices == null) {
            this.sourceIndices = new byte[this.sourceCanvasArraySize[0]];
        } else {
            this.sourceIndices = indices;
            if (this.sourceIndices.length < this.sourceCanvasArraySize[0]) {
                this.sourceIndices = Arrays.copyOf(this.sourceIndices, this.sourceCanvasArraySize[0]);
            }
        }
        this.canvasSizeLock = false;
        this.changeCanvasSize(this.sourceCanvasScale);
    }

    void setImage(byte palette, byte[] indices, int scale, int canvasScale) {
        this.parent.scaleLayer = true;
        this.setImage(this.TEXT_IMPORT, palette, indices, scale);
        this.changeCanvasSize(canvasScale);
        this.canvasSizeLock = true;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        double y;
        double x;
        int col;
        int row;
        ResourceLocation guiTexture = Textures.EMBROIDERY_SCALE.get();
        String tooltip = "";
        GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.guiLeft, (double)this.guiTop, (int)0, (int)0, (int)this.xSize, (int)this.ySize, (ResourceLocation)guiTexture);
        if (this.isMouseOverArea(mouseX, mouseY, this.theme, 16.0)) {
            tooltip = this.TEXT_THEME;
        }
        if (this.isMouseOverArea(mouseX, mouseY, this.save, 16.0)) {
            tooltip = this.TEXT_SAVE;
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.save.x, (double)this.save.y, (int)208, (int)208, (int)16, (int)16, (ResourceLocation)guiTexture);
        } else {
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.save.x, (double)this.save.y, (int)224, (int)208, (int)16, (int)16, (ResourceLocation)guiTexture);
        }
        if (this.isMouseOverArea(mouseX, mouseY, this.close, 16.0)) {
            tooltip = this.TEXT_EXIT;
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.close.x, (double)this.close.y, (int)192, (int)208, (int)16, (int)16, (ResourceLocation)guiTexture);
        } else {
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.close.x, (double)this.close.y, (int)176, (int)208, (int)16, (int)16, (ResourceLocation)guiTexture);
        }
        for (row = 0; row < this.sourceCanvasScale; ++row) {
            for (col = 0; col < this.sourceCanvasScale; ++col) {
                x = (double)this.sourceCanvas.x + (double)col * this.sourceCanvasPixel;
                y = (double)this.sourceCanvas.y + (double)row * this.sourceCanvasPixel;
                GuiHelper.drawRect((GuiGraphics)graphics, (double)x, (double)y, (double)(x + this.sourceCanvasPixel), (double)(y + this.sourceCanvasPixel), (int)Embroidery.getColorAt(this.sourcePalette, this.sourceIndices, this.sourceCanvasScale * row + col));
            }
        }
        for (row = 0; row < this.outputCanvasScale; ++row) {
            for (col = 0; col < this.outputCanvasScale; ++col) {
                x = (double)this.outputCanvas.x + (double)col * this.outputCanvasPixel;
                y = (double)this.outputCanvas.y + (double)row * this.outputCanvasPixel;
                GuiHelper.drawRect((GuiGraphics)graphics, (double)x, (double)y, (double)(x + this.outputCanvasPixel), (double)(y + this.outputCanvasPixel), (int)Embroidery.getColorAt(this.sourcePalette, this.outputIndices, this.outputCanvasScale * row + col));
            }
        }
        if (this.isMouseOverArea(mouseX, mouseY, this.x12, 16.0)) {
            tooltip = this.TEXT_X12;
        }
        GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.x12.x, (double)this.x12.y, (int)(this.outputCanvasScale == 12 ? 0 : 16), (int)208, (int)16, (int)16, (ResourceLocation)guiTexture);
        GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.x12.x, (double)this.x12.y, (int)32, (int)208, (int)16, (int)16, (ResourceLocation)guiTexture);
        if (this.isMouseOverArea(mouseX, mouseY, this.x16, 16.0)) {
            tooltip = this.TEXT_X16;
        }
        GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.x16.x, (double)this.x16.y, (int)(this.outputCanvasScale == 16 ? 0 : 16), (int)208, (int)16, (int)16, (ResourceLocation)guiTexture);
        GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.x16.x, (double)this.x16.y, (int)32, (int)208, (int)16, (int)16, (ResourceLocation)guiTexture);
        if (this.isMouseOverArea(mouseX, mouseY, this.x24, 16.0)) {
            tooltip = this.TEXT_X24;
        }
        GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.x24.x, (double)this.x24.y, (int)(this.outputCanvasScale == 24 ? 0 : 16), (int)208, (int)16, (int)16, (ResourceLocation)guiTexture);
        GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.x24.x, (double)this.x24.y, (int)32, (int)208, (int)16, (int)16, (ResourceLocation)guiTexture);
        if (this.isMouseOverArea(mouseX, mouseY, this.x32, 16.0)) {
            tooltip = this.TEXT_X32;
        }
        GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.x32.x, (double)this.x32.y, (int)(this.outputCanvasScale == 32 ? 0 : 16), (int)208, (int)16, (int)16, (ResourceLocation)guiTexture);
        GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.x32.x, (double)this.x32.y, (int)32, (int)208, (int)16, (int)16, (ResourceLocation)guiTexture);
        if (this.outputCanvasScale < this.scaledCanvasScale) {
            if (this.isMouseOverArea(mouseX, mouseY, this.crop, 16.0)) {
                tooltip = this.TEXT_CROP;
            }
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.crop.x, (double)this.crop.y, (int)(240 - 16 * this.getNudge(mouseX, mouseY)), (int)240, (int)16, (int)16, (ResourceLocation)guiTexture);
        } else {
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.crop.x, (double)this.crop.y, (int)160, (int)240, (int)16, (int)16, (ResourceLocation)guiTexture);
        }
        if (this.selectedImageScale > 1) {
            if (this.isMouseOverArea(mouseX, mouseY, this.decrease, 16.0)) {
                tooltip = this.TEXT_DECREASE;
                GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.decrease.x, (double)this.decrease.y, (int)64, (int)240, (int)16, (int)16, (ResourceLocation)guiTexture);
            } else {
                GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.decrease.x, (double)this.decrease.y, (int)64, (int)224, (int)16, (int)16, (ResourceLocation)guiTexture);
            }
        } else {
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.decrease.x, (double)this.decrease.y, (int)64, (int)208, (int)16, (int)16, (ResourceLocation)guiTexture);
        }
        if (this.selectedImageScale < 4) {
            if (this.isMouseOverArea(mouseX, mouseY, this.increase, 16.0)) {
                tooltip = this.TEXT_INCREASE;
                GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.increase.x, (double)this.increase.y, (int)80, (int)240, (int)16, (int)16, (ResourceLocation)guiTexture);
            } else {
                GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.increase.x, (double)this.increase.y, (int)80, (int)224, (int)16, (int)16, (ResourceLocation)guiTexture);
            }
        } else {
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.increase.x, (double)this.increase.y, (int)80, (int)208, (int)16, (int)16, (ResourceLocation)guiTexture);
        }
        graphics.drawCenteredString(this.font, "12", this.x12.x + 8, this.x12.y + 4, 0xFFFFFF);
        graphics.drawCenteredString(this.font, "16", this.x16.x + 8, this.x16.y + 4, 0xFFFFFF);
        graphics.drawCenteredString(this.font, "24", this.x24.x + 8, this.x24.y + 4, 0xFFFFFF);
        graphics.drawCenteredString(this.font, "32", this.x32.x + 8, this.x32.y + 4, 0xFFFFFF);
        graphics.drawCenteredString(this.font, this.selectedImageScale + "x", this.decrease.x + 24, this.decrease.y + 4, 0xFFFFFF);
        graphics.drawCenteredString(this.font, this.sourceCanvasScale + "x" + this.sourceCanvasScale, this.sourceCanvas.x + 48, this.sourceCanvas.y + 100, 0xFFFFFF);
        graphics.drawCenteredString(this.font, this.name, this.sourceCanvas.x + 48, this.sourceCanvas.y + 110, 0xFFFFFF);
        if (!Strings.isNullOrEmpty((String)tooltip)) {
            if (!tooltip.equals(this.lastToolTip)) {
                this.lastToolTip = tooltip;
                this.countToolTip = 0;
            } else {
                ++this.countToolTip;
            }
            if (this.countToolTip >= 40) {
                this.countToolTip = 40;
                ArrayList lines = new ArrayList();
                StringUtil.multiLineTooltip((String)tooltip, lines);
                graphics.renderComponentTooltip(this.font, lines, this.guiLeft, this.guiTop + this.ySize + 10);
            }
        }
    }

    private boolean isMouseOverArea(double mouseX, double mouseY, Point point, double size) {
        return this.isMouseOverArea(mouseX, mouseY, point.x, point.y, size, size);
    }

    private boolean isMouseOverArea(double mouseX, double mouseY, double x, double y, double sizeX, double sizeY) {
        return mouseX >= x && mouseX < x + sizeX && mouseY >= y && mouseY < y + sizeY;
    }

    private int getNudge(double mouseX, double mouseY) {
        if (this.isMouseOverArea(mouseX, mouseY, this.crop, 16.0)) {
            double localX = mouseX - (double)this.crop.x;
            double localY = mouseY - (double)this.crop.y;
            if (localX >= Math.max(5.0, localY) && localX < Math.min(16.0 - localY, 11.0) && localY >= 0.0 && localY < 6.0) {
                return 1;
            }
            if (localX >= Math.max(5.0, 16.0 - localY) && localX < Math.min(localY, 11.0) && localY >= 10.0 && localY < 16.0) {
                return 2;
            }
            if (localX >= 10.0 && localX < 16.0 && localY >= Math.max(5.0, 16.0 - localX) && localY < Math.min(localX, 11.0)) {
                return 3;
            }
            if (localX >= 0.0 && localX < 6.0 && localY >= Math.max(5.0, localX) && localY < Math.min(16.0 - localX, 11.0)) {
                return 4;
            }
        }
        return 0;
    }

    boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.mouseClicked(this.close.x + 8, this.close.y + 8, 0);
        }
        if (keyCode == 257 || keyCode == 335) {
            this.mouseClicked(this.save.x + 8, this.save.y + 8, 0);
        }
        if (keyCode == 265) {
            this.mouseClicked(this.crop.x + 8, this.crop.y + 3, 0);
            return true;
        }
        if (keyCode == 264) {
            this.mouseClicked(this.crop.x + 8, this.crop.y + 13, 0);
            return true;
        }
        if (keyCode == 263) {
            this.mouseClicked(this.crop.x + 3, this.crop.y + 8, 0);
            return true;
        }
        if (keyCode == 262) {
            this.mouseClicked(this.crop.x + 13, this.crop.y + 8, 0);
            return true;
        }
        if (keyCode == 49 || keyCode == 321) {
            this.mouseClicked(this.x12.x + 8, this.x12.y + 8, 0);
            return true;
        }
        if (keyCode == 50 || keyCode == 322) {
            this.mouseClicked(this.x16.x + 8, this.x16.y + 8, 0);
            return true;
        }
        if (keyCode == 51 || keyCode == 323) {
            this.mouseClicked(this.x24.x + 8, this.x24.y + 8, 0);
            return true;
        }
        if (keyCode == 52 || keyCode == 324) {
            this.mouseClicked(this.x32.x + 8, this.x32.y + 8, 0);
            return true;
        }
        if (keyCode == 61 || keyCode == 334) {
            this.mouseClicked(this.increase.x + 8, this.increase.y + 8, 0);
            return true;
        }
        if (keyCode == 45 || keyCode == 333) {
            this.mouseClicked(this.decrease.x + 8, this.decrease.y + 8, 0);
            return true;
        }
        return false;
    }

    boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.isMouseOverArea(mouseX, mouseY, this.theme, 16.0)) {
                Configs.GUI_STYLE.mc_painter.update((Object)(Configs.GUI_STYLE.mc_painter.get() == Configs.Menu_GUI.STYLE.DEFAULT ? Configs.Menu_GUI.STYLE.VANILLA : Configs.Menu_GUI.STYLE.DEFAULT));
            }
            if (this.isMouseOverArea(mouseX, mouseY, this.close, 16.0)) {
                if (this.parent.scaleLayer) {
                    this.parent.scaleLayer = false;
                } else {
                    this.parent.activePage = GuiEmbroidery.ActivePage.SELECT;
                }
                return true;
            }
            if (this.isMouseOverArea(mouseX, mouseY, this.save, 16.0)) {
                if (this.parent.scaleLayer) {
                    this.parent.pageDraw.setFloatingImage(this.outputIndices);
                    this.parent.scaleLayer = false;
                } else {
                    this.parent.pageDraw.setImage(this.name, this.sourcePalette, this.outputIndices, this.outputCanvasScale);
                    this.parent.activePage = GuiEmbroidery.ActivePage.DRAW;
                }
                return true;
            }
            if (this.outputCanvasScale < this.scaledCanvasScale && this.isMouseOverArea(mouseX, mouseY, this.crop, 16.0)) {
                int nudge = this.getNudge(mouseX, mouseY);
                if (nudge >= 1 && nudge <= 4) {
                    switch (nudge) {
                        case 1: {
                            this.selectedImageOffset[1] = (byte)Math.max(0, this.selectedImageOffset[1] - 1);
                            break;
                        }
                        case 2: {
                            this.selectedImageOffset[1] = (byte)Math.min(this.selectedImageOffset[0], this.selectedImageOffset[1] + 1);
                            break;
                        }
                        case 3: {
                            this.selectedImageOffset[2] = (byte)Math.max(0, this.selectedImageOffset[2] - 1);
                            break;
                        }
                        case 4: {
                            this.selectedImageOffset[2] = (byte)Math.min(this.selectedImageOffset[0], this.selectedImageOffset[2] + 1);
                        }
                    }
                    this.updateOutput();
                }
                return true;
            }
            if (this.isMouseOverArea(mouseX, mouseY, this.x12, 16.0)) {
                this.changeCanvasSize(12);
                return true;
            }
            if (this.isMouseOverArea(mouseX, mouseY, this.x16, 16.0)) {
                this.changeCanvasSize(16);
                return true;
            }
            if (this.isMouseOverArea(mouseX, mouseY, this.x24, 16.0)) {
                this.changeCanvasSize(24);
                return true;
            }
            if (this.isMouseOverArea(mouseX, mouseY, this.x32, 16.0)) {
                this.changeCanvasSize(32);
                return true;
            }
            if (this.selectedImageScale < 4 && this.isMouseOverArea(mouseX, mouseY, this.increase, 16.0)) {
                int value = Math.min(4, this.selectedImageScale + 1);
                if (this.selectedImageScale != value) {
                    this.selectedImageScale = value;
                    this.updateScaledSource();
                }
                return true;
            }
            if (this.selectedImageScale > 1 && this.isMouseOverArea(mouseX, mouseY, this.decrease, 16.0)) {
                int value = Math.max(1, this.selectedImageScale - 1);
                if (this.selectedImageScale != value) {
                    this.selectedImageScale = value;
                    this.updateScaledSource();
                }
                return true;
            }
        }
        return false;
    }

    private void changeCanvasSize(int canvasSize) {
        if (this.canvasSizeLock) {
            return;
        }
        this.selectedCanvasSize = canvasSize;
        this.selectedImageScale = 1;
        this.updateScaledSource();
    }

    private void updateScaledSource() {
        this.scaledCanvasScale = Math.max(this.selectedCanvasSize, this.sourceCanvasScale * this.selectedImageScale);
        this.scaledCanvasScale = this.scaledCanvasScale == 0 ? this.sourceCanvasScale : this.scaledCanvasScale;
        this.scaledCanvasArraySize[0] = this.scaledCanvasScale * this.scaledCanvasScale;
        this.scaledCanvasArraySize[1] = this.scaledCanvasArraySize[0] + this.scaledCanvasArraySize[0] / 8;
        if (this.scaledCanvasScale == this.sourceCanvasScale) {
            this.scaledIndices = (byte[])this.sourceIndices.clone();
        } else {
            this.scaledIndices = new byte[this.scaledCanvasArraySize[this.scaledIndices.length == this.scaledCanvasArraySize[1] ? 1 : 0]];
            for (int row = 0; row < this.sourceCanvasScale; ++row) {
                for (int col = 0; col < this.sourceCanvasScale; ++col) {
                    int sourcePixel = this.sourceCanvasScale * row + col;
                    for (int rPointer = 1; rPointer <= this.selectedImageScale; ++rPointer) {
                        for (int cPointer = 1; cPointer <= this.selectedImageScale; ++cPointer) {
                            int scaledPixel;
                            int oRow = row * this.selectedImageScale + (rPointer - 1);
                            int oCol = col * this.selectedImageScale + (cPointer - 1);
                            boolean valid = oRow >= 0 && oCol >= 0 && oRow < this.scaledCanvasScale && oCol < this.scaledCanvasScale;
                            int n = scaledPixel = valid ? this.scaledCanvasScale * oRow + oCol : -1;
                            if (scaledPixel < 0 || scaledPixel >= this.scaledCanvasArraySize[0]) continue;
                            this.scaledIndices[scaledPixel] = this.sourceIndices[sourcePixel];
                            this.setAlphaFlag(this.scaledCanvasArraySize[0], scaledPixel, this.getAlphaFlag(this.sourceCanvasArraySize[0], this.sourceIndices, sourcePixel));
                        }
                    }
                }
            }
        }
        int difference = Math.max(this.selectedCanvasSize, this.scaledCanvasScale) - Math.min(this.selectedCanvasSize, this.scaledCanvasScale);
        this.selectedImageOffset[0] = (byte)difference;
        this.selectedImageOffset[1] = this.selectedImageOffset[2] = (byte)(difference / 2);
        this.updateOutput();
    }

    private void updateOutput() {
        this.outputCanvasScale = this.selectedCanvasSize;
        this.outputCanvasScale = this.outputCanvasScale == 0 ? this.scaledCanvasScale : this.outputCanvasScale;
        this.outputCanvasPixel = 96.0 / (double)this.outputCanvasScale;
        this.outputCanvasArraySize[0] = this.outputCanvasScale * this.outputCanvasScale;
        this.outputCanvasArraySize[1] = this.outputCanvasArraySize[0] + this.outputCanvasArraySize[0] / 8;
        if (this.outputCanvasScale == this.scaledCanvasScale) {
            this.outputIndices = (byte[])this.scaledIndices.clone();
            return;
        }
        this.outputIndices = new byte[this.outputCanvasArraySize[this.scaledIndices.length == this.scaledCanvasArraySize[1] ? 1 : 0]];
        boolean shouldCrop = this.outputCanvasScale < this.scaledCanvasScale;
        for (int row = 0; row < this.scaledCanvasScale; ++row) {
            for (int col = 0; col < this.scaledCanvasScale; ++col) {
                int outputPixel;
                int scaledPixel = this.scaledCanvasScale * row + col;
                int oRow = row + (shouldCrop ? -this.selectedImageOffset[1] : 0);
                int oCol = col + (shouldCrop ? -this.selectedImageOffset[2] : 0);
                boolean valid = oRow >= 0 && oCol >= 0 && oRow < this.outputCanvasScale && oCol < this.outputCanvasScale;
                int n = outputPixel = valid ? this.outputCanvasScale * oRow + oCol : -1;
                if (outputPixel < 0 || outputPixel >= this.outputCanvasArraySize[0]) continue;
                this.outputIndices[outputPixel] = this.scaledIndices[scaledPixel];
                this.setAlphaFlag(this.outputCanvasArraySize[0], outputPixel, this.getAlphaFlag(this.scaledCanvasArraySize[0], this.scaledIndices, scaledPixel));
            }
        }
    }

    private boolean getAlphaFlag(int canvasArraySize, byte[] array, int pixel) {
        int alphaIndex = canvasArraySize + pixel / 8;
        if (array.length > alphaIndex) {
            byte alphaByte = array[alphaIndex];
            int bitShift = 7 - pixel % 8;
            return (alphaByte >> bitShift & 1) == 1;
        }
        return false;
    }

    private void setAlphaFlag(int canvasArraySize, int canvasPixel, boolean enable) {
        int alphaIndex = canvasArraySize + canvasPixel / 8;
        if (this.outputIndices.length > alphaIndex) {
            byte alphaByte = this.outputIndices[alphaIndex];
            int bitShift = 7 - canvasPixel % 8;
            alphaByte = !enable ? (byte)(alphaByte & ~(1 << bitShift)) : (byte)(alphaByte | 1 << bitShift);
            this.outputIndices[alphaIndex] = alphaByte;
        }
    }
}

