/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client.gui;

import com.google.common.base.Strings;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Point;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;
import shetiphian.core.client.gui.BasicUiElement;
import shetiphian.core.client.gui.GuiHelper;
import shetiphian.core.common.StringUtil;
import shetiphian.multibeds.Configs;
import shetiphian.multibeds.client.gui.GuiEmbroidery;
import shetiphian.multibeds.client.gui.Textures;
import shetiphian.multibeds.client.gui.UiElement;
import shetiphian.multibeds.client.misc.EmbroideryData;
import shetiphian.multibeds.client.misc.WIPProject;
import shetiphian.multibeds.common.misc.Embroidery;
import shetiphian.multibeds.common.misc.Palettes;

public class EmbroideryPage_Draw {
    private final String TEXT_NO_SAVE_UNNAMED = I18n.get((String)"gui.multibeds.embroidery.draw.save.blocked.unnamed", (Object[])new Object[0]);
    private final String TEXT_NO_SAVE_DUPLICATE = I18n.get((String)"gui.multibeds.embroidery.draw.save.blocked.duplicate", (Object[])new Object[0]);
    private final String TEXT_ERROR_UNNAMED = I18n.get((String)"gui.multibeds.embroidery.draw.name_error.unnamed", (Object[])new Object[0]);
    private final String TEXT_ERROR_DUPLICATE = I18n.get((String)"gui.multibeds.embroidery.draw.name_error.duplicate", (Object[])new Object[0]);
    private final String TEXT_NO_EXIT = I18n.get((String)"gui.multibeds.embroidery.draw.exit.blocked", (Object[])new Object[0]);
    private final String TEXT_NUDGE = I18n.get((String)"gui.multibeds.embroidery.draw.nudge", (Object[])new Object[0]);
    private final String TEXT_NO_COPY_FLOATING = I18n.get((String)"gui.multibeds.embroidery.draw.layer.copy.error", (Object[])new Object[0]);
    private final String TEXT_NO_MERGE_FLOATING = I18n.get((String)"gui.multibeds.embroidery.draw.layer.merge.error.floating", (Object[])new Object[0]);
    private final String TEXT_NO_MERGE_BOTTOM = I18n.get((String)"gui.multibeds.embroidery.draw.layer.merge.error.bottom", (Object[])new Object[0]);
    private final String TEXT_NO_MERGE_VISIBILITY = I18n.get((String)"gui.multibeds.embroidery.draw.layer.merge.error.hidden", (Object[])new Object[0]);
    private final String TEXT_NO_ANCHOR_VISIBILITY = I18n.get((String)"gui.multibeds.embroidery.draw.layer.float.anchor.error", (Object[])new Object[0]);
    private final String TEXT_TAG_IMPORT = I18n.get((String)"gui.multibeds.embroidery.draw.layer.float.import", (Object[])new Object[0]);
    private final String TEXT_TAG_IMPORT_ERROR = I18n.get((String)"gui.multibeds.embroidery.draw.layer.float.import.error", (Object[])new Object[0]);
    private final Random random = new Random();
    @NotNull
    private final GuiEmbroidery parent;
    private final int xSize = 241;
    private final int ySize = 185;
    private int guiLeft;
    private int guiTop;
    private final int layerCount = 6;
    private byte activeLayer = 0;
    private boolean floatingLayer;
    private boolean[] visibleLayers = new boolean[this.layerCount];
    private byte[][] canvasIndices = new byte[this.layerCount][0];
    private final byte[] activeIndex = new byte[2];
    private boolean needsSaving = false;
    private boolean hadChanges = false;
    private boolean isProject = false;
    private boolean drawInAlpha = false;
    private final boolean[] isMouseDown = new boolean[2];
    private DrawMode drawMode = DrawMode.SINGLE;
    private ToolMode toolMode = ToolMode.DRAW;
    private final ArrayDeque<SnapShot> undoLevels = new ArrayDeque();
    private final ArrayDeque<SnapShot> redoLevels = new ArrayDeque();
    private EditBox name;
    private String lastToolTip;
    private int countToolTip;
    private int canvasScale;
    private double canvasPixel;
    private double layerPixel;
    private int previousPixel = -1;
    private final int[] canvasArraySize = new int[2];
    private final int palettePixel = 4;
    private byte activePalette = 0;
    private final List<BasicUiElement> elements = new ArrayList<BasicUiElement>();
    private final UiElement.Invisible colors;
    private Point canvas;
    private Point palette;
    private Point nudge;
    private Point nameWarning;
    private final int[] layerPos = new int[]{214, 147, 127, 107, 87, 67, 46};
    private final int[] toolTracker = new int[]{-1, 0, 0, 8, 8, 8, 8, 0};
    private int invalidTag;
    private static final int[] PATTERNS = new int[]{10704488, 2920970, 6863490, 4830792, 8868196, 8441928, 4797098, 8706338, 6609252};
    private static final int[] PATTERNS2 = new int[]{1216958725, 610542884, -2129491880, 303044242};

    EmbroideryPage_Draw(@NotNull GuiEmbroidery parent) {
        this.parent = parent;
        this.activeIndex[0] = -24;
        this.activeIndex[1] = -4;
        this.elements.add(new UiElement.Invisible(7, 6, 16, 16, "theme", () -> Configs.GUI_STYLE.mc_painter.update((Object)(Configs.GUI_STYLE.mc_painter.get() == Configs.Menu_GUI.STYLE.DEFAULT ? Configs.Menu_GUI.STYLE.VANILLA : Configs.Menu_GUI.STYLE.DEFAULT))));
        this.elements.add(new UiElement.Basic(171, 6, 16, 16, 144, 224, 144, 240, 1.0f, "undo", this::preformUndo));
        this.elements.add(new UiElement.Basic(187, 6, 16, 16, 160, 224, 160, 240, 1.0f, "redo", this::preformRedo));
        this.elements.add(new UiElement.State(203, 6, 16, 16, (int[][])new int[][]{{240, 224}, {208, 224}, {224, 224}}, 1.0f, "save", hover -> hover ? 2 : (this.needsSaving ? 1 : 0), this::save));
        this.elements.add(new UiElement.Basic(219, 6, 16, 16, 176, 224, 192, 224, 1.0f, "exit", this::exit));
        this.elements.add(new UiElement.State(44, 28, 16, 16, (int[][])new int[][]{{48, 224}, {48, 240}, {64, 240}, {64, 224}}, 1.0f, "place", hover -> this.drawMode.ordinal(), (mX, mY, mB) -> this.changeDrawMode(mB == 0)));
        this.elements.add(new UiElement.Basic(10, 55, 16, 16, 112, 224, 112, 240, 0.5f, "rotate.cw", this::rotateCW));
        this.elements.add(new UiElement.Basic(18, 55, 16, 16, 128, 224, 128, 240, 0.5f, "rotate.ccw", this::rotateCCW));
        this.elements.add(new UiElement.Basic(26, 55, 16, 16, 80, 224, 80, 240, 0.5f, "flip.v", this::flipV));
        this.elements.add(new UiElement.Basic(34, 55, 16, 16, 96, 224, 96, 240, 0.5f, "flip.h", this::flipH));
        this.elements.add(new UiElement.State(50, 68, 8, 8, (int[][])new int[][]{{216, 216}, {216, 208}}, 1.0f, "alpha_toggle", hovered -> this.drawInAlpha ? 1 : 0, () -> {
            this.drawInAlpha = !this.drawInAlpha;
        }));
        this.colors = new UiElement.Invisible(37, 71, 16, 16, "colors", (mx, my, mb) -> {
            if (mb == 0) {
                this.swapDrawColors();
            } else {
                this.setToDefaultColors(this.activePalette);
            }
        });
        this.elements.add(this.colors);
        this.elements.add(new UiElement.Tool(this, 10, 28, "pencil", ToolMode.DRAW));
        this.elements.add(new UiElement.Tool(this, 18, 28, "eraser", ToolMode.ERASE));
        this.elements.add(new UiElement.Tool(this, 10, 36, "dropper", ToolMode.PICK));
        this.elements.add(new UiElement.Tool(this, 18, 36, "replace", ToolMode.SWAP));
        this.elements.add(new UiElement.Tool(this, 26, 28, "brush", ToolMode.BRUSH));
        this.elements.add(new UiElement.Tool(this, 34, 28, "spray", ToolMode.SPRAY));
        this.elements.add(new UiElement.Tool(this, 26, 36, "bucket", ToolMode.BUCKET));
        this.elements.add(new UiElement.Tool(this, 34, 36, "scramble", ToolMode.SCRAMBLE));
        this.elements.add(new UiElement.Tool(this, 26, 44, "bomb", ToolMode.BOMB));
        this.elements.add(new UiElement.Tool(this, 18, 44, "clone", ToolMode.CLONE));
        this.elements.add(new UiElement.Invisible(this.layerPos[0], this.layerPos[6], 16, 16, "layer.float", this::importShareTag));
        this.elements.add(new UiElement.State(this.layerPos[0] - 10, this.layerPos[6], 8, 8, (int[][])new int[][]{{192, 208}, {192, 216}}, 1.0f, "layer.float.anchor", hovered -> this.floatingLayer ? (hovered ? 1 : 0) : -1, this::anchorFloating));
        this.elements.add(new UiElement.State(this.layerPos[0] - 10, this.layerPos[6] + 8, 8, 8, (int[][])new int[][]{{200, 208}, {200, 216}}, 1.0f, "layer.float.clear", hovered -> this.floatingLayer ? (hovered ? 1 : 0) : -1, () -> this.clearFloating(true)));
        for (int layer = 0; layer < this.layerCount - 1; ++layer) {
            int x = this.layerPos[0];
            int y = this.layerPos[layer + 1];
            byte finalLayer = (byte)layer;
            this.elements.add(new UiElement.Invisible(x, y, 16, 16, "layer.select." + layer, () -> {
                this.activeLayer = finalLayer;
            }));
            this.elements.add(new UiElement.State(x - 10, y + 5, 8, 6, (int[][])new int[][]{{176, 193}, {176, 201}, {184, 193}, {184, 201}}, 1.0f, "layer.visible", hovered -> (hovered ? 1 : 0) + (this.visibleLayers[finalLayer] ? 0 : 2), () -> {
                this.visibleLayers[finalLayer] = !this.visibleLayers[finalLayer];
            }));
            if (layer < this.layerCount - 2) {
                this.elements.add(new UiElement.State(x - 10, y - 1, 8, 6, (int[][])new int[][]{{168, 193}, {168, 201}}, 1.0f, "layer.up", hovered -> this.activeLayer == finalLayer ? (hovered ? 1 : 0) : -1, this::moveLayerUp));
            }
            if (layer <= 0) continue;
            this.elements.add(new UiElement.State(x - 10, y + 11, 8, 6, (int[][])new int[][]{{160, 193}, {160, 201}}, 1.0f, "layer.down", hovered -> this.activeLayer == finalLayer ? (hovered ? 1 : 0) : -1, this::moveLayerDown));
        }
        this.elements.add(new UiElement.Basic(214, 168, 8, 8, 176, 208, 176, 216, 1.0f, "layer.merge", this::mergeLayers));
        this.elements.add(new UiElement.Basic(224, 168, 8, 8, 184, 208, 184, 216, 1.0f, "layer.copy", this::copyLayer));
        int rowMax = Math.min(3, (Palettes.PALETTE_COUNT - 1) / 4);
        for (int row = 0; row <= rowMax; ++row) {
            int colMax = Math.min(3, Palettes.PALETTE_COUNT - 1 - row * 4);
            for (int col = 0; col <= colMax; ++col) {
                byte index = (byte)(row * 4 + col);
                this.elements.add(new UiElement.Palette(this, 12 + 5 * col, 83 - 5 * row, index));
            }
        }
    }

    void init() {
        this.guiLeft = (this.parent.width - this.xSize) / 2;
        this.guiTop = (this.parent.height - this.ySize) / 2;
        this.elements.forEach(uiElement -> uiElement.setScreenOffset(this.guiLeft, this.guiTop));
        this.name = new EditBox(this.parent.getMinecraft().font, 68 + this.guiLeft, 28 + this.guiTop, 128, 12, (Component)Component.literal((String)"unnamed"));
        this.name.setMaxLength(20);
        this.name.setVisible(true);
        this.name.setTextColor(0xFFFFFF);
        this.name.setValue("unnamed");
        this.canvas = new Point(68 + this.guiLeft, 46 + this.guiTop);
        this.palette = new Point(11 + this.guiLeft, 90 + this.guiTop);
        this.nudge = new Point(44 + this.guiLeft, 47 + this.guiTop);
        this.nameWarning = new Point(this.name.getX() + 60, this.name.getY() - 9);
    }

    void setImage(String name, byte palette, byte[] indices, int canvasScale) {
        this.name.setValue(name);
        this.canvasScale = canvasScale;
        this.canvasPixel = 128.0 / (double)this.canvasScale;
        this.canvasArraySize[0] = this.canvasScale * this.canvasScale;
        this.canvasArraySize[1] = this.canvasArraySize[0] + this.canvasArraySize[0] / 8;
        this.layerPixel = 16.0 / (double)this.canvasScale;
        Arrays.fill(this.visibleLayers, true);
        this.activePalette = palette;
        if (palette > 0) {
            this.setToDefaultColors(palette);
        }
        if (indices == null) {
            this.canvasIndices[0] = new byte[this.canvasArraySize[1]];
            this.toolMode = ToolMode.DRAW;
        } else {
            this.canvasIndices[0] = this.clampIndices(indices);
            this.toolMode = ToolMode.PICK;
        }
        this.floatingLayer = false;
        for (int layer = 1; layer < this.layerCount; ++layer) {
            this.canvasIndices[layer] = new byte[this.canvasIndices[0].length];
        }
        this.activeLayer = 0;
        this.drawInAlpha = false;
        this.undoLevels.clear();
        this.redoLevels.clear();
        this.needsSaving = false;
        this.isProject = false;
    }

    void loadProject(String name, WIPProject project) {
        this.setImage(name, project.getPalette(), project.getLayer(0), project.getCanvasScale());
        this.visibleLayers[0] = project.isVisible(0);
        int count = this.floatingLayer ? this.layerCount : this.layerCount - 1;
        for (int index = 1; index < count; ++index) {
            this.canvasIndices[index] = this.clampIndices(project.getLayer(index));
            this.visibleLayers[index] = project.isVisible(index);
        }
        for (int pixel = 0; pixel < this.canvasArraySize[0]; ++pixel) {
            if (this.canvasIndices[this.layerCount - 1][pixel] == 0) continue;
            this.floatingLayer = true;
            break;
        }
        this.isProject = true;
    }

    void setFloatingImage(byte[] indices) {
        this.floatingLayer = true;
        this.canvasIndices[this.layerCount - 1] = this.clampIndices(indices);
    }

    private byte[] clampIndices(byte[] indices) {
        return indices.length == this.canvasArraySize[1] ? indices : Arrays.copyOf(indices, this.canvasArraySize[1]);
    }

    private void setToDefaultColors(int palette) {
        if ((palette = Palettes.getPaletteUiIndex(palette < 0 ? ~palette : palette)) == 0) {
            this.activeIndex[0] = -24;
            this.activeIndex[1] = -4;
        } else if (palette == 15) {
            this.activeIndex[0] = 24;
            this.activeIndex[1] = 106;
        } else {
            this.activeIndex[0] = 21;
            this.activeIndex[1] = -4;
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ResourceLocation guiTexture = Textures.EMBROIDERY_DRAW.get();
        String tooltip = "";
        GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.guiLeft, (double)this.guiTop, (int)0, (int)0, (int)this.xSize, (int)this.ySize, (ResourceLocation)guiTexture);
        if (this.parent.scaleLayer) {
            return;
        }
        GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.guiLeft + this.layerPos[0] - 12), (double)(this.guiTop + this.layerPos[this.activeLayer + 1] - 2), (int)224, (int)204, (int)32, (int)20, (ResourceLocation)guiTexture);
        for (int row = 0; row < this.canvasScale; ++row) {
            for (int col = 0; col < this.canvasScale; ++col) {
                double x = (double)this.canvas.x + (double)col * this.canvasPixel;
                double y = (double)this.canvas.y + (double)row * this.canvasPixel;
                double lx = (double)(this.guiLeft + this.layerPos[0]) + (double)col * this.layerPixel;
                double ly = (double)this.guiTop + (double)row * this.layerPixel;
                int index = this.canvasScale * row + col;
                byte canvasLayer = -1;
                for (byte layer = this.layerCount - 1; layer >= 0; --layer) {
                    if (canvasLayer < 0 && layer < this.layerCount - 1 && this.visibleLayers[layer]) {
                        byte pixelLayer = layer;
                        if (layer == this.activeLayer && this.floatingLayer && (Screen.hasAltDown() || this.canvasIndices[this.layerCount - 1][index] != 0)) {
                            pixelLayer = this.layerCount - 1;
                        }
                        if (this.canvasIndices[pixelLayer][index] != 0) {
                            canvasLayer = pixelLayer;
                        }
                    }
                    double yos = ly + (double)this.layerPos[layer + 1];
                    GuiHelper.drawRect((GuiGraphics)graphics, (double)lx, (double)yos, (double)(lx + this.layerPixel), (double)(yos + this.layerPixel), (int)Embroidery.getColorAt(this.activePalette, this.canvasIndices[layer], index));
                }
                if (canvasLayer <= -1) continue;
                GuiHelper.drawRect((GuiGraphics)graphics, (double)x, (double)y, (double)(x + this.canvasPixel), (double)(y + this.canvasPixel), (int)Embroidery.getColorAt(this.activePalette, this.canvasIndices[canvasLayer], index));
            }
        }
        long windowId = this.parent.getMinecraft().getWindow().getWindow();
        int pixel = this.getPixelUnderMouse(mouseX, mouseY);
        if (pixel > -1) {
            boolean line;
            if (GLFW.glfwGetInputMode((long)windowId, (int)208897) != 212994) {
                GLFW.glfwSetInputMode((long)windowId, (int)208897, (int)212994);
            }
            RenderSystem.enableBlend();
            double scale = this.canvasPixel / 32.0;
            int col = pixel % this.canvasScale;
            int row = pixel / this.canvasScale;
            double x = (double)this.canvas.x + (double)col * this.canvasPixel;
            double y = (double)this.canvas.y + (double)row * this.canvasPixel;
            GuiHelper.drawTextureScaled((GuiGraphics)graphics, (double)x, (double)y, (int)0, (int)224, (int)32, (int)32, (double)scale, (ResourceLocation)guiTexture);
            if (this.drawMode != DrawMode.SINGLE && this.toolMode.canMultiDraw()) {
                int ocol = this.canvasScale - 1 - col;
                int orow = this.canvasScale - 1 - row;
                double ox = (double)this.canvas.x + (double)ocol * this.canvasPixel;
                double oy = (double)this.canvas.y + (double)orow * this.canvasPixel;
                if (this.drawMode != DrawMode.V_MIRROR) {
                    GuiHelper.drawTextureScaled((GuiGraphics)graphics, (double)x, (double)oy, (int)0, (int)224, (int)32, (int)32, (double)scale, (ResourceLocation)guiTexture);
                }
                if (this.drawMode != DrawMode.H_MIRROR) {
                    GuiHelper.drawTextureScaled((GuiGraphics)graphics, (double)ox, (double)y, (int)0, (int)224, (int)32, (int)32, (double)scale, (ResourceLocation)guiTexture);
                }
                if (this.drawMode == DrawMode.QUADRANT) {
                    GuiHelper.drawTextureScaled((GuiGraphics)graphics, (double)ox, (double)oy, (int)0, (int)224, (int)32, (int)32, (double)scale, (ResourceLocation)guiTexture);
                }
            }
            boolean bl = line = (this.toolMode == ToolMode.DRAW || this.toolMode == ToolMode.BRUSH) && Screen.hasShiftDown();
            if (line || this.toolMode == ToolMode.CLONE) {
                boolean dual = line && !Screen.hasAltDown() && (this.toolTracker[1] != this.toolTracker[3] || this.toolTracker[2] != this.toolTracker[4]);
                double scale2 = this.canvasPixel / 12.0 / 2.0;
                float half = (float)(this.canvasPixel / 2.0);
                int[] color = new int[]{Palettes.getColorFor(this.activePalette, this.activeIndex[0] & 0xFF, false), Palettes.getColorFor(this.activePalette, this.activeIndex[1] & 0xFF, false)};
                for (int pass = 0; pass < (dual ? 2 : 1); ++pass) {
                    double y2;
                    double x2;
                    int pointer;
                    int n = pass == 1 ? 3 : (pointer = dual ? 1 : 5);
                    if (this.toolTracker[pointer] < 0 || this.toolTracker[pointer + 1] < 0 || this.toolTracker[pointer] >= this.canvasScale || this.toolTracker[pointer + 1] >= this.canvasScale) continue;
                    if (line) {
                        x2 = (double)this.canvas.x + (double)this.toolTracker[pointer + 1] * this.canvasPixel;
                        y2 = (double)this.canvas.y + (double)this.toolTracker[pointer] * this.canvasPixel;
                        GuiHelper.drawLine((GuiGraphics)graphics, (double)(x + (double)half), (double)(y + (double)half), (double)(x2 + (double)half), (double)(y2 + (double)half), (float)0.8f, (int)color[dual ? pass : 0], (int)color[dual ? pass : 1]);
                    }
                    x2 = (double)this.canvas.x + (double)this.toolTracker[pointer + 1] * this.canvasPixel + 8.0 * scale2;
                    y2 = (double)this.canvas.y + (double)this.toolTracker[pointer] * this.canvasPixel + 8.0 * scale2;
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc((int)775, (int)0);
                    GuiHelper.drawTextureScaled((GuiGraphics)graphics, (double)x2, (double)y2, (int)32, (int)240, (int)16, (int)16, (double)scale2, (ResourceLocation)guiTexture);
                    RenderSystem.blendFunc((int)770, (int)771);
                }
            }
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)775, (int)0);
            GuiHelper.drawTextureScaled((GuiGraphics)graphics, (double)mouseX, (double)mouseY, (int)32, (int)224, (int)16, (int)16, (double)0.5, (ResourceLocation)guiTexture);
            RenderSystem.blendFunc((int)770, (int)771);
            if (this.toolTracker[0] != ToolMode.BOMB.ordinal()) {
                if (this.toolMode.ctrlIsDropper && Screen.hasControlDown()) {
                    GuiHelper.drawTextureScaled((GuiGraphics)graphics, (double)(mouseX + 1), (double)(mouseY + 1), (int)ToolMode.PICK.u, (int)ToolMode.PICK.v, (int)16, (int)16, (double)0.5, (ResourceLocation)guiTexture);
                } else {
                    GuiHelper.drawTextureScaled((GuiGraphics)graphics, (double)(mouseX + 1), (double)(mouseY + 1), (int)this.toolMode.u, (int)this.toolMode.v, (int)16, (int)16, (double)0.5, (ResourceLocation)guiTexture);
                }
            }
        } else if (GLFW.glfwGetInputMode((long)windowId, (int)208897) != 212993) {
            GLFW.glfwSetInputMode((long)windowId, (int)208897, (int)212993);
        }
        if (this.toolTracker[0] == ToolMode.BOMB.ordinal()) {
            if (this.toolTracker[7] > 0 && this.toolTracker[7] < 11) {
                double x = (double)this.canvas.x + (double)this.toolTracker[6] * this.canvasPixel;
                double y = (double)this.canvas.y + (double)this.toolTracker[5] * this.canvasPixel;
                int aU = 80 + 16 * (5 - this.toolTracker[7] / 2);
                GuiHelper.drawTextureScaled((GuiGraphics)graphics, (double)x, (double)y, (int)aU, (int)this.toolMode.v, (int)16, (int)16, (double)0.5, (ResourceLocation)guiTexture);
            }
            this.toolTracker[7] = this.toolTracker[7] - 1;
            if (this.toolTracker[7] < -4) {
                this.toolTracker[0] = -1;
            }
        }
        for (int row = 0; row < 21; ++row) {
            for (int col = 0; col < 12; ++col) {
                int x = this.palette.x + col * this.palettePixel;
                int y = this.palette.y + row * this.palettePixel;
                GuiHelper.drawRect((GuiGraphics)graphics, (double)x, (double)y, (double)(x + this.palettePixel), (double)(y + this.palettePixel), (int)Palettes.getColorFor(this.activePalette, 1 + row + 21 * (11 - col), false));
            }
        }
        for (int index = 1; index >= 0; --index) {
            int col = 11 - ((this.activeIndex[index] & 0xFF) - 1) / 21;
            int row = ((this.activeIndex[index] & 0xFF) - 1) % 21;
            int pixX = this.palette.x + col * this.palettePixel;
            int pixY = this.palette.y + row * this.palettePixel;
            int x = Math.max(this.palette.x, pixX - 1);
            int y = Math.max(this.palette.y, pixY - 1);
            int x2 = Math.min(this.palette.x + 12 * this.palettePixel, pixX + this.palettePixel + 1);
            int y2 = Math.min(this.palette.y + 21 * this.palettePixel, pixY + this.palettePixel + 1);
            GuiHelper.drawRect((GuiGraphics)graphics, (double)x, (double)y, (double)x2, (double)y2, (int)Palettes.getColorFor(this.activePalette, this.activeIndex[index] & 0xFF, false));
            GuiHelper.drawRect((GuiGraphics)graphics, (double)x, (double)((double)y2 - 0.5), (double)x2, (double)y2, (int)Integer.MIN_VALUE);
            GuiHelper.drawRect((GuiGraphics)graphics, (double)((double)x2 - 0.5), (double)y, (double)x2, (double)y2, (int)Integer.MIN_VALUE);
            GuiHelper.drawRect((GuiGraphics)graphics, (double)x, (double)y, (double)x2, (double)((double)y + 0.5), (int)-2130706433);
            GuiHelper.drawRect((GuiGraphics)graphics, (double)x, (double)y, (double)((double)x + 0.5), (double)y2, (int)-2130706433);
        }
        int cX = this.colors.getX();
        int cY = this.colors.getY();
        GuiHelper.drawRect((GuiGraphics)graphics, (double)(cX + 1), (double)(cY + 1), (double)(cX + 11), (double)(cY + 9), (int)Palettes.getColorFor(this.activePalette, this.activeIndex[0] & 0xFF, this.drawInAlpha));
        GuiHelper.drawRect((GuiGraphics)graphics, (double)(cX + 12), (double)(cY + 7), (double)(cX + 15), (double)(cY + 10), (int)Palettes.getColorFor(this.activePalette, this.activeIndex[1] & 0xFF, this.drawInAlpha));
        GuiHelper.drawRect((GuiGraphics)graphics, (double)(cX + 5), (double)(cY + 10), (double)(cX + 15), (double)(cY + 15), (int)Palettes.getColorFor(this.activePalette, this.activeIndex[1] & 0xFF, this.drawInAlpha));
        if (this.isMouseOverArea(mouseX, mouseY, this.nudge, 24.0)) {
            tooltip = this.TEXT_NUDGE;
        }
        GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.nudge.x, (double)this.nudge.y, (int)(240 - 16 * this.getNudge(mouseX, mouseY)), (int)240, (int)16, (int)16, (ResourceLocation)guiTexture);
        boolean errorUnnamed = Strings.isNullOrEmpty((String)this.name.getValue());
        boolean errorDuplicate = EmbroideryData.has(this.name.getValue());
        boolean showHistory = false;
        block30: for (BasicUiElement element : this.elements) {
            element.render(graphics, mouseX, mouseY, guiTexture);
            if (!element.isMouseOver((double)mouseX, (double)mouseY)) continue;
            switch (element.name) {
                case "exit": {
                    tooltip = this.needsSaving ? this.TEXT_NO_EXIT : element.tooltip;
                    continue block30;
                }
                case "save": {
                    tooltip = this.needsSaving && (errorDuplicate || errorUnnamed) ? (errorUnnamed ? this.TEXT_NO_SAVE_UNNAMED : this.TEXT_NO_SAVE_DUPLICATE) : element.tooltip;
                    continue block30;
                }
                case "place": {
                    tooltip = this.drawMode.tooltip;
                    continue block30;
                }
                case "layer.copy": {
                    tooltip = this.floatingLayer ? this.TEXT_NO_COPY_FLOATING : element.tooltip;
                    continue block30;
                }
                case "layer.merge": {
                    if (this.floatingLayer) {
                        tooltip = this.TEXT_NO_MERGE_FLOATING;
                        continue block30;
                    }
                    if (this.activeLayer == 0) {
                        tooltip = this.TEXT_NO_MERGE_BOTTOM;
                        continue block30;
                    }
                    if (this.visibleLayers[this.activeLayer] && this.visibleLayers[this.activeLayer - 1]) {
                        tooltip = element.tooltip;
                        GuiHelper.drawTexture((GuiGraphics)graphics, (double)(this.guiLeft + this.layerPos[0] + 4), (double)(this.guiTop + this.layerPos[this.activeLayer + 1] + 14), (int)208, (int)216, (int)8, (int)8, (ResourceLocation)guiTexture);
                        continue block30;
                    }
                    tooltip = this.TEXT_NO_MERGE_VISIBILITY;
                    continue block30;
                }
                case "layer.float": {
                    tooltip = this.floatingLayer ? "" : (this.invalidTag > 0 ? this.TEXT_TAG_IMPORT_ERROR : this.TEXT_TAG_IMPORT);
                    continue block30;
                }
                case "layer.float.clear": {
                    tooltip = this.floatingLayer ? element.tooltip : "";
                    continue block30;
                }
                case "layer.float.anchor": {
                    tooltip = this.floatingLayer ? (this.visibleLayers[this.activeLayer] ? element.tooltip : this.TEXT_NO_ANCHOR_VISIBILITY) : "";
                    continue block30;
                }
                case "undo": 
                case "redo": {
                    showHistory = true;
                }
            }
            tooltip = element.tooltip;
        }
        if (errorDuplicate || errorUnnamed) {
            if (this.isMouseOverArea(mouseX, mouseY, this.nameWarning, 8.0)) {
                tooltip = errorUnnamed ? this.TEXT_ERROR_UNNAMED : this.TEXT_ERROR_DUPLICATE;
            }
            GuiHelper.drawTexture((GuiGraphics)graphics, (double)this.nameWarning.x, (double)this.nameWarning.y, (int)208, (int)208, (int)8, (int)8, (ResourceLocation)guiTexture);
        }
        if (showHistory) {
            graphics.pose().pushPose();
            graphics.pose().scale(0.75f, 0.75f, 0.75f);
            String text = this.undoLevels.size() + " |";
            float x = (float)(this.guiLeft + 188 - this.parent.getMinecraft().font.width(text)) + (this.undoLevels.size() > 9 ? 1.5f : 0.0f);
            text = text + " " + this.redoLevels.size();
            float y = this.guiTop + 15;
            GuiHelper.drawString((GuiGraphics)graphics, (Font)this.parent.getMinecraft().font, (String)text, (float)(x / 0.743f), (float)(y / 0.743f), (int)0xFFFFFF, (boolean)true);
            graphics.pose().popPose();
        }
        this.name.render(graphics, mouseX, mouseY, partialTicks);
        if (!Strings.isNullOrEmpty((String)tooltip)) {
            if (!tooltip.equals(this.lastToolTip)) {
                this.lastToolTip = tooltip;
                this.countToolTip = 0;
                this.invalidTag = 0;
            } else {
                ++this.countToolTip;
            }
            if (this.countToolTip >= 40) {
                this.countToolTip = 40;
                ArrayList lines = new ArrayList();
                StringUtil.multiLineTooltip((String)tooltip, lines);
                graphics.renderComponentTooltip(this.parent.getMinecraft().font, lines, this.guiLeft, this.guiTop + this.ySize + 10);
                if (this.invalidTag > 0) {
                    --this.invalidTag;
                }
            }
        }
    }

    private int getPixelUnderMouse(double mouseX, double mouseY) {
        for (int row = 0; row < this.canvasScale; ++row) {
            for (int col = 0; col < this.canvasScale; ++col) {
                if (!this.isMouseOverArea(mouseX, mouseY, (double)this.canvas.x + (double)col * this.canvasPixel, (double)this.canvas.y + (double)row * this.canvasPixel, this.canvasPixel)) continue;
                return this.canvasScale * row + col;
            }
        }
        return -1;
    }

    private int[] getAdjacentPixels(int origin) {
        int row = origin / this.canvasScale;
        int col = origin % this.canvasScale;
        int max = this.canvasScale - 1;
        return new int[]{row == 0 ? -1 : this.canvasScale * (row - 1) + col, row == max ? -1 : this.canvasScale * (row + 1) + col, col == 0 ? -1 : this.canvasScale * row + col - 1, col == max ? -1 : this.canvasScale * row + col + 1};
    }

    private boolean isMouseOverArea(double mouseX, double mouseY, Point point, double size) {
        return this.isMouseOverArea(mouseX, mouseY, point.x, point.y, size, size);
    }

    private boolean isMouseOverArea(double mouseX, double mouseY, Point point, double sizeX, double sizeY) {
        return this.isMouseOverArea(mouseX, mouseY, point.x, point.y, sizeX, sizeY);
    }

    private boolean isMouseOverArea(double mouseX, double mouseY, double x, double y, double size) {
        return this.isMouseOverArea(mouseX, mouseY, x, y, size, size);
    }

    private boolean isMouseOverArea(double mouseX, double mouseY, double x, double y, double sizeX, double sizeY) {
        return mouseX >= x && mouseX < x + sizeX && mouseY >= y && mouseY < y + sizeY;
    }

    private int getNudge(double mouseX, double mouseY) {
        if (this.isMouseOverArea(mouseX, mouseY, this.nudge, 16.0)) {
            double localX = mouseX - (double)this.nudge.x;
            double localY = mouseY - (double)this.nudge.y;
            if (localX >= Math.max(5.0, localY) && localX < Math.min(16.0 - localY, 11.0) && localY >= 0.0 && localY < 6.0) {
                return 1;
            }
            if (localX >= Math.max(5.0, 16.0 - localY) && localX < Math.min(localY, 11.0) && localY >= 10.0 && localY < 16.0) {
                return 2;
            }
            if (localX >= 10.0 && localX < 16.0 && localY >= Math.max(5.0, 16.0 - localX) && localY < Math.min(localX, 11.0)) {
                return 3;
            }
            if (localX >= 0.0 && localX < 6.0 && localY >= Math.max(5.0, localX) && localY < Math.min(16.0 - localX, 11.0)) {
                return 4;
            }
        }
        return 0;
    }

    boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.name.isFocused()) {
            String text = this.name.getValue();
            if (this.name.keyPressed(keyCode, scanCode, modifiers)) {
                if (!this.name.getValue().equals(text)) {
                    this.needsSaving = true;
                }
                return true;
            }
        }
        return false;
    }

    boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.name.isFocused()) {
            if (keyCode == 256 || keyCode == 257 || keyCode == 335) {
                this.name.setFocused(false);
            }
            String text = this.name.getValue();
            if (this.name.keyReleased(keyCode, scanCode, modifiers)) {
                if (!this.name.getValue().equals(text)) {
                    this.needsSaving = true;
                }
                return true;
            }
        } else if (!this.isMouseDown[0] && !this.isMouseDown[1]) {
            if (modifiers == 2) {
                if (keyCode == 90) {
                    return this.preformUndo();
                }
                if (keyCode == 89) {
                    return this.preformRedo();
                }
            }
            for (ToolMode mode : ToolMode.values()) {
                if (keyCode != mode.glfwKey) continue;
                this.toolMode = mode;
                return true;
            }
            if (keyCode == 65) {
                this.drawInAlpha = !this.drawInAlpha;
                return true;
            }
            if (keyCode == 88) {
                this.swapDrawColors();
                return true;
            }
            if (keyCode == 77) {
                this.changeDrawMode(true);
                return true;
            }
            if (keyCode == 265) {
                this.mouseClicked(this.nudge.x + 8, this.nudge.y + 3, 0);
                return true;
            }
            if (keyCode == 264) {
                this.mouseClicked(this.nudge.x + 8, this.nudge.y + 13, 0);
                return true;
            }
            if (keyCode == 263) {
                this.mouseClicked(this.nudge.x + 3, this.nudge.y + 8, 0);
                return true;
            }
            if (keyCode == 262) {
                this.mouseClicked(this.nudge.x + 13, this.nudge.y + 8, 0);
                return true;
            }
            if (keyCode == 320 || keyCode == 48) {
                this.visibleLayers[this.activeLayer] = !this.visibleLayers[this.activeLayer];
                return true;
            }
            if (keyCode == 321 || keyCode == 49) {
                this.activeLayer = 0;
                return true;
            }
            if (keyCode == 322 || keyCode == 50) {
                this.activeLayer = 1;
                return true;
            }
            if (keyCode == 323 || keyCode == 51) {
                this.activeLayer = (byte)2;
                return true;
            }
            if (keyCode == 324 || keyCode == 52) {
                this.activeLayer = (byte)3;
                return true;
            }
            if (keyCode == 325 || keyCode == 53) {
                this.activeLayer = (byte)4;
                return true;
            }
            if (keyCode == 334) {
                this.moveLayerUp();
                return true;
            }
            if (keyCode == 333) {
                this.moveLayerDown();
                return true;
            }
            if (keyCode == 331) {
                this.mergeLayers();
                return true;
            }
        }
        return false;
    }

    boolean charTyped(char character, int value) {
        if (this.name.isFocused()) {
            String text = this.name.getValue();
            if (this.name.charTyped(character, value)) {
                if (!this.name.getValue().equals(text)) {
                    this.needsSaving = true;
                }
                return true;
            }
        }
        return false;
    }

    private int getDrawLayer() {
        return this.floatingLayer ? this.layerCount - 1 : this.activeLayer;
    }

    boolean mouseClicked(double mouseX, double mouseY, int button) {
        int pixel;
        String text = this.name.getValue();
        this.name.setFocused(this.name.mouseClicked(mouseX, mouseY, button));
        if (this.name.isFocused()) {
            if (!this.name.getValue().equals(text)) {
                this.needsSaving = true;
            }
            return true;
        }
        this.previousPixel = pixel = this.getPixelUnderMouse(mouseX, mouseY);
        if (button == 0 || button == 1) {
            this.isMouseDown[button] = true;
            if (this.isMouseOverArea(mouseX, mouseY, this.canvas, this.canvasPixel * (double)this.canvasScale) && pixel > -1) {
                if (this.toolMode.ctrlIsDropper && Screen.hasControlDown()) {
                    byte index = this.getPixelPaletteIndex(pixel, Screen.hasAltDown());
                    if (index != 0) {
                        this.activeIndex[button] = index;
                    }
                    return true;
                }
                switch (this.toolMode.ordinal()) {
                    case 0: 
                    case 4: {
                        this.setUndo();
                        this.drawAndPaint(this.toolMode, pixel, button, true);
                        break;
                    }
                    case 1: {
                        if (Screen.hasAltDown()) {
                            if (!this.visibleLayers[this.getDrawLayer()]) break;
                            this.setUndo();
                            Arrays.fill(this.canvasIndices[this.getDrawLayer()], (byte)0);
                            break;
                        }
                        if (Screen.hasControlDown()) {
                            this.swapCanvasColor(pixel, (byte)0);
                            break;
                        }
                        if (Screen.hasShiftDown()) {
                            this.setUndo();
                            this.fillSection(pixel, (byte)0);
                            break;
                        }
                        this.setUndo();
                        this.drawPixel(pixel, (byte)0);
                        break;
                    }
                    case 2: {
                        byte index = this.getPixelPaletteIndex(pixel, Screen.hasAltDown());
                        if (index == 0) break;
                        this.activeIndex[button] = index;
                        break;
                    }
                    case 3: {
                        this.swapCanvasColor(pixel, this.activeIndex[button]);
                        break;
                    }
                    case 5: {
                        this.setUndo();
                        this.spray(pixel, this.activeIndex[button]);
                        break;
                    }
                    case 6: {
                        this.setUndo();
                        this.fillSection(pixel, this.activeIndex[button]);
                        break;
                    }
                    case 7: {
                        this.setUndo();
                        this.scramble(pixel, !Screen.hasShiftDown());
                        break;
                    }
                    case 8: {
                        this.setUndo();
                        this.bomb(pixel);
                        break;
                    }
                    case 9: {
                        if (button == 0) {
                            this.setUndo();
                        }
                        this.clone(pixel, button == 1, false);
                    }
                }
                return true;
            }
            if (this.isMouseOverArea(mouseX, mouseY, this.palette, (double)(this.palettePixel * 12), (double)(this.palettePixel * 21))) {
                for (int row = 0; row < 21; ++row) {
                    for (int col = 0; col < 12; ++col) {
                        if (!this.isMouseOverArea(mouseX, mouseY, this.palette.x + col * this.palettePixel, (double)(this.palette.y + row * this.palettePixel), (double)this.palettePixel)) continue;
                        int index = 1 + row + 21 * (11 - col);
                        if (Palettes.getPaletteUiIndex(this.activePalette < 0 ? ~this.activePalette : this.activePalette) == 15) {
                            index = index >= 1 && index <= 3 ? 106 : (index >= -24 && index <= -22 ? 24 : (int)index);
                        }
                        this.activeIndex[button] = index;
                        return true;
                    }
                }
            }
        }
        if (button == 0 && this.isMouseOverArea(mouseX, mouseY, this.nudge, 16.0)) {
            int nudge = this.getNudge(mouseX, mouseY);
            if (nudge >= 1 && nudge <= 4) {
                this.setUndo();
                byte[] copy = (byte[])this.canvasIndices[this.getDrawLayer()].clone();
                for (int row = 0; row < this.canvasScale; ++row) {
                    for (int col = 0; col < this.canvasScale; ++col) {
                        int ncol;
                        int nrow;
                        int n = nudge == 1 ? row - 1 : (nrow = nudge == 2 ? row + 1 : row);
                        int n2 = nudge == 3 ? col + 1 : (ncol = nudge == 4 ? col - 1 : col);
                        int n3 = nrow < 0 ? this.canvasScale - 1 : (nrow = nrow > this.canvasScale - 1 ? 0 : nrow);
                        ncol = ncol < 0 ? this.canvasScale - 1 : (ncol > this.canvasScale - 1 ? 0 : ncol);
                        this.canvasIndices[this.getDrawLayer()][nrow * this.canvasScale + ncol] = copy[row * this.canvasScale + col];
                        this.setAlphaFlag(nrow * this.canvasScale + ncol, this.getAlphaFlag(copy, row * this.canvasScale + col));
                    }
                }
            }
            return true;
        }
        for (BasicUiElement element : this.elements) {
            if (!element.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    boolean mouseDragged(double mouseX, double mouseY, int button) {
        int pixel;
        if (this.toolMode.draggable && (button == 0 || button == 1) && (pixel = this.getPixelUnderMouse(mouseX, mouseY)) > -1 && pixel != this.previousPixel) {
            if (this.toolMode.ctrlIsDropper && Screen.hasControlDown()) {
                return true;
            }
            switch (this.toolMode.ordinal()) {
                case 0: 
                case 4: {
                    this.drawAndPaint(this.toolMode, pixel, button, false);
                    break;
                }
                case 1: {
                    if (Screen.hasAltDown() || Screen.hasControlDown() || Screen.hasShiftDown()) break;
                    this.drawPixel(pixel, (byte)0);
                    break;
                }
                case 5: {
                    this.spray(pixel, this.activeIndex[button]);
                    break;
                }
                case 7: {
                    this.scramble(pixel, !Screen.hasShiftDown());
                    break;
                }
                case 9: {
                    this.clone(pixel, button == 1, true);
                }
            }
            this.previousPixel = pixel;
            return true;
        }
        return false;
    }

    boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 || button == 1) {
            this.isMouseDown[button] = false;
            if (this.toolMode == ToolMode.CLONE) {
                this.toolTracker[5] = this.toolTracker[3];
                this.toolTracker[6] = this.toolTracker[4];
            }
        }
        return false;
    }

    private void changeDrawMode(boolean next) {
        switch (this.drawMode.ordinal()) {
            case 0: {
                this.drawMode = next ? DrawMode.H_MIRROR : DrawMode.QUADRANT;
                break;
            }
            case 1: {
                this.drawMode = next ? DrawMode.V_MIRROR : DrawMode.SINGLE;
                break;
            }
            case 2: {
                this.drawMode = next ? DrawMode.QUADRANT : DrawMode.H_MIRROR;
                break;
            }
            case 3: {
                this.drawMode = next ? DrawMode.SINGLE : DrawMode.V_MIRROR;
            }
        }
    }

    private void copyLayer() {
        if (!this.floatingLayer) {
            this.canvasIndices[this.layerCount - 1] = (byte[])this.canvasIndices[this.activeLayer].clone();
            this.floatingLayer = true;
        }
    }

    private void mergeLayers() {
        if (!this.floatingLayer && this.activeLayer > 0 && this.visibleLayers[this.activeLayer] && this.visibleLayers[this.activeLayer - 1]) {
            this.setUndo();
            this.preformMerge(this.activeLayer, this.activeLayer - 1);
        }
    }

    private void preformMerge(int upper, int lower) {
        for (int index = 0; index < this.canvasArraySize[0]; ++index) {
            byte value = this.canvasIndices[upper][index];
            if (value == 0) continue;
            this.setAlphaFlag(this.canvasIndices[lower], index, this.getAlphaFlag(this.canvasIndices[upper], index));
            this.canvasIndices[upper][index] = 0;
            this.canvasIndices[lower][index] = value;
        }
    }

    private void importShareTag(double mx, double my, int button) {
        String clipboard;
        if (!this.floatingLayer && button == 1 && !Strings.isNullOrEmpty((String)(clipboard = Minecraft.getInstance().keyboardHandler.getClipboard()))) {
            Embroidery embroidery = Embroidery.fromShareTag(clipboard = clipboard.replaceAll("\"", "").trim());
            if (!embroidery.isEmpty()) {
                byte[] indices = embroidery.getUncompressedIndices();
                int scale = Embroidery.getCanvasScale(indices);
                if (scale == this.canvasScale) {
                    this.setFloatingImage(indices);
                } else {
                    this.parent.pageScale.setImage(this.activePalette, indices, scale, this.canvasScale);
                }
            } else {
                this.invalidTag = 100;
                this.lastToolTip = this.TEXT_TAG_IMPORT_ERROR;
                this.countToolTip = 40;
            }
        }
    }

    private void clearFloating(boolean addUndo) {
        if (addUndo) {
            this.setUndo();
        }
        Arrays.fill(this.canvasIndices[this.layerCount - 1], (byte)0);
        this.floatingLayer = false;
    }

    private void anchorFloating() {
        if (this.visibleLayers[this.activeLayer]) {
            this.setUndo();
            if (Screen.hasAltDown()) {
                this.canvasIndices[this.activeLayer] = (byte[])this.canvasIndices[this.layerCount - 1].clone();
            } else {
                this.preformMerge(this.layerCount - 1, this.activeLayer);
            }
            this.clearFloating(false);
        }
    }

    private void moveLayerUp() {
        if (this.activeLayer != this.layerCount - 2) {
            byte[] array = this.canvasIndices[this.activeLayer];
            this.canvasIndices[this.activeLayer] = this.canvasIndices[this.activeLayer + 1];
            this.canvasIndices[this.activeLayer + 1] = array;
            boolean visibility = this.visibleLayers[this.activeLayer];
            this.visibleLayers[this.activeLayer] = this.visibleLayers[this.activeLayer + 1];
            this.visibleLayers[this.activeLayer + 1] = visibility;
            this.activeLayer = (byte)(this.activeLayer + 1);
        }
    }

    private void moveLayerDown() {
        if (this.activeLayer > 0) {
            byte[] array = this.canvasIndices[this.activeLayer];
            this.canvasIndices[this.activeLayer] = this.canvasIndices[this.activeLayer - 1];
            this.canvasIndices[this.activeLayer - 1] = array;
            boolean visibility = this.visibleLayers[this.activeLayer];
            this.visibleLayers[this.activeLayer] = this.visibleLayers[this.activeLayer - 1];
            this.visibleLayers[this.activeLayer - 1] = visibility;
            this.activeLayer = (byte)(this.activeLayer - 1);
        }
    }

    private void swapDrawColors() {
        byte temp = this.activeIndex[0];
        this.activeIndex[0] = this.activeIndex[1];
        this.activeIndex[1] = temp;
    }

    private void flipV() {
        this.setUndo();
        byte[] copy = (byte[])this.canvasIndices[this.getDrawLayer()].clone();
        for (int row = 0; row < this.canvasScale; ++row) {
            for (int col = 0; col < this.canvasScale; ++col) {
                this.canvasIndices[this.getDrawLayer()][row * this.canvasScale + col] = copy[row * this.canvasScale + (this.canvasScale - 1 - col)];
                this.setAlphaFlag(row * this.canvasScale + col, this.getAlphaFlag(copy, row * this.canvasScale + (this.canvasScale - 1 - col)));
            }
        }
    }

    private void flipH() {
        this.setUndo();
        byte[] copy = (byte[])this.canvasIndices[this.getDrawLayer()].clone();
        for (int row = 0; row < this.canvasScale; ++row) {
            for (int col = 0; col < this.canvasScale; ++col) {
                this.canvasIndices[this.getDrawLayer()][row * this.canvasScale + col] = copy[(this.canvasScale - 1 - row) * this.canvasScale + col];
                this.setAlphaFlag(row * this.canvasScale + col, this.getAlphaFlag(copy, (this.canvasScale - 1 - row) * this.canvasScale + col));
            }
        }
    }

    private void rotateCW() {
        this.setUndo();
        byte[] copy = (byte[])this.canvasIndices[this.getDrawLayer()].clone();
        for (int row = 0; row < this.canvasScale; ++row) {
            for (int col = 0; col < this.canvasScale; ++col) {
                this.canvasIndices[this.getDrawLayer()][row * this.canvasScale + col] = copy[(this.canvasScale - 1 - col) * this.canvasScale + row];
                this.setAlphaFlag(row * this.canvasScale + col, this.getAlphaFlag(copy, (this.canvasScale - 1 - col) * this.canvasScale + row));
            }
        }
    }

    private void rotateCCW() {
        this.setUndo();
        byte[] copy = (byte[])this.canvasIndices[this.getDrawLayer()].clone();
        for (int row = 0; row < this.canvasScale; ++row) {
            for (int col = 0; col < this.canvasScale; ++col) {
                this.canvasIndices[this.getDrawLayer()][row * this.canvasScale + col] = copy[col * this.canvasScale + (this.canvasScale - 1) - row];
                this.setAlphaFlag(row * this.canvasScale + col, this.getAlphaFlag(copy, col * this.canvasScale + (this.canvasScale - 1) - row));
            }
        }
    }

    private void exit() {
        if (!this.needsSaving || Screen.hasAltDown()) {
            if ((this.hadChanges || this.needsSaving) && !Screen.hasControlDown()) {
                this.generateProject();
                this.parent.buildListProjects();
            }
            this.parent.buildListCustom();
            this.parent.activePage = GuiEmbroidery.ActivePage.SELECT;
        }
    }

    private void generateProject() {
        boolean[] usedLayer = new boolean[this.layerCount];
        int usedLayerCount = 0;
        block0: for (int layer = 0; layer < this.layerCount; ++layer) {
            for (int pixel = 0; pixel < this.canvasArraySize[0]; ++pixel) {
                if (this.canvasIndices[layer][pixel] == 0) continue;
                usedLayer[layer] = true;
                ++usedLayerCount;
                continue block0;
            }
        }
        if (usedLayerCount > 1) {
            Object name = this.name.getValue();
            if (!this.isProject) {
                while (EmbroideryData.hasProject((String)name)) {
                    name = (String)name + ".";
                }
            }
            byte[][] layerData = new byte[usedLayerCount][];
            boolean[] layerVisibility = new boolean[usedLayerCount];
            int index = 0;
            for (int layer = 0; layer < this.layerCount; ++layer) {
                if (!usedLayer[layer]) continue;
                layerData[index] = this.canvasIndices[layer];
                layerVisibility[index] = this.visibleLayers[layer];
                ++index;
            }
            EmbroideryData.saveProject((String)name, new WIPProject(this.generateOutput(), this.activePalette, layerData, layerVisibility, this.canvasScale));
        }
    }

    private byte[] generateOutput() {
        byte[] outputIndices = new byte[this.canvasArraySize[0]];
        for (int row = 0; row < this.canvasScale; ++row) {
            for (int col = 0; col < this.canvasScale; ++col) {
                int index = this.canvasScale * row + col;
                Pair<Byte, Boolean> data = this.getPixelPaletteData(index, true);
                outputIndices[index] = (Byte)data.getLeft();
                if (((Boolean)data.getRight()).booleanValue() && outputIndices.length < this.canvasArraySize[1]) {
                    outputIndices = Arrays.copyOf(outputIndices, this.canvasArraySize[1]);
                }
                this.setAlphaFlag(outputIndices, index, (Boolean)data.getRight());
            }
        }
        return outputIndices;
    }

    private void save() {
        if (!(Strings.isNullOrEmpty((String)this.name.getValue()) || EmbroideryData.has(this.name.getValue()) && !Screen.hasAltDown())) {
            EmbroideryData.save(this.name.getValue(), Embroidery.fromUncompressed(this.activePalette, this.generateOutput()));
            this.needsSaving = false;
            this.hadChanges = true;
        }
    }

    private void setUndo() {
        this.redoLevels.clear();
        if (this.undoLevels.size() == 16) {
            this.undoLevels.removeLast();
        }
        this.undoLevels.push(new SnapShot(this));
        this.needsSaving = true;
    }

    private boolean preformUndo() {
        if (this.undoLevels.size() > 0) {
            this.redoLevels.push(new SnapShot(this));
            this.undoLevels.pop().unpack(this);
            return true;
        }
        return false;
    }

    private boolean preformRedo() {
        if (this.redoLevels.size() > 0) {
            this.undoLevels.push(new SnapShot(this));
            this.redoLevels.pop().unpack(this);
            return true;
        }
        return false;
    }

    private void swapCanvasColor(int pixel, byte index) {
        ArrayList<Integer> pixels = new ArrayList<Integer>();
        byte find = this.canvasIndices[this.getDrawLayer()][pixel];
        boolean alpha = this.getAlphaFlag(this.canvasIndices[this.getDrawLayer()], pixel);
        for (int pos = 0; pos < this.canvasArraySize[0]; ++pos) {
            if (this.canvasIndices[this.getDrawLayer()][pos] != find || this.getAlphaFlag(this.canvasIndices[this.getDrawLayer()], pos) != alpha) continue;
            pixels.add(pos);
        }
        if (!pixels.isEmpty()) {
            this.setUndo();
            Iterator iterator = pixels.iterator();
            while (iterator.hasNext()) {
                int pos = (Integer)iterator.next();
                this.setPixel(pos, index);
            }
        }
    }

    private void fillSection(int pixel, byte index) {
        int layer = this.getDrawLayer();
        byte find = this.canvasIndices[layer][pixel];
        if (find != index) {
            ArrayDeque<Integer> queue = new ArrayDeque<Integer>();
            queue.push(pixel);
            while (!queue.isEmpty()) {
                int[] neighbours;
                int qPix = (Integer)queue.pop();
                this.drawPixel(qPix, index);
                for (int neighbour : neighbours = this.getAdjacentPixels(qPix)) {
                    if (neighbour < 0 || find != this.canvasIndices[layer][neighbour] || queue.contains(neighbour)) continue;
                    queue.push(neighbour);
                }
            }
        }
    }

    private void drawAndPaint(ToolMode toolMode, int pixel, int button, boolean clicked) {
        int pointer;
        if (this.toolTracker[0] != toolMode.ordinal()) {
            this.toolTracker[0] = toolMode.ordinal();
        }
        int center_row = pixel / this.canvasScale;
        int center_col = pixel % this.canvasScale;
        int n = pointer = Screen.hasAltDown() ? 5 : button * 2 + 1;
        if (clicked && Screen.hasShiftDown()) {
            this.drawLine(this.toolTracker[pointer + 1], this.toolTracker[pointer], center_col, center_row, lPixel -> {
                if (toolMode == ToolMode.BRUSH) {
                    this.paintPixel((int)lPixel, this.activeIndex[button]);
                } else {
                    this.drawPixel((int)lPixel, this.activeIndex[button]);
                }
                return true;
            });
        } else if (toolMode == ToolMode.BRUSH) {
            this.paintPixel(pixel, this.activeIndex[button]);
        } else {
            this.drawPixel(pixel, this.activeIndex[button]);
        }
        pointer = button * 2 + 1;
        this.toolTracker[5] = this.toolTracker[pointer] = center_row;
        int n2 = center_col;
        this.toolTracker[pointer + 1] = n2;
        this.toolTracker[6] = n2;
    }

    private void drawLine(int x, int y, int x2, int y2, Predicate<Integer> predicate) {
        int w = x2 - x;
        int h = y2 - y;
        int dx1 = 0;
        int dy1 = 0;
        int dx2 = 0;
        int dy2 = 0;
        if (w < 0) {
            dx1 = -1;
        } else if (w > 0) {
            dx1 = 1;
        }
        if (h < 0) {
            dy1 = -1;
        } else if (h > 0) {
            dy1 = 1;
        }
        if (w < 0) {
            dx2 = -1;
        } else if (w > 0) {
            dx2 = 1;
        }
        int longest = Math.abs(w);
        int shortest = Math.abs(h);
        if (longest <= shortest) {
            longest = Math.abs(h);
            shortest = Math.abs(w);
            if (h < 0) {
                dy2 = -1;
            } else if (h > 0) {
                dy2 = 1;
            }
            dx2 = 0;
        }
        int numerator = longest >> 1;
        for (int i = 0; i <= longest; ++i) {
            predicate.test(y * this.canvasScale + x);
            if ((numerator += shortest) >= longest) {
                numerator -= longest;
                x += dx1;
                y += dy1;
                continue;
            }
            x += dx2;
            y += dy2;
        }
    }

    private void paintPixel(int pixel, byte index) {
        this.drawPixel(pixel, index);
        boolean alpha = this.drawInAlpha;
        this.drawInAlpha = true;
        for (int neighbour : this.getAdjacentPixels(pixel)) {
            if (neighbour < 0 || this.canvasIndices[this.getDrawLayer()][neighbour] != 0) continue;
            this.drawPixel(neighbour, index);
        }
        this.drawInAlpha = alpha;
    }

    private void clone(int pixel, boolean set, boolean dragging) {
        int source;
        byte index;
        int center_row = pixel / this.canvasScale;
        int center_col = pixel % this.canvasScale;
        if (set) {
            this.toolTracker[0] = ToolMode.CLONE.ordinal();
            this.toolTracker[5] = this.toolTracker[3] = center_row;
            this.toolTracker[6] = this.toolTracker[4] = center_col;
            return;
        }
        if (dragging) {
            this.toolTracker[5] = this.toolTracker[5] + (center_row - this.toolTracker[1]);
            this.toolTracker[6] = this.toolTracker[6] + (center_col - this.toolTracker[2]);
        } else {
            this.toolTracker[0] = ToolMode.CLONE.ordinal();
            this.toolTracker[5] = this.toolTracker[3];
            this.toolTracker[6] = this.toolTracker[4];
        }
        this.toolTracker[1] = center_row;
        this.toolTracker[2] = center_col;
        if (this.toolTracker[5] >= 0 && this.toolTracker[6] >= 0 && this.toolTracker[5] < this.canvasScale && this.toolTracker[6] < this.canvasScale && ((index = this.getPixelPaletteIndex(source = this.toolTracker[5] * this.canvasScale + this.toolTracker[6], Screen.hasAltDown())) != 0 || Screen.hasControlDown())) {
            boolean alphaCache = this.drawInAlpha;
            this.drawInAlpha = this.getAlphaFlag(this.canvasIndices[this.getDrawLayer()], source);
            this.drawPixel(pixel, index);
            this.drawInAlpha = alphaCache;
        }
    }

    private void bomb(int pixel) {
        this.random.setSeed((long)this.name.getValue().hashCode() ^ (long)pixel);
        int center_row = pixel / this.canvasScale;
        int center_col = pixel % this.canvasScale;
        this.toolTracker[0] = ToolMode.BOMB.ordinal();
        this.toolTracker[5] = center_row;
        this.toolTracker[6] = center_col;
        this.toolTracker[7] = 10;
        boolean large = !Screen.hasAltDown();
        int size = large ? 7 : 5;
        int offset = size / 2;
        this.scramble((center_row - offset) * this.canvasScale + center_col, large);
        this.scramble((center_row + offset) * this.canvasScale + center_col, large);
        this.scramble(center_row * this.canvasScale + center_col - offset, large);
        this.scramble(center_row * this.canvasScale + center_col + offset, large);
        this.toolScan(pixel, size, (diameter, scan_row, scan_col, tool_row, tool_col) -> {
            if (this.inCircle(diameter, scan_row, scan_col, true)) {
                this.drawPixel(this.canvasScale * tool_row + tool_col, (byte)0);
            }
        });
        if (large && !this.floatingLayer && this.activeLayer > 0 && this.visibleLayers[this.activeLayer - 1]) {
            this.activeLayer = (byte)(this.activeLayer - 1);
            this.scramble((center_row - 2) * this.canvasScale + center_col, false);
            this.scramble((center_row + 2) * this.canvasScale + center_col, false);
            this.scramble(center_row * this.canvasScale + center_col - 2, false);
            this.scramble(center_row * this.canvasScale + center_col + 2, false);
            this.toolScan(pixel, 5, (diameter, scan_row, scan_col, tool_row, tool_col) -> {
                if (this.inCircle(diameter, scan_row, scan_col, false)) {
                    this.drawPixel(this.canvasScale * tool_row + tool_col, (byte)0);
                }
            });
            this.activeLayer = (byte)(this.activeLayer + 1);
        }
    }

    private boolean inCircle(int diameter, int scan_row, int scan_col, boolean large) {
        if (large) {
            boolean rCorner = !(scan_row != 0 && scan_row != diameter - 1 || scan_col >= 2 && scan_col <= diameter - 3);
            boolean cCorner = !(scan_col != 0 && scan_col != diameter - 1 || scan_row >= 2 && scan_row <= diameter - 3);
            return !rCorner && !cCorner;
        }
        boolean corners = !(scan_row != 0 && scan_row != diameter - 1 || scan_col != 0 && scan_col != diameter - 1);
        return !corners;
    }

    private void scramble(int pixel, boolean large) {
        this.random.setSeed((long)this.name.getValue().hashCode() ^ (long)pixel);
        ArrayList values = new ArrayList();
        this.toolScan(pixel, large ? 7 : 5, (diameter, scan_row, scan_col, tool_row, tool_col) -> {
            if (this.inCircle(diameter, scan_row, scan_col, large)) {
                int index = this.canvasScale * tool_row + tool_col;
                values.add(this.getPixelPaletteData(index, false));
            }
        });
        Collections.shuffle(values, this.random);
        this.toolScan(pixel, large ? 7 : 5, (diameter, scan_row, scan_col, tool_row, tool_col) -> {
            if (this.inCircle(diameter, scan_row, scan_col, large)) {
                Pair data = (Pair)values.get(0);
                boolean alphaCache = this.drawInAlpha;
                if (!Screen.hasAltDown()) {
                    this.drawInAlpha = (Boolean)data.getRight();
                }
                this.drawPixel(this.canvasScale * tool_row + tool_col, (Byte)data.getLeft());
                this.drawInAlpha = alphaCache;
                values.remove(0);
            }
        });
    }

    private void spray(int pixel, byte index) {
        if (Screen.hasShiftDown()) {
            int pattern = PATTERNS[this.random.nextInt(PATTERNS.length)];
            this.toolScan(pixel, 5, (diameter, scan_row, scan_col, tool_row, tool_col) -> {
                if ((pattern >> 24 - (scan_row * diameter + scan_col) & 1) == 1 && this.random.nextBoolean()) {
                    if (Screen.hasAltDown()) {
                        this.paintPixel(this.canvasScale * tool_row + tool_col, index);
                    } else {
                        this.drawPixel(this.canvasScale * tool_row + tool_col, index);
                    }
                }
            });
        } else {
            int pattern = PATTERNS2[this.random.nextInt(PATTERNS2.length)];
            this.toolScan(pixel, 6, (diameter, scan_row, scan_col, tool_row, tool_col) -> {
                int pointer = scan_row * diameter + scan_col;
                if (pointer != 0 && pointer != 5 && pointer != 30 && pointer != 35 && (pattern >> 31 - (pointer -= pointer < 5 ? 1 : (pointer < 30 ? 2 : 3)) & 1) == 1 && this.random.nextBoolean()) {
                    if (Screen.hasAltDown()) {
                        this.paintPixel(this.canvasScale * tool_row + tool_col, index);
                    } else {
                        this.drawPixel(this.canvasScale * tool_row + tool_col, index);
                    }
                }
            });
        }
    }

    private void toolScan(int pixel, int diameter, ToolScanProgress operation) {
        int center_row = pixel / this.canvasScale;
        int center_col = pixel % this.canvasScale;
        int radius = diameter / 2;
        for (int scan_row = 0; scan_row < diameter; ++scan_row) {
            int tool_row = center_row + scan_row - radius;
            if (tool_row < 0 || tool_row >= this.canvasScale) continue;
            for (int scan_col = 0; scan_col < diameter; ++scan_col) {
                int tool_col = center_col + scan_col - radius;
                if (tool_col < 0 || tool_col >= this.canvasScale) continue;
                operation.process(diameter, scan_row, scan_col, tool_row, tool_col);
            }
        }
    }

    private void drawPixel(int pixel, byte index) {
        this.setPixel(pixel, index);
        if (this.drawMode != DrawMode.SINGLE && this.toolMode.canMultiDraw()) {
            int col = pixel % this.canvasScale;
            int row = pixel / this.canvasScale;
            int ocol = this.canvasScale - 1 - col;
            int orow = this.canvasScale - 1 - row;
            switch (this.drawMode.ordinal()) {
                case 2: {
                    this.setPixel(this.canvasScale * row + ocol, index);
                    break;
                }
                case 1: {
                    this.setPixel(this.canvasScale * orow + col, index);
                    break;
                }
                case 3: {
                    this.setPixel(this.canvasScale * orow + col, index);
                    this.setPixel(this.canvasScale * row + ocol, index);
                    this.setPixel(this.canvasScale * orow + ocol, index);
                }
            }
        }
    }

    private byte getPixelPaletteIndex(int pixel, boolean merged) {
        return (Byte)this.getPixelPaletteData(pixel, merged).getLeft();
    }

    private Pair<Byte, Boolean> getPixelPaletteData(int pixel, boolean merged) {
        if (merged) {
            for (int layer = this.layerCount - 1; layer >= 0; --layer) {
                byte value;
                if (!this.visibleLayers[layer] || (value = this.canvasIndices[layer][pixel]) == 0) continue;
                return Pair.of((Object)value, (Object)this.getAlphaFlag(this.canvasIndices[layer], pixel));
            }
        } else {
            return Pair.of((Object)this.canvasIndices[this.activeLayer][pixel], (Object)this.getAlphaFlag(this.canvasIndices[this.activeLayer], pixel));
        }
        return Pair.of((Object)0, (Object)false);
    }

    private void setPixel(int pixel, byte index) {
        if (this.visibleLayers[this.getDrawLayer()]) {
            this.canvasIndices[this.getDrawLayer()][pixel] = index;
            this.setAlphaFlag(pixel, this.drawInAlpha && this.toolMode != ToolMode.ERASE);
        }
    }

    private boolean getAlphaFlag(byte[] array, int pixel) {
        int alphaIndex = this.canvasArraySize[0] + pixel / 8;
        if (array.length > alphaIndex) {
            byte alphaByte = array[alphaIndex];
            int bitShift = 7 - pixel % 8;
            return (alphaByte >> bitShift & 1) == 1;
        }
        return false;
    }

    private void setAlphaFlag(int pixel, boolean enable) {
        this.setAlphaFlag(this.canvasIndices[this.getDrawLayer()], pixel, enable);
    }

    private void setAlphaFlag(byte[] array, int pixel, boolean enable) {
        int alphaIndex = this.canvasArraySize[0] + pixel / 8;
        if (array.length > alphaIndex) {
            byte alphaByte = array[alphaIndex];
            int bitShift = 7 - pixel % 8;
            alphaByte = !enable ? (byte)(alphaByte & ~(1 << bitShift)) : (byte)(alphaByte | 1 << bitShift);
            array[alphaIndex] = alphaByte;
        }
    }

    ToolMode getToolMode() {
        return this.toolMode;
    }

    void setToolMode(ToolMode toolMode) {
        this.toolMode = toolMode;
    }

    byte getActivePalette() {
        return this.activePalette;
    }

    void setActivePalette(byte activePalette) {
        if (activePalette != this.activePalette && ~activePalette != this.activePalette) {
            this.setToDefaultColors(activePalette);
        }
        this.activePalette = activePalette;
    }

    static enum DrawMode {
        SINGLE("single", 32, 224),
        H_MIRROR("h_mirror", 32, 240),
        V_MIRROR("v_mirror", 48, 240),
        QUADRANT("quadrant", 48, 224);

        private final String tooltip;
        private final int u;
        private final int v;

        private DrawMode(String mode, int u, int v) {
            this.tooltip = I18n.get((String)("gui.multibeds.embroidery.draw.place." + mode), (Object[])new Object[0]);
            this.u = u;
            this.v = v;
        }
    }

    static enum ToolMode {
        DRAW(32, 208, true, true, true, 87),
        ERASE(48, 208, true, true, false, 69),
        PICK(64, 208, false, false, false, 68),
        SWAP(16, 192, false, false, true, 67),
        BRUSH(16, 208, true, true, true, 66),
        SPRAY(0, 208, true, true, true, 83),
        BUCKET(0, 192, true, false, true, 70),
        SCRAMBLE(32, 192, false, true, false, 82),
        BOMB(80, 208, false, false, false, 81),
        CLONE(48, 192, false, true, false, 84);

        private final int u;
        private final int v;
        private final boolean multidraw;
        private final boolean draggable;
        private final boolean ctrlIsDropper;
        private final int glfwKey;

        private ToolMode(int u, int v, boolean multidraw, boolean draggable, boolean ctrlIsDropper, int glfwKey) {
            this.u = u;
            this.v = v;
            this.multidraw = multidraw;
            this.draggable = draggable;
            this.ctrlIsDropper = ctrlIsDropper;
            this.glfwKey = glfwKey;
        }

        private boolean canMultiDraw() {
            return this.multidraw && (this != ERASE || !Screen.hasAltDown() && !Screen.hasControlDown() && !Screen.hasShiftDown());
        }

        public int getU() {
            return this.u;
        }

        public int getV() {
            return this.v;
        }
    }

    private static class SnapShot {
        private final boolean floatingLayer;
        private final byte activeLayer;
        private final boolean[] visibleLayers;
        private final byte[][] canvasIndices;

        private SnapShot(EmbroideryPage_Draw parent) {
            this.floatingLayer = parent.floatingLayer;
            this.activeLayer = parent.activeLayer;
            this.visibleLayers = (boolean[])parent.visibleLayers.clone();
            this.canvasIndices = new byte[parent.canvasIndices.length][0];
            for (int layer = 0; layer < parent.layerCount; ++layer) {
                this.canvasIndices[layer] = Arrays.copyOf(parent.canvasIndices[layer], parent.canvasIndices[layer].length);
            }
        }

        private void unpack(EmbroideryPage_Draw parent) {
            parent.floatingLayer = this.floatingLayer;
            parent.activeLayer = this.activeLayer;
            parent.visibleLayers = this.visibleLayers;
            parent.canvasIndices = this.canvasIndices;
        }
    }

    @FunctionalInterface
    private static interface ToolScanProgress {
        public void process(int var1, int var2, int var3, int var4, int var5);
    }
}

