/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.client;

import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.javafmlmod.FMLModContainer;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import shetiphian.multibeds.MultiBeds;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.client.EventHandlerClient;
import shetiphian.multibeds.client.gui.GuiBlanketLoom;
import shetiphian.multibeds.client.gui.GuiBuilder;
import shetiphian.multibeds.client.misc.EmbroideryData;
import shetiphian.multibeds.client.model.ModelLoader;
import shetiphian.multibeds.client.render.RenderArtOnBed;

@Mod(value="multibeds", dist={Dist.CLIENT})
public final class ModMainClient {
    public ModMainClient(FMLModContainer container, IEventBus modEventBus) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        modEventBus.addListener(this::clientSetup);
        modEventBus.register((Object)new ModBusEvents());
        NeoForge.EVENT_BUS.register((Object)new EventRelay());
    }

    private void clientSetup(FMLClientSetupEvent event) {
        EmbroideryData.INSTANCE.loadData();
    }

    private static class ModBusEvents {
        private ModBusEvents() {
        }

        @SubscribeEvent
        public void registerScreenFactories(RegisterMenuScreensEvent event) {
            event.register((MenuType)Roster.Containers.BED_KIT.get(), GuiBuilder::new);
            event.register((MenuType)Roster.Containers.BLANKET_LOOM.get(), GuiBlanketLoom::new);
            event.register((MenuType)Roster.Containers.LADDER_KIT.get(), GuiBuilder::new);
        }

        @SubscribeEvent
        public void modelRegistryEvent(ModelEvent.RegisterGeometryLoaders event) {
            event.register(MultiBeds.RESOURCE.apply("bed"), (IGeometryLoader)ModelLoader.BED);
            event.register(MultiBeds.RESOURCE.apply("bed_extras"), (IGeometryLoader)ModelLoader.BED_EXTRA);
            event.register(MultiBeds.RESOURCE.apply("ladder"), (IGeometryLoader)ModelLoader.LADDER);
        }

        @SubscribeEvent
        public void entityRenderersEvent(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)Roster.Tiles.BED.get(), context -> new RenderArtOnBed());
        }
    }

    private static class EventRelay
    extends EventHandlerClient {
        private EventRelay() {
        }

        @SubscribeEvent
        public void itemTooltip(ItemTooltipEvent event) {
            this.onItemTooltip(event.getItemStack(), event.getToolTip());
        }
    }
}

