/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds;

import com.google.common.collect.ImmutableMap;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import shetiphian.core.common.rgb16.TileEntityRGB16;
import shetiphian.core.common.setup.RosterDataComponent;
import shetiphian.core.common.setup.RosterObject;
import shetiphian.multibeds.common.block.BlockMultiBed;
import shetiphian.multibeds.common.component.Artwork;
import shetiphian.multibeds.common.component.Bedding;
import shetiphian.multibeds.common.component.Texture;
import shetiphian.multibeds.common.crafting.RecipeSpool;
import shetiphian.multibeds.common.crafting.RecipeUncraft;
import shetiphian.multibeds.common.inventory.ContainerBlanketLoom;
import shetiphian.multibeds.common.inventory.ContainerBuilder;
import shetiphian.multibeds.common.item.ItemBlanket;
import shetiphian.multibeds.common.misc.EnumBedStyle;
import shetiphian.multibeds.common.misc.EnumBlanket;
import shetiphian.multibeds.common.tileentity.TileEntityBedExtra;
import shetiphian.multibeds.common.tileentity.TileEntityLadder;
import shetiphian.multibeds.common.tileentity.TileEntityMultiBed;

public final class Roster {

    public static class Containers {
        public static final RosterObject<MenuType<ContainerBuilder>> BED_KIT = RosterObject.of((String)"bed_kit");
        public static final RosterObject<MenuType<ContainerBlanketLoom>> BLANKET_LOOM = RosterObject.of((String)"blanket_loom");
        public static final RosterObject<MenuType<ContainerBuilder>> LADDER_KIT = RosterObject.of((String)"ladder_kit");
    }

    public static class RecipeSerializers {
        public static final RosterObject<RecipeSerializer<RecipeSpool>> SPOOLING = RosterObject.of((String)"spooling");
        public static final RosterObject<RecipeSerializer<RecipeUncraft>> UNCRAFT = RosterObject.of((String)"uncraft");
    }

    public static class Recipes {
        public static final RosterObject<RecipeType<RecipeSpool>> SPOOLING = RosterObject.of((String)"spooling");
        public static final RosterObject<RecipeType<RecipeUncraft>> UNCRAFT = RosterObject.of((String)"uncraft");
    }

    public static class Items {
        public static final RosterObject<BlockItem> CUSTOM = RosterObject.of((String)"custom");
        public static final RosterObject<BlockItem> SLAB = RosterObject.of((String)"slab");
        public static final RosterObject<BlockItem> COT = RosterObject.of((String)"cot");
        public static final RosterObject<BlockItem> CLASSIC = RosterObject.of((String)"classic");
        public static final RosterObject<BlockItem> VINTAGE = RosterObject.of((String)"vintage");
        public static final RosterObject<BlockItem> MODERN = RosterObject.of((String)"modern");
        public static final RosterObject<BlockItem> RUSTIC = RosterObject.of((String)"rustic");
        public static final RosterObject<BlockItem> FUTURE = RosterObject.of((String)"future");
        public static final RosterObject<BlockItem> CREW = RosterObject.of((String)"crew");
        public static final RosterObject<BlockItem> HANGER = RosterObject.of((String)"hanger");
        public static final RosterObject<BlockItem> LADDER = RosterObject.of((String)"ladder");
        public static final RosterObject<Item> WOOLEN_CLOTH = RosterObject.of((String)"woolen_cloth");
        public static final RosterObject<Item> FEATHER_PILE = RosterObject.of((String)"feather_pile");
        public static final RosterObject<Item> PADDING = RosterObject.of((String)"padding");
        public static final RosterObject<Item> BED_KIT = RosterObject.of((String)"bed_kit");
        public static final RosterObject<Item> LADDER_TOOLS = RosterObject.of((String)"ladder_tools");
        public static final RosterObject<Item> EMBROIDERY_THREAD = RosterObject.of((String)"embroidery_thread");
        public static final RosterObject<Item> BEDDING_PACKAGE = RosterObject.of((String)"bedding_package");
        public static final RosterObject<Item> SHEET = RosterObject.of((String)"sheet");
        public static final RosterObject<Item> PILLOW = RosterObject.of((String)"pillow");
        public static final RosterObject<ItemBlanket> BLANKET_WHITE = RosterObject.of((String)"blanket_white");
        public static final RosterObject<ItemBlanket> BLANKET_ORANGE = RosterObject.of((String)"blanket_orange");
        public static final RosterObject<ItemBlanket> BLANKET_MAGENTA = RosterObject.of((String)"blanket_magenta");
        public static final RosterObject<ItemBlanket> BLANKET_LIGHT_BLUE = RosterObject.of((String)"blanket_light_blue");
        public static final RosterObject<ItemBlanket> BLANKET_YELLOW = RosterObject.of((String)"blanket_yellow");
        public static final RosterObject<ItemBlanket> BLANKET_LIME = RosterObject.of((String)"blanket_lime");
        public static final RosterObject<ItemBlanket> BLANKET_PINK = RosterObject.of((String)"blanket_pink");
        public static final RosterObject<ItemBlanket> BLANKET_GRAY = RosterObject.of((String)"blanket_gray");
        public static final RosterObject<ItemBlanket> BLANKET_LIGHT_GRAY = RosterObject.of((String)"blanket_light_gray");
        public static final RosterObject<ItemBlanket> BLANKET_CYAN = RosterObject.of((String)"blanket_cyan");
        public static final RosterObject<ItemBlanket> BLANKET_PURPLE = RosterObject.of((String)"blanket_purple");
        public static final RosterObject<ItemBlanket> BLANKET_BLUE = RosterObject.of((String)"blanket_blue");
        public static final RosterObject<ItemBlanket> BLANKET_BROWN = RosterObject.of((String)"blanket_brown");
        public static final RosterObject<ItemBlanket> BLANKET_GREEN = RosterObject.of((String)"blanket_green");
        public static final RosterObject<ItemBlanket> BLANKET_RED = RosterObject.of((String)"blanket_red");
        public static final RosterObject<ItemBlanket> BLANKET_BLACK = RosterObject.of((String)"blanket_black");
        private static final ImmutableMap<DyeColor, RosterObject<ItemBlanket>> BLANKET_MAP = ImmutableMap.builder().put((Object)DyeColor.WHITE, BLANKET_WHITE).put((Object)DyeColor.ORANGE, BLANKET_ORANGE).put((Object)DyeColor.MAGENTA, BLANKET_MAGENTA).put((Object)DyeColor.LIGHT_BLUE, BLANKET_LIGHT_BLUE).put((Object)DyeColor.YELLOW, BLANKET_YELLOW).put((Object)DyeColor.LIME, BLANKET_LIME).put((Object)DyeColor.PINK, BLANKET_PINK).put((Object)DyeColor.GRAY, BLANKET_GRAY).put((Object)DyeColor.LIGHT_GRAY, BLANKET_LIGHT_GRAY).put((Object)DyeColor.CYAN, BLANKET_CYAN).put((Object)DyeColor.PURPLE, BLANKET_PURPLE).put((Object)DyeColor.BLUE, BLANKET_BLUE).put((Object)DyeColor.BROWN, BLANKET_BROWN).put((Object)DyeColor.GREEN, BLANKET_GREEN).put((Object)DyeColor.RED, BLANKET_RED).put((Object)DyeColor.BLACK, BLANKET_BLACK).build();

        public static ItemBlanket getBlanket(DyeColor color) {
            return (ItemBlanket)((Object)((RosterObject)BLANKET_MAP.getOrDefault((Object)color, BLANKET_WHITE)).get());
        }
    }

    public static class Tiles {
        public static final RosterObject<BlockEntityType<TileEntityMultiBed>> BED = RosterObject.of((String)"bed");
        public static final RosterObject<BlockEntityType<TileEntityBedExtra>> BEXTRA = RosterObject.of((String)"bed_extras");
        public static final RosterObject<BlockEntityType<TileEntityRGB16>> RGB16 = RosterObject.of((String)"rgb16");
        public static final RosterObject<BlockEntityType<TileEntityLadder>> LADDER = RosterObject.of((String)"ladder");
    }

    public static class Blocks {
        public static final RosterObject<BlockMultiBed> CUSTOM = RosterObject.of((String)"custom");
        public static final RosterObject<BlockMultiBed> SLAB = RosterObject.of((String)"slab");
        public static final RosterObject<BlockMultiBed> COT = RosterObject.of((String)"cot");
        public static final RosterObject<BlockMultiBed> CLASSIC = RosterObject.of((String)"classic");
        public static final RosterObject<BlockMultiBed> VINTAGE = RosterObject.of((String)"vintage");
        public static final RosterObject<BlockMultiBed> MODERN = RosterObject.of((String)"modern");
        public static final RosterObject<BlockMultiBed> RUSTIC = RosterObject.of((String)"rustic");
        public static final RosterObject<BlockMultiBed> FUTURE = RosterObject.of((String)"future");
        public static final RosterObject<BlockMultiBed> CREW = RosterObject.of((String)"crew");
        public static final RosterObject<Block> BEXTRA = RosterObject.of((String)"bed_extras");
        public static final RosterObject<Block> HANGER = RosterObject.of((String)"hanger");
        public static final RosterObject<Block> LADDER = RosterObject.of((String)"ladder");
        public static final ImmutableMap<EnumBedStyle, RosterObject<BlockMultiBed>> BED_MAP = ImmutableMap.of((Object)((Object)EnumBedStyle.CUSTOM), CUSTOM, (Object)((Object)EnumBedStyle.SLAB), SLAB, (Object)((Object)EnumBedStyle.COT), COT, (Object)((Object)EnumBedStyle.CLASSIC), CLASSIC, (Object)((Object)EnumBedStyle.VINTAGE), VINTAGE, (Object)((Object)EnumBedStyle.MODERN), MODERN, (Object)((Object)EnumBedStyle.RUSTIC), RUSTIC, (Object)((Object)EnumBedStyle.FUTURE), FUTURE, (Object)((Object)EnumBedStyle.CREW), CREW);

        public static BlockMultiBed getBed(EnumBedStyle style) {
            return (BlockMultiBed)((RosterObject)BED_MAP.getOrDefault((Object)style, COT)).get();
        }
    }

    public static class Components {
        public static final RosterDataComponent<Texture> TEXTURE_DATA = RosterDataComponent.of((String)"texture", builder -> builder.persistent(Texture.CODEC));
        public static final RosterDataComponent<Bedding> BEDDING_DATA = RosterDataComponent.of((String)"bedding", builder -> builder.persistent(Bedding.CODEC));
        public static final RosterDataComponent<EnumBlanket.Pattern> PATTERN_DATA = RosterDataComponent.of((String)"pattern", builder -> builder.persistent(EnumBlanket.Pattern.CODEC));
        public static final RosterDataComponent<Artwork> ARTWORK_DATA = RosterDataComponent.of((String)"artwork", builder -> builder.persistent(Artwork.CODEC));
    }
}

