/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds;

import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import shetiphian.core.common.rgb16.BlockItemRGB16;
import shetiphian.core.common.rgb16.ImmutableRGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.rgb16.TileEntityRGB16;
import shetiphian.multibeds.CreativeTabs;
import shetiphian.multibeds.MultiBeds;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.common.block.BlockBedExtra;
import shetiphian.multibeds.common.block.BlockBunkLadder;
import shetiphian.multibeds.common.block.BlockHanger;
import shetiphian.multibeds.common.block.BlockMultiBed;
import shetiphian.multibeds.common.component.Bedding;
import shetiphian.multibeds.common.component.Texture;
import shetiphian.multibeds.common.crafting.RecipeSpool;
import shetiphian.multibeds.common.crafting.RecipeUncraft;
import shetiphian.multibeds.common.inventory.ContainerProviders;
import shetiphian.multibeds.common.item.ItemBedCustomization;
import shetiphian.multibeds.common.item.ItemBeddingPackage;
import shetiphian.multibeds.common.item.ItemBlanket;
import shetiphian.multibeds.common.item.ItemBlockLadder;
import shetiphian.multibeds.common.item.ItemBlockMultiBed;
import shetiphian.multibeds.common.item.ItemBuilderKit;
import shetiphian.multibeds.common.item.ItemEmbroideryThread;
import shetiphian.multibeds.common.item.ItemPillowSheet;
import shetiphian.multibeds.common.loot.BannerLootHandler;
import shetiphian.multibeds.common.misc.EnumBedStyle;
import shetiphian.multibeds.common.misc.EnumBlanket;
import shetiphian.multibeds.common.tileentity.TileEntityBedExtra;
import shetiphian.multibeds.common.tileentity.TileEntityLadder;
import shetiphian.multibeds.common.tileentity.TileEntityMultiBed;

final class Registration {
    Registration(IEventBus eventBus) {
        this.components(this.create(Registries.DATA_COMPONENT_TYPE, eventBus));
        this.blocks(this.create((Registry)BuiltInRegistries.BLOCK, eventBus));
        this.tiles(this.create(BuiltInRegistries.BLOCK_ENTITY_TYPE, eventBus));
        this.items(this.create((Registry)BuiltInRegistries.ITEM, eventBus));
        this.recipes(this.create(BuiltInRegistries.RECIPE_TYPE, eventBus));
        this.recipeSerializers(this.create(BuiltInRegistries.RECIPE_SERIALIZER, eventBus));
        this.containers(this.create(BuiltInRegistries.MENU, eventBus));
        this.lootModifiers(this.create(NeoForgeRegistries.GLOBAL_LOOT_MODIFIER_SERIALIZERS, eventBus));
        CreativeTabs.init(eventBus);
    }

    private <T> DeferredRegister<T> create(Registry<T> registry, IEventBus eventBus) {
        return this.create(registry.key(), eventBus);
    }

    private <T> DeferredRegister<T> create(ResourceKey<? extends Registry<T>> key, IEventBus eventBus) {
        DeferredRegister registry = DeferredRegister.create(key, (String)"multibeds");
        registry.register(eventBus);
        return registry;
    }

    private void components(DeferredRegister<DataComponentType<?>> reg) {
        Roster.Components.TEXTURE_DATA.wrap((id, builder) -> reg.register(id, () -> ((DataComponentType.Builder)builder).build()));
        Roster.Components.BEDDING_DATA.wrap((id, builder) -> reg.register(id, () -> ((DataComponentType.Builder)builder).build()));
        Roster.Components.PATTERN_DATA.wrap((id, builder) -> reg.register(id, () -> ((DataComponentType.Builder)builder).build()));
        Roster.Components.ARTWORK_DATA.wrap((id, builder) -> reg.register(id, () -> ((DataComponentType.Builder)builder).build()));
    }

    private void blocks(DeferredRegister<Block> reg) {
        Roster.Blocks.CUSTOM.wrap(id -> reg.register(id, () -> new BlockMultiBed(EnumBedStyle.CUSTOM)));
        Roster.Blocks.SLAB.wrap(id -> reg.register(id, () -> new BlockMultiBed(EnumBedStyle.SLAB)));
        Roster.Blocks.COT.wrap(id -> reg.register(id, () -> new BlockMultiBed(EnumBedStyle.COT)));
        Roster.Blocks.CLASSIC.wrap(id -> reg.register(id, () -> new BlockMultiBed(EnumBedStyle.CLASSIC)));
        Roster.Blocks.VINTAGE.wrap(id -> reg.register(id, () -> new BlockMultiBed(EnumBedStyle.VINTAGE)));
        Roster.Blocks.MODERN.wrap(id -> reg.register(id, () -> new BlockMultiBed(EnumBedStyle.MODERN)));
        Roster.Blocks.RUSTIC.wrap(id -> reg.register(id, () -> new BlockMultiBed(EnumBedStyle.RUSTIC)));
        Roster.Blocks.FUTURE.wrap(id -> reg.register(id, () -> new BlockMultiBed(EnumBedStyle.FUTURE)));
        Roster.Blocks.CREW.wrap(id -> reg.register(id, () -> new BlockMultiBed(EnumBedStyle.CREW)));
        Roster.Blocks.BEXTRA.wrap(id -> reg.register(id, BlockBedExtra::new));
        Roster.Blocks.HANGER.wrap(id -> reg.register(id, BlockHanger::new));
        Roster.Blocks.LADDER.wrap(id -> reg.register(id, BlockBunkLadder::new));
    }

    private void tiles(DeferredRegister<BlockEntityType<?>> reg) {
        Roster.Tiles.BED.wrap(id -> reg.register(id, () -> BlockEntityType.Builder.of(TileEntityMultiBed::new, (Block[])((Block[])Roster.Blocks.BED_MAP.values().stream().map(Supplier::get).toArray(Block[]::new))).build(null)));
        Roster.Tiles.BEXTRA.wrap(id -> reg.register(id, () -> BlockEntityType.Builder.of(TileEntityBedExtra::new, (Block[])new Block[]{(Block)Roster.Blocks.BEXTRA.get()}).build(null)));
        Roster.Tiles.RGB16.wrap(id -> reg.register(id, () -> BlockEntityType.Builder.of((pos, state) -> new TileEntityRGB16((BlockEntityType)Roster.Tiles.RGB16.get(), pos, state), (Block[])new Block[]{(Block)Roster.Blocks.HANGER.get()}).build(null)));
        Roster.Tiles.LADDER.wrap(id -> reg.register(id, () -> BlockEntityType.Builder.of(TileEntityLadder::new, (Block[])new Block[]{(Block)Roster.Blocks.LADDER.get()}).build(null)));
    }

    private void items(DeferredRegister<Item> reg) {
        Supplier<Item.Properties> propTextured = () -> Registration.property((DataComponentType)Roster.Components.TEXTURE_DATA.get(), Texture.DEFAULT);
        Roster.Items.CUSTOM.wrap(id -> reg.register(id, () -> Registration.lambda$items$36((Supplier)propTextured)));
        Roster.Items.SLAB.wrap(id -> reg.register(id, () -> Registration.lambda$items$38((Supplier)propTextured)));
        Roster.Items.COT.wrap(id -> reg.register(id, () -> Registration.lambda$items$40((Supplier)propTextured)));
        Roster.Items.CLASSIC.wrap(id -> reg.register(id, () -> Registration.lambda$items$42((Supplier)propTextured)));
        Roster.Items.VINTAGE.wrap(id -> reg.register(id, () -> Registration.lambda$items$44((Supplier)propTextured)));
        Roster.Items.MODERN.wrap(id -> reg.register(id, () -> Registration.lambda$items$46((Supplier)propTextured)));
        Roster.Items.RUSTIC.wrap(id -> reg.register(id, () -> Registration.lambda$items$48((Supplier)propTextured)));
        Roster.Items.FUTURE.wrap(id -> reg.register(id, () -> Registration.lambda$items$50((Supplier)propTextured)));
        Roster.Items.CREW.wrap(id -> reg.register(id, () -> Registration.lambda$items$52((Supplier)propTextured)));
        Roster.Items.HANGER.wrap(id -> reg.register(id, () -> new BlockItemRGB16((Block)Roster.Blocks.HANGER.get(), Registration.property(), DyeColor.WHITE).tint(new int[]{0})));
        Roster.Items.LADDER.wrap(id -> reg.register(id, () -> Registration.lambda$items$56((Supplier)propTextured)));
        Roster.Items.WOOLEN_CLOTH.wrap(id -> reg.register(id, () -> new Item(Registration.property())));
        Roster.Items.FEATHER_PILE.wrap(id -> reg.register(id, () -> new Item(Registration.property())));
        Roster.Items.PADDING.wrap(id -> reg.register(id, () -> new Item(Registration.property())));
        Roster.Items.BED_KIT.wrap(id -> reg.register(id, () -> new ItemBuilderKit.Bed(Registration.property())));
        Roster.Items.LADDER_TOOLS.wrap(id -> reg.register(id, () -> new ItemBuilderKit.Ladder(Registration.property())));
        Roster.Items.EMBROIDERY_THREAD.wrap(id -> reg.register(id, () -> new ItemEmbroideryThread(Registration.property().stacksTo(1))));
        Roster.Items.BEDDING_PACKAGE.wrap(id -> reg.register(id, () -> new ItemBeddingPackage(Registration.property((DataComponentType)Roster.Components.BEDDING_DATA.get(), Bedding.EMPTY))));
        Roster.Items.SHEET.wrap(id -> reg.register(id, () -> new ItemPillowSheet(Registration.property((DataComponentType)RGB16Helper.RGB16_DATA.get(), new ImmutableRGB16(4095)), ItemBedCustomization.EnumType.SHEET)));
        Roster.Items.PILLOW.wrap(id -> reg.register(id, () -> new ItemPillowSheet(Registration.property((DataComponentType)RGB16Helper.RGB16_DATA.get(), new ImmutableRGB16(4095)), ItemBedCustomization.EnumType.PILLOW)));
        Supplier<Item.Properties> propBlanket = () -> Registration.property((DataComponentType)Roster.Components.PATTERN_DATA.get(), EnumBlanket.Pattern.PLAIN);
        Roster.Items.BLANKET_WHITE.wrap(id -> reg.register(id, () -> Registration.lambda$items$77((Supplier)propBlanket)));
        Roster.Items.BLANKET_ORANGE.wrap(id -> reg.register(id, () -> Registration.lambda$items$79((Supplier)propBlanket)));
        Roster.Items.BLANKET_MAGENTA.wrap(id -> reg.register(id, () -> Registration.lambda$items$81((Supplier)propBlanket)));
        Roster.Items.BLANKET_LIGHT_BLUE.wrap(id -> reg.register(id, () -> Registration.lambda$items$83((Supplier)propBlanket)));
        Roster.Items.BLANKET_YELLOW.wrap(id -> reg.register(id, () -> Registration.lambda$items$85((Supplier)propBlanket)));
        Roster.Items.BLANKET_LIME.wrap(id -> reg.register(id, () -> Registration.lambda$items$87((Supplier)propBlanket)));
        Roster.Items.BLANKET_PINK.wrap(id -> reg.register(id, () -> Registration.lambda$items$89((Supplier)propBlanket)));
        Roster.Items.BLANKET_GRAY.wrap(id -> reg.register(id, () -> Registration.lambda$items$91((Supplier)propBlanket)));
        Roster.Items.BLANKET_LIGHT_GRAY.wrap(id -> reg.register(id, () -> Registration.lambda$items$93((Supplier)propBlanket)));
        Roster.Items.BLANKET_CYAN.wrap(id -> reg.register(id, () -> Registration.lambda$items$95((Supplier)propBlanket)));
        Roster.Items.BLANKET_PURPLE.wrap(id -> reg.register(id, () -> Registration.lambda$items$97((Supplier)propBlanket)));
        Roster.Items.BLANKET_BLUE.wrap(id -> reg.register(id, () -> Registration.lambda$items$99((Supplier)propBlanket)));
        Roster.Items.BLANKET_BROWN.wrap(id -> reg.register(id, () -> Registration.lambda$items$101((Supplier)propBlanket)));
        Roster.Items.BLANKET_GREEN.wrap(id -> reg.register(id, () -> Registration.lambda$items$103((Supplier)propBlanket)));
        Roster.Items.BLANKET_RED.wrap(id -> reg.register(id, () -> Registration.lambda$items$105((Supplier)propBlanket)));
        Roster.Items.BLANKET_BLACK.wrap(id -> reg.register(id, () -> Registration.lambda$items$107((Supplier)propBlanket)));
    }

    private static <T> Item.Properties property(DataComponentType<T> component, T fallback) {
        return Registration.property().component(component, fallback);
    }

    private static Item.Properties property() {
        return new Item.Properties();
    }

    private void recipes(DeferredRegister<RecipeType<?>> reg) {
        Roster.Recipes.SPOOLING.wrap(id -> reg.register(id, () -> RecipeType.simple((ResourceLocation)MultiBeds.RESOURCE.apply((String)id))));
        Roster.Recipes.UNCRAFT.wrap(id -> reg.register(id, () -> RecipeType.simple((ResourceLocation)MultiBeds.RESOURCE.apply((String)id))));
    }

    private void recipeSerializers(DeferredRegister<RecipeSerializer<?>> reg) {
        Roster.RecipeSerializers.SPOOLING.wrap(id -> reg.register(id, () -> new SimpleCraftingRecipeSerializer(RecipeSpool::new)));
        Roster.RecipeSerializers.UNCRAFT.wrap(id -> reg.register(id, () -> new SimpleCraftingRecipeSerializer(RecipeUncraft::new)));
    }

    private void containers(DeferredRegister<MenuType<?>> reg) {
        Roster.Containers.BED_KIT.wrap(id -> reg.register(id, () -> IMenuTypeExtension.create(ContainerProviders.BedKit::createMenu)));
        Roster.Containers.BLANKET_LOOM.wrap(id -> reg.register(id, () -> IMenuTypeExtension.create(ContainerProviders.BlanketLoom::createMenu)));
        Roster.Containers.LADDER_KIT.wrap(id -> reg.register(id, () -> IMenuTypeExtension.create(ContainerProviders.LadderKit::createMenu)));
    }

    private void lootModifiers(DeferredRegister<MapCodec<? extends IGlobalLootModifier>> reg) {
        BannerLootHandler.BANNER_EMBROIDERY.wrap(id -> reg.register(id, () -> BannerLootHandler.CODEC));
    }

    private static /* synthetic */ ItemBlanket lambda$items$107(Supplier propBlanket) {
        return new ItemBlanket((Item.Properties)propBlanket.get(), DyeColor.BLACK);
    }

    private static /* synthetic */ ItemBlanket lambda$items$105(Supplier propBlanket) {
        return new ItemBlanket((Item.Properties)propBlanket.get(), DyeColor.RED);
    }

    private static /* synthetic */ ItemBlanket lambda$items$103(Supplier propBlanket) {
        return new ItemBlanket((Item.Properties)propBlanket.get(), DyeColor.GREEN);
    }

    private static /* synthetic */ ItemBlanket lambda$items$101(Supplier propBlanket) {
        return new ItemBlanket((Item.Properties)propBlanket.get(), DyeColor.BROWN);
    }

    private static /* synthetic */ ItemBlanket lambda$items$99(Supplier propBlanket) {
        return new ItemBlanket((Item.Properties)propBlanket.get(), DyeColor.BLUE);
    }

    private static /* synthetic */ ItemBlanket lambda$items$97(Supplier propBlanket) {
        return new ItemBlanket((Item.Properties)propBlanket.get(), DyeColor.PURPLE);
    }

    private static /* synthetic */ ItemBlanket lambda$items$95(Supplier propBlanket) {
        return new ItemBlanket((Item.Properties)propBlanket.get(), DyeColor.CYAN);
    }

    private static /* synthetic */ ItemBlanket lambda$items$93(Supplier propBlanket) {
        return new ItemBlanket((Item.Properties)propBlanket.get(), DyeColor.LIGHT_GRAY);
    }

    private static /* synthetic */ ItemBlanket lambda$items$91(Supplier propBlanket) {
        return new ItemBlanket((Item.Properties)propBlanket.get(), DyeColor.GRAY);
    }

    private static /* synthetic */ ItemBlanket lambda$items$89(Supplier propBlanket) {
        return new ItemBlanket((Item.Properties)propBlanket.get(), DyeColor.PINK);
    }

    private static /* synthetic */ ItemBlanket lambda$items$87(Supplier propBlanket) {
        return new ItemBlanket((Item.Properties)propBlanket.get(), DyeColor.LIME);
    }

    private static /* synthetic */ ItemBlanket lambda$items$85(Supplier propBlanket) {
        return new ItemBlanket((Item.Properties)propBlanket.get(), DyeColor.YELLOW);
    }

    private static /* synthetic */ ItemBlanket lambda$items$83(Supplier propBlanket) {
        return new ItemBlanket((Item.Properties)propBlanket.get(), DyeColor.LIGHT_BLUE);
    }

    private static /* synthetic */ ItemBlanket lambda$items$81(Supplier propBlanket) {
        return new ItemBlanket((Item.Properties)propBlanket.get(), DyeColor.MAGENTA);
    }

    private static /* synthetic */ ItemBlanket lambda$items$79(Supplier propBlanket) {
        return new ItemBlanket((Item.Properties)propBlanket.get(), DyeColor.ORANGE);
    }

    private static /* synthetic */ ItemBlanket lambda$items$77(Supplier propBlanket) {
        return new ItemBlanket((Item.Properties)propBlanket.get(), DyeColor.WHITE);
    }

    private static /* synthetic */ BlockItem lambda$items$56(Supplier propTextured) {
        return new ItemBlockLadder((Block)Roster.Blocks.LADDER.get(), (Item.Properties)propTextured.get());
    }

    private static /* synthetic */ BlockItem lambda$items$52(Supplier propTextured) {
        return new ItemBlockMultiBed((Block)Roster.Blocks.CREW.get(), (Item.Properties)propTextured.get());
    }

    private static /* synthetic */ BlockItem lambda$items$50(Supplier propTextured) {
        return new ItemBlockMultiBed((Block)Roster.Blocks.FUTURE.get(), (Item.Properties)propTextured.get());
    }

    private static /* synthetic */ BlockItem lambda$items$48(Supplier propTextured) {
        return new ItemBlockMultiBed((Block)Roster.Blocks.RUSTIC.get(), (Item.Properties)propTextured.get());
    }

    private static /* synthetic */ BlockItem lambda$items$46(Supplier propTextured) {
        return new ItemBlockMultiBed((Block)Roster.Blocks.MODERN.get(), (Item.Properties)propTextured.get());
    }

    private static /* synthetic */ BlockItem lambda$items$44(Supplier propTextured) {
        return new ItemBlockMultiBed((Block)Roster.Blocks.VINTAGE.get(), (Item.Properties)propTextured.get());
    }

    private static /* synthetic */ BlockItem lambda$items$42(Supplier propTextured) {
        return new ItemBlockMultiBed((Block)Roster.Blocks.CLASSIC.get(), (Item.Properties)propTextured.get());
    }

    private static /* synthetic */ BlockItem lambda$items$40(Supplier propTextured) {
        return new ItemBlockMultiBed((Block)Roster.Blocks.COT.get(), (Item.Properties)propTextured.get());
    }

    private static /* synthetic */ BlockItem lambda$items$38(Supplier propTextured) {
        return new ItemBlockMultiBed((Block)Roster.Blocks.SLAB.get(), (Item.Properties)propTextured.get());
    }

    private static /* synthetic */ BlockItem lambda$items$36(Supplier propTextured) {
        return new ItemBlockMultiBed((Block)Roster.Blocks.CUSTOM.get(), (Item.Properties)propTextured.get());
    }
}

