/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds;

import net.minecraft.world.InteractionResult;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import shetiphian.multibeds.ConfigLoader;
import shetiphian.multibeds.Registration;
import shetiphian.multibeds.common.EventHandler;
import shetiphian.multibeds.modintegration.ModIntegration;
import shetiphian.multibeds.network.NetworkHandler;

@Mod(value="multibeds")
public final class ModMain {
    public ModMain(ModContainer modContainer, IEventBus modEventBus) {
        new Registration(modEventBus);
        new ConfigLoader(modContainer, modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(NetworkHandler::initialise);
        modEventBus.addListener(InterModEnqueueEvent.class, event -> ModIntegration.INSTANCE.init());
        NeoForge.EVENT_BUS.register((Object)new EventRelay());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        EventHandler.injectBedPOI();
    }

    private static class EventRelay
    extends EventHandler {
        private EventRelay() {
        }

        @SubscribeEvent
        public void playerRightClickBlockEvent(PlayerInteractEvent.RightClickBlock event) {
            if (this.onPlayerRightClickBlock(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec()).consumesAction()) {
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public void playerRightClickItemEvent(PlayerInteractEvent.RightClickItem event) {
            if (this.onPlayerRightClickItem(event.getEntity(), event.getLevel(), event.getHand()).getResult().consumesAction()) {
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        }
    }
}

