/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.config;

import com.sonicether.soundphysics.Loggers;
import com.sonicether.soundphysics.config.ConfigUtils;
import de.maxhenkel.sound_physics_remastered.configbuilder.CommentedProperties;
import de.maxhenkel.sound_physics_remastered.configbuilder.CommentedPropertyConfig;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class AllowedSoundConfig
extends CommentedPropertyConfig {
    private Map<String, Boolean> allowedSounds;

    public AllowedSoundConfig(Path path) {
        super(new CommentedProperties(false));
        this.path = path;
        this.reload();
    }

    @Override
    public void load() throws IOException {
        super.load();
        Map<String, Boolean> map = this.createDefaultMap();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            boolean value;
            String key = entry.getKey();
            try {
                value = Boolean.parseBoolean(entry.getValue());
            }
            catch (Exception e) {
                Loggers.warn("Failed to set allowed sound entry {}", key);
                continue;
            }
            ResourceLocation resourceLocation = ResourceLocation.tryParse((String)key);
            if (resourceLocation == null) {
                Loggers.warn("Failed to set allowed sound entry {}", key);
                continue;
            }
            if (!resourceLocation.getNamespace().equals("voicechat")) {
                this.logIfUnknownSound(resourceLocation);
            }
            map.put(resourceLocation.toString(), value);
        }
        this.allowedSounds = ConfigUtils.sortMap(map);
        this.saveSync();
    }

    private void logIfUnknownSound(ResourceLocation resourceLocation) {
        try {
            SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(resourceLocation);
            if (soundEvent == null) {
                Loggers.log("Unknown sound in allowed sound config: {}", resourceLocation);
            }
        }
        catch (Exception e) {
            Loggers.warn("Failed to parse allowed sound entry {}", resourceLocation, e);
        }
    }

    @Override
    public void saveSync() {
        this.properties.clear();
        this.properties.addHeaderComment("Allowed sounds");
        this.properties.addHeaderComment("Set to 'false' to disable sound physics for that sound");
        for (Map.Entry<String, Boolean> entry : this.allowedSounds.entrySet()) {
            this.properties.set(entry.getKey(), String.valueOf(entry.getValue()), new String[0]);
        }
        super.saveSync();
    }

    public Map<String, Boolean> getAllowedSounds() {
        return this.allowedSounds;
    }

    public boolean isAllowed(String soundEvent) {
        return this.allowedSounds.getOrDefault(soundEvent, true);
    }

    public Map<String, Boolean> createDefaultMap() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (SoundEvent event : BuiltInRegistries.SOUND_EVENT) {
            map.put(event.getLocation().toString(), true);
        }
        map.put(SoundEvents.WEATHER_RAIN.getLocation().toString(), false);
        map.put(SoundEvents.WEATHER_RAIN_ABOVE.getLocation().toString(), false);
        map.put(SoundEvents.LIGHTNING_BOLT_THUNDER.getLocation().toString(), false);
        SoundEvents.GOAT_HORN_SOUND_VARIANTS.forEach(r -> map.put(r.key().location().toString(), false));
        return map;
    }
}

