/*
 * Decompiled with CFR 0.152.
 */
package net.combat_roll.network;

import com.google.gson.Gson;
import net.combat_roll.client.RollEffect;
import net.combat_roll.config.ServerConfig;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class Packets {

    public record Ack(String code) implements CustomPacketPayload
    {
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"combat_roll", (String)"ack");
        public static final CustomPacketPayload.Type<Ack> PACKET_ID = new CustomPacketPayload.Type(ID);
        public static final StreamCodec<FriendlyByteBuf, Ack> CODEC = StreamCodec.ofMember(Ack::write, Ack::read);

        public void write(FriendlyByteBuf buffer) {
            buffer.writeUtf(this.code);
        }

        public static Ack read(FriendlyByteBuf buffer) {
            String code = buffer.readUtf();
            return new Ack(code);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }

    public record ConfigSync(String json) implements CustomPacketPayload
    {
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"combat_roll", (String)"config_sync");
        public static final CustomPacketPayload.Type<ConfigSync> PACKET_ID = new CustomPacketPayload.Type(ID);
        public static final StreamCodec<FriendlyByteBuf, ConfigSync> CODEC = StreamCodec.ofMember(ConfigSync::write, ConfigSync::read);
        private static final Gson gson = new Gson();

        public static String serialize(ServerConfig config) {
            return gson.toJson((Object)config);
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeUtf(this.json);
        }

        public static ConfigSync read(FriendlyByteBuf buffer) {
            String json = buffer.readUtf();
            return new ConfigSync(json);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }

    public record RollAnimation(int playerId, RollEffect.Visuals visuals, Vec3 velocity) implements CustomPacketPayload
    {
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"combat_roll", (String)"animation");
        public static final CustomPacketPayload.Type<RollAnimation> PACKET_ID = new CustomPacketPayload.Type(ID);
        public static final StreamCodec<RegistryFriendlyByteBuf, RollAnimation> CODEC = StreamCodec.ofMember(RollAnimation::write, RollAnimation::read);

        public static RollAnimation read(RegistryFriendlyByteBuf buffer) {
            int playerId = buffer.readInt();
            RollEffect.Visuals visuals = new RollEffect.Visuals(buffer.readUtf(), RollEffect.Particles.valueOf(buffer.readUtf()));
            Vec3 velocity = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            return new RollAnimation(playerId, visuals, velocity);
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeInt(this.playerId);
            buffer.writeUtf(this.visuals.animationName());
            buffer.writeUtf(this.visuals.particles().toString());
            buffer.writeDouble(this.velocity.x);
            buffer.writeDouble(this.velocity.y);
            buffer.writeDouble(this.velocity.z);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }

    public record RollPublish(int playerId, RollEffect.Visuals visuals, Vec3 velocity) implements CustomPacketPayload
    {
        public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"combat_roll", (String)"publish");
        public static final CustomPacketPayload.Type<RollPublish> PACKET_ID = new CustomPacketPayload.Type(ID);
        public static final StreamCodec<RegistryFriendlyByteBuf, RollPublish> CODEC = StreamCodec.ofMember(RollPublish::write, RollPublish::read);

        public static RollPublish read(RegistryFriendlyByteBuf buffer) {
            int playerId = buffer.readInt();
            RollEffect.Visuals visuals = new RollEffect.Visuals(buffer.readUtf(), RollEffect.Particles.valueOf(buffer.readUtf()));
            Vec3 velocity = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
            return new RollPublish(playerId, visuals, velocity);
        }

        public void write(RegistryFriendlyByteBuf buffer) {
            buffer.writeInt(this.playerId);
            buffer.writeUtf(this.visuals.animationName());
            buffer.writeUtf(this.visuals.particles().toString());
            buffer.writeDouble(this.velocity.x);
            buffer.writeDouble(this.velocity.y);
            buffer.writeDouble(this.velocity.z);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return PACKET_ID;
        }
    }
}

