/*
 * Decompiled with CFR 0.152.
 */
package net.combat_roll.internals;

import net.combat_roll.CombatRollMod;
import net.combat_roll.api.CombatRoll;
import net.combat_roll.client.CombatRollClient;
import net.combat_roll.mixin.PlayerEntityAccessor;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class RollManager {
    public boolean isEnabled = true;
    private int timeSinceLastRoll = 10;
    private int currentCooldownProgress = 0;
    private int currentCooldownLength = 0;
    private int maxRolls = 1;
    private int availableRolls = 0;

    public static int rollDuration() {
        return CombatRollMod.config.roll_duration;
    }

    public CooldownInfo getCooldown() {
        return new CooldownInfo(this.currentCooldownProgress, this.currentCooldownLength, this.availableRolls, this.maxRolls);
    }

    public boolean isRollAvailable(Player player) {
        return this.isEnabled && !this.isRolling() && this.availableRolls > 0 && !((PlayerEntityAccessor)player).invokeIsImmobile_combat_roll() && player.isEffectiveAi() && player.getAttributeValue(Attributes.MOVEMENT_SPEED) > 0.0;
    }

    public boolean isRolling() {
        return this.timeSinceLastRoll <= RollManager.rollDuration();
    }

    public void onRoll(LocalPlayer player) {
        --this.availableRolls;
        this.timeSinceLastRoll = 0;
        this.updateCooldownLength(player);
    }

    public void tick(LocalPlayer player) {
        this.maxRolls = (int)player.getAttributeValue(CombatRoll.Attributes.COUNT.entry);
        ++this.timeSinceLastRoll;
        if (this.availableRolls < this.maxRolls) {
            ++this.currentCooldownProgress;
            if (this.currentCooldownProgress >= this.currentCooldownLength) {
                this.rechargeRoll(player);
            }
        }
        if (this.availableRolls == this.maxRolls) {
            this.currentCooldownProgress = 0;
        }
        if (this.availableRolls > this.maxRolls) {
            this.availableRolls = this.maxRolls;
        }
    }

    private void rechargeRoll(LocalPlayer player) {
        SoundEvent cooldownReady;
        ++this.availableRolls;
        this.currentCooldownProgress = 0;
        this.updateCooldownLength(player);
        if (CombatRollClient.config.playCooldownSound && (cooldownReady = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"combat_roll:roll_cooldown_ready"))) != null) {
            player.level().playLocalSound(player.getX(), player.getY(), player.getZ(), cooldownReady, SoundSource.PLAYERS, 1.0f, 1.0f, false);
        }
    }

    private void updateCooldownLength(LocalPlayer player) {
        float duration = CombatRollMod.config.roll_cooldown;
        this.currentCooldownLength = (int)Math.round((double)(duration * 20.0f) * (20.0 / player.getAttributeValue(CombatRoll.Attributes.RECHARGE.entry)));
    }

    public record CooldownInfo(int elapsed, int total, int availableRolls, int maxRolls) {
    }
}

