/*
 * Decompiled with CFR 0.152.
 */
package net.combat_roll.client;

import java.util.Random;
import net.combat_roll.client.CombatRollClient;
import net.combat_roll.client.animation.AnimatablePlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public record RollEffect(Visuals visuals, String soundId) {
    private static Random random = new Random();

    public static void playVisuals(Visuals visuals, Player player, Vec3 direction) {
        SoundEvent sound;
        ((AnimatablePlayer)player).playRollAnimation(visuals.animationName(), direction);
        if (CombatRollClient.config.playRollSound && (sound = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"combat_roll:roll"))) != null) {
            player.level().playLocalSound(player.getX(), player.getY(), player.getZ(), sound, SoundSource.PLAYERS, 1.0f, 1.0f, true);
        }
        switch (visuals.particles().ordinal()) {
            case 0: {
                for (int i = 0; i < 15; ++i) {
                    double d = random.nextGaussian() * 0.02;
                    double e = random.nextGaussian() * 0.02;
                    double f = random.nextGaussian() * 0.02;
                    player.level().addParticle((ParticleOptions)ParticleTypes.POOF, player.getRandomX(1.5), player.getY(random.nextGaussian() * 0.3), player.getRandomZ(1.5), d, e, f);
                }
                break;
            }
        }
    }

    public record Visuals(String animationName, Particles particles) {
    }

    public static enum Particles {
        PUFF;

    }
}

