/*
 * Decompiled with CFR 0.152.
 */
package net.combat_roll.api;

import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import org.jetbrains.annotations.Nullable;

public class CombatRoll {
    public static final String NAMESPACE = "combat_roll";

    public static class Attributes {
        public static final ArrayList<Entry> all = new ArrayList();
        public static final Entry DISTANCE = Attributes.entry("distance", 3.0, 1.0, 24.0, true);
        public static final Entry RECHARGE = Attributes.entry("recharge", 20.0, 0.1, 200.0, true);
        public static final Entry COUNT = Attributes.entry("count", 1.0, 0.0, 20.0, true);

        private static Entry entry(String name, double baseValue, double minValue, double maxValue, boolean tracked) {
            Entry entry = new Entry(name, baseValue, minValue, maxValue, tracked);
            all.add(entry);
            return entry;
        }

        public static class Entry {
            public final ResourceLocation id;
            public final String translationKey;
            public final Attribute attribute;
            public final double baseValue;
            @Nullable
            public Holder<Attribute> entry;

            public Entry(String name, double baseValue, double minValue, double maxValue, boolean tracked) {
                this.id = ResourceLocation.fromNamespaceAndPath((String)CombatRoll.NAMESPACE, (String)name);
                this.translationKey = "attribute.name.combat_roll." + name;
                this.attribute = new RangedAttribute(this.translationKey, baseValue, minValue, maxValue).setSyncable(tracked);
                this.baseValue = baseValue;
            }

            public void register() {
                this.entry = Registry.registerForHolder((Registry)BuiltInRegistries.ATTRIBUTE, (ResourceLocation)this.id, (Object)this.attribute);
            }
        }
    }
}

