/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.util.rituals;

import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.alshanex.alshanex_familiars.AlshanexFamiliarsMod;
import net.alshanex.alshanex_familiars.block.entity.FamiliarStatueEntity;
import net.alshanex.alshanex_familiars.compat.ItemMultiSet;
import net.alshanex.alshanex_familiars.recipe_types.RitualRecipeType;
import net.alshanex.alshanex_familiars.registry.RecipeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class RitualHelper {
    public static boolean isValidRecipe(Level level, BlockPos centralPos, ItemStack stack) {
        if (stack == null || level == null) {
            return false;
        }
        List<BlockEntity> surroundingPedestals = RitualHelper.getSurroundingPedestals(centralPos, level);
        AlshanexFamiliarsMod.LOGGER.debug("Found pedestals: " + surroundingPedestals.size());
        if (surroundingPedestals.size() < 4) {
            AlshanexFamiliarsMod.LOGGER.debug("Not enough pedestals! Need 4, found: " + surroundingPedestals.size());
            return false;
        }
        ItemMultiSet pedestalItems = RitualHelper.getItemsFromPedestals(surroundingPedestals);
        AlshanexFamiliarsMod.LOGGER.debug("Pedestal items: " + String.valueOf(pedestalItems));
        RecipeManager manager = level.getRecipeManager();
        Optional<ItemStack> ritualRecipe = manager.getAllRecipesFor((RecipeType)RecipeRegistry.RITUAL_RECIPE_TYPE.get()).stream().map(RecipeHolder::value).filter(ritualRecipeInstance -> ItemStack.isSameItemSameComponents((ItemStack)Arrays.stream(ritualRecipeInstance.centralItem().getItems()).findFirst().orElse(ItemStack.EMPTY), (ItemStack)stack) && Objects.equals(pedestalItems, ritualRecipeInstance.inputItems())).map(RitualRecipeType::result).findFirst();
        return ritualRecipe.isPresent();
    }

    public static List<BlockEntity> getSurroundingPedestals(BlockPos origin, Level level) {
        BlockPos[] offsets = new BlockPos[]{origin.north(2), origin.south(2), origin.east(2), origin.west(2)};
        ArrayList<BlockEntity> pedestals = new ArrayList<BlockEntity>();
        for (BlockPos pos : offsets) {
            FamiliarStatueEntity pedestal;
            BlockEntity entity = level.getBlockEntity(pos);
            if (!(entity instanceof FamiliarStatueEntity) || !(entity instanceof FamiliarStatueEntity) || (pedestal = (FamiliarStatueEntity)entity).getHeldItem() == ItemStack.EMPTY) continue;
            pedestals.add(pedestal);
        }
        return pedestals;
    }

    public static void spawnParticlesAtPedestals(ParticleOptions particles, BlockPos origin, Level pLevel) {
        if (!pLevel.isClientSide()) {
            BlockPos[] offsets = new BlockPos[]{origin.north(2), origin.south(2), origin.east(2), origin.west(2)};
            MagicManager.spawnParticles((Level)pLevel, (ParticleOptions)particles, (double)origin.getX(), (double)(origin.getY() + 2), (double)origin.getZ(), (int)25, (double)0.4, (double)0.8, (double)0.4, (double)0.03, (boolean)false);
            for (BlockPos pos : offsets) {
                MagicManager.spawnParticles((Level)pLevel, (ParticleOptions)particles, (double)pos.getX(), (double)(pos.getY() + 2), (double)pos.getZ(), (int)25, (double)0.4, (double)0.8, (double)0.4, (double)0.03, (boolean)false);
            }
        }
    }

    public static ItemMultiSet getItemsFromPedestals(List<BlockEntity> surroundingPedestals) {
        ItemMultiSet pedestalItems = new ItemMultiSet();
        for (BlockEntity pedestal : surroundingPedestals) {
            if (!(pedestal instanceof FamiliarStatueEntity)) continue;
            FamiliarStatueEntity statue = (FamiliarStatueEntity)pedestal;
            pedestalItems.add(statue.getHeldItem().getItem());
        }
        return pedestalItems;
    }

    public static void clearItemsFromPedestals(Level level, BlockPos pos) {
        for (BlockEntity pedestal : RitualHelper.getSurroundingPedestals(pos, level)) {
            if (!(pedestal instanceof FamiliarStatueEntity)) continue;
            FamiliarStatueEntity statue = (FamiliarStatueEntity)pedestal;
            BlockState prevState = statue.getBlockState();
            statue.setHeldItem(ItemStack.EMPTY);
            BlockState nextState = statue.getBlockState();
            level.sendBlockUpdated(statue.getBlockPos(), prevState, nextState, 2);
        }
    }

    public static Item getResultForRecipe(Level level, BlockPos centerPos, ItemStack stack) {
        if (stack == null || level == null) {
            return ItemStack.EMPTY.getItem();
        }
        List<BlockEntity> surroundingPedestals = RitualHelper.getSurroundingPedestals(centerPos, level);
        ItemMultiSet pedestalItems = RitualHelper.getItemsFromPedestals(surroundingPedestals);
        RecipeManager manager = level.getRecipeManager();
        Optional<ItemStack> ritualRecipe = manager.getAllRecipesFor((RecipeType)RecipeRegistry.RITUAL_RECIPE_TYPE.get()).stream().map(RecipeHolder::value).filter(ritualRecipeInstance -> ItemStack.isSameItemSameComponents((ItemStack)Arrays.stream(ritualRecipeInstance.centralItem().getItems()).findFirst().orElse(ItemStack.EMPTY), (ItemStack)stack) && Objects.equals(pedestalItems, ritualRecipeInstance.inputItems())).map(RitualRecipeType::result).findFirst();
        return ritualRecipe.map(ItemStack::getItem).orElseGet(() -> ((ItemStack)ItemStack.EMPTY).getItem());
    }

    public static boolean isItemInRecipeRecipe(Level level, ItemStack stack) {
        if (stack == null || level == null) {
            return false;
        }
        RecipeManager manager = level.getRecipeManager();
        Optional<Ingredient> ritualRecipe = manager.getAllRecipesFor((RecipeType)RecipeRegistry.RITUAL_RECIPE_TYPE.get()).stream().map(RecipeHolder::value).map(RitualRecipeType::centralItem).filter(ingredient -> ItemStack.isSameItemSameComponents((ItemStack)Arrays.stream(ingredient.getItems()).findFirst().orElse(ItemStack.EMPTY), (ItemStack)stack)).findAny();
        return ritualRecipe.isPresent();
    }

    public static ParticleOptions getParticleForRecipe(Level level, BlockPos centerPos, ItemStack stack) {
        Object object;
        SimpleParticleType particles = ParticleTypes.ENCHANT;
        if (stack == null || level == null) {
            return particles;
        }
        List<BlockEntity> surroundingPedestals = RitualHelper.getSurroundingPedestals(centerPos, level);
        ItemMultiSet pedestalItems = RitualHelper.getItemsFromPedestals(surroundingPedestals);
        RecipeManager manager = level.getRecipeManager();
        Optional<RitualRecipeType> recipe = manager.getAllRecipesFor((RecipeType)RecipeRegistry.RITUAL_RECIPE_TYPE.get()).stream().map(RecipeHolder::value).filter(ritualRecipeInstance -> ItemStack.isSameItemSameComponents((ItemStack)Arrays.stream(ritualRecipeInstance.centralItem().getItems()).findFirst().orElse(ItemStack.EMPTY), (ItemStack)stack) && Objects.equals(pedestalItems, ritualRecipeInstance.inputItems())).findFirst();
        if (recipe.isPresent() && recipe.get().defaultParticle() != null && (object = recipe.get().defaultParticle().value()) instanceof SimpleParticleType) {
            SimpleParticleType simpleParticleType;
            particles = simpleParticleType = (SimpleParticleType)object;
        }
        return particles;
    }
}

