/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.util.familiars;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record SelectedFamiliarsComponent(Set<UUID> selectedFamiliars) {
    public static final Codec<SelectedFamiliarsComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)Codec.STRING.xmap(UUID::fromString, UUID::toString)).xmap(HashSet::new, list -> list.stream().toList()).fieldOf("selected_familiars").forGetter(component -> new HashSet<UUID>(component.selectedFamiliars()))).apply((Applicative)instance, SelectedFamiliarsComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SelectedFamiliarsComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.collection(HashSet::new, (StreamCodec)ByteBufCodecs.STRING_UTF8.map(UUID::fromString, UUID::toString)).map(set -> set, set -> new HashSet(set)), SelectedFamiliarsComponent::selectedFamiliars, SelectedFamiliarsComponent::new);

    public SelectedFamiliarsComponent() {
        this(new HashSet<UUID>());
    }

    public Set<UUID> getSelectedFamiliars() {
        return new HashSet<UUID>(this.selectedFamiliars);
    }

    public SelectedFamiliarsComponent withFamiliar(UUID familiarId) {
        HashSet<UUID> newSet = new HashSet<UUID>(this.selectedFamiliars);
        newSet.add(familiarId);
        return new SelectedFamiliarsComponent(newSet);
    }

    public SelectedFamiliarsComponent withoutFamiliar(UUID familiarId) {
        HashSet<UUID> newSet = new HashSet<UUID>(this.selectedFamiliars);
        newSet.remove(familiarId);
        return new SelectedFamiliarsComponent(newSet);
    }

    public boolean contains(UUID familiarId) {
        return this.selectedFamiliars.contains(familiarId);
    }

    public int size() {
        return this.selectedFamiliars.size();
    }

    public boolean canAddMore() {
        return this.selectedFamiliars.size() < 10;
    }
}

