/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.util.familiars;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.alshanex.alshanex_familiars.AlshanexFamiliarsMod;
import net.alshanex.alshanex_familiars.item.PandoraBox;
import net.alshanex.alshanex_familiars.network.FamiliarDeathPacket;
import net.alshanex.alshanex_familiars.network.OpenFamiliarSelectionPacket;
import net.alshanex.alshanex_familiars.network.OpenPandoraBoxScreenPacket;
import net.alshanex.alshanex_familiars.network.ReloadFamiliarScreenPacket;
import net.alshanex.alshanex_familiars.screen.FamiliarSelectionScreen;
import net.alshanex.alshanex_familiars.screen.PandoraBoxScreen;
import net.alshanex.alshanex_familiars.util.PandoraUtils;
import net.alshanex.familiarslib.data.BedLinkData;
import net.alshanex.familiarslib.data.PlayerFamiliarData;
import net.alshanex.familiarslib.entity.AbstractSpellCastingPet;
import net.alshanex.familiarslib.network.SyncBedLinkDataPacket;
import net.alshanex.familiarslib.registry.AttachmentRegistry;
import net.alshanex.familiarslib.screen.BedLinkSelectionScreen;
import net.alshanex.familiarslib.util.familiars.FamiliarManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

public class AlshanexFamiliarManager {
    public static void handleFamiliarDeath(AbstractSpellCastingPet familiar, ServerPlayer player) {
        UUID familiarId = familiar.getUUID();
        AlshanexFamiliarsMod.LOGGER.info("Handling familiar death for familiar {} owned by player {}", (Object)familiarId, (Object)player.getName().getString());
        try {
            PlayerFamiliarData familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
            BedLinkData bedLinkData = (BedLinkData)player.getData(AttachmentRegistry.BED_LINK_DATA);
            if (!familiarData.hasFamiliar(familiarId)) {
                AlshanexFamiliarsMod.LOGGER.warn("Familiar {} not found in player {} data during death handling", (Object)familiarId, (Object)player.getName().getString());
                return;
            }
            FamiliarManager.markFamiliarAsDead((UUID)familiarId);
            familiarData.removeTamedFamiliar(familiarId);
            bedLinkData.unlinkFamiliar(familiarId);
            AlshanexFamiliarManager.cleanFamiliarFromPandoraBox(player, familiarId);
            UUID newSelectedFamiliarId = null;
            if (familiarId.equals(familiarData.getSelectedFamiliarId())) {
                Map availableFamiliars = familiarData.getAllFamiliars();
                if (!availableFamiliars.isEmpty()) {
                    newSelectedFamiliarId = (UUID)availableFamiliars.keySet().iterator().next();
                    familiarData.setSelectedFamiliarId(newSelectedFamiliarId);
                    AlshanexFamiliarsMod.LOGGER.info("Selected new familiar {} after death of {}", (Object)newSelectedFamiliarId, (Object)familiarId);
                } else {
                    familiarData.setSelectedFamiliarId(null);
                    AlshanexFamiliarsMod.LOGGER.info("No familiars available, cleared selection after death of {}", (Object)familiarId);
                }
            }
            Map remainingFamiliars = familiarData.getAllFamiliars();
            UUID currentSummonedFamiliarId = familiarData.getCurrentSummonedFamiliarId();
            CompoundTag familiarSyncData = familiarData.serializeNBT((HolderLookup.Provider)player.registryAccess());
            CompoundTag bedLinkSyncData = bedLinkData.serializeNBT((HolderLookup.Provider)player.registryAccess());
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new FamiliarDeathPacket(familiarId, remainingFamiliars, newSelectedFamiliarId, currentSummonedFamiliarId, familiarSyncData, bedLinkSyncData), (CustomPacketPayload[])new CustomPacketPayload[0]);
            AlshanexFamiliarsMod.LOGGER.debug("Successfully processed death of familiar {} for player {}. {} familiars remaining.", new Object[]{familiarId, player.getName().getString(), remainingFamiliars.size()});
        }
        catch (Exception e) {
            AlshanexFamiliarsMod.LOGGER.error("Error handling familiar death for familiar {} and player {}: ", new Object[]{familiarId, player.getName().getString(), e});
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openFamiliarSelectionScreen() {
        Minecraft.getInstance().setScreen((Screen)new FamiliarSelectionScreen());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void openPandoraBoxScreen() {
        Minecraft.getInstance().setScreen((Screen)new PandoraBoxScreen());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleFamiliarDeathPacket(UUID deadFamiliarId, Map<UUID, CompoundTag> remainingFamiliars, UUID newSelectedFamiliarId, UUID currentSummonedFamiliarId, CompoundTag familiarData, CompoundTag bedLinkData) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            AlshanexFamiliarsMod.LOGGER.info("Client received familiar death packet for familiar: {}", (Object)deadFamiliarId);
            PlayerFamiliarData playerFamiliarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
            BedLinkData playerBedLinkData = (BedLinkData)player.getData(AttachmentRegistry.BED_LINK_DATA);
            boolean wasRemoved = playerFamiliarData.hasFamiliar(deadFamiliarId);
            if (wasRemoved) {
                playerFamiliarData.removeTamedFamiliar(deadFamiliarId);
                AlshanexFamiliarsMod.LOGGER.info("Removed dead familiar {} from client data", (Object)deadFamiliarId);
            }
            playerFamiliarData.deserializeNBT((HolderLookup.Provider)player.registryAccess(), familiarData);
            playerBedLinkData.deserializeNBT((HolderLookup.Provider)player.registryAccess(), bedLinkData);
            AlshanexFamiliarsMod.LOGGER.info("Updated client data - Remaining familiars: {}, New selected: {}, Current summoned: {}", new Object[]{remainingFamiliars.size(), newSelectedFamiliarId, currentSummonedFamiliarId});
            AlshanexFamiliarManager.cleanFamiliarFromPandoraBoxClient((Player)player, deadFamiliarId);
            AlshanexFamiliarManager.updateScreensAfterDeath(deadFamiliarId);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void updateScreensAfterDeath(UUID deadFamiliarId) {
        try {
            PlayerFamiliarData familiarData;
            Screen player;
            Screen screen = Minecraft.getInstance().screen;
            if (screen instanceof FamiliarSelectionScreen) {
                FamiliarSelectionScreen familiarScreen = (FamiliarSelectionScreen)screen;
                AlshanexFamiliarsMod.LOGGER.info("Updating FamiliarSelectionScreen after familiar death: {}", (Object)deadFamiliarId);
                familiarScreen.reloadFamiliarData();
                player = Minecraft.getInstance().player;
                if (player != null && (familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA)).isEmpty()) {
                    AlshanexFamiliarsMod.LOGGER.info("No familiars remaining, closing FamiliarSelectionScreen");
                    familiarScreen.onClose();
                }
            }
            if ((player = Minecraft.getInstance().screen) instanceof BedLinkSelectionScreen) {
                BedLinkSelectionScreen bedLinkScreen = (BedLinkSelectionScreen)player;
                AlshanexFamiliarsMod.LOGGER.info("Updating BedLinkSelectionScreen after familiar death: {}", (Object)deadFamiliarId);
                bedLinkScreen.reloadFamiliarData();
                player = Minecraft.getInstance().player;
                if (player != null && (familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA)).isEmpty()) {
                    AlshanexFamiliarsMod.LOGGER.info("No familiars remaining, closing BedLinkSelectionScreen");
                    bedLinkScreen.onClose();
                }
            }
            if ((screen = Minecraft.getInstance().screen) instanceof PandoraBoxScreen) {
                PandoraBoxScreen pandoraScreen = (PandoraBoxScreen)screen;
                Minecraft.getInstance().setScreen(null);
                Minecraft.getInstance().setScreen((Screen)new PandoraBoxScreen());
            }
        }
        catch (Exception e) {
            AlshanexFamiliarsMod.LOGGER.error("Error updating screens after familiar death: ", (Throwable)e);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void cleanFamiliarFromPandoraBoxClient(Player player, UUID deadFamiliarId) {
        try {
            ItemStack pandoraBox;
            Set<UUID> selectedFamiliars;
            Optional<ItemStack> equippedPandoraBox = PandoraUtils.getEquippedPandoraBox((LivingEntity)player);
            if (equippedPandoraBox.isPresent() && (selectedFamiliars = PandoraBox.getSelectedFamiliars(pandoraBox = equippedPandoraBox.get())).contains(deadFamiliarId)) {
                HashSet<UUID> updatedSelection = new HashSet<UUID>(selectedFamiliars);
                updatedSelection.remove(deadFamiliarId);
                PandoraBox.setSelectedFamiliars(pandoraBox, updatedSelection);
                AlshanexFamiliarsMod.LOGGER.info("Client: Removed dead familiar {} from equipped PandoraBox", (Object)deadFamiliarId);
                return;
            }
            ItemStack mainHandItem = player.getItemInHand(InteractionHand.MAIN_HAND);
            ItemStack offHandItem = player.getItemInHand(InteractionHand.OFF_HAND);
            for (ItemStack handItem : Arrays.asList(mainHandItem, offHandItem)) {
                Set<UUID> selectedFamiliars2;
                if (!(handItem.getItem() instanceof PandoraBox) || !(selectedFamiliars2 = PandoraBox.getSelectedFamiliars(handItem)).contains(deadFamiliarId)) continue;
                HashSet<UUID> updatedSelection = new HashSet<UUID>(selectedFamiliars2);
                updatedSelection.remove(deadFamiliarId);
                PandoraBox.setSelectedFamiliars(handItem, updatedSelection);
                AlshanexFamiliarsMod.LOGGER.info("Client: Removed dead familiar {} from held PandoraBox", (Object)deadFamiliarId);
                break;
            }
        }
        catch (Exception e) {
            AlshanexFamiliarsMod.LOGGER.error("Error cleaning dead familiar {} from PandoraBox on client: ", (Object)deadFamiliarId, (Object)e);
        }
    }

    public static void requestFamiliarSelectionScreen(ServerPlayer serverPlayer) {
        FamiliarManager.updateSummonedFamiliarsData((ServerPlayer)serverPlayer);
        PlayerFamiliarData familiarData = (PlayerFamiliarData)serverPlayer.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        if (!familiarData.isEmpty()) {
            FamiliarManager.syncFamiliarDataForPlayer((ServerPlayer)serverPlayer);
            if (PandoraUtils.isWearingPandoraBox((LivingEntity)serverPlayer)) {
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new OpenPandoraBoxScreenPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new OpenFamiliarSelectionPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static void handleFamiliarSummonPackage(ServerPlayer serverPlayer) {
        if (PandoraUtils.isWearingPandoraBox((LivingEntity)serverPlayer)) {
            AlshanexFamiliarManager.handlePandoraBoxSummoning(serverPlayer);
        } else {
            FamiliarManager.handleFamiliarSummoning((ServerPlayer)serverPlayer);
        }
    }

    private static void handlePandoraBoxSummoning(ServerPlayer player) {
        Set<UUID> selectedFamiliars = PandoraUtils.getSelectedFamiliarsFromEquipped((LivingEntity)player);
        if (selectedFamiliars.isEmpty()) {
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"message.alshanex_familiars.no_familiars_selected").withStyle(ChatFormatting.YELLOW)));
            return;
        }
        PlayerFamiliarData familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        boolean anyAction = false;
        int spawnIndex = 0;
        for (UUID familiarId : selectedFamiliars) {
            if (!familiarData.hasFamiliar(familiarId)) continue;
            boolean isSummoned = familiarData.isFamiliarSummoned(familiarId);
            if (isSummoned) {
                FamiliarManager.desummonSpecificFamiliar((ServerPlayer)player, (UUID)familiarId);
                anyAction = true;
                continue;
            }
            FamiliarManager.summonSpecificFamiliarAtPosition((ServerPlayer)player, (UUID)familiarId, (int)spawnIndex);
            anyAction = true;
            ++spawnIndex;
        }
        if (anyAction) {
            player.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"message.alshanex_familiars.familiars_toggled").withStyle(ChatFormatting.GREEN)));
        }
    }

    public static void cleanFamiliarFromPandoraBox(ServerPlayer player, UUID deadFamiliarId) {
        try {
            ItemStack pandoraBox;
            Set<UUID> selectedFamiliars;
            Optional<ItemStack> equippedPandoraBox = PandoraUtils.getEquippedPandoraBox((LivingEntity)player);
            if (equippedPandoraBox.isPresent() && (selectedFamiliars = PandoraBox.getSelectedFamiliars(pandoraBox = equippedPandoraBox.get())).contains(deadFamiliarId)) {
                HashSet<UUID> updatedSelection = new HashSet<UUID>(selectedFamiliars);
                updatedSelection.remove(deadFamiliarId);
                PandoraBox.setSelectedFamiliars(pandoraBox, updatedSelection);
                AlshanexFamiliarsMod.LOGGER.info("Removed dead familiar {} from equipped PandoraBox for player {}. {} familiars remaining in selection.", new Object[]{deadFamiliarId, player.getName().getString(), updatedSelection.size()});
                return;
            }
            ItemStack mainHandItem = player.getItemInHand(InteractionHand.MAIN_HAND);
            ItemStack offHandItem = player.getItemInHand(InteractionHand.OFF_HAND);
            for (ItemStack handItem : Arrays.asList(mainHandItem, offHandItem)) {
                Set<UUID> selectedFamiliars2;
                if (!(handItem.getItem() instanceof PandoraBox) || !(selectedFamiliars2 = PandoraBox.getSelectedFamiliars(handItem)).contains(deadFamiliarId)) continue;
                HashSet<UUID> updatedSelection = new HashSet<UUID>(selectedFamiliars2);
                updatedSelection.remove(deadFamiliarId);
                PandoraBox.setSelectedFamiliars(handItem, updatedSelection);
                AlshanexFamiliarsMod.LOGGER.info("Removed dead familiar {} from held PandoraBox for player {}. {} familiars remaining in selection.", new Object[]{deadFamiliarId, player.getName().getString(), updatedSelection.size()});
                break;
            }
        }
        catch (Exception e) {
            AlshanexFamiliarsMod.LOGGER.error("Error cleaning dead familiar {} from PandoraBox for player {}: ", new Object[]{deadFamiliarId, player.getName().getString(), e});
        }
    }

    public static void handleReleaseFamiliar(ServerPlayer player, UUID familiarId) {
        boolean hasRemainingFamiliars;
        PlayerFamiliarData familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        BedLinkData bedLinkData = (BedLinkData)player.getData(AttachmentRegistry.BED_LINK_DATA);
        AlshanexFamiliarsMod.LOGGER.info("Attempting to release familiar {} for player {}", (Object)familiarId, (Object)player.getName().getString());
        if (!familiarData.hasFamiliar(familiarId)) {
            AlshanexFamiliarsMod.LOGGER.warn("Player {} tried to release familiar {} but it doesn't exist in their data", (Object)player.getName().getString(), (Object)familiarId);
            return;
        }
        CompoundTag familiarNBT = familiarData.getFamiliarData(familiarId);
        String familiarName = "Unknown";
        if (familiarNBT != null) {
            if (familiarNBT.contains("customName")) {
                familiarName = familiarNBT.getString("customName");
            } else {
                String entityTypeString = familiarNBT.getString("id");
                String[] parts = entityTypeString.split(":");
                if (parts.length > 1) {
                    familiarName = parts[1].replace("_", " ");
                }
            }
        }
        if (familiarData.isFamiliarSummoned(familiarId)) {
            AlshanexFamiliarsMod.LOGGER.info("Familiar {} is summoned, desummoning before release", (Object)familiarId);
            FamiliarManager.desummonSpecificFamiliar((ServerPlayer)player, (UUID)familiarId);
        }
        bedLinkData.unlinkFamiliar(familiarId);
        familiarData.removeTamedFamiliar(familiarId);
        AlshanexFamiliarManager.cleanFamiliarFromPandoraBox(player, familiarId);
        Map remainingFamiliars = familiarData.getAllFamiliars();
        boolean bl = hasRemainingFamiliars = !remainingFamiliars.isEmpty();
        if (familiarId.equals(familiarData.getSelectedFamiliarId()) && hasRemainingFamiliars) {
            Iterator iterator = remainingFamiliars.keySet().iterator();
            if (iterator.hasNext()) {
                UUID otherId = (UUID)iterator.next();
                familiarData.setSelectedFamiliarId(otherId);
                AlshanexFamiliarsMod.LOGGER.info("Released familiar was selected, new selected: {}", (Object)otherId);
            }
        } else if (familiarId.equals(familiarData.getSelectedFamiliarId())) {
            familiarData.setSelectedFamiliarId(null);
            AlshanexFamiliarsMod.LOGGER.info("Released familiar was selected and no familiars remain, clearing selection");
        }
        FamiliarManager.syncFamiliarData((ServerPlayer)player, (PlayerFamiliarData)familiarData);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncBedLinkDataPacket(bedLinkData.serializeNBT((HolderLookup.Provider)player.registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]);
        boolean shouldClose = !hasRemainingFamiliars;
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ReloadFamiliarScreenPacket(shouldClose), (CustomPacketPayload[])new CustomPacketPayload[0]);
        AlshanexFamiliarsMod.LOGGER.info("Successfully released familiar {} for player {}. Remaining familiars: {}. Screen action: {}", new Object[]{familiarId, player.getName().getString(), remainingFamiliars.size(), shouldClose ? "CLOSE" : "RELOAD"});
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleFamiliarSelectionScreenUpdate(boolean shouldClose) {
        Minecraft minecraft = Minecraft.getInstance();
        Screen screen = minecraft.screen;
        if (screen instanceof FamiliarSelectionScreen) {
            FamiliarSelectionScreen familiarScreen = (FamiliarSelectionScreen)screen;
            if (shouldClose) {
                minecraft.setScreen(null);
                AlshanexFamiliarsMod.LOGGER.info("Closed familiar selection screen - no familiars remaining");
            } else {
                familiarScreen.reloadFamiliarData();
                AlshanexFamiliarsMod.LOGGER.info("Reloaded familiar selection screen after familiar release");
            }
        }
    }
}

