/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.util.familiars;

import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.block.pedestal.PedestalTile;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.registries.BlockRegistry;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.alshanex.alshanex_familiars.entity.misc.IllusionistDecoy;
import net.alshanex.alshanex_familiars.util.AlshanexFamiliarsTags;
import net.alshanex.familiarslib.entity.AbstractSpellCastingPet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.BonemealEvent;

public class AlshanexFamiliarGoals {

    public static class RerollScrollGoal
    extends Goal {
        private final AbstractSpellCastingPet controllerEntity;
        private final Supplier<LivingEntity> targetEntity;
        private final int radius;
        private final int interval;
        private int tickCounter;

        public RerollScrollGoal(AbstractSpellCastingPet controllerEntity, Supplier<LivingEntity> targetEntity, int radius, int interval) {
            this.controllerEntity = controllerEntity;
            this.targetEntity = targetEntity;
            this.radius = radius;
            this.interval = interval;
            this.tickCounter = 0;
            this.setFlags(EnumSet.noneOf(Goal.Flag.class));
        }

        public boolean canUse() {
            LivingEntity owner = this.targetEntity.get();
            if (owner == null) {
                return false;
            }
            if (this.controllerEntity.getMovementDisabled()) {
                return false;
            }
            if (!this.controllerEntity.canExecuteGoalsInHouse()) {
                return false;
            }
            return this.controllerEntity.isAlive() && owner.isAlive();
        }

        public void tick() {
            if (this.tickCounter < this.interval) {
                ++this.tickCounter;
            }
            if (this.tickCounter >= this.interval) {
                LivingEntity owner = this.targetEntity.get();
                BlockPos controllerPos = owner.blockPosition();
                PedestalTile nearestPedestal = null;
                double minDistance = Double.MAX_VALUE;
                for (int x = -this.radius; x <= this.radius; ++x) {
                    for (int y = -this.radius; y <= this.radius; ++y) {
                        for (int z = -this.radius; z <= this.radius; ++z) {
                            double distance;
                            PedestalTile pedestal;
                            BlockPos currentPos = controllerPos.offset(x, y, z);
                            BlockState blockState = this.controllerEntity.level().getBlockState(currentPos);
                            if (!blockState.is((Holder)BlockRegistry.PEDESTAL_BLOCK) || (pedestal = (PedestalTile)this.controllerEntity.level().getBlockEntity(currentPos)) == null || pedestal.getHeldItem() == null || pedestal.getHeldItem().isEmpty() || !(pedestal.getHeldItem().getItem() instanceof Scroll) || !((distance = controllerPos.distSqr((Vec3i)currentPos)) < minDistance)) continue;
                            minDistance = distance;
                            nearestPedestal = pedestal;
                        }
                    }
                }
                if (nearestPedestal != null) {
                    BlockState prevState = nearestPedestal.getBlockState();
                    ItemStack item = nearestPedestal.getHeldItem();
                    SpellData spellData = ISpellContainer.get((ItemStack)item).getSpellAtIndex(0);
                    if (!AlshanexFamiliarsTags.isSpellInTag(spellData.getSpell(), AlshanexFamiliarsTags.ARCHMAGE_CANNOT_REROLL)) {
                        this.controllerEntity.triggerAnim("interact_controller", "interact");
                        ItemStack finalItem = this.getResultSpell(spellData.getRarity());
                        SpellData spellDataFinal = ISpellContainer.get((ItemStack)finalItem).getSpellAtIndex(0);
                        nearestPedestal.setHeldItem(finalItem);
                        BlockState nextState = nearestPedestal.getBlockState();
                        this.controllerEntity.level.sendBlockUpdated(nearestPedestal.getBlockPos(), prevState, nextState, 2);
                        float radius = 2.0f;
                        MagicManager.spawnParticles((Level)this.controllerEntity.level, (ParticleOptions)new BlastwaveParticleOptions(spellDataFinal.getSpell().getSchoolType().getTargetingColor(), radius), (double)nearestPedestal.getBlockPos().getCenter().x, (double)(nearestPedestal.getBlockPos().getCenter().y + 1.0), (double)nearestPedestal.getBlockPos().getCenter().z, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
                        this.tickCounter = 0;
                    }
                }
            }
        }

        private ItemStack getResultSpell(SpellRarity rarity) {
            ItemStack resultStack = new ItemStack((ItemLike)ItemRegistry.SCROLL.get());
            resultStack.setCount(1);
            List spells = SpellRegistry.getEnabledSpells();
            List<AbstractSpell> finalSpells = spells.stream().filter(spell -> !AlshanexFamiliarsTags.isSpellInTag(spell, AlshanexFamiliarsTags.ARCHMAGE_CANNOT_CREATE)).toList();
            boolean spellSelected = false;
            Random random = new Random();
            int chance = random.nextInt(100);
            if (chance < 5 && rarity != SpellRarity.LEGENDARY) {
                int rarityValue = rarity.getValue() + 1;
                rarity = Arrays.stream(SpellRarity.values()).filter(rarityAux -> rarityAux.getValue() == rarityValue).findFirst().get();
            }
            while (!spellSelected) {
                Random spellRandom = new Random();
                int randomSpellIndex = spellRandom.nextInt(finalSpells.size());
                AbstractSpell spell2 = finalSpells.get(randomSpellIndex);
                if (spell2.getMaxRarity() < rarity.getValue() || spell2.getMinRarity() > rarity.getValue()) continue;
                ISpellContainer.createScrollContainer((AbstractSpell)spell2, (int)spell2.getMinLevelForRarity(rarity), (ItemStack)resultStack);
                spellSelected = true;
            }
            return resultStack;
        }

        public boolean canContinueToUse() {
            return this.canUse();
        }
    }

    public static class CustomBreedGoal
    extends Goal {
        private final AbstractSpellCastingPet pet;
        private Animal animal;

        public CustomBreedGoal(AbstractSpellCastingPet pet) {
            this.pet = pet;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (this.animal != null) {
                return false;
            }
            if (this.pet.getMovementDisabled()) {
                return false;
            }
            if (this.pet.getSummoner() == null || this.pet.getOwnerUUID() == null) {
                return false;
            }
            if (!this.pet.canExecuteGoalsInHouse()) {
                return false;
            }
            this.animal = this.pet.level().getEntitiesOfClass(Animal.class, this.pet.getBoundingBox().inflate(10.0), a -> a.canFallInLove() && !a.isPanicking() && !a.isBaby() && a.getAge() == 0 && !a.getType().is(AlshanexFamiliarsTags.DRUID_CANNOT_BREED)).stream().min(Comparator.comparingDouble(arg_0 -> ((AbstractSpellCastingPet)this.pet).distanceTo(arg_0))).orElse(null);
            return this.animal != null;
        }

        public boolean canContinueToUse() {
            return this.animal != null && this.animal.isAlive() && this.animal.canFallInLove() && this.pet.canExecuteGoalsInHouse();
        }

        public void start() {
            this.pet.getNavigation().moveTo((Entity)this.animal, 1.0);
        }

        public void tick() {
            if (this.animal == null) {
                return;
            }
            if ((double)this.pet.distanceTo((Entity)this.animal) < 2.0) {
                this.pet.getLookControl().setLookAt((Entity)this.animal, 10.0f, 10.0f);
                if (this.animal.canFallInLove() && this.animal.getAge() == 0) {
                    this.animal.setInLove(null);
                }
            } else {
                this.pet.getNavigation().moveTo((Entity)this.animal, 1.0);
            }
        }

        public void stop() {
            this.animal = null;
        }
    }

    public static class ApplyBonemealGoal
    extends Goal {
        private final AbstractSpellCastingPet controllerEntity;
        private final Supplier<LivingEntity> targetEntity;
        private final int interval;
        private int tickCounter;

        public ApplyBonemealGoal(AbstractSpellCastingPet controllerEntity, Supplier<LivingEntity> targetEntity, int interval) {
            this.controllerEntity = controllerEntity;
            this.interval = interval;
            this.targetEntity = targetEntity;
            this.tickCounter = 0;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            LivingEntity owner = this.targetEntity.get();
            if (owner == null || !(owner instanceof Player)) {
                return false;
            }
            if (this.controllerEntity.getMovementDisabled()) {
                return false;
            }
            if (!this.controllerEntity.canExecuteGoalsInHouse()) {
                return false;
            }
            return this.controllerEntity.isAlive() && owner.isAlive();
        }

        public void tick() {
            ++this.tickCounter;
            if (this.tickCounter >= this.interval) {
                this.tickCounter = 0;
                BlockPos targetPos = this.controllerEntity.blockPosition();
                Level level = this.controllerEntity.level();
                Player player = (Player)this.targetEntity.get();
                this.controllerEntity.triggerAnim("interact_controller", "interact");
                for (int x = -5; x <= 5; ++x) {
                    for (int y = -5; y <= 5; ++y) {
                        for (int z = -5; z <= 5; ++z) {
                            BlockPos currentPos = targetPos.offset(x, y, z);
                            if (!this.applyBonemeal(level, currentPos, player) || level.isClientSide) continue;
                            level.levelEvent(1505, currentPos, 15);
                        }
                    }
                }
            }
        }

        boolean applyBonemeal(Level level, BlockPos pos, Player player) {
            Block block;
            BlockState blockstate = level.getBlockState(pos);
            BonemealEvent event = EventHooks.fireBonemealEvent((Player)player, (Level)level, (BlockPos)pos, (BlockState)blockstate, (ItemStack)new ItemStack((ItemLike)Items.BONE_MEAL));
            if (event.isCanceled()) {
                return event.isSuccessful();
            }
            if (blockstate.is(AlshanexFamiliarsTags.DRUID_GROWABLES) && (block = blockstate.getBlock()) instanceof BonemealableBlock) {
                BonemealableBlock bonemealableblock = (BonemealableBlock)block;
                if (level instanceof ServerLevel && bonemealableblock.isBonemealSuccess(level, level.random, pos, blockstate)) {
                    bonemealableblock.performBonemeal((ServerLevel)level, level.random, pos, blockstate);
                }
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.canUse();
        }
    }

    public static class UndeadChaosGoal
    extends Goal {
        private final AbstractSpellCastingPet pet;
        private final Supplier<LivingEntity> petOwner;
        private final double range;
        private final int interval;
        private int tickCounter;

        public UndeadChaosGoal(AbstractSpellCastingPet pet, Supplier<LivingEntity> owner, double range, int interval) {
            this.pet = pet;
            this.petOwner = owner;
            this.range = range;
            this.interval = interval;
            this.tickCounter = 0;
        }

        public boolean canUse() {
            LivingEntity owner = this.petOwner.get();
            if (owner == null) {
                return false;
            }
            if (!this.pet.canExecuteGoalsInHouse()) {
                return false;
            }
            return ++this.tickCounter >= this.interval;
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void start() {
            this.tickCounter = 0;
            this.pet.triggerAnim("interact_controller", "interact");
            Level level = this.pet.level();
            if (level.isClientSide) {
                return;
            }
            LivingEntity owner = this.petOwner.get();
            List undeadEntities = level.getEntitiesOfClass(LivingEntity.class, this.pet.getBoundingBox().inflate(this.range), entity -> entity != this.pet && entity != owner && entity.getType().is(EntityTypeTags.UNDEAD) && !entity.getType().is(AlshanexFamiliarsTags.NECROMANCER_BLACKLIST));
            if (undeadEntities.isEmpty()) {
                return;
            }
            List potentialTargets = level.getEntitiesOfClass(LivingEntity.class, this.pet.getBoundingBox().inflate(this.range), entity -> entity != this.pet && entity != owner);
            if (potentialTargets.isEmpty()) {
                return;
            }
            for (LivingEntity undead : undeadEntities) {
                if (!(undead instanceof Mob)) continue;
                Mob mob = (Mob)undead;
                if (undead instanceof IMagicSummon) {
                    IMagicSummon summon = (IMagicSummon)undead;
                    if (summon.getSummoner() == null || summon.getSummoner() == owner || summon.getSummoner() == this.pet) continue;
                    this.selectTarget(potentialTargets, mob);
                    continue;
                }
                this.selectTarget(potentialTargets, mob);
            }
        }

        private void selectTarget(List<LivingEntity> potentialTargets, Mob mob) {
            ArrayList<LivingEntity> localTargets = new ArrayList<LivingEntity>(potentialTargets);
            localTargets.remove(mob);
            if (!localTargets.isEmpty()) {
                Random random = new Random();
                LivingEntity randomTarget = (LivingEntity)localTargets.get(random.nextInt(localTargets.size()));
                mob.setTarget(randomTarget);
            }
        }
    }

    public static class DecoyGoal
    extends Goal {
        private final AbstractSpellCastingPet pet;
        private final int interval;
        private int tickCounter;

        public DecoyGoal(AbstractSpellCastingPet pet, int interval) {
            this.pet = pet;
            this.interval = interval;
            this.tickCounter = 0;
        }

        public boolean canUse() {
            return ++this.tickCounter >= this.interval && this.pet.getHealth() <= this.pet.getMaxHealth() / 2.0f && this.pet.canExecuteGoalsInHouse();
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void start() {
            this.tickCounter = 0;
            this.pet.triggerAnim("interact_controller", "interact");
            Level level = this.pet.level();
            if (level.isClientSide) {
                return;
            }
            this.pet.addEffect(new MobEffectInstance((Holder)MobEffectRegistry.TRUE_INVISIBILITY, 100, 0, false, false, true));
            this.pet.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 100, 5, false, false, true));
            IllusionistDecoy decoy = new IllusionistDecoy(this.pet.level(), (LivingEntity)this.pet);
            decoy.moveTo(this.pet.position());
            decoy.setYRot(this.pet.getYRot());
            this.pet.level().addFreshEntity((Entity)decoy);
        }
    }
}

