/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.util;

import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.alshanex.alshanex_familiars.AlshanexFamiliarsMod;
import net.alshanex.alshanex_familiars.item.PandoraBox;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class PandoraUtils {
    public static boolean isWearingPandoraBox(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).map(curios -> !curios.findCurios(item -> item != null && item.getItem() instanceof PandoraBox).isEmpty()).orElse(false);
    }

    public static Optional<ItemStack> getEquippedPandoraBox(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).map(curios -> curios.findFirstCurio(item -> item.getItem() instanceof PandoraBox).map(SlotResult::stack).orElse(ItemStack.EMPTY)).filter(stack -> !stack.isEmpty());
    }

    public static Set<UUID> getSelectedFamiliarsFromEquipped(LivingEntity entity) {
        Optional<ItemStack> pandoraBox = PandoraUtils.getEquippedPandoraBox(entity);
        if (pandoraBox.isPresent()) {
            return PandoraBox.getSelectedFamiliars(pandoraBox.get());
        }
        return Set.of();
    }

    public static boolean updateSelectedFamiliarsInEquipped(LivingEntity entity, Set<UUID> selectedFamiliars) {
        Optional<ItemStack> pandoraBox = PandoraUtils.getEquippedPandoraBox(entity);
        if (pandoraBox.isPresent()) {
            PandoraBox.setSelectedFamiliars(pandoraBox.get(), selectedFamiliars);
            return true;
        }
        return false;
    }

    public static void clearPandoraBoxSelected(ItemStack box) {
        if (box.getItem() instanceof PandoraBox) {
            AlshanexFamiliarsMod.LOGGER.debug("Clearing selected familiars from PandoraBox ItemStack");
            PandoraBox.setSelectedFamiliars(box, Set.of());
        }
    }

    public static void findAndClearAllPandoraBoxes(ServerPlayer player) {
        Set<UUID> selectedBefore;
        int clearedCount = 0;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            Set<UUID> selectedBefore2;
            ItemStack stack = player.getInventory().getItem(i);
            if (!(stack.getItem() instanceof PandoraBox) || (selectedBefore2 = PandoraBox.getSelectedFamiliars(stack)).isEmpty()) continue;
            PandoraUtils.clearPandoraBoxSelected(stack);
            ++clearedCount;
            AlshanexFamiliarsMod.LOGGER.debug("Cleared Pandora Box in inventory slot {} (had {} selected)", (Object)i, (Object)selectedBefore2.size());
        }
        ItemStack carriedItem = player.containerMenu.getCarried();
        if (carriedItem.getItem() instanceof PandoraBox && !(selectedBefore = PandoraBox.getSelectedFamiliars(carriedItem)).isEmpty()) {
            PandoraUtils.clearPandoraBoxSelected(carriedItem);
            ++clearedCount;
            AlshanexFamiliarsMod.LOGGER.debug("Cleared Pandora Box being carried by cursor (had {} selected)", (Object)selectedBefore.size());
        }
        for (InteractionHand hand : InteractionHand.values()) {
            Set<UUID> selectedBefore3;
            ItemStack handStack = player.getItemInHand(hand);
            if (!(handStack.getItem() instanceof PandoraBox) || (selectedBefore3 = PandoraBox.getSelectedFamiliars(handStack)).isEmpty()) continue;
            PandoraUtils.clearPandoraBoxSelected(handStack);
            ++clearedCount;
            AlshanexFamiliarsMod.LOGGER.debug("Cleared Pandora Box in {} hand (had {} selected)", (Object)hand.name(), (Object)selectedBefore3.size());
        }
        if (clearedCount > 0) {
            player.inventoryMenu.broadcastChanges();
            AlshanexFamiliarsMod.LOGGER.info("Found and cleared {} Pandora Box(es) for player {}", (Object)clearedCount, (Object)player.getName().getString());
        } else {
            AlshanexFamiliarsMod.LOGGER.debug("No Pandora Boxes with selections found for player {}", (Object)player.getName().getString());
        }
    }

    public static void handlePandoraBoxUnequip(ServerPlayer player, ItemStack unequippedBox) {
        if (!(unequippedBox.getItem() instanceof PandoraBox)) {
            return;
        }
        Set<UUID> selectedFamiliars = PandoraBox.getSelectedFamiliars(unequippedBox);
        AlshanexFamiliarsMod.LOGGER.info("Player {} unequipped Pandora Box with {} selected familiars - searching all locations", (Object)player.getName().getString(), (Object)selectedFamiliars.size());
        PandoraUtils.findAndClearAllPandoraBoxes(player);
        AlshanexFamiliarsMod.LOGGER.info("Completed Pandora Box cleanup for player {}", (Object)player.getName().getString());
    }

    public static boolean isFamiliarSelectedInEquippedPandoraBox(LivingEntity entity, UUID familiarId) {
        Set<UUID> selectedFamiliars = PandoraUtils.getSelectedFamiliarsFromEquipped(entity);
        return selectedFamiliars.contains(familiarId);
    }

    public static boolean removeFamiliarFromEquippedPandoraBox(LivingEntity entity, UUID familiarId) {
        Set<UUID> currentSelection;
        Optional<ItemStack> pandoraBox = PandoraUtils.getEquippedPandoraBox(entity);
        if (pandoraBox.isPresent() && (currentSelection = PandoraBox.getSelectedFamiliars(pandoraBox.get())).contains(familiarId)) {
            currentSelection.remove(familiarId);
            PandoraBox.setSelectedFamiliars(pandoraBox.get(), currentSelection);
            return true;
        }
        return false;
    }

    public static void updatePandoraBox(ServerPlayer serverPlayer, Set<UUID> selectedFamiliars) {
        boolean updatedEquipped = PandoraUtils.updateSelectedFamiliarsInEquipped((LivingEntity)serverPlayer, selectedFamiliars);
        if (!updatedEquipped) {
            ItemStack heldItem = serverPlayer.getItemInHand(InteractionHand.MAIN_HAND);
            if (!(heldItem.getItem() instanceof PandoraBox)) {
                heldItem = serverPlayer.getItemInHand(InteractionHand.OFF_HAND);
            }
            if (heldItem.getItem() instanceof PandoraBox) {
                PandoraBox.setSelectedFamiliars(heldItem, selectedFamiliars);
                updatedEquipped = true;
            }
        }
        if (updatedEquipped) {
            AlshanexFamiliarsMod.LOGGER.info("Updated PandoraBox with {} selected familiars for player {}", (Object)selectedFamiliars.size(), (Object)serverPlayer.getName().getString());
        }
    }
}

