/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.spells;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.alshanex.alshanex_familiars.registry.AFSoundRegistry;
import net.alshanex.alshanex_familiars.registry.EffectRegistry;
import net.alshanex.alshanex_familiars.registry.ParticleRegistry;
import net.alshanex.familiarslib.registry.FSchoolRegistry;
import net.alshanex.familiarslib.util.CylinderParticleManager;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class LullabySpell
extends AbstractSpell {
    SoundEvent playingSound = null;
    private boolean musicPlaying = false;
    private int musicTimer = 0;
    private static final int MUSIC_DURATION = 200;
    private final ResourceLocation spellId = new ResourceLocation("alshanex_familiars", "lullaby");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(FSchoolRegistry.SOUND_RESOURCE).setMaxLevel(1).setCooldownSeconds(40.0).build();

    public LullabySpell() {
        this.manaCostPerLevel = 1;
        this.baseSpellPower = 15;
        this.spellPowerPerLevel = 1;
        this.castTime = 300;
        this.baseManaCost = 7;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.radius", (Object[])new Object[]{Utils.stringTruncation((double)this.getRadius(), (int)1)}));
    }

    public boolean allowCrafting() {
        return false;
    }

    public CastType getCastType() {
        return CastType.CONTINUOUS;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.ANIMATION_CONTINUOUS_OVERHEAD;
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (this.musicPlaying) {
            this.stopMinecraftAmbientMusic(world);
            if (this.musicTimer > 0) {
                --this.musicTimer;
            } else {
                this.playMusic(world, entity);
            }
        }
        if (!this.musicPlaying) {
            this.playMusic(world, entity);
        }
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        if (playerMagicData != null && (playerMagicData.getCastDurationRemaining() + 1) % 20 == 0) {
            this.applySleepy(level, entity);
        }
        if (playerMagicData != null && (playerMagicData.getCastDurationRemaining() + 1) % 5 == 0) {
            boolean isBlackParticle;
            boolean bl = isBlackParticle = Utils.random.nextDouble() <= 0.5;
            if (isBlackParticle) {
                CylinderParticleManager.spawnParticlesAtBlockPos((Level)level, (Vec3)entity.position(), (int)1, (ParticleOptions)((ParticleOptions)ParticleRegistry.BLACK_NOTE_PARTICLE.get()), (CylinderParticleManager.ParticleDirection)CylinderParticleManager.ParticleDirection.UPWARD, (double)0.1, (double)0.2, (double)entity.getBbHeight());
            } else {
                CylinderParticleManager.spawnParticlesAtBlockPos((Level)level, (Vec3)entity.position(), (int)1, (ParticleOptions)((ParticleOptions)ParticleRegistry.MUSICAL_NOTE_PARTICLE.get()), (CylinderParticleManager.ParticleDirection)CylinderParticleManager.ParticleDirection.UPWARD, (double)0.1, (double)0.2, (double)entity.getBbHeight());
            }
        }
    }

    private double getRadius() {
        return 15.0;
    }

    public void applySleepy(Level world, LivingEntity entity) {
        double radius = this.getRadius();
        double radiusSqr = radius * radius;
        world.getEntitiesOfClass(LivingEntity.class, new AABB(entity.position().subtract(radius, radius, radius), entity.position().add(radius, radius, radius)), livingEntity -> (double)this.horizontalDistanceSqr((LivingEntity)livingEntity, entity.position()) < radiusSqr && !Utils.shouldHealEntity((LivingEntity)entity, (LivingEntity)livingEntity) && !livingEntity.hasEffect(EffectRegistry.SLEEPY)).forEach(livingEntity -> livingEntity.addEffect(new MobEffectInstance(EffectRegistry.SLEEPY, 100, 0, false, false, true)));
    }

    public void onServerCastComplete(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData, boolean cancelled) {
        if (this.musicPlaying) {
            this.stopMusic(level);
            this.musicPlaying = false;
            this.musicTimer = 0;
        }
        super.onServerCastComplete(level, spellLevel, entity, playerMagicData, cancelled);
    }

    private float horizontalDistanceSqr(LivingEntity livingEntity, Vec3 vec3) {
        double dx = livingEntity.getX() - vec3.x;
        double dz = livingEntity.getZ() - vec3.z;
        return (float)(dx * dx + dz * dz);
    }

    private void stopMinecraftAmbientMusic(Level level) {
        if (!level.isClientSide && level.getServer() != null) {
            for (ServerPlayer player : Objects.requireNonNull(level.getServer()).getPlayerList().getPlayers()) {
                player.connection.send((Packet)new ClientboundStopSoundPacket(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"music.game"), SoundSource.MUSIC));
                player.connection.send((Packet)new ClientboundStopSoundPacket(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"music.creative"), SoundSource.MUSIC));
                player.connection.send((Packet)new ClientboundStopSoundPacket(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"music.menu"), SoundSource.MUSIC));
                player.connection.send((Packet)new ClientboundStopSoundPacket(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"music.overworld.day"), SoundSource.MUSIC));
                player.connection.send((Packet)new ClientboundStopSoundPacket(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"music.overworld.night"), SoundSource.MUSIC));
                player.connection.send((Packet)new ClientboundStopSoundPacket(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"music.overworld.hills"), SoundSource.MUSIC));
                player.connection.send((Packet)new ClientboundStopSoundPacket(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"music.overworld.water"), SoundSource.MUSIC));
            }
        }
    }

    private void playMusic(Level level, LivingEntity entity) {
        if (!level.isClientSide && !this.musicPlaying) {
            this.playingSound = (SoundEvent)AFSoundRegistry.BARD_SONG_1.get();
            this.musicPlaying = true;
            this.musicTimer = 200;
            level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), this.playingSound, SoundSource.MUSIC, 1.0f, 1.0f);
        }
    }

    private void stopMusic(Level level) {
        if (!level.isClientSide && level.getServer() != null && this.playingSound != null) {
            Objects.requireNonNull(level.getServer()).getPlayerList().getPlayers().forEach(player -> player.connection.send((Packet)new ClientboundStopSoundPacket(this.playingSound.getLocation(), SoundSource.MUSIC)));
            this.playingSound = null;
        }
    }
}

