/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.alshanex.alshanex_familiars.AlshanexFamiliarsMod;
import net.alshanex.alshanex_familiars.item.PandoraBox;
import net.alshanex.alshanex_familiars.network.UpdatePandoraBoxPacket;
import net.alshanex.alshanex_familiars.util.PandoraUtils;
import net.alshanex.familiarslib.data.PlayerFamiliarData;
import net.alshanex.familiarslib.entity.AbstractSpellCastingPet;
import net.alshanex.familiarslib.registry.AttachmentRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PandoraBoxScreen
extends Screen {
    private static final int CELL_SIZE = 120;
    private static final int GRID_COLS = 3;
    private static final int GRID_ROWS = 2;
    private static final int PANEL_WIDTH = 400;
    private static final int PANEL_HEIGHT = 280;
    private static final int SCROLL_SPEED = 20;
    private final List<FamiliarGridEntry> familiarEntries = new ArrayList<FamiliarGridEntry>();
    private final Set<UUID> selectedFamiliars = new HashSet<UUID>();
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private float animationTime = 0.0f;
    private int gridStartX;
    private int gridStartY;
    private static final ResourceLocation HEART_CONTAINER = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/hud/heart/container.png");
    private static final ResourceLocation HEART_FULL = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/hud/heart/full.png");
    private static final ResourceLocation ARMOR_FULL = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/hud/armor_full.png");
    private static final ResourceLocation STRANGE_MUSHROOM = ResourceLocation.fromNamespaceAndPath((String)"alshanex_familiars", (String)"textures/item/strange_mushroom.png");
    private static final ResourceLocation BROKEN_SHIELD = ResourceLocation.fromNamespaceAndPath((String)"alshanex_familiars", (String)"textures/item/broken_shield.png");

    public PandoraBoxScreen() {
        super((Component)Component.translatable((String)"screen.alshanex_familiars.pandora_box"));
    }

    protected void init() {
        super.init();
        this.loadFamiliarData();
        this.loadSelectedFamiliars();
        this.gridStartX = (this.width - 400) / 2 + 20;
        int availableHeight = this.height - 55;
        this.gridStartY = 40 + (availableHeight - 280) / 2;
        this.gridStartY = Math.max(40, this.gridStartY);
        this.calculateMaxScroll();
    }

    private void loadFamiliarData() {
        this.familiarEntries.clear();
        if (this.minecraft == null || this.minecraft.player == null) {
            return;
        }
        PlayerFamiliarData familiarData = (PlayerFamiliarData)this.minecraft.player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        Map familiars = familiarData.getAllFamiliars();
        for (Map.Entry entry : familiars.entrySet()) {
            Entity entity;
            UUID id = (UUID)entry.getKey();
            CompoundTag nbt = (CompoundTag)entry.getValue();
            String entityTypeString = nbt.getString("id");
            EntityType entityType = EntityType.byString((String)entityTypeString).orElse(null);
            if (entityType == null || !((entity = entityType.create((Level)this.minecraft.level)) instanceof AbstractSpellCastingPet)) continue;
            AbstractSpellCastingPet familiar = (AbstractSpellCastingPet)entity;
            familiar.load(nbt);
            familiar.setUUID(id);
            String displayName = familiar.hasCustomName() ? familiar.getCustomName().getString() : familiar.getType().getDescription().getString();
            float health = nbt.getFloat("currentHealth");
            int armor = nbt.getInt("armorStacks");
            int enraged = nbt.getInt("enragedStacks");
            boolean canBlock = nbt.getBoolean("canBlock");
            this.familiarEntries.add(new FamiliarGridEntry(id, familiar, displayName, health, armor, enraged, canBlock));
        }
    }

    private void loadSelectedFamiliars() {
        this.selectedFamiliars.clear();
        if (this.minecraft == null || this.minecraft.player == null) {
            return;
        }
        Set<UUID> equippedFamiliars = PandoraUtils.getSelectedFamiliarsFromEquipped((LivingEntity)this.minecraft.player);
        if (!equippedFamiliars.isEmpty()) {
            this.selectedFamiliars.addAll(equippedFamiliars);
            return;
        }
        ItemStack heldItem = this.minecraft.player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!(heldItem.getItem() instanceof PandoraBox)) {
            heldItem = this.minecraft.player.getItemInHand(InteractionHand.OFF_HAND);
        }
        if (heldItem.getItem() instanceof PandoraBox) {
            this.selectedFamiliars.addAll(PandoraBox.getSelectedFamiliars(heldItem));
        }
    }

    private void calculateMaxScroll() {
        int visibleRows;
        int totalRows = (int)Math.ceil((double)this.familiarEntries.size() / 3.0);
        this.maxScroll = totalRows > (visibleRows = 2) ? (totalRows - visibleRows) * 120 : 0;
        AlshanexFamiliarsMod.LOGGER.info("Total familiars: {}, Total rows: {}, Visible rows: {}, Max scroll: {}", new Object[]{this.familiarEntries.size(), totalRows, visibleRows, this.maxScroll});
    }

    private void drawHeartIcon(GuiGraphics guiGraphics, int x, int y) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(HEART_CONTAINER, x, y - 1, 0.0f, 0.0f, 9, 9, 9, 9);
        guiGraphics.blit(HEART_FULL, x, y - 1, 0.0f, 0.0f, 9, 9, 9, 9);
        RenderSystem.disableBlend();
    }

    private void drawArmorIcon(GuiGraphics guiGraphics, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(ARMOR_FULL, x, y, 0.0f, 0.0f, 9, 9, 9, 9);
        RenderSystem.disableBlend();
    }

    private void drawItemIcon(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.disableBlend();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.animationTime += partialTick;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        MutableComponent title = Component.translatable((String)"screen.alshanex_familiars.pandora_box");
        int titleWidth = this.font.width((FormattedText)title);
        guiGraphics.drawString(this.font, (Component)title, (this.width - titleWidth) / 2, 10, 0xFFFFFF);
        MutableComponent counter = Component.translatable((String)"screen.alshanex_familiars.pandora_box.selected_count", (Object[])new Object[]{this.selectedFamiliars.size(), 10});
        int counterWidth = this.font.width((FormattedText)counter);
        guiGraphics.drawString(this.font, (Component)counter, (this.width - counterWidth) / 2, 25, 0xFFFF55);
        this.renderFamiliarGrid(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderFamiliarGrid(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int scissorX = this.gridStartX;
        int scissorY = this.gridStartY;
        int scissorWidth = 360;
        int scissorHeight = 260;
        this.enableScissor(scissorX, scissorY, scissorX + scissorWidth, scissorY + scissorHeight);
        int currentIndex = 0;
        for (FamiliarGridEntry entry : this.familiarEntries) {
            int col = currentIndex % 3;
            int row = currentIndex / 3;
            int cellX = this.gridStartX + col * 120;
            int cellY = this.gridStartY + row * 120 - this.scrollOffset;
            if (cellY + 120 > this.gridStartY - 10 && cellY < this.gridStartY + scissorHeight + 10) {
                this.renderFamiliarCell(guiGraphics, entry, cellX, cellY, mouseX, mouseY, partialTick);
            }
            ++currentIndex;
        }
        this.disableScissor();
    }

    private void renderFamiliarCell(GuiGraphics guiGraphics, FamiliarGridEntry entry, int x, int y, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        boolean isSelected = this.selectedFamiliars.contains(entry.id);
        boolean cellVisible = y + 120 > this.gridStartY && y < this.gridStartY + 240;
        boolean isHovered = cellVisible && mouseX >= x + 5 && mouseX < x + 120 - 5 && mouseY >= y + 5 && mouseY < y + 120 - 5;
        int backgroundColor = 0x44000000;
        if (isSelected) {
            backgroundColor = 0x4400FF00;
        } else if (isHovered) {
            backgroundColor = 0x44FFFFFF;
        }
        guiGraphics.fill(x + 5, y + 5, x + 120 - 5, y + 120 - 5, backgroundColor);
        int borderColor = isSelected ? -16711936 : (isHovered ? -1 : -10066330);
        guiGraphics.renderOutline(x + 5, y + 5, 110, 110, borderColor);
        poseStack.pushPose();
        poseStack.translate((float)(x + 60), (float)(y + 45), 50.0f);
        poseStack.scale(25.0f, 25.0f, 25.0f);
        Quaternionf rotation = new Quaternionf().rotateY((float)Math.toRadians(45.0));
        poseStack.mulPose(rotation);
        this.renderEntity(guiGraphics, (LivingEntity)entry.familiar, 0.0f, 0.0f, 0.0f);
        poseStack.popPose();
        Object displayName = entry.displayName;
        if (this.font.width((String)displayName) > 100) {
            displayName = this.font.plainSubstrByWidth((String)displayName, 95) + "...";
        }
        int nameWidth = this.font.width((String)displayName);
        guiGraphics.drawString(this.font, (String)displayName, x + (120 - nameWidth) / 2, y + 55, 0xFFFFFF);
        this.renderAttributesInQuadrants(guiGraphics, entry, x, y + 68);
        if (isSelected) {
            MutableComponent checkmark = Component.literal((String)"\u2713");
            guiGraphics.drawString(this.font, (Component)checkmark, x + 120 - 20, y + 10, 65280);
        }
    }

    private void renderAttributesInQuadrants(GuiGraphics guiGraphics, FamiliarGridEntry entry, int x, int y) {
        int boxX = x + 20;
        int boxY = y;
        int boxWidth = 80;
        int boxHeight = 40;
        guiGraphics.fill(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -1430208320);
        guiGraphics.fill(boxX, boxY, boxX + boxWidth, boxY + 1, -8355712);
        guiGraphics.fill(boxX, boxY + boxHeight - 1, boxX + boxWidth, boxY + boxHeight, -8355712);
        guiGraphics.fill(boxX, boxY, boxX + 1, boxY + boxHeight, -8355712);
        guiGraphics.fill(boxX + boxWidth - 1, boxY, boxX + boxWidth, boxY + boxHeight, -8355712);
        int halfWidth = boxWidth / 2;
        int halfHeight = boxHeight / 2;
        MutableComponent healthComponent = Component.literal((String)String.format("%.0f", Float.valueOf(entry.health)));
        int healthTextWidth = this.font.width((FormattedText)healthComponent);
        int healthTotalWidth = 11 + healthTextWidth;
        int healthStartX = boxX + (halfWidth - healthTotalWidth) / 2;
        int healthY = boxY + (halfHeight - 9) / 2;
        this.drawHeartIcon(guiGraphics, healthStartX, healthY);
        guiGraphics.drawString(this.font, (Component)healthComponent, healthStartX + 11, healthY, 0xFF5555);
        MutableComponent armorComponent = Component.literal((String)String.valueOf(entry.armor));
        int armorTextWidth = this.font.width((FormattedText)armorComponent);
        int armorTotalWidth = 11 + armorTextWidth;
        int armorStartX = boxX + halfWidth + (halfWidth - armorTotalWidth) / 2;
        int armorY = boxY + (halfHeight - 9) / 2;
        this.drawArmorIcon(guiGraphics, armorStartX, armorY);
        guiGraphics.drawString(this.font, (Component)armorComponent, armorStartX + 11, armorY, 0xAAAAAA);
        MutableComponent blockComponent = Component.literal((String)(entry.canBlock ? "1" : "0"));
        int blockTextWidth = this.font.width((FormattedText)blockComponent);
        int blockTotalWidth = 18 + blockTextWidth;
        int blockStartX = boxX + (halfWidth - blockTotalWidth) / 2;
        int blockY = boxY + halfHeight + (halfHeight - 16) / 2;
        this.drawItemIcon(guiGraphics, BROKEN_SHIELD, blockStartX, blockY);
        int blockColor = entry.canBlock ? 0x55FF55 : 0xFF5555;
        guiGraphics.drawString(this.font, (Component)blockComponent, blockStartX + 18, blockY + 4, blockColor);
        MutableComponent enragedComponent = Component.literal((String)String.valueOf(entry.enraged));
        int enragedTextWidth = this.font.width((FormattedText)enragedComponent);
        int enragedTotalWidth = 18 + enragedTextWidth;
        int enragedStartX = boxX + halfWidth + (halfWidth - enragedTotalWidth) / 2;
        int enragedY = boxY + halfHeight + (halfHeight - 16) / 2;
        this.drawItemIcon(guiGraphics, STRANGE_MUSHROOM, enragedStartX, enragedY);
        guiGraphics.drawString(this.font, (Component)enragedComponent, enragedStartX + 18, enragedY + 4, 0xFF55FF);
    }

    private void renderEntity(GuiGraphics guiGraphics, LivingEntity entity, float x, float y, float z) {
        if (entity == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        poseStack.pushPose();
        poseStack.translate(x, y, z);
        poseStack.scale(1.0f, -1.0f, 1.0f);
        float rotationY = this.animationTime * 0.02f % ((float)Math.PI * 2);
        Quaternionf rotation = new Quaternionf().rotateY(rotationY);
        poseStack.mulPose(rotation);
        Quaternionf tiltRotation = new Quaternionf().rotateX((float)Math.toRadians(-10.0));
        poseStack.mulPose(tiltRotation);
        RenderSystem.setShaderLights((Vector3f)new Vector3f(0.2f, 1.0f, -1.0f), (Vector3f)new Vector3f(-0.2f, -1.0f, 0.0f));
        RenderSystem.disableCull();
        try {
            MultiBufferSource.BufferSource bufferSource = guiGraphics.bufferSource();
            entityRenderDispatcher.render((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, (MultiBufferSource)bufferSource, 0xF000F0);
            guiGraphics.flush();
        }
        catch (Exception e) {
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.translate(x, y, z);
            MutableComponent errorText = Component.literal((String)"Error");
            int textWidth = this.font.width((FormattedText)errorText);
            guiGraphics.drawString(this.font, (Component)errorText, (int)x - textWidth / 2, (int)y, 0xFF5555);
        }
        RenderSystem.enableCull();
        poseStack.popPose();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int currentIndex = 0;
            for (FamiliarGridEntry entry : this.familiarEntries) {
                boolean mouseInCell;
                int col = currentIndex % 3;
                int row = currentIndex / 3;
                int cellX = this.gridStartX + col * 120;
                int cellY = this.gridStartY + row * 120 - this.scrollOffset;
                boolean cellVisible = cellY + 120 > this.gridStartY && cellY < this.gridStartY + 240;
                boolean bl = mouseInCell = mouseX >= (double)(cellX + 5) && mouseX < (double)(cellX + 120 - 5) && mouseY >= (double)(cellY + 5) && mouseY < (double)(cellY + 120 - 5);
                if (cellVisible && mouseInCell) {
                    this.toggleFamiliarSelection(entry.id);
                    return true;
                }
                ++currentIndex;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void toggleFamiliarSelection(UUID familiarId) {
        if (this.selectedFamiliars.contains(familiarId)) {
            this.selectedFamiliars.remove(familiarId);
        } else if (this.selectedFamiliars.size() < 10) {
            this.selectedFamiliars.add(familiarId);
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new UpdatePandoraBoxPacket(new HashSet<UUID>(this.selectedFamiliars)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.maxScroll > 0) {
            this.scrollOffset -= (int)(scrollY * 20.0);
            this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScroll));
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.fill(0, 0, this.width, this.height, -2013265920);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void enableScissor(int x1, int y1, int x2, int y2) {
        double scale = this.minecraft.getWindow().getGuiScale();
        RenderSystem.enableScissor((int)((int)((double)x1 * scale)), (int)((int)((double)this.minecraft.getWindow().getHeight() - (double)y2 * scale)), (int)((int)((double)(x2 - x1) * scale)), (int)((int)((double)(y2 - y1) * scale)));
    }

    private void disableScissor() {
        RenderSystem.disableScissor();
    }

    private static class FamiliarGridEntry {
        final UUID id;
        final AbstractSpellCastingPet familiar;
        final String displayName;
        final float health;
        final int armor;
        final int enraged;
        final boolean canBlock;

        FamiliarGridEntry(UUID id, AbstractSpellCastingPet familiar, String displayName, float health, int armor, int enraged, boolean canBlock) {
            this.id = id;
            this.familiar = familiar;
            this.displayName = displayName;
            this.health = health;
            this.armor = armor;
            this.enraged = enraged;
            this.canBlock = canBlock;
        }
    }
}

