/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.alshanex.alshanex_familiars.AlshanexFamiliarsMod;
import net.alshanex.alshanex_familiars.network.ReleaseFamiliarPacket;
import net.alshanex.alshanex_familiars.network.SelectFamiliarPacket;
import net.alshanex.familiarslib.data.PlayerFamiliarData;
import net.alshanex.familiarslib.entity.AbstractSpellCastingPet;
import net.alshanex.familiarslib.registry.AttachmentRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class FamiliarSelectionScreen
extends Screen {
    private static final int PANEL_WIDTH = 200;
    private static final int PANEL_HEIGHT = 300;
    private static final int FAMILIAR_ITEM_HEIGHT = 80;
    private static final int SCROLL_SPEED = 20;
    private static final ResourceLocation HEART_CONTAINER = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/hud/heart/container.png");
    private static final ResourceLocation HEART_FULL = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/hud/heart/full.png");
    private static final ResourceLocation ARMOR_FULL = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/hud/armor_full.png");
    private static final ResourceLocation STRANGE_MUSHROOM = ResourceLocation.fromNamespaceAndPath((String)"alshanex_familiars", (String)"textures/item/strange_mushroom.png");
    private static final ResourceLocation BROKEN_SHIELD = ResourceLocation.fromNamespaceAndPath((String)"alshanex_familiars", (String)"textures/item/broken_shield.png");
    private final List<FamiliarEntry> familiarEntries = new ArrayList<FamiliarEntry>();
    private UUID selectedFamiliarId;
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private float animationTime = 0.0f;
    private int leftPanelX;
    private int rightPanelX;
    private int panelY;
    private Button releaseButton;

    public FamiliarSelectionScreen() {
        super((Component)Component.translatable((String)"ui.alshanex_familiars.familiar_selection_screen"));
    }

    protected void init() {
        super.init();
        this.loadFamiliarData();
        this.leftPanelX = (this.width - 400 - 20) / 2;
        this.rightPanelX = this.leftPanelX + 200 + 20;
        this.panelY = (this.height - 300) / 2 + 30;
        int buttonWidth = 80;
        int buttonHeight = 20;
        int buttonX = this.leftPanelX + (200 - buttonWidth) / 2;
        int buttonY = this.panelY + 300 - 85;
        this.releaseButton = Button.builder((Component)Component.translatable((String)"ui.alshanex_familiars.release_familiar"), this::onReleaseButtonPressed).bounds(buttonX, buttonY, buttonWidth, buttonHeight).build();
        this.addRenderableWidget((GuiEventListener)this.releaseButton);
        this.updateReleaseButtonVisibility();
    }

    private void loadFamiliarData() {
        this.familiarEntries.clear();
        if (this.minecraft == null || this.minecraft.player == null) {
            return;
        }
        PlayerFamiliarData familiarData = (PlayerFamiliarData)this.minecraft.player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        this.selectedFamiliarId = familiarData.getSelectedFamiliarId();
        Map familiars = familiarData.getAllFamiliars();
        for (Map.Entry entry : familiars.entrySet()) {
            Entity entity;
            UUID id = (UUID)entry.getKey();
            CompoundTag nbt = (CompoundTag)entry.getValue();
            String entityTypeString = nbt.getString("id");
            EntityType entityType = EntityType.byString((String)entityTypeString).orElse(null);
            if (entityType == null || !((entity = entityType.create((Level)this.minecraft.level)) instanceof AbstractSpellCastingPet)) continue;
            AbstractSpellCastingPet familiar = (AbstractSpellCastingPet)entity;
            familiar.load(nbt);
            familiar.setUUID(id);
            String displayName = familiar.hasCustomName() ? familiar.getCustomName().getString() : familiar.getType().getDescription().getString();
            float health = nbt.getFloat("currentHealth");
            float maxHealth = familiar.getMaxHealth();
            int armor = nbt.getInt("armorStacks");
            int enraged = nbt.getInt("enragedStacks");
            boolean canBlock = nbt.getBoolean("canBlock");
            this.familiarEntries.add(new FamiliarEntry(id, familiar, displayName, health, armor, enraged, canBlock));
        }
        int visibleItems = 3;
        this.maxScroll = Math.max(0, (this.familiarEntries.size() - visibleItems) * 80);
    }

    private void updateReleaseButtonVisibility() {
        if (this.releaseButton != null) {
            this.releaseButton.visible = this.selectedFamiliarId != null && !this.familiarEntries.isEmpty();
        }
    }

    private void onReleaseButtonPressed(Button button) {
        if (this.selectedFamiliarId == null) {
            return;
        }
        FamiliarEntry selectedEntry = this.getSelectedEntry();
        String familiarName = selectedEntry != null ? selectedEntry.displayName : "Unknown";
        MutableComponent title = Component.translatable((String)"ui.alshanex_familiars.confirm_release");
        MutableComponent message = Component.translatable((String)"ui.alshanex_familiars.confirm_release_message", (Object[])new Object[]{familiarName});
        this.minecraft.setScreen((Screen)new ConfirmReleaseScreen(this, (Component)title, (Component)message, confirmed -> {
            if (confirmed.booleanValue()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ReleaseFamiliarPacket(this.selectedFamiliarId), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }));
    }

    public void reloadFamiliarData() {
        try {
            boolean foundSelected;
            AlshanexFamiliarsMod.LOGGER.info("=== FamiliarSelectionScreen.reloadFamiliarData() START ===");
            UUID previousSelected = this.selectedFamiliarId;
            int previousCount = this.familiarEntries.size();
            AlshanexFamiliarsMod.LOGGER.info("Previous state - Count: {}, Selected: {}", (Object)previousCount, (Object)previousSelected);
            this.familiarEntries.clear();
            if (this.minecraft == null || this.minecraft.player == null) {
                AlshanexFamiliarsMod.LOGGER.warn("Minecraft or player is null, cannot reload familiar data");
                return;
            }
            PlayerFamiliarData familiarData = (PlayerFamiliarData)this.minecraft.player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
            if (familiarData == null) {
                AlshanexFamiliarsMod.LOGGER.warn("FamiliarData is null");
                return;
            }
            Map familiars = familiarData.getAllFamiliars();
            UUID currentSelected = familiarData.getSelectedFamiliarId();
            AlshanexFamiliarsMod.LOGGER.info("Current data - Familiar count: {}, Selected: {}", (Object)familiars.size(), (Object)currentSelected);
            if (familiars.isEmpty()) {
                AlshanexFamiliarsMod.LOGGER.info("No familiars found, closing screen");
                this.onClose();
                return;
            }
            for (Map.Entry entry2 : familiars.entrySet()) {
                UUID id = (UUID)entry2.getKey();
                CompoundTag nbt = (CompoundTag)entry2.getValue();
                AlshanexFamiliarsMod.LOGGER.debug("Processing familiar: {} with health: {}", (Object)id, (Object)Float.valueOf(nbt.getFloat("currentHealth")));
                String entityTypeString = nbt.getString("id");
                EntityType entityType = EntityType.byString((String)entityTypeString).orElse(null);
                if (entityType != null) {
                    Entity entity = entityType.create((Level)this.minecraft.level);
                    if (!(entity instanceof AbstractSpellCastingPet)) continue;
                    AbstractSpellCastingPet familiar = (AbstractSpellCastingPet)entity;
                    familiar.load(nbt);
                    familiar.setUUID(id);
                    String displayName = familiar.hasCustomName() ? familiar.getCustomName().getString() : familiar.getType().getDescription().getString();
                    float health = nbt.getFloat("currentHealth");
                    int armor = nbt.getInt("armorStacks");
                    int enraged = nbt.getInt("enragedStacks");
                    boolean canBlock = nbt.getBoolean("canBlock");
                    this.familiarEntries.add(new FamiliarEntry(id, familiar, displayName, health, armor, enraged, canBlock));
                    AlshanexFamiliarsMod.LOGGER.debug("Added familiar entry: {} ({})", (Object)displayName, (Object)id);
                    continue;
                }
                AlshanexFamiliarsMod.LOGGER.warn("Unknown entity type for familiar {}: {}", (Object)id, (Object)entityTypeString);
            }
            this.selectedFamiliarId = currentSelected;
            if (this.selectedFamiliarId != null && !(foundSelected = this.familiarEntries.stream().anyMatch(entry -> entry.id.equals(this.selectedFamiliarId)))) {
                AlshanexFamiliarsMod.LOGGER.warn("Selected familiar {} not found in entries, selecting first available", (Object)this.selectedFamiliarId);
                this.selectedFamiliarId = !this.familiarEntries.isEmpty() ? this.familiarEntries.get((int)0).id : null;
            }
            int visibleItems = 3;
            this.maxScroll = Math.max(0, (this.familiarEntries.size() - visibleItems) * 80);
            this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScroll));
            this.updateReleaseButtonVisibility();
            AlshanexFamiliarsMod.LOGGER.info("Reload completed - New count: {}, New selected: {}, Max scroll: {}", new Object[]{this.familiarEntries.size(), this.selectedFamiliarId, this.maxScroll});
            AlshanexFamiliarsMod.LOGGER.info("=== FamiliarSelectionScreen.reloadFamiliarData() END ===");
        }
        catch (Exception e) {
            AlshanexFamiliarsMod.LOGGER.error("Error reloading familiar data in FamiliarSelectionScreen: ", (Throwable)e);
            try {
                this.onClose();
            }
            catch (Exception closeError) {
                AlshanexFamiliarsMod.LOGGER.error("Error closing screen after reload failure: ", (Throwable)closeError);
            }
        }
    }

    private Set<UUID> getAllSummonedFamiliarIds() {
        if (this.minecraft == null || this.minecraft.player == null) {
            return new HashSet<UUID>();
        }
        PlayerFamiliarData familiarData = (PlayerFamiliarData)this.minecraft.player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        return familiarData.getSummonedFamiliarIds();
    }

    private boolean isFamiliarSummoned(UUID familiarId) {
        if (this.minecraft == null || this.minecraft.player == null) {
            return false;
        }
        PlayerFamiliarData familiarData = (PlayerFamiliarData)this.minecraft.player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        return familiarData.isFamiliarSummoned(familiarId);
    }

    private void drawHeartIcon(GuiGraphics guiGraphics, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(HEART_CONTAINER, x, y - 1, 0.0f, 0.0f, 9, 9, 9, 9);
        guiGraphics.blit(HEART_FULL, x, y - 1, 0.0f, 0.0f, 9, 9, 9, 9);
        RenderSystem.disableBlend();
    }

    private void drawArmorIcon(GuiGraphics guiGraphics, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(ARMOR_FULL, x, y, 0.0f, 0.0f, 9, 9, 9, 9);
        RenderSystem.disableBlend();
    }

    private void drawItemIcon(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.disableBlend();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.animationTime += partialTick;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.renderSelectedFamiliar(guiGraphics, mouseX, mouseY, partialTick);
        this.renderFamiliarList(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderSelectedFamiliar(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        FamiliarEntry selectedEntry = this.getSelectedEntry();
        if (selectedEntry == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        if (this.isFamiliarSummoned(selectedEntry.id)) {
            MutableComponent statusComponent = Component.translatable((String)"ui.alshanex_familiars.familiar_summoned");
            int statusWidth = this.font.width((FormattedText)statusComponent);
            guiGraphics.drawString(this.font, (Component)statusComponent, this.leftPanelX + (200 - statusWidth) / 2, this.panelY + 20, 0xFFFF55);
        }
        poseStack.pushPose();
        poseStack.translate((float)(this.leftPanelX + 100), (float)(this.panelY + 100), 100.0f);
        poseStack.scale(60.0f, 60.0f, 60.0f);
        Quaternionf rotation = new Quaternionf().rotateY((float)Math.toRadians(45.0));
        poseStack.mulPose(rotation);
        this.renderEntity(guiGraphics, (LivingEntity)selectedEntry.familiar, 0.0f, 0.0f, 0.0f);
        poseStack.popPose();
        int infoY = this.panelY + 120;
        MutableComponent nameComponent = Component.literal((String)selectedEntry.displayName);
        int nameWidth = this.font.width((FormattedText)nameComponent);
        guiGraphics.drawString(this.font, (Component)nameComponent, this.leftPanelX + (200 - nameWidth) / 2, infoY, 0xFFFFFF);
        int boxX = this.leftPanelX + 40;
        int boxY = infoY + 25;
        int boxWidth = 120;
        int boxHeight = 60;
        guiGraphics.fill(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -1430208320);
        guiGraphics.fill(boxX, boxY, boxX + boxWidth, boxY + 1, -8355712);
        guiGraphics.fill(boxX, boxY + boxHeight - 1, boxX + boxWidth, boxY + boxHeight, -8355712);
        guiGraphics.fill(boxX, boxY, boxX + 1, boxY + boxHeight, -8355712);
        guiGraphics.fill(boxX + boxWidth - 1, boxY, boxX + boxWidth, boxY + boxHeight, -8355712);
        int halfWidth = boxWidth / 2;
        int halfHeight = boxHeight / 2;
        MutableComponent healthComponent = Component.literal((String)String.format("%.0f", Float.valueOf(selectedEntry.health)));
        int healthTextWidth = this.font.width((FormattedText)healthComponent);
        int healthTotalWidth = 11 + healthTextWidth;
        int healthStartX = boxX + (halfWidth - healthTotalWidth) / 2;
        int healthY = boxY + (halfHeight - 9) / 2;
        this.drawHeartIcon(guiGraphics, healthStartX, healthY);
        guiGraphics.drawString(this.font, (Component)healthComponent, healthStartX + 11, healthY, 0xFF5555);
        MutableComponent armorComponent = Component.literal((String)String.valueOf(selectedEntry.armor));
        int armorTextWidth = this.font.width((FormattedText)armorComponent);
        int armorTotalWidth = 11 + armorTextWidth;
        int armorStartX = boxX + halfWidth + (halfWidth - armorTotalWidth) / 2;
        int armorY = boxY + (halfHeight - 9) / 2;
        this.drawArmorIcon(guiGraphics, armorStartX, armorY);
        guiGraphics.drawString(this.font, (Component)armorComponent, armorStartX + 11, armorY, 0xAAAAAA);
        MutableComponent blockComponent = Component.literal((String)(selectedEntry.canBlock ? "1" : "0"));
        int blockTextWidth = this.font.width((FormattedText)blockComponent);
        int blockTotalWidth = 18 + blockTextWidth;
        int blockStartX = boxX + (halfWidth - blockTotalWidth) / 2;
        int blockY = boxY + halfHeight + (halfHeight - 16) / 2;
        this.drawItemIcon(guiGraphics, BROKEN_SHIELD, blockStartX, blockY);
        int blockColor = selectedEntry.canBlock ? 0x55FF55 : 0xFF5555;
        guiGraphics.drawString(this.font, (Component)blockComponent, blockStartX + 18, blockY + 4, blockColor);
        MutableComponent enragedComponent = Component.literal((String)String.valueOf(selectedEntry.enraged));
        int enragedTextWidth = this.font.width((FormattedText)enragedComponent);
        int enragedTotalWidth = 18 + enragedTextWidth;
        int enragedStartX = boxX + halfWidth + (halfWidth - enragedTotalWidth) / 2;
        int enragedY = boxY + halfHeight + (halfHeight - 16) / 2;
        this.drawItemIcon(guiGraphics, STRANGE_MUSHROOM, enragedStartX, enragedY);
        guiGraphics.drawString(this.font, (Component)enragedComponent, enragedStartX + 18, enragedY + 4, 0xFF55FF);
    }

    private UUID getCurrentSummonedFamiliarId() {
        if (this.minecraft == null || this.minecraft.player == null) {
            return null;
        }
        PlayerFamiliarData familiarData = (PlayerFamiliarData)this.minecraft.player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        return familiarData.getCurrentSummonedFamiliarId();
    }

    private void renderFamiliarList(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        int scissorX = this.rightPanelX;
        int scissorY = this.panelY;
        int scissorWidth = 200;
        int scissorHeight = 300;
        this.enableScissor(scissorX, scissorY, scissorX + scissorWidth, scissorY + scissorHeight);
        int currentY = this.panelY - this.scrollOffset;
        for (int i = 0; i < this.familiarEntries.size(); ++i) {
            FamiliarEntry entry = this.familiarEntries.get(i);
            if (currentY + 80 > this.panelY && currentY < this.panelY + 300) {
                this.renderFamiliarItem(guiGraphics, entry, this.rightPanelX, currentY, mouseX, mouseY, partialTick);
            }
            currentY += 80;
        }
        this.disableScissor();
    }

    private void renderFamiliarItem(GuiGraphics guiGraphics, FamiliarEntry entry, int x, int y, int mouseX, int mouseY, float partialTick) {
        boolean isHovered;
        PoseStack poseStack = guiGraphics.pose();
        boolean isSelected = entry.id.equals(this.selectedFamiliarId);
        boolean bl = isHovered = mouseX >= x && mouseX < x + 200 && mouseY >= y && mouseY < y + 80;
        if (isSelected) {
            guiGraphics.fill(x, y, x + 200, y + 80, 0x4400FF00);
        } else if (isHovered) {
            guiGraphics.fill(x, y, x + 200, y + 80, 0x44FFFFFF);
        }
        poseStack.pushPose();
        poseStack.translate((float)(x + 40), (float)(y + 50), 50.0f);
        poseStack.scale(30.0f, 30.0f, 30.0f);
        Quaternionf rotation = new Quaternionf().rotateY((float)Math.toRadians(45.0));
        poseStack.mulPose(rotation);
        this.renderEntity(guiGraphics, (LivingEntity)entry.familiar, 0.0f, 0.0f, 0.0f);
        poseStack.popPose();
        MutableComponent nameComponent = Component.literal((String)entry.displayName);
        guiGraphics.drawString(this.font, (Component)nameComponent, x + 85, y + 20, 0xFFFFFF);
        this.drawHeartIcon(guiGraphics, x + 85, y + 35);
        MutableComponent healthComponent = Component.literal((String)String.format("%.0f", Float.valueOf(entry.health)));
        guiGraphics.drawString(this.font, (Component)healthComponent, x + 85 + 12, y + 35, 0xFF5555);
        this.drawArmorIcon(guiGraphics, x + 85, y + 49);
        MutableComponent armorComponent = Component.literal((String)String.valueOf(entry.armor));
        guiGraphics.drawString(this.font, (Component)armorComponent, x + 85 + 12, y + 50, 0xAAAAAA);
        if (this.isFamiliarSummoned(entry.id)) {
            MutableComponent summonedIndicator = Component.literal((String)"\u2605");
            guiGraphics.drawString(this.font, (Component)summonedIndicator, x + 200 - 20, y + 10, 0xFFFF55);
        }
    }

    private void renderEntity(GuiGraphics guiGraphics, LivingEntity entity, float x, float y, float z) {
        if (entity == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        poseStack.pushPose();
        poseStack.translate(x, y, z);
        poseStack.scale(1.0f, -1.0f, 1.0f);
        float rotationY = this.animationTime * 0.02f % ((float)Math.PI * 2);
        Quaternionf rotation = new Quaternionf().rotateY(rotationY);
        poseStack.mulPose(rotation);
        Quaternionf tiltRotation = new Quaternionf().rotateX((float)Math.toRadians(-10.0));
        poseStack.mulPose(tiltRotation);
        RenderSystem.setShaderLights((Vector3f)new Vector3f(0.2f, 1.0f, -1.0f), (Vector3f)new Vector3f(-0.2f, -1.0f, 0.0f));
        RenderSystem.disableCull();
        try {
            MultiBufferSource.BufferSource bufferSource = guiGraphics.bufferSource();
            entityRenderDispatcher.render((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, (MultiBufferSource)bufferSource, 0xF000F0);
            guiGraphics.flush();
        }
        catch (Exception e) {
            poseStack.popPose();
            poseStack.pushPose();
            poseStack.translate(x, y, z);
            MutableComponent errorText = Component.literal((String)"Error");
            int textWidth = this.font.width((FormattedText)errorText);
            guiGraphics.drawString(this.font, (Component)errorText, (int)x - textWidth / 2, (int)y, 0xFF5555);
        }
        RenderSystem.enableCull();
        poseStack.popPose();
    }

    private FamiliarEntry getSelectedEntry() {
        if (this.selectedFamiliarId == null) {
            return null;
        }
        return this.familiarEntries.stream().filter(entry -> entry.id.equals(this.selectedFamiliarId)).findFirst().orElse(null);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int relativeY;
        int itemIndex;
        if (button == 0 && mouseX >= (double)this.rightPanelX && mouseX < (double)(this.rightPanelX + 200) && mouseY >= (double)this.panelY && mouseY < (double)(this.panelY + 300) && (itemIndex = (relativeY = (int)(mouseY - (double)this.panelY + (double)this.scrollOffset)) / 80) >= 0 && itemIndex < this.familiarEntries.size()) {
            FamiliarEntry selected = this.familiarEntries.get(itemIndex);
            this.selectedFamiliarId = selected.id;
            PacketDistributor.sendToServer((CustomPacketPayload)new SelectFamiliarPacket(selected.id), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.updateReleaseButtonVisibility();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (mouseX >= (double)this.rightPanelX && mouseX < (double)(this.rightPanelX + 200) && mouseY >= (double)this.panelY && mouseY < (double)(this.panelY + 300)) {
            this.scrollOffset -= (int)(scrollY * 20.0);
            this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.maxScroll));
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.fill(0, 0, this.width, this.height, -2013265920);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void enableScissor(int x1, int y1, int x2, int y2) {
        double scale = this.minecraft.getWindow().getGuiScale();
        RenderSystem.enableScissor((int)((int)((double)x1 * scale)), (int)((int)((double)this.minecraft.getWindow().getHeight() - (double)y2 * scale)), (int)((int)((double)(x2 - x1) * scale)), (int)((int)((double)(y2 - y1) * scale)));
    }

    private void disableScissor() {
        RenderSystem.disableScissor();
    }

    private static class FamiliarEntry {
        final UUID id;
        final AbstractSpellCastingPet familiar;
        final String displayName;
        final float health;
        final int armor;
        final int enraged;
        final boolean canBlock;

        FamiliarEntry(UUID id, AbstractSpellCastingPet familiar, String displayName, float health, int armor, int enraged, boolean canBlock) {
            this.id = id;
            this.familiar = familiar;
            this.displayName = displayName;
            this.health = health;
            this.armor = armor;
            this.enraged = enraged;
            this.canBlock = canBlock;
        }
    }

    private static class ConfirmReleaseScreen
    extends Screen {
        private final Screen parent;
        private final Component message;
        private final Consumer<Boolean> callback;

        protected ConfirmReleaseScreen(Screen parent, Component title, Component message, Consumer<Boolean> callback) {
            super(title);
            this.parent = parent;
            this.message = message;
            this.callback = callback;
        }

        protected void init() {
            super.init();
            int buttonWidth = 60;
            int buttonHeight = 20;
            int spacing = 10;
            int totalWidth = buttonWidth * 2 + spacing;
            int startX = (this.width - totalWidth) / 2;
            int buttonY = this.height / 2 + 20;
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.yes"), button -> {
                this.callback.accept(true);
                this.minecraft.setScreen(this.parent);
            }).bounds(startX, buttonY, buttonWidth, buttonHeight).build());
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.cancel"), button -> {
                this.callback.accept(false);
                this.minecraft.setScreen(this.parent);
            }).bounds(startX + buttonWidth + spacing, buttonY, buttonWidth, buttonHeight).build());
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
            Component titleComponent = this.getTitle();
            int titleWidth = this.font.width((FormattedText)titleComponent);
            guiGraphics.drawString(this.font, titleComponent, (this.width - titleWidth) / 2, this.height / 2 - 40, 0xFFFFFF);
            int messageWidth = this.font.width((FormattedText)this.message);
            guiGraphics.drawString(this.font, this.message, (this.width - messageWidth) / 2, this.height / 2 - 10, 0xFFFFFF);
            super.render(guiGraphics, mouseX, mouseY, partialTick);
        }

        public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.fill(0, 0, this.width, this.height, -2013265920);
            int boxWidth = 300;
            int boxHeight = 120;
            int boxX = (this.width - boxWidth) / 2;
            int boxY = (this.height - boxHeight) / 2;
            guiGraphics.fill(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -870178270);
            guiGraphics.fill(boxX, boxY, boxX + boxWidth, boxY + 1, -1);
            guiGraphics.fill(boxX, boxY + boxHeight - 1, boxX + boxWidth, boxY + boxHeight, -1);
            guiGraphics.fill(boxX, boxY, boxX + 1, boxY + boxHeight, -1);
            guiGraphics.fill(boxX + boxWidth - 1, boxY, boxX + boxWidth, boxY + boxHeight, -1);
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 256) {
                this.callback.accept(false);
                this.minecraft.setScreen(this.parent);
                return true;
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }

        public boolean isPauseScreen() {
            return false;
        }
    }
}

