/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.recipe_types;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import javax.annotation.Nullable;
import net.alshanex.alshanex_familiars.AlshanexFamiliarsMod;
import net.alshanex.alshanex_familiars.compat.ItemMultiSet;
import net.alshanex.alshanex_familiars.registry.RecipeRegistry;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public record RitualRecipeType(Ingredient centralItem, ItemMultiSet inputItems, ItemStack result, Holder<ParticleType<?>> defaultParticle) implements Recipe<Input>
{
    private final ItemStack result;

    public static Builder builder() {
        return new Builder();
    }

    public ItemStack result() {
        return this.result.copy();
    }

    public boolean matches(Input input, Level level) {
        return this.centralItem.test(input.getItem(0)) && Objects.equals(this.inputItems, input.inputItems);
    }

    public ItemStack assemble(Input input, HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegistry.RITUAL_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)RecipeRegistry.RITUAL_RECIPE_TYPE.get();
    }

    public static class Builder
    implements RecipeBuilder {
        ParticleType<?> defaultParticle = ParticleTypes.ASH;
        Ingredient centralItem = null;
        ItemMultiSet inputItems = null;
        ItemStack result = null;

        public Builder withInput(Item input) {
            this.centralItem = Ingredient.of((ItemLike[])new ItemLike[]{input});
            return this;
        }

        public Builder withReturnItem(Item returned) {
            this.result = new ItemStack((ItemLike)returned);
            return this;
        }

        public Builder withInputs(ItemMultiSet inputs) {
            this.inputItems = inputs;
            return this;
        }

        public Builder withParticles(ParticleType<?> particle) {
            this.defaultParticle = particle;
            return this;
        }

        public RecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
            return this;
        }

        public RecipeBuilder group(@Nullable String groupName) {
            return this;
        }

        public Item getResult() {
            return this.result.getItem();
        }

        public void save(RecipeOutput recipeOutput) {
            recipeOutput.accept(AlshanexFamiliarsMod.id("ritual_recipes/" + BuiltInRegistries.ITEM.getKey((Object)this.result.getItem()).getPath()), (Recipe)new RitualRecipeType(this.centralItem, this.inputItems, this.result, BuiltInRegistries.PARTICLE_TYPE.wrapAsHolder(this.defaultParticle)), null);
        }

        public void save(RecipeOutput recipeOutput, ResourceLocation id) {
            recipeOutput.accept(id, (Recipe)new RitualRecipeType(this.centralItem, this.inputItems, this.result, BuiltInRegistries.PARTICLE_TYPE.wrapAsHolder(this.defaultParticle)), null);
        }
    }

    public record Input(ItemStack centralItem, ItemMultiSet inputItems) implements RecipeInput
    {
        public ItemStack getItem(int index) {
            return this.centralItem;
        }

        public int size() {
            return 1;
        }
    }

    public static class Serializer
    implements RecipeSerializer<RitualRecipeType> {
        public static final MapCodec<RitualRecipeType> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("central_item").forGetter(RitualRecipeType::centralItem), (App)ItemMultiSet.CODEC.fieldOf("input_items").forGetter(RitualRecipeType::inputItems), (App)ItemStack.CODEC.fieldOf("result").forGetter(RitualRecipeType::result), (App)BuiltInRegistries.PARTICLE_TYPE.holderByNameCodec().optionalFieldOf("particle_type", (Object)BuiltInRegistries.PARTICLE_TYPE.wrapAsHolder((Object)ParticleTypes.ASH)).forGetter(RitualRecipeType::defaultParticle)).apply((Applicative)builder, RitualRecipeType::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, RitualRecipeType> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, RitualRecipeType::centralItem, ItemMultiSet.STREAM_CODEC, RitualRecipeType::inputItems, (StreamCodec)ItemStack.STREAM_CODEC, RitualRecipeType::result, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.PARTICLE_TYPE), RitualRecipeType::defaultParticle, RitualRecipeType::new);

        public MapCodec<RitualRecipeType> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RitualRecipeType> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

