/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.network;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.alshanex.alshanex_familiars.util.PandoraUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class UpdatePandoraBoxPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<UpdatePandoraBoxPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"alshanex_familiars", (String)"update_pandora_box"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdatePandoraBoxPacket> STREAM_CODEC = CustomPacketPayload.codec(UpdatePandoraBoxPacket::write, UpdatePandoraBoxPacket::new);
    private final Set<UUID> selectedFamiliars;

    public UpdatePandoraBoxPacket(Set<UUID> selectedFamiliars) {
        this.selectedFamiliars = selectedFamiliars;
    }

    public UpdatePandoraBoxPacket(FriendlyByteBuf buf) {
        int size = buf.readVarInt();
        this.selectedFamiliars = new HashSet<UUID>();
        for (int i = 0; i < size; ++i) {
            this.selectedFamiliars.add(buf.readUUID());
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeVarInt(this.selectedFamiliars.size());
        for (UUID uuid : this.selectedFamiliars) {
            buf.writeUUID(uuid);
        }
    }

    public static void handle(UpdatePandoraBoxPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                PandoraUtils.updatePandoraBox(serverPlayer, packet.selectedFamiliars);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

